/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.util;

public class CappedDatabaseStats {
    private long totalBytesBeforeCompression;
    private long totalBytesAfterCompression;
    private long totalNanos;
    private long writeCount;

    public long getTotalBytesBeforeCompression() {
        return this.totalBytesBeforeCompression;
    }

    public long getTotalBytesAfterCompression() {
        return this.totalBytesAfterCompression;
    }

    public double getTotalMillis() {
        return (double)this.totalNanos / 1000000.0;
    }

    public long getWriteCount() {
        return this.writeCount;
    }

    public double getCompressionRatio() {
        return (double)(this.totalBytesBeforeCompression - this.totalBytesAfterCompression) / (double)this.totalBytesBeforeCompression;
    }

    public double getAverageBytesPerWriteBeforeCompression() {
        return (double)this.totalBytesBeforeCompression / (double)this.writeCount;
    }

    public double getAverageBytesPerWriteAfterCompression() {
        return (double)this.totalBytesAfterCompression / (double)this.writeCount;
    }

    public double getAverageMillisPerWrite() {
        return (double)this.totalNanos / (1000000.0 * (double)this.writeCount);
    }

    void record(long bytesBeforeCompression, long bytesAfterCompression, long nanos) {
        this.totalBytesBeforeCompression += bytesBeforeCompression;
        this.totalBytesAfterCompression += bytesAfterCompression;
        this.totalNanos += nanos;
        ++this.writeCount;
    }
}

