/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.embedded.util.CappedDatabase;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveTraceRepository;

public class RowMappers {
    private RowMappers() {
    }

    public static @Nullable Long getLong(ResultSet resultSet, int columnIndex) throws SQLException {
        long value = resultSet.getLong(columnIndex);
        if (value == 0L && resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    public static void setLong(PreparedStatement preparedStatement, int columnIndex, @Nullable Long value) throws SQLException {
        if (value == null) {
            preparedStatement.setNull(columnIndex, -5);
        } else {
            preparedStatement.setLong(columnIndex, value);
        }
    }

    public static void setBytes(PreparedStatement preparedStatement, int columnIndex, byte[] value) throws SQLException {
        if (value == null) {
            preparedStatement.setNull(columnIndex, -3);
        } else {
            preparedStatement.setBytes(columnIndex, value);
        }
    }

    public static LiveTraceRepository.Existence getExistence(ResultSet resultSet, int columnIndex, CappedDatabase cappedDatabase) throws SQLException {
        long cappedId = resultSet.getLong(columnIndex);
        if (cappedId == 0L && resultSet.wasNull()) {
            return LiveTraceRepository.Existence.NO;
        }
        if (cappedDatabase.isExpired(cappedId)) {
            return LiveTraceRepository.Existence.EXPIRED;
        }
        return LiveTraceRepository.Existence.YES;
    }
}

