/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19-11.7.2-MariaDB, for osx10.20 (arm64)
--
-- Host: localhost    Database: jwdb
-- ------------------------------------------------------
-- Server version	11.7.2-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*M!100616 SET @OLD_NOTE_VERBOSITY=@@NOTE_VERBOSITY, NOTE_VERBOSITY=0 */;

--
-- Table structure for table `SHKActivities`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKActivities` (
  `Id` varchar(100) NOT NULL,
  `ActivitySetDefinitionId` varchar(90) DEFAULT NULL,
  `ActivityDefinitionId` varchar(90) NOT NULL,
  `Process` decimal(19,0) NOT NULL,
  `TheResource` decimal(19,0) DEFAULT NULL,
  `PDefName` varchar(200) NOT NULL,
  `ProcessId` varchar(200) NOT NULL,
  `ResourceId` varchar(100) DEFAULT NULL,
  `State` decimal(19,0) NOT NULL,
  `BlockActivityId` varchar(100) DEFAULT NULL,
  `Performer` varchar(100) DEFAULT NULL,
  `IsPerformerAsynchronous` smallint(6) DEFAULT NULL,
  `Priority` int(11) DEFAULT NULL,
  `Name` varchar(254) DEFAULT NULL,
  `Activated` bigint(20) NOT NULL,
  `ActivatedTZO` bigint(20) NOT NULL,
  `Accepted` bigint(20) DEFAULT NULL,
  `AcceptedTZO` bigint(20) DEFAULT NULL,
  `LastStateTime` bigint(20) NOT NULL,
  `LastStateTimeTZO` bigint(20) NOT NULL,
  `LimitTime` bigint(20) NOT NULL,
  `LimitTimeTZO` bigint(20) NOT NULL,
  `Description` varchar(254) DEFAULT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKActivities` (`Id`),
  KEY `SHKActivities_TheResource` (`TheResource`),
  KEY `SHKActivities_State` (`State`),
  KEY `I2_SHKActivities` (`Process`,`ActivitySetDefinitionId`,`ActivityDefinitionId`),
  KEY `I3_SHKActivities` (`Process`,`State`),
  CONSTRAINT `SHKActivities_Process` FOREIGN KEY (`Process`) REFERENCES `SHKProcesses` (`oid`),
  CONSTRAINT `SHKActivities_State` FOREIGN KEY (`State`) REFERENCES `SHKActivityStates` (`oid`),
  CONSTRAINT `SHKActivities_TheResource` FOREIGN KEY (`TheResource`) REFERENCES `SHKResourcesTable` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKActivities`
--

LOCK TABLES `SHKActivities` WRITE;
/*!40000 ALTER TABLE `SHKActivities` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKActivities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKActivityData`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKActivityData` (
  `Activity` decimal(19,0) NOT NULL,
  `VariableDefinitionId` varchar(100) NOT NULL,
  `VariableType` int(11) NOT NULL,
  `VariableValue` mediumblob DEFAULT NULL,
  `VariableValueXML` text DEFAULT NULL,
  `VariableValueVCHAR` varchar(4000) DEFAULT NULL,
  `VariableValueDBL` double DEFAULT NULL,
  `VariableValueLONG` bigint(20) DEFAULT NULL,
  `VariableValueDATE` datetime DEFAULT NULL,
  `VariableValueBOOL` smallint(6) DEFAULT NULL,
  `IsResult` smallint(6) NOT NULL,
  `OrdNo` int(11) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKActivityData` (`CNT`),
  UNIQUE KEY `I2_SHKActivityData` (`Activity`,`VariableDefinitionId`,`OrdNo`),
  CONSTRAINT `SHKActivityData_Activity` FOREIGN KEY (`Activity`) REFERENCES `SHKActivities` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKActivityData`
--

LOCK TABLES `SHKActivityData` WRITE;
/*!40000 ALTER TABLE `SHKActivityData` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKActivityData` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKActivityDataBLOBs`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKActivityDataBLOBs` (
  `ActivityDataWOB` decimal(19,0) NOT NULL,
  `VariableValue` mediumblob DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKActivityDataBLOBs` (`ActivityDataWOB`,`OrdNo`),
  CONSTRAINT `SHKActivityDataBLOBs_ActivityDataWOB` FOREIGN KEY (`ActivityDataWOB`) REFERENCES `SHKActivityDataWOB` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKActivityDataBLOBs`
--

LOCK TABLES `SHKActivityDataBLOBs` WRITE;
/*!40000 ALTER TABLE `SHKActivityDataBLOBs` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKActivityDataBLOBs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKActivityDataWOB`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKActivityDataWOB` (
  `Activity` decimal(19,0) NOT NULL,
  `VariableDefinitionId` varchar(100) NOT NULL,
  `VariableType` int(11) NOT NULL,
  `VariableValueXML` text DEFAULT NULL,
  `VariableValueVCHAR` varchar(4000) DEFAULT NULL,
  `VariableValueDBL` double DEFAULT NULL,
  `VariableValueLONG` bigint(20) DEFAULT NULL,
  `VariableValueDATE` datetime DEFAULT NULL,
  `VariableValueBOOL` smallint(6) DEFAULT NULL,
  `IsResult` smallint(6) NOT NULL,
  `OrdNo` int(11) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKActivityDataWOB` (`CNT`),
  UNIQUE KEY `I2_SHKActivityDataWOB` (`Activity`,`VariableDefinitionId`,`OrdNo`),
  CONSTRAINT `SHKActivityDataWOB_Activity` FOREIGN KEY (`Activity`) REFERENCES `SHKActivities` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKActivityDataWOB`
--

LOCK TABLES `SHKActivityDataWOB` WRITE;
/*!40000 ALTER TABLE `SHKActivityDataWOB` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKActivityDataWOB` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKActivityStateEventAudits`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKActivityStateEventAudits` (
  `KeyValue` varchar(30) NOT NULL,
  `Name` varchar(50) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKActivityStateEventAudits` (`KeyValue`),
  UNIQUE KEY `I2_SHKActivityStateEventAudits` (`Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKActivityStateEventAudits`
--

LOCK TABLES `SHKActivityStateEventAudits` WRITE;
/*!40000 ALTER TABLE `SHKActivityStateEventAudits` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKActivityStateEventAudits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKActivityStates`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKActivityStates` (
  `KeyValue` varchar(30) NOT NULL,
  `Name` varchar(50) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKActivityStates` (`KeyValue`),
  UNIQUE KEY `I2_SHKActivityStates` (`Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKActivityStates`
--

LOCK TABLES `SHKActivityStates` WRITE;
/*!40000 ALTER TABLE `SHKActivityStates` DISABLE KEYS */;
INSERT INTO `SHKActivityStates` VALUES
('open.running','open.running',1000001,0),
('open.not_running.not_started','open.not_running.not_started',1000003,0),
('open.not_running.suspended','open.not_running.suspended',1000005,0),
('closed.completed','closed.completed',1000007,0),
('closed.terminated','closed.terminated',1000009,0),
('closed.aborted','closed.aborted',1000011,0);
/*!40000 ALTER TABLE `SHKActivityStates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKAndJoinTable`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKAndJoinTable` (
  `Process` decimal(19,0) NOT NULL,
  `BlockActivity` decimal(19,0) DEFAULT NULL,
  `ActivityDefinitionId` varchar(90) NOT NULL,
  `Activity` decimal(19,0) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKAndJoinTable` (`CNT`),
  KEY `SHKAndJoinTable_BlockActivity` (`BlockActivity`),
  KEY `I2_SHKAndJoinTable` (`Process`,`BlockActivity`,`ActivityDefinitionId`),
  KEY `I3_SHKAndJoinTable` (`Activity`),
  CONSTRAINT `SHKAndJoinTable_Activity` FOREIGN KEY (`Activity`) REFERENCES `SHKActivities` (`oid`),
  CONSTRAINT `SHKAndJoinTable_BlockActivity` FOREIGN KEY (`BlockActivity`) REFERENCES `SHKActivities` (`oid`),
  CONSTRAINT `SHKAndJoinTable_Process` FOREIGN KEY (`Process`) REFERENCES `SHKProcesses` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKAndJoinTable`
--

LOCK TABLES `SHKAndJoinTable` WRITE;
/*!40000 ALTER TABLE `SHKAndJoinTable` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKAndJoinTable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKAssignmentEventAudits`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKAssignmentEventAudits` (
  `RecordedTime` bigint(20) NOT NULL,
  `RecordedTimeTZO` bigint(20) NOT NULL,
  `TheUsername` varchar(100) NOT NULL,
  `TheType` decimal(19,0) NOT NULL,
  `ActivityId` varchar(100) NOT NULL,
  `ActivityName` varchar(254) DEFAULT NULL,
  `ProcessId` varchar(100) NOT NULL,
  `ProcessName` varchar(254) DEFAULT NULL,
  `ProcessFactoryName` varchar(200) NOT NULL,
  `ProcessFactoryVersion` varchar(20) NOT NULL,
  `ActivityDefinitionId` varchar(90) NOT NULL,
  `ActivityDefinitionName` varchar(90) DEFAULT NULL,
  `ActivityDefinitionType` int(11) NOT NULL,
  `ProcessDefinitionId` varchar(90) NOT NULL,
  `ProcessDefinitionName` varchar(90) DEFAULT NULL,
  `PackageId` varchar(90) NOT NULL,
  `OldResourceUsername` varchar(100) DEFAULT NULL,
  `OldResourceName` varchar(100) DEFAULT NULL,
  `NewResourceUsername` varchar(100) NOT NULL,
  `NewResourceName` varchar(100) DEFAULT NULL,
  `IsAccepted` smallint(6) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKAssignmentEventAudits` (`CNT`),
  KEY `SHKAssignmentEventAudits_TheType` (`TheType`),
  CONSTRAINT `SHKAssignmentEventAudits_TheType` FOREIGN KEY (`TheType`) REFERENCES `SHKEventTypes` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKAssignmentEventAudits`
--

LOCK TABLES `SHKAssignmentEventAudits` WRITE;
/*!40000 ALTER TABLE `SHKAssignmentEventAudits` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKAssignmentEventAudits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKAssignmentsTable`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKAssignmentsTable` (
  `Activity` decimal(19,0) NOT NULL,
  `TheResource` decimal(19,0) NOT NULL,
  `ActivityId` varchar(100) NOT NULL,
  `ActivityProcessId` varchar(100) NOT NULL,
  `ActivityProcessDefName` varchar(200) NOT NULL,
  `ResourceId` varchar(100) NOT NULL,
  `IsAccepted` smallint(6) NOT NULL,
  `IsValid` smallint(6) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKAssignmentsTable` (`CNT`),
  UNIQUE KEY `I2_SHKAssignmentsTable` (`Activity`,`TheResource`),
  KEY `I3_SHKAssignmentsTable` (`TheResource`,`IsValid`),
  KEY `I4_SHKAssignmentsTable` (`ActivityId`),
  KEY `I5_SHKAssignmentsTable` (`ResourceId`),
  KEY `FK_rnb6mhntls567xpifcfvygkuu` (`ActivityProcessId`),
  CONSTRAINT `FK_183e6adufsi558hl5p4dqkqsx` FOREIGN KEY (`ActivityId`) REFERENCES `SHKActivities` (`Id`),
  CONSTRAINT `FK_rnb6mhntls567xpifcfvygkuu` FOREIGN KEY (`ActivityProcessId`) REFERENCES `SHKProcesses` (`Id`),
  CONSTRAINT `SHKAssignmentsTable_Activity` FOREIGN KEY (`Activity`) REFERENCES `SHKActivities` (`oid`),
  CONSTRAINT `SHKAssignmentsTable_TheResource` FOREIGN KEY (`TheResource`) REFERENCES `SHKResourcesTable` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKAssignmentsTable`
--

LOCK TABLES `SHKAssignmentsTable` WRITE;
/*!40000 ALTER TABLE `SHKAssignmentsTable` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKAssignmentsTable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKCounters`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKCounters` (
  `name` varchar(100) NOT NULL,
  `the_number` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKCounters` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKCounters`
--

LOCK TABLES `SHKCounters` WRITE;
/*!40000 ALTER TABLE `SHKCounters` DISABLE KEYS */;
INSERT INTO `SHKCounters` VALUES
('_xpdldata_',1001,29504246,0);
/*!40000 ALTER TABLE `SHKCounters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKCreateProcessEventAudits`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKCreateProcessEventAudits` (
  `RecordedTime` bigint(20) NOT NULL,
  `RecordedTimeTZO` bigint(20) NOT NULL,
  `TheUsername` varchar(100) NOT NULL,
  `TheType` decimal(19,0) NOT NULL,
  `ProcessId` varchar(100) NOT NULL,
  `ProcessName` varchar(254) DEFAULT NULL,
  `ProcessFactoryName` varchar(200) NOT NULL,
  `ProcessFactoryVersion` varchar(20) NOT NULL,
  `ProcessDefinitionId` varchar(90) NOT NULL,
  `ProcessDefinitionName` varchar(90) DEFAULT NULL,
  `PackageId` varchar(90) NOT NULL,
  `PActivityId` varchar(100) DEFAULT NULL,
  `PProcessId` varchar(100) DEFAULT NULL,
  `PProcessName` varchar(254) DEFAULT NULL,
  `PProcessFactoryName` varchar(200) DEFAULT NULL,
  `PProcessFactoryVersion` varchar(20) DEFAULT NULL,
  `PActivityDefinitionId` varchar(90) DEFAULT NULL,
  `PActivityDefinitionName` varchar(90) DEFAULT NULL,
  `PProcessDefinitionId` varchar(90) DEFAULT NULL,
  `PProcessDefinitionName` varchar(90) DEFAULT NULL,
  `PPackageId` varchar(90) DEFAULT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKCreateProcessEventAudits` (`CNT`),
  KEY `SHKCreateProcessEventAudits_TheType` (`TheType`),
  CONSTRAINT `SHKCreateProcessEventAudits_TheType` FOREIGN KEY (`TheType`) REFERENCES `SHKEventTypes` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKCreateProcessEventAudits`
--

LOCK TABLES `SHKCreateProcessEventAudits` WRITE;
/*!40000 ALTER TABLE `SHKCreateProcessEventAudits` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKCreateProcessEventAudits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKDataEventAudits`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKDataEventAudits` (
  `RecordedTime` bigint(20) NOT NULL,
  `RecordedTimeTZO` bigint(20) NOT NULL,
  `TheUsername` varchar(100) NOT NULL,
  `TheType` decimal(19,0) NOT NULL,
  `ActivityId` varchar(100) DEFAULT NULL,
  `ActivityName` varchar(254) DEFAULT NULL,
  `ProcessId` varchar(100) NOT NULL,
  `ProcessName` varchar(254) DEFAULT NULL,
  `ProcessFactoryName` varchar(200) NOT NULL,
  `ProcessFactoryVersion` varchar(20) NOT NULL,
  `ActivityDefinitionId` varchar(90) DEFAULT NULL,
  `ActivityDefinitionName` varchar(90) DEFAULT NULL,
  `ActivityDefinitionType` int(11) DEFAULT NULL,
  `ProcessDefinitionId` varchar(90) NOT NULL,
  `ProcessDefinitionName` varchar(90) DEFAULT NULL,
  `PackageId` varchar(90) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKDataEventAudits` (`CNT`),
  KEY `SHKDataEventAudits_TheType` (`TheType`),
  CONSTRAINT `SHKDataEventAudits_TheType` FOREIGN KEY (`TheType`) REFERENCES `SHKEventTypes` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKDataEventAudits`
--

LOCK TABLES `SHKDataEventAudits` WRITE;
/*!40000 ALTER TABLE `SHKDataEventAudits` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKDataEventAudits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKDeadlines`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKDeadlines` (
  `Process` decimal(19,0) NOT NULL,
  `Activity` decimal(19,0) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `TimeLimit` bigint(20) NOT NULL,
  `TimeLimitTZO` bigint(20) NOT NULL,
  `ExceptionName` varchar(100) NOT NULL,
  `IsSynchronous` smallint(6) NOT NULL,
  `IsExecuted` smallint(6) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKDeadlines` (`CNT`),
  KEY `I2_SHKDeadlines` (`Process`,`TimeLimit`),
  KEY `I3_SHKDeadlines` (`Activity`,`TimeLimit`),
  CONSTRAINT `SHKDeadlines_Activity` FOREIGN KEY (`Activity`) REFERENCES `SHKActivities` (`oid`),
  CONSTRAINT `SHKDeadlines_Process` FOREIGN KEY (`Process`) REFERENCES `SHKProcesses` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKDeadlines`
--

LOCK TABLES `SHKDeadlines` WRITE;
/*!40000 ALTER TABLE `SHKDeadlines` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKDeadlines` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKEventTypes`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKEventTypes` (
  `KeyValue` varchar(30) NOT NULL,
  `Name` varchar(50) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKEventTypes` (`KeyValue`),
  UNIQUE KEY `I2_SHKEventTypes` (`Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKEventTypes`
--

LOCK TABLES `SHKEventTypes` WRITE;
/*!40000 ALTER TABLE `SHKEventTypes` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKEventTypes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKGroupGroupTable`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKGroupGroupTable` (
  `sub_gid` decimal(19,0) NOT NULL,
  `groupid` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKGroupGroupTable` (`sub_gid`,`groupid`),
  KEY `I2_SHKGroupGroupTable` (`groupid`),
  CONSTRAINT `SHKGroupGroupTable_groupid` FOREIGN KEY (`groupid`) REFERENCES `SHKGroupTable` (`oid`),
  CONSTRAINT `SHKGroupGroupTable_sub_gid` FOREIGN KEY (`sub_gid`) REFERENCES `SHKGroupTable` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKGroupGroupTable`
--

LOCK TABLES `SHKGroupGroupTable` WRITE;
/*!40000 ALTER TABLE `SHKGroupGroupTable` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKGroupGroupTable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKGroupTable`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKGroupTable` (
  `groupid` varchar(100) NOT NULL,
  `description` varchar(254) DEFAULT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKGroupTable` (`groupid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKGroupTable`
--

LOCK TABLES `SHKGroupTable` WRITE;
/*!40000 ALTER TABLE `SHKGroupTable` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKGroupTable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKGroupUser`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKGroupUser` (
  `USERNAME` varchar(100) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKGroupUser` (`USERNAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKGroupUser`
--

LOCK TABLES `SHKGroupUser` WRITE;
/*!40000 ALTER TABLE `SHKGroupUser` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKGroupUser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKGroupUserPackLevelPart`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKGroupUserPackLevelPart` (
  `PARTICIPANTOID` decimal(19,0) NOT NULL,
  `USEROID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKGroupUserPackLevelPart` (`PARTICIPANTOID`,`USEROID`),
  KEY `SHKGroupUserPackLevelPart_USEROID` (`USEROID`),
  CONSTRAINT `SHKGroupUserPackLevelPart_PARTICIPANTOID` FOREIGN KEY (`PARTICIPANTOID`) REFERENCES `SHKPackLevelParticipant` (`oid`),
  CONSTRAINT `SHKGroupUserPackLevelPart_USEROID` FOREIGN KEY (`USEROID`) REFERENCES `SHKGroupUser` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKGroupUserPackLevelPart`
--

LOCK TABLES `SHKGroupUserPackLevelPart` WRITE;
/*!40000 ALTER TABLE `SHKGroupUserPackLevelPart` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKGroupUserPackLevelPart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKGroupUserProcLevelPart`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKGroupUserProcLevelPart` (
  `PARTICIPANTOID` decimal(19,0) NOT NULL,
  `USEROID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKGroupUserProcLevelPart` (`PARTICIPANTOID`,`USEROID`),
  KEY `SHKGroupUserProcLevelPart_USEROID` (`USEROID`),
  CONSTRAINT `SHKGroupUserProcLevelPart_PARTICIPANTOID` FOREIGN KEY (`PARTICIPANTOID`) REFERENCES `SHKProcLevelParticipant` (`oid`),
  CONSTRAINT `SHKGroupUserProcLevelPart_USEROID` FOREIGN KEY (`USEROID`) REFERENCES `SHKGroupUser` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKGroupUserProcLevelPart`
--

LOCK TABLES `SHKGroupUserProcLevelPart` WRITE;
/*!40000 ALTER TABLE `SHKGroupUserProcLevelPart` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKGroupUserProcLevelPart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKNewEventAuditData`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKNewEventAuditData` (
  `DataEventAudit` decimal(19,0) NOT NULL,
  `VariableDefinitionId` varchar(100) NOT NULL,
  `VariableType` int(11) NOT NULL,
  `VariableValue` mediumblob DEFAULT NULL,
  `VariableValueXML` text DEFAULT NULL,
  `VariableValueVCHAR` varchar(4000) DEFAULT NULL,
  `VariableValueDBL` float DEFAULT NULL,
  `VariableValueLONG` bigint(20) DEFAULT NULL,
  `VariableValueDATE` datetime DEFAULT NULL,
  `VariableValueBOOL` smallint(6) DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKNewEventAuditData` (`CNT`),
  UNIQUE KEY `I2_SHKNewEventAuditData` (`DataEventAudit`,`VariableDefinitionId`,`OrdNo`),
  CONSTRAINT `SHKNewEventAuditData_DataEventAudit` FOREIGN KEY (`DataEventAudit`) REFERENCES `SHKDataEventAudits` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKNewEventAuditData`
--

LOCK TABLES `SHKNewEventAuditData` WRITE;
/*!40000 ALTER TABLE `SHKNewEventAuditData` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKNewEventAuditData` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKNewEventAuditDataBLOBs`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKNewEventAuditDataBLOBs` (
  `NewEventAuditDataWOB` decimal(19,0) NOT NULL,
  `VariableValue` mediumblob DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKNewEventAuditDataBLOBs` (`NewEventAuditDataWOB`,`OrdNo`),
  CONSTRAINT `SHKNewEventAuditDataBLOBs_NewEventAuditDataWOB` FOREIGN KEY (`NewEventAuditDataWOB`) REFERENCES `SHKNewEventAuditDataWOB` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKNewEventAuditDataBLOBs`
--

LOCK TABLES `SHKNewEventAuditDataBLOBs` WRITE;
/*!40000 ALTER TABLE `SHKNewEventAuditDataBLOBs` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKNewEventAuditDataBLOBs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKNewEventAuditDataWOB`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKNewEventAuditDataWOB` (
  `DataEventAudit` decimal(19,0) NOT NULL,
  `VariableDefinitionId` varchar(100) NOT NULL,
  `VariableType` int(11) NOT NULL,
  `VariableValueXML` text DEFAULT NULL,
  `VariableValueVCHAR` varchar(4000) DEFAULT NULL,
  `VariableValueDBL` float DEFAULT NULL,
  `VariableValueLONG` bigint(20) DEFAULT NULL,
  `VariableValueDATE` datetime DEFAULT NULL,
  `VariableValueBOOL` smallint(6) DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKNewEventAuditDataWOB` (`CNT`),
  UNIQUE KEY `I2_SHKNewEventAuditDataWOB` (`DataEventAudit`,`VariableDefinitionId`,`OrdNo`),
  CONSTRAINT `SHKNewEventAuditDataWOB_DataEventAudit` FOREIGN KEY (`DataEventAudit`) REFERENCES `SHKDataEventAudits` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKNewEventAuditDataWOB`
--

LOCK TABLES `SHKNewEventAuditDataWOB` WRITE;
/*!40000 ALTER TABLE `SHKNewEventAuditDataWOB` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKNewEventAuditDataWOB` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKNextXPDLVersions`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKNextXPDLVersions` (
  `XPDLId` varchar(90) NOT NULL,
  `NextVersion` varchar(20) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKNextXPDLVersions` (`XPDLId`,`NextVersion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKNextXPDLVersions`
--

LOCK TABLES `SHKNextXPDLVersions` WRITE;
/*!40000 ALTER TABLE `SHKNextXPDLVersions` DISABLE KEYS */;
INSERT INTO `SHKNextXPDLVersions` VALUES
('crm','2',1000201,0),
('expenseclaim','2',1000205,0),
('isr','2',1000209,0),
('JogetDxShowcase','2',1000213,0);
/*!40000 ALTER TABLE `SHKNextXPDLVersions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKNormalUser`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKNormalUser` (
  `USERNAME` varchar(100) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKNormalUser` (`USERNAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKNormalUser`
--

LOCK TABLES `SHKNormalUser` WRITE;
/*!40000 ALTER TABLE `SHKNormalUser` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKNormalUser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKOldEventAuditData`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKOldEventAuditData` (
  `DataEventAudit` decimal(19,0) NOT NULL,
  `VariableDefinitionId` varchar(100) NOT NULL,
  `VariableType` int(11) NOT NULL,
  `VariableValue` mediumblob DEFAULT NULL,
  `VariableValueXML` text DEFAULT NULL,
  `VariableValueVCHAR` varchar(4000) DEFAULT NULL,
  `VariableValueDBL` float DEFAULT NULL,
  `VariableValueLONG` bigint(20) DEFAULT NULL,
  `VariableValueDATE` datetime DEFAULT NULL,
  `VariableValueBOOL` smallint(6) DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKOldEventAuditData` (`CNT`),
  UNIQUE KEY `I2_SHKOldEventAuditData` (`DataEventAudit`,`VariableDefinitionId`,`OrdNo`),
  CONSTRAINT `SHKOldEventAuditData_DataEventAudit` FOREIGN KEY (`DataEventAudit`) REFERENCES `SHKDataEventAudits` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKOldEventAuditData`
--

LOCK TABLES `SHKOldEventAuditData` WRITE;
/*!40000 ALTER TABLE `SHKOldEventAuditData` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKOldEventAuditData` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKOldEventAuditDataBLOBs`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKOldEventAuditDataBLOBs` (
  `OldEventAuditDataWOB` decimal(19,0) NOT NULL,
  `VariableValue` mediumblob DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKOldEventAuditDataBLOBs` (`OldEventAuditDataWOB`,`OrdNo`),
  CONSTRAINT `SHKOldEventAuditDataBLOBs_OldEventAuditDataWOB` FOREIGN KEY (`OldEventAuditDataWOB`) REFERENCES `SHKOldEventAuditDataWOB` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKOldEventAuditDataBLOBs`
--

LOCK TABLES `SHKOldEventAuditDataBLOBs` WRITE;
/*!40000 ALTER TABLE `SHKOldEventAuditDataBLOBs` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKOldEventAuditDataBLOBs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKOldEventAuditDataWOB`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKOldEventAuditDataWOB` (
  `DataEventAudit` decimal(19,0) NOT NULL,
  `VariableDefinitionId` varchar(100) NOT NULL,
  `VariableType` int(11) NOT NULL,
  `VariableValueXML` text DEFAULT NULL,
  `VariableValueVCHAR` varchar(4000) DEFAULT NULL,
  `VariableValueDBL` float DEFAULT NULL,
  `VariableValueLONG` bigint(20) DEFAULT NULL,
  `VariableValueDATE` datetime DEFAULT NULL,
  `VariableValueBOOL` smallint(6) DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKOldEventAuditDataWOB` (`CNT`),
  UNIQUE KEY `I2_SHKOldEventAuditDataWOB` (`DataEventAudit`,`VariableDefinitionId`,`OrdNo`),
  CONSTRAINT `SHKOldEventAuditDataWOB_DataEventAudit` FOREIGN KEY (`DataEventAudit`) REFERENCES `SHKDataEventAudits` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKOldEventAuditDataWOB`
--

LOCK TABLES `SHKOldEventAuditDataWOB` WRITE;
/*!40000 ALTER TABLE `SHKOldEventAuditDataWOB` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKOldEventAuditDataWOB` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKPackLevelParticipant`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKPackLevelParticipant` (
  `PARTICIPANT_ID` varchar(90) NOT NULL,
  `PACKAGEOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKPackLevelParticipant` (`PARTICIPANT_ID`,`PACKAGEOID`),
  KEY `SHKPackLevelParticipant_PACKAGEOID` (`PACKAGEOID`),
  CONSTRAINT `SHKPackLevelParticipant_PACKAGEOID` FOREIGN KEY (`PACKAGEOID`) REFERENCES `SHKXPDLParticipantPackage` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKPackLevelParticipant`
--

LOCK TABLES `SHKPackLevelParticipant` WRITE;
/*!40000 ALTER TABLE `SHKPackLevelParticipant` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKPackLevelParticipant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKPackLevelXPDLApp`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKPackLevelXPDLApp` (
  `APPLICATION_ID` varchar(90) NOT NULL,
  `PACKAGEOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKPackLevelXPDLApp` (`APPLICATION_ID`,`PACKAGEOID`),
  KEY `SHKPackLevelXPDLApp_PACKAGEOID` (`PACKAGEOID`),
  CONSTRAINT `SHKPackLevelXPDLApp_PACKAGEOID` FOREIGN KEY (`PACKAGEOID`) REFERENCES `SHKXPDLApplicationPackage` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKPackLevelXPDLApp`
--

LOCK TABLES `SHKPackLevelXPDLApp` WRITE;
/*!40000 ALTER TABLE `SHKPackLevelXPDLApp` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKPackLevelXPDLApp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKPackLevelXPDLAppTAAppDetUsr`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKPackLevelXPDLAppTAAppDetUsr` (
  `XPDL_APPOID` decimal(19,0) NOT NULL,
  `TOOLAGENTOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKPackLevelXPDLAppTAAppDetUsr` (`XPDL_APPOID`,`TOOLAGENTOID`),
  KEY `SHKPackLevelXPDLAppTAAppDetUsr_TOOLAGENTOID` (`TOOLAGENTOID`),
  CONSTRAINT `SHKPackLevelXPDLAppTAAppDetUsr_TOOLAGENTOID` FOREIGN KEY (`TOOLAGENTOID`) REFERENCES `SHKToolAgentAppDetailUser` (`oid`),
  CONSTRAINT `SHKPackLevelXPDLAppTAAppDetUsr_XPDL_APPOID` FOREIGN KEY (`XPDL_APPOID`) REFERENCES `SHKPackLevelXPDLApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKPackLevelXPDLAppTAAppDetUsr`
--

LOCK TABLES `SHKPackLevelXPDLAppTAAppDetUsr` WRITE;
/*!40000 ALTER TABLE `SHKPackLevelXPDLAppTAAppDetUsr` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKPackLevelXPDLAppTAAppDetUsr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKPackLevelXPDLAppTAAppDetail`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKPackLevelXPDLAppTAAppDetail` (
  `XPDL_APPOID` decimal(19,0) NOT NULL,
  `TOOLAGENTOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKPackLevelXPDLAppTAAppDetail` (`XPDL_APPOID`,`TOOLAGENTOID`),
  KEY `SHKPackLevelXPDLAppTAAppDetail_TOOLAGENTOID` (`TOOLAGENTOID`),
  CONSTRAINT `SHKPackLevelXPDLAppTAAppDetail_TOOLAGENTOID` FOREIGN KEY (`TOOLAGENTOID`) REFERENCES `SHKToolAgentAppDetail` (`oid`),
  CONSTRAINT `SHKPackLevelXPDLAppTAAppDetail_XPDL_APPOID` FOREIGN KEY (`XPDL_APPOID`) REFERENCES `SHKPackLevelXPDLApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKPackLevelXPDLAppTAAppDetail`
--

LOCK TABLES `SHKPackLevelXPDLAppTAAppDetail` WRITE;
/*!40000 ALTER TABLE `SHKPackLevelXPDLAppTAAppDetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKPackLevelXPDLAppTAAppDetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKPackLevelXPDLAppTAAppUser`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKPackLevelXPDLAppTAAppUser` (
  `XPDL_APPOID` decimal(19,0) NOT NULL,
  `TOOLAGENTOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKPackLevelXPDLAppTAAppUser` (`XPDL_APPOID`,`TOOLAGENTOID`),
  KEY `SHKPackLevelXPDLAppTAAppUser_TOOLAGENTOID` (`TOOLAGENTOID`),
  CONSTRAINT `SHKPackLevelXPDLAppTAAppUser_TOOLAGENTOID` FOREIGN KEY (`TOOLAGENTOID`) REFERENCES `SHKToolAgentAppUser` (`oid`),
  CONSTRAINT `SHKPackLevelXPDLAppTAAppUser_XPDL_APPOID` FOREIGN KEY (`XPDL_APPOID`) REFERENCES `SHKPackLevelXPDLApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKPackLevelXPDLAppTAAppUser`
--

LOCK TABLES `SHKPackLevelXPDLAppTAAppUser` WRITE;
/*!40000 ALTER TABLE `SHKPackLevelXPDLAppTAAppUser` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKPackLevelXPDLAppTAAppUser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKPackLevelXPDLAppToolAgntApp`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKPackLevelXPDLAppToolAgntApp` (
  `XPDL_APPOID` decimal(19,0) NOT NULL,
  `TOOLAGENTOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKPackLevelXPDLAppToolAgntApp` (`XPDL_APPOID`,`TOOLAGENTOID`),
  KEY `SHKPackLevelXPDLAppToolAgntApp_TOOLAGENTOID` (`TOOLAGENTOID`),
  CONSTRAINT `SHKPackLevelXPDLAppToolAgntApp_TOOLAGENTOID` FOREIGN KEY (`TOOLAGENTOID`) REFERENCES `SHKToolAgentApp` (`oid`),
  CONSTRAINT `SHKPackLevelXPDLAppToolAgntApp_XPDL_APPOID` FOREIGN KEY (`XPDL_APPOID`) REFERENCES `SHKPackLevelXPDLApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKPackLevelXPDLAppToolAgntApp`
--

LOCK TABLES `SHKPackLevelXPDLAppToolAgntApp` WRITE;
/*!40000 ALTER TABLE `SHKPackLevelXPDLAppToolAgntApp` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKPackLevelXPDLAppToolAgntApp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcLevelParticipant`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKProcLevelParticipant` (
  `PARTICIPANT_ID` varchar(90) NOT NULL,
  `PROCESSOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcLevelParticipant` (`PARTICIPANT_ID`,`PROCESSOID`),
  KEY `SHKProcLevelParticipant_PROCESSOID` (`PROCESSOID`),
  CONSTRAINT `SHKProcLevelParticipant_PROCESSOID` FOREIGN KEY (`PROCESSOID`) REFERENCES `SHKXPDLParticipantProcess` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcLevelParticipant`
--

LOCK TABLES `SHKProcLevelParticipant` WRITE;
/*!40000 ALTER TABLE `SHKProcLevelParticipant` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcLevelParticipant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcLevelXPDLApp`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKProcLevelXPDLApp` (
  `APPLICATION_ID` varchar(90) NOT NULL,
  `PROCESSOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcLevelXPDLApp` (`APPLICATION_ID`,`PROCESSOID`),
  KEY `SHKProcLevelXPDLApp_PROCESSOID` (`PROCESSOID`),
  CONSTRAINT `SHKProcLevelXPDLApp_PROCESSOID` FOREIGN KEY (`PROCESSOID`) REFERENCES `SHKXPDLApplicationProcess` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcLevelXPDLApp`
--

LOCK TABLES `SHKProcLevelXPDLApp` WRITE;
/*!40000 ALTER TABLE `SHKProcLevelXPDLApp` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcLevelXPDLApp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcLevelXPDLAppTAAppDetUsr`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKProcLevelXPDLAppTAAppDetUsr` (
  `XPDL_APPOID` decimal(19,0) NOT NULL,
  `TOOLAGENTOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcLevelXPDLAppTAAppDetUsr` (`XPDL_APPOID`,`TOOLAGENTOID`),
  KEY `SHKProcLevelXPDLAppTAAppDetUsr_TOOLAGENTOID` (`TOOLAGENTOID`),
  CONSTRAINT `SHKProcLevelXPDLAppTAAppDetUsr_TOOLAGENTOID` FOREIGN KEY (`TOOLAGENTOID`) REFERENCES `SHKToolAgentAppDetailUser` (`oid`),
  CONSTRAINT `SHKProcLevelXPDLAppTAAppDetUsr_XPDL_APPOID` FOREIGN KEY (`XPDL_APPOID`) REFERENCES `SHKProcLevelXPDLApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcLevelXPDLAppTAAppDetUsr`
--

LOCK TABLES `SHKProcLevelXPDLAppTAAppDetUsr` WRITE;
/*!40000 ALTER TABLE `SHKProcLevelXPDLAppTAAppDetUsr` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcLevelXPDLAppTAAppDetUsr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcLevelXPDLAppTAAppDetail`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKProcLevelXPDLAppTAAppDetail` (
  `XPDL_APPOID` decimal(19,0) NOT NULL,
  `TOOLAGENTOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcLevelXPDLAppTAAppDetail` (`XPDL_APPOID`,`TOOLAGENTOID`),
  KEY `SHKProcLevelXPDLAppTAAppDetail_TOOLAGENTOID` (`TOOLAGENTOID`),
  CONSTRAINT `SHKProcLevelXPDLAppTAAppDetail_TOOLAGENTOID` FOREIGN KEY (`TOOLAGENTOID`) REFERENCES `SHKToolAgentAppDetail` (`oid`),
  CONSTRAINT `SHKProcLevelXPDLAppTAAppDetail_XPDL_APPOID` FOREIGN KEY (`XPDL_APPOID`) REFERENCES `SHKProcLevelXPDLApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcLevelXPDLAppTAAppDetail`
--

LOCK TABLES `SHKProcLevelXPDLAppTAAppDetail` WRITE;
/*!40000 ALTER TABLE `SHKProcLevelXPDLAppTAAppDetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcLevelXPDLAppTAAppDetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcLevelXPDLAppTAAppUser`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKProcLevelXPDLAppTAAppUser` (
  `XPDL_APPOID` decimal(19,0) NOT NULL,
  `TOOLAGENTOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcLevelXPDLAppTAAppUser` (`XPDL_APPOID`,`TOOLAGENTOID`),
  KEY `SHKProcLevelXPDLAppTAAppUser_TOOLAGENTOID` (`TOOLAGENTOID`),
  CONSTRAINT `SHKProcLevelXPDLAppTAAppUser_TOOLAGENTOID` FOREIGN KEY (`TOOLAGENTOID`) REFERENCES `SHKToolAgentAppUser` (`oid`),
  CONSTRAINT `SHKProcLevelXPDLAppTAAppUser_XPDL_APPOID` FOREIGN KEY (`XPDL_APPOID`) REFERENCES `SHKProcLevelXPDLApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcLevelXPDLAppTAAppUser`
--

LOCK TABLES `SHKProcLevelXPDLAppTAAppUser` WRITE;
/*!40000 ALTER TABLE `SHKProcLevelXPDLAppTAAppUser` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcLevelXPDLAppTAAppUser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcLevelXPDLAppToolAgntApp`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKProcLevelXPDLAppToolAgntApp` (
  `XPDL_APPOID` decimal(19,0) NOT NULL,
  `TOOLAGENTOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcLevelXPDLAppToolAgntApp` (`XPDL_APPOID`,`TOOLAGENTOID`),
  KEY `SHKProcLevelXPDLAppToolAgntApp_TOOLAGENTOID` (`TOOLAGENTOID`),
  CONSTRAINT `SHKProcLevelXPDLAppToolAgntApp_TOOLAGENTOID` FOREIGN KEY (`TOOLAGENTOID`) REFERENCES `SHKToolAgentApp` (`oid`),
  CONSTRAINT `SHKProcLevelXPDLAppToolAgntApp_XPDL_APPOID` FOREIGN KEY (`XPDL_APPOID`) REFERENCES `SHKProcLevelXPDLApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcLevelXPDLAppToolAgntApp`
--

LOCK TABLES `SHKProcLevelXPDLAppToolAgntApp` WRITE;
/*!40000 ALTER TABLE `SHKProcLevelXPDLAppToolAgntApp` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcLevelXPDLAppToolAgntApp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcessData`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKProcessData` (
  `Process` decimal(19,0) NOT NULL,
  `VariableDefinitionId` varchar(100) NOT NULL,
  `VariableType` int(11) NOT NULL,
  `VariableValue` mediumblob DEFAULT NULL,
  `VariableValueXML` text DEFAULT NULL,
  `VariableValueVCHAR` varchar(4000) DEFAULT NULL,
  `VariableValueDBL` double DEFAULT NULL,
  `VariableValueLONG` bigint(20) DEFAULT NULL,
  `VariableValueDATE` datetime DEFAULT NULL,
  `VariableValueBOOL` smallint(6) DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcessData` (`CNT`),
  UNIQUE KEY `I2_SHKProcessData` (`Process`,`VariableDefinitionId`,`OrdNo`),
  CONSTRAINT `SHKProcessData_Process` FOREIGN KEY (`Process`) REFERENCES `SHKProcesses` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcessData`
--

LOCK TABLES `SHKProcessData` WRITE;
/*!40000 ALTER TABLE `SHKProcessData` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcessData` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcessDataBLOBs`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKProcessDataBLOBs` (
  `ProcessDataWOB` decimal(19,0) NOT NULL,
  `VariableValue` mediumblob DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcessDataBLOBs` (`ProcessDataWOB`,`OrdNo`),
  CONSTRAINT `SHKProcessDataBLOBs_ProcessDataWOB` FOREIGN KEY (`ProcessDataWOB`) REFERENCES `SHKProcessDataWOB` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcessDataBLOBs`
--

LOCK TABLES `SHKProcessDataBLOBs` WRITE;
/*!40000 ALTER TABLE `SHKProcessDataBLOBs` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcessDataBLOBs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcessDataWOB`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKProcessDataWOB` (
  `Process` decimal(19,0) NOT NULL,
  `VariableDefinitionId` varchar(100) NOT NULL,
  `VariableType` int(11) NOT NULL,
  `VariableValueXML` text DEFAULT NULL,
  `VariableValueVCHAR` varchar(4000) DEFAULT NULL,
  `VariableValueDBL` double DEFAULT NULL,
  `VariableValueLONG` bigint(20) DEFAULT NULL,
  `VariableValueDATE` datetime DEFAULT NULL,
  `VariableValueBOOL` smallint(6) DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcessDataWOB` (`CNT`),
  UNIQUE KEY `I2_SHKProcessDataWOB` (`Process`,`VariableDefinitionId`,`OrdNo`),
  CONSTRAINT `SHKProcessDataWOB_Process` FOREIGN KEY (`Process`) REFERENCES `SHKProcesses` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcessDataWOB`
--

LOCK TABLES `SHKProcessDataWOB` WRITE;
/*!40000 ALTER TABLE `SHKProcessDataWOB` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcessDataWOB` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcessDefinitions`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKProcessDefinitions` (
  `Name` varchar(200) NOT NULL,
  `PackageId` varchar(90) NOT NULL,
  `ProcessDefinitionId` varchar(90) NOT NULL,
  `ProcessDefinitionCreated` bigint(20) NOT NULL,
  `ProcessDefinitionVersion` varchar(20) NOT NULL,
  `State` int(11) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcessDefinitions` (`Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcessDefinitions`
--

LOCK TABLES `SHKProcessDefinitions` WRITE;
/*!40000 ALTER TABLE `SHKProcessDefinitions` DISABLE KEYS */;
INSERT INTO `SHKProcessDefinitions` VALUES
('crm#1#process1','crm','process1',1764202270381,'1',0,1000204,0),
('expenseclaim#1#process1','expenseclaim','process1',1764202275890,'1',0,1000208,0),
('isr#1#isr','isr','isr',1764202277774,'1',0,1000212,0),
('JogetDxShowcase#1#process1','JogetDxShowcase','process1',1764202279614,'1',0,1000216,0),
('JogetDxShowcase#1#populateChart2','JogetDxShowcase','populateChart2',1764202279614,'1',0,1000217,0);
/*!40000 ALTER TABLE `SHKProcessDefinitions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcessRequesters`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKProcessRequesters` (
  `Id` varchar(100) NOT NULL,
  `ActivityRequester` decimal(19,0) DEFAULT NULL,
  `ResourceRequester` decimal(19,0) DEFAULT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcessRequesters` (`Id`),
  KEY `I2_SHKProcessRequesters` (`ActivityRequester`),
  KEY `I3_SHKProcessRequesters` (`ResourceRequester`),
  CONSTRAINT `SHKProcessRequesters_ActivityRequester` FOREIGN KEY (`ActivityRequester`) REFERENCES `SHKActivities` (`oid`),
  CONSTRAINT `SHKProcessRequesters_ResourceRequester` FOREIGN KEY (`ResourceRequester`) REFERENCES `SHKResourcesTable` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcessRequesters`
--

LOCK TABLES `SHKProcessRequesters` WRITE;
/*!40000 ALTER TABLE `SHKProcessRequesters` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcessRequesters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcessStateEventAudits`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKProcessStateEventAudits` (
  `KeyValue` varchar(30) NOT NULL,
  `Name` varchar(50) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcessStateEventAudits` (`KeyValue`),
  UNIQUE KEY `I2_SHKProcessStateEventAudits` (`Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcessStateEventAudits`
--

LOCK TABLES `SHKProcessStateEventAudits` WRITE;
/*!40000 ALTER TABLE `SHKProcessStateEventAudits` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcessStateEventAudits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcessStates`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKProcessStates` (
  `KeyValue` varchar(30) NOT NULL,
  `Name` varchar(50) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcessStates` (`KeyValue`),
  UNIQUE KEY `I2_SHKProcessStates` (`Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcessStates`
--

LOCK TABLES `SHKProcessStates` WRITE;
/*!40000 ALTER TABLE `SHKProcessStates` DISABLE KEYS */;
INSERT INTO `SHKProcessStates` VALUES
('open.running','open.running',1000000,0),
('open.not_running.not_started','open.not_running.not_started',1000002,0),
('open.not_running.suspended','open.not_running.suspended',1000004,0),
('closed.completed','closed.completed',1000006,0),
('closed.terminated','closed.terminated',1000008,0),
('closed.aborted','closed.aborted',1000010,0);
/*!40000 ALTER TABLE `SHKProcessStates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcesses`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKProcesses` (
  `SyncVersion` bigint(20) NOT NULL,
  `Id` varchar(100) NOT NULL,
  `ProcessDefinition` decimal(19,0) NOT NULL,
  `PDefName` varchar(200) NOT NULL,
  `ActivityRequesterId` varchar(100) DEFAULT NULL,
  `ActivityRequesterProcessId` varchar(100) DEFAULT NULL,
  `ResourceRequesterId` varchar(100) NOT NULL,
  `ExternalRequesterClassName` varchar(254) DEFAULT NULL,
  `State` decimal(19,0) NOT NULL,
  `Priority` int(11) DEFAULT NULL,
  `Name` varchar(254) DEFAULT NULL,
  `Created` bigint(20) NOT NULL,
  `CreatedTZO` bigint(20) NOT NULL,
  `Started` bigint(20) DEFAULT NULL,
  `StartedTZO` bigint(20) DEFAULT NULL,
  `LastStateTime` bigint(20) NOT NULL,
  `LastStateTimeTZO` bigint(20) NOT NULL,
  `LimitTime` bigint(20) NOT NULL,
  `LimitTimeTZO` bigint(20) NOT NULL,
  `Description` varchar(254) DEFAULT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcesses` (`Id`),
  KEY `I2_SHKProcesses` (`ProcessDefinition`),
  KEY `I3_SHKProcesses` (`State`),
  KEY `I4_SHKProcesses` (`ActivityRequesterId`),
  KEY `I5_SHKProcesses` (`ResourceRequesterId`),
  CONSTRAINT `SHKProcesses_ProcessDefinition` FOREIGN KEY (`ProcessDefinition`) REFERENCES `SHKProcessDefinitions` (`oid`),
  CONSTRAINT `SHKProcesses_State` FOREIGN KEY (`State`) REFERENCES `SHKProcessStates` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcesses`
--

LOCK TABLES `SHKProcesses` WRITE;
/*!40000 ALTER TABLE `SHKProcesses` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcesses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKResourcesTable`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKResourcesTable` (
  `Username` varchar(100) NOT NULL,
  `Name` varchar(100) DEFAULT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKResourcesTable` (`Username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKResourcesTable`
--

LOCK TABLES `SHKResourcesTable` WRITE;
/*!40000 ALTER TABLE `SHKResourcesTable` DISABLE KEYS */;
INSERT INTO `SHKResourcesTable` VALUES
('roleSystem',NULL,1000200,0);
/*!40000 ALTER TABLE `SHKResourcesTable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKStateEventAudits`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKStateEventAudits` (
  `RecordedTime` bigint(20) NOT NULL,
  `RecordedTimeTZO` bigint(20) NOT NULL,
  `TheUsername` varchar(100) NOT NULL,
  `TheType` decimal(19,0) NOT NULL,
  `ActivityId` varchar(100) DEFAULT NULL,
  `ActivityName` varchar(254) DEFAULT NULL,
  `ProcessId` varchar(100) NOT NULL,
  `ProcessName` varchar(254) DEFAULT NULL,
  `ProcessFactoryName` varchar(200) NOT NULL,
  `ProcessFactoryVersion` varchar(20) NOT NULL,
  `ActivityDefinitionId` varchar(90) DEFAULT NULL,
  `ActivityDefinitionName` varchar(90) DEFAULT NULL,
  `ActivityDefinitionType` int(11) DEFAULT NULL,
  `ProcessDefinitionId` varchar(90) NOT NULL,
  `ProcessDefinitionName` varchar(90) DEFAULT NULL,
  `PackageId` varchar(90) NOT NULL,
  `OldProcessState` decimal(19,0) DEFAULT NULL,
  `NewProcessState` decimal(19,0) DEFAULT NULL,
  `OldActivityState` decimal(19,0) DEFAULT NULL,
  `NewActivityState` decimal(19,0) DEFAULT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKStateEventAudits` (`CNT`),
  KEY `SHKStateEventAudits_TheType` (`TheType`),
  KEY `SHKStateEventAudits_OldProcessState` (`OldProcessState`),
  KEY `SHKStateEventAudits_NewProcessState` (`NewProcessState`),
  KEY `SHKStateEventAudits_OldActivityState` (`OldActivityState`),
  KEY `SHKStateEventAudits_NewActivityState` (`NewActivityState`),
  CONSTRAINT `SHKStateEventAudits_NewActivityState` FOREIGN KEY (`NewActivityState`) REFERENCES `SHKActivityStateEventAudits` (`oid`),
  CONSTRAINT `SHKStateEventAudits_NewProcessState` FOREIGN KEY (`NewProcessState`) REFERENCES `SHKProcessStateEventAudits` (`oid`),
  CONSTRAINT `SHKStateEventAudits_OldActivityState` FOREIGN KEY (`OldActivityState`) REFERENCES `SHKActivityStateEventAudits` (`oid`),
  CONSTRAINT `SHKStateEventAudits_OldProcessState` FOREIGN KEY (`OldProcessState`) REFERENCES `SHKProcessStateEventAudits` (`oid`),
  CONSTRAINT `SHKStateEventAudits_TheType` FOREIGN KEY (`TheType`) REFERENCES `SHKEventTypes` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKStateEventAudits`
--

LOCK TABLES `SHKStateEventAudits` WRITE;
/*!40000 ALTER TABLE `SHKStateEventAudits` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKStateEventAudits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKToolAgentApp`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKToolAgentApp` (
  `TOOL_AGENT_NAME` varchar(250) NOT NULL,
  `APP_NAME` varchar(90) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKToolAgentApp` (`TOOL_AGENT_NAME`,`APP_NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKToolAgentApp`
--

LOCK TABLES `SHKToolAgentApp` WRITE;
/*!40000 ALTER TABLE `SHKToolAgentApp` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKToolAgentApp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKToolAgentAppDetail`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKToolAgentAppDetail` (
  `APP_MODE` decimal(10,0) NOT NULL,
  `TOOLAGENT_APPOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKToolAgentAppDetail` (`APP_MODE`,`TOOLAGENT_APPOID`),
  KEY `SHKToolAgentAppDetail_TOOLAGENT_APPOID` (`TOOLAGENT_APPOID`),
  CONSTRAINT `SHKToolAgentAppDetail_TOOLAGENT_APPOID` FOREIGN KEY (`TOOLAGENT_APPOID`) REFERENCES `SHKToolAgentApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKToolAgentAppDetail`
--

LOCK TABLES `SHKToolAgentAppDetail` WRITE;
/*!40000 ALTER TABLE `SHKToolAgentAppDetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKToolAgentAppDetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKToolAgentAppDetailUser`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKToolAgentAppDetailUser` (
  `TOOLAGENT_APPOID` decimal(19,0) NOT NULL,
  `USEROID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKToolAgentAppDetailUser` (`TOOLAGENT_APPOID`,`USEROID`),
  KEY `SHKToolAgentAppDetailUser_USEROID` (`USEROID`),
  CONSTRAINT `SHKToolAgentAppDetailUser_TOOLAGENT_APPOID` FOREIGN KEY (`TOOLAGENT_APPOID`) REFERENCES `SHKToolAgentAppDetail` (`oid`),
  CONSTRAINT `SHKToolAgentAppDetailUser_USEROID` FOREIGN KEY (`USEROID`) REFERENCES `SHKToolAgentUser` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKToolAgentAppDetailUser`
--

LOCK TABLES `SHKToolAgentAppDetailUser` WRITE;
/*!40000 ALTER TABLE `SHKToolAgentAppDetailUser` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKToolAgentAppDetailUser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKToolAgentAppUser`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKToolAgentAppUser` (
  `TOOLAGENT_APPOID` decimal(19,0) NOT NULL,
  `USEROID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKToolAgentAppUser` (`TOOLAGENT_APPOID`,`USEROID`),
  KEY `SHKToolAgentAppUser_USEROID` (`USEROID`),
  CONSTRAINT `SHKToolAgentAppUser_TOOLAGENT_APPOID` FOREIGN KEY (`TOOLAGENT_APPOID`) REFERENCES `SHKToolAgentApp` (`oid`),
  CONSTRAINT `SHKToolAgentAppUser_USEROID` FOREIGN KEY (`USEROID`) REFERENCES `SHKToolAgentUser` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKToolAgentAppUser`
--

LOCK TABLES `SHKToolAgentAppUser` WRITE;
/*!40000 ALTER TABLE `SHKToolAgentAppUser` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKToolAgentAppUser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKToolAgentUser`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKToolAgentUser` (
  `USERNAME` varchar(100) NOT NULL,
  `PWD` varchar(100) DEFAULT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKToolAgentUser` (`USERNAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKToolAgentUser`
--

LOCK TABLES `SHKToolAgentUser` WRITE;
/*!40000 ALTER TABLE `SHKToolAgentUser` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKToolAgentUser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKUserGroupTable`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKUserGroupTable` (
  `userid` decimal(19,0) NOT NULL,
  `groupid` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKUserGroupTable` (`userid`,`groupid`),
  KEY `SHKUserGroupTable_groupid` (`groupid`),
  CONSTRAINT `SHKUserGroupTable_groupid` FOREIGN KEY (`groupid`) REFERENCES `SHKGroupTable` (`oid`),
  CONSTRAINT `SHKUserGroupTable_userid` FOREIGN KEY (`userid`) REFERENCES `SHKUserTable` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKUserGroupTable`
--

LOCK TABLES `SHKUserGroupTable` WRITE;
/*!40000 ALTER TABLE `SHKUserGroupTable` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKUserGroupTable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKUserPackLevelPart`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKUserPackLevelPart` (
  `PARTICIPANTOID` decimal(19,0) NOT NULL,
  `USEROID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKUserPackLevelPart` (`PARTICIPANTOID`,`USEROID`),
  KEY `SHKUserPackLevelPart_USEROID` (`USEROID`),
  CONSTRAINT `SHKUserPackLevelPart_PARTICIPANTOID` FOREIGN KEY (`PARTICIPANTOID`) REFERENCES `SHKPackLevelParticipant` (`oid`),
  CONSTRAINT `SHKUserPackLevelPart_USEROID` FOREIGN KEY (`USEROID`) REFERENCES `SHKNormalUser` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKUserPackLevelPart`
--

LOCK TABLES `SHKUserPackLevelPart` WRITE;
/*!40000 ALTER TABLE `SHKUserPackLevelPart` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKUserPackLevelPart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKUserProcLevelParticipant`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKUserProcLevelParticipant` (
  `PARTICIPANTOID` decimal(19,0) NOT NULL,
  `USEROID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKUserProcLevelParticipant` (`PARTICIPANTOID`,`USEROID`),
  KEY `SHKUserProcLevelParticipant_USEROID` (`USEROID`),
  CONSTRAINT `SHKUserProcLevelParticipant_PARTICIPANTOID` FOREIGN KEY (`PARTICIPANTOID`) REFERENCES `SHKProcLevelParticipant` (`oid`),
  CONSTRAINT `SHKUserProcLevelParticipant_USEROID` FOREIGN KEY (`USEROID`) REFERENCES `SHKNormalUser` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKUserProcLevelParticipant`
--

LOCK TABLES `SHKUserProcLevelParticipant` WRITE;
/*!40000 ALTER TABLE `SHKUserProcLevelParticipant` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKUserProcLevelParticipant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKUserTable`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKUserTable` (
  `userid` varchar(100) NOT NULL,
  `firstname` varchar(50) DEFAULT NULL,
  `lastname` varchar(50) DEFAULT NULL,
  `passwd` varchar(50) NOT NULL,
  `email` varchar(254) DEFAULT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKUserTable` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKUserTable`
--

LOCK TABLES `SHKUserTable` WRITE;
/*!40000 ALTER TABLE `SHKUserTable` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKUserTable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLApplicationPackage`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKXPDLApplicationPackage` (
  `PACKAGE_ID` varchar(90) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLApplicationPackage` (`PACKAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLApplicationPackage`
--

LOCK TABLES `SHKXPDLApplicationPackage` WRITE;
/*!40000 ALTER TABLE `SHKXPDLApplicationPackage` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKXPDLApplicationPackage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLApplicationProcess`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKXPDLApplicationProcess` (
  `PROCESS_ID` varchar(90) NOT NULL,
  `PACKAGEOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLApplicationProcess` (`PROCESS_ID`,`PACKAGEOID`),
  KEY `SHKXPDLApplicationProcess_PACKAGEOID` (`PACKAGEOID`),
  CONSTRAINT `SHKXPDLApplicationProcess_PACKAGEOID` FOREIGN KEY (`PACKAGEOID`) REFERENCES `SHKXPDLApplicationPackage` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLApplicationProcess`
--

LOCK TABLES `SHKXPDLApplicationProcess` WRITE;
/*!40000 ALTER TABLE `SHKXPDLApplicationProcess` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKXPDLApplicationProcess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLData`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKXPDLData` (
  `XPDLContent` longblob DEFAULT NULL,
  `XPDLClassContent` longblob DEFAULT NULL,
  `XPDL` decimal(19,0) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLData` (`CNT`),
  UNIQUE KEY `I2_SHKXPDLData` (`XPDL`),
  CONSTRAINT `SHKXPDLData_XPDL` FOREIGN KEY (`XPDL`) REFERENCES `SHKXPDLS` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLData`
--

LOCK TABLES `SHKXPDLData` WRITE;
/*!40000 ALTER TABLE `SHKXPDLData` DISABLE KEYS */;
INSERT INTO `SHKXPDLData` VALUES
('<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Package xmlns=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xpdl=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" Id=\"crm\" Name=\"Customer Relationship Management\" xsi:schemaLocation=\"http://www.wfmc.org/2002/XPDL1.0 http://wfmc.org/standards/docs/TC-1025_schema_10_xpdl.xsd\">\n    <PackageHeader>\n        <XPDLVersion>1.0</XPDLVersion>\n        <Vendor/>\n        <Created/>\n    </PackageHeader>\n    <Script Type=\"text/javascript\"/>\n    <Participants>\n        <Participant Id=\"requester\" Name=\"Requester\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n        <Participant Id=\"approver\" Name=\"Approver\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n    </Participants>\n    <Applications>\n        <Application Id=\"default_application\"/>\n    </Applications>\n    <WorkflowProcesses>\n        <WorkflowProcess Id=\"process1\" Name=\"Proposal Approval Process\">\n            <ProcessHeader DurationUnit=\"h\"/>\n            <DataFields>\n                <DataField Id=\"status\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n                <DataField Id=\"selectApprover\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n            </DataFields>\n            <Activities>\n                <Activity Id=\"approve_proposal\" Name=\"Approve Proposal\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"540,584\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"activity1\" Name=\"Resubmit Proposal\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"1080,176\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"send_proposal\" Name=\"Finalize Proposal\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"540,276\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool1\" Name=\"Email Approved Notification\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"720,176\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool2\" Name=\"Email Reject Notification\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"900,584\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool3\" Name=\"Email Request For Approval\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Join Type=\"XOR\"/>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"360,484\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool4\" Name=\"Email Resubmit Notification\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"900,276\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"route2\">\n                    <Route/>\n                    <Performer>approver</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Split Type=\"XOR\">\n                                <TransitionRefs>\n                                    <TransitionRef Id=\"transition5\"/>\n                                    <TransitionRef Id=\"transition8\"/>\n                                    <TransitionRef Id=\"transition10\"/>\n                                </TransitionRefs>\n                            </Split>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"720,484\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"route1\">\n                    <Route/>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"360,176\"/>\n                    </ExtendedAttributes>\n                </Activity>\n            </Activities>\n            <Transitions>\n                <Transition From=\"approve_proposal\" Id=\"transition2\" To=\"route2\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_STRAIGHT\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition5\" To=\"tool2\">\n                    <Condition Type=\"CONDITION\">status === \'Rejected\'</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_STRAIGHT\"/>\n                        <ExtendedAttribute Name=\"PBUILDER_TRANSITION_CONDITIONS\" Value=\"[{&quot;join&quot;:&quot;&amp;&amp;&quot;,&quot;variable&quot;:&quot;status&quot;,&quot;operator&quot;:&quot;===&quot;,&quot;value&quot;:&quot;Rejected&quot;}]\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool1\" Id=\"transition7\" To=\"send_proposal\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_STRAIGHT\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition8\" Name=\"Approved\" To=\"tool1\">\n                    <Condition Type=\"OTHERWISE\"/>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_STRAIGHT\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition11\" To=\"tool3\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_STRAIGHT\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool3\" Id=\"transition9\" To=\"approve_proposal\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_STRAIGHT\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"activity1\" Id=\"transition12\" To=\"tool3\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_STRAIGHT\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition10\" To=\"tool4\">\n                    <Condition Type=\"CONDITION\">status === \'Resubmit\'</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_STRAIGHT\"/>\n                        <ExtendedAttribute Name=\"PBUILDER_TRANSITION_CONDITIONS\" Value=\"[{&quot;join&quot;:&quot;&amp;&amp;&quot;,&quot;variable&quot;:&quot;status&quot;,&quot;operator&quot;:&quot;===&quot;,&quot;value&quot;:&quot;Resubmit&quot;}]\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool4\" Id=\"transition13\" To=\"activity1\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_STRAIGHT\"/>\n                    </ExtendedAttributes>\n                </Transition>\n            </Transitions>\n            <ExtendedAttributes>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER\" Value=\"requester;approver\"/>\n                <ExtendedAttribute Name=\"Auto_Layout\" Value=\"true\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=send_proposal,X_OFFSET=1260,Y_OFFSET=276,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_STRAIGHT,TYPE=END_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_START_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=route1,X_OFFSET=180,Y_OFFSET=176,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_STRAIGHT,TYPE=START_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=approver,CONNECTING_ACTIVITY_ID=tool2,X_OFFSET=1080,Y_OFFSET=484,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_STRAIGHT,TYPE=END_DEFAULT\"/>\n            </ExtendedAttributes>\n        </WorkflowProcess>\n    </WorkflowProcesses>\n    <ExtendedAttributes>\n        <ExtendedAttribute Name=\"EDITING_TOOL\" Value=\"Web Workflow Designer\"/>\n        <ExtendedAttribute Name=\"EDITING_TOOL_VERSION\" Value=\"5.0-pre-alpha\"/>\n    </ExtendedAttributes>\n</Package>\n','\0sr\0\'org.enhydra.shark.xpdl.elements.Package~+Vmŀ~\0Z\0isTransientL\0extPkgRefsToIdst\0.Lorg/enhydra/shark/utilities/SequencedHashMap;L\0internalVersiont\0Ljava/lang/String;L\0\nnamespacest\0,Lorg/enhydra/shark/xpdl/elements/Namespaces;xr\0(org.enhydra.shark.xpdl.XMLComplexElement>(\0\0xr\05org.enhydra.shark.xpdl.XMLBaseForCollectionAndComplex2\0L\0\nelementMapq\0~\0L\0elementst\0Ljava/util/ArrayList;xr\0!org.enhydra.shark.xpdl.XMLElement#+B#\0Z\0\nisReadOnlyZ\0\nisRequiredL\0nameq\0~\0L\0originalElementHashCodet\0Ljava/lang/Integer;L\0parentt\0#Lorg/enhydra/shark/xpdl/XMLElement;L\0valueq\0~\0xpt\0Packagesr\0java.lang.Integer⠤8\0I\0valuexr\0java.lang.Number\0\0xp*\rpt\0\0sr\0,org.enhydra.shark.utilities.SequencedHashMap.\"\"&\0\0xpw\0\0\0\rt\0Idsr\0#org.enhydra.shark.xpdl.XMLAttribute#c݀M;\0L\0choicesq\0~\0xq\0~\0q\0~\0sq\0~\0q\0~\0\nt\0crmpt\0Namesq\0~\0\0q\0~\0sq\0~\0+n?q\0~\0\nt\0 Customer Relationship Managementpt\0\rPackageHeadersr\0-org.enhydra.shark.xpdl.elements.PackageHeaderv,\0\0xq\0~\0\0q\0~\0sq\0~\0w)q\0~\0\nt\0\0sq\0~\0w\0\0\0t\0XPDLVersionsr\0+org.enhydra.shark.xpdl.elements.XPDLVersion\"}Y.w\0\0xr\0\'org.enhydra.shark.xpdl.XMLSimpleElementm\0\0xq\0~\0q\0~\0!sq\0~\0&q\0~\0t\01.0t\0Vendorsr\0&org.enhydra.shark.xpdl.elements.Vendor tE:\0\0xq\0~\0#q\0~\0\'sq\0~\0iiq\0~\0t\0\0t\0Createdsr\0\'org.enhydra.shark.xpdl.elements.CreatedzdK|[\0\0xq\0~\0#q\0~\0,sq\0~\0fq\0~\0t\0\0t\0Descriptionsr\0+org.enhydra.shark.xpdl.elements.Description۰738\0\0xq\0~\0#\0q\0~\01sq\0~\0?q\0~\0t\0\0t\0\rDocumentationsr\0-org.enhydra.shark.xpdl.elements.Documentation`9y\0\0xq\0~\0#\0q\0~\06sq\0~\0#ڦzq\0~\0t\0\0t\0PriorityUnitsr\0,org.enhydra.shark.xpdl.elements.PriorityUnit\0\0xq\0~\0#\0q\0~\0;sq\0~\0II\nq\0~\0t\0\0t\0CostUnitsr\0(org.enhydra.shark.xpdl.elements.CostUnit܎=H\0\0xq\0~\0#\0q\0~\0@sq\0~\0ۻ}q\0~\0t\0\0xsr\0java.util.ArrayListxa\0I\0sizexp\0\0\0w\0\0\0q\0~\0$q\0~\0)q\0~\0.q\0~\03q\0~\08q\0~\0=q\0~\0Bxt\0RedefinableHeadersr\01org.enhydra.shark.xpdl.elements.RedefinableHeaderMϪ\'H\0\0xq\0~\0\0q\0~\0Gsq\0~\0fZq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0PublicationStatussq\0~\0\0q\0~\0Msq\0~\0{؍(q\0~\0It\0\0sq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0UNDER_REVISIONt\0RELEASEDt\0\nUNDER_TESTxt\0Authorsr\0&org.enhydra.shark.xpdl.elements.Author5fᧆ\0\0xq\0~\0#\0q\0~\0Usq\0~\0m\nEq\0~\0It\0\0t\0Versionsr\0\'org.enhydra.shark.xpdl.elements.Version9=3~JQ\0\0xq\0~\0#\0q\0~\0Zsq\0~\0Ftq\0~\0It\0\0t\0Codepagesr\0(org.enhydra.shark.xpdl.elements.Codepage9$me\rG\0\0xq\0~\0#\0q\0~\0_sq\0~\0i:!q\0~\0It\0\0t\0\nCountrykeysr\0*org.enhydra.shark.xpdl.elements.Countrykey.\0\0xq\0~\0#\0q\0~\0dsq\0~\0%fUoq\0~\0It\0\0t\0Responsiblessr\0,org.enhydra.shark.xpdl.elements.Responsibles${S\0\0xr\0$org.enhydra.shark.xpdl.XMLCollectionjċm\0\0xq\0~\0\0q\0~\0isq\0~\0\ZBq\0~\0It\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0Nq\0~\0Wq\0~\0\\q\0~\0aq\0~\0fq\0~\0lxt\0ConformanceClasssr\00org.enhydra.shark.xpdl.elements.ConformanceClassy0|k\0\0xq\0~\0\0q\0~\0rsq\0~\0zzq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0GraphConformancesq\0~\0\0q\0~\0xsq\0~\0%Fq\0~\0tq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0FULL_BLOCKEDt\0LOOP_BLOCKEDt\0NON_BLOCKEDxxsq\0~\0E\0\0\0w\0\0\0q\0~\0yxt\0Scriptsr\0&org.enhydra.shark.xpdl.elements.ScriptQjS8\0\0xq\0~\0\0q\0~\0sq\0~\0M:uq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0Typesq\0~\0q\0~\0sq\0~\0(**q\0~\0t\0text/javascriptpt\0Versionsq\0~\0\0q\0~\0sq\0~\08/q\0~\0t\0\0pt\0Grammarsq\0~\0\0q\0~\0sq\0~\0~]mq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExternalPackagessr\00org.enhydra.shark.xpdl.elements.ExternalPackagesw\"+Ũ\0\0xq\0~\0k\0q\0~\0sq\0~\0vq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0TypeDeclarationssr\00org.enhydra.shark.xpdl.elements.TypeDeclarations\rOx5\0\0xq\0~\0k\0q\0~\0sq\0~\0pq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Participantssr\0,org.enhydra.shark.xpdl.elements.Participantsh`g8J\0\0xq\0~\0k\0q\0~\0sq\0~\0|q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Participanto$rc\0\0xr\0+org.enhydra.shark.xpdl.XMLCollectionElementCxvr\0\0xq\0~\0t\0Participantsq\0~\0Eq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\04]\"q\0~\0t\0	requesterpq\0~\0sq\0~\0\0q\0~\0sq\0~\0)~q\0~\0t\0	Requesterpt\0ParticipantTypesr\0/org.enhydra.shark.xpdl.elements.ParticipantType>n݅\0\0xq\0~\0q\0~\0sq\0~\0\rq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q?9q\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0t\0RESOURCE_SETt\0RESOURCEt\0ROLEt\0ORGANIZATIONAL_UNITt\0HUMANt\0SYSTEMxxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\0xHq\0~\0t\0\0t\0ExternalReferencesr\01org.enhydra.shark.xpdl.elements.ExternalReferencebQ\0\0xq\0~\0\0q\0~\0sq\0~\0ziq\0~\0t\0\0sq\0~\0w\0\0\0t\0xrefsq\0~\0\0q\0~\0sq\0~\0a);q\0~\0t\0\0pt\0locationsq\0~\0q\0~\0sq\0~\0iq\0~\0t\0\0pt\0	namespacesq\0~\0\0q\0~\0sq\0~\0QCxq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExtendedAttributessr\02org.enhydra.shark.xpdl.elements.ExtendedAttributesOUF\0L\0extAttribsStringq\0~\0xq\0~\0k\0q\0~\0sq\0~\0d@Gq\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xsq\0~\0t\0Participantsq\0~\0)Sq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0f9q\0~\0t\0approverpq\0~\0sq\0~\0\0q\0~\0sq\0~\0:6q\0~\0t\0Approverpt\0ParticipantTypesq\0~\0q\0~\0sq\0~\0L٦q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\rWq\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\0bu~q\0~\0t\0\0t\0ExternalReferencesq\0~\0\0q\0~\0sq\0~\0C2q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0#1q\0~\0t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0Xq\0~\0t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Q2!q\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~	xt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0Iq\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~xxt\0Applicationssr\0,org.enhydra.shark.xpdl.elements.Applications\0\0xq\0~\0k\0q\0~sq\0~\0|Wwq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Applicationv	RS\0\0xq\0~\0t\0Applicationsq\0~\0=@Hsq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0kՅq\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\07qq\0~t\0\0pt\0Descriptionsq\0~\02\0q\0~\'sq\0~\0jVq\0~t\0\0t\0Choicesr\00org.enhydra.shark.xpdl.elements.ApplicationTypes?!\0\0xr\0\'org.enhydra.shark.xpdl.XMLComplexChoice|\"\0L\0choicesq\0~\0L\0choosenq\0~\0	xq\0~\0q\0~+sq\0~\0E*Wq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\00org.enhydra.shark.xpdl.elements.FormalParameterspBÁZ\0\0xq\0~\0k\0t\0FormalParameterssq\0~\0rkq\0~.t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0\0t\0ExternalReferencesq\0~\0M\Z3q\0~.t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0y\Zq\0~9t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0hƛZq\0~9t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0-Veq\0~9t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~>q\0~Aq\0~Dxxq\0~3t\0ExtendedAttributessq\0~\0\0q\0~Hsq\0~\01L%jq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~!q\0~$q\0~(q\0~.q\0~Ixxt\0\nDataFieldssr\0*org.enhydra.shark.xpdl.elements.DataFieldsʦU\0\0xq\0~\0k\0q\0~Osq\0~\0T6q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0WorkflowProcessessr\01org.enhydra.shark.xpdl.elements.WorkflowProcessesp_0,\0\0xq\0~\0k\0q\0~Vsq\0~\0`Uq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0/org.enhydra.shark.xpdl.elements.WorkflowProcess%v0L\0\0xq\0~\0t\0WorkflowProcesssq\0~\0q\0~Xt\0\0sq\0~\0w\0\0\0\rq\0~\0sq\0~\0q\0~\0sq\0~\03hq\0~^t\0process1pq\0~\0sq\0~\0\0q\0~\0sq\0~\07d	#q\0~^t\0Proposal Approval Processpt\0AccessLevelsq\0~\0\0q\0~isq\0~\0c3q\0~^q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0PUBLICt\0PRIVATExt\0\rProcessHeadersr\0-org.enhydra.shark.xpdl.elements.ProcessHeaderLC-)\0\0xq\0~\0q\0~osq\0~\0|q\0~^t\0\0sq\0~\0w\0\0\0t\0DurationUnitsq\0~\0\0q\0~usq\0~\0pUq\0~qt\0hsq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0Yt\0Mt\0Dt\0ht\0mt\0sxt\0Createdsq\0~\0-\0q\0~sq\0~\0ggq\0~qt\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0M9)q\0~qt\0\0t\0Prioritysr\0(org.enhydra.shark.xpdl.elements.Priority`Nn>b\0\0xq\0~\0#\0q\0~sq\0~\09Dq\0~qt\0\0t\0Limitsr\0%org.enhydra.shark.xpdl.elements.Limit1ӗ\0\0xq\0~\0#\0q\0~sq\0~\0pHq\0~qt\0\0t\0	ValidFromsr\0)org.enhydra.shark.xpdl.elements.ValidFromcŅ|L<\0\0xq\0~\0#\0q\0~sq\0~\0)q\0~qt\0\0t\0ValidTosr\0\'org.enhydra.shark.xpdl.elements.ValidToM\0\0xq\0~\0#\0q\0~sq\0~\0{\\Hq\0~qt\0\0t\0TimeEstimationsr\0.org.enhydra.shark.xpdl.elements.TimeEstimationŀ\'3\0\0xq\0~\0\0q\0~sq\0~\0b5wq\0~qt\0\0sq\0~\0w\0\0\0t\0WaitingTimesr\0+org.enhydra.shark.xpdl.elements.WaitingTimeN/\0\0xq\0~\0#\0q\0~sq\0~\0zM;q\0~t\0\0t\0WorkingTimesr\0+org.enhydra.shark.xpdl.elements.WorkingTime~\0\0xq\0~\0#\0q\0~sq\0~\0Hsq\0~t\0\0t\0Durationsr\0(org.enhydra.shark.xpdl.elements.Duration C\0\0xq\0~\0#\0q\0~sq\0~\0W(Uq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~vq\0~q\0~q\0~q\0~q\0~q\0~q\0~xt\0RedefinableHeadersq\0~\0H\0q\0~sq\0~\0Gq\0~^t\0\0sq\0~\0w\0\0\0q\0~\0Msq\0~\0\0q\0~\0Msq\0~\0\rnq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~\0Rq\0~\0Sq\0~\0Txt\0Authorsq\0~\0V\0q\0~sq\0~\0Kq\0~t\0\0t\0Versionsq\0~\0[\0q\0~sq\0~\0\nq\0~t\0\0t\0Codepagesq\0~\0`\0q\0~sq\0~\0KGmq\0~t\0\0t\0\nCountrykeysq\0~\0e\0q\0~sq\0~\0Kq\0~t\0\0t\0Responsiblessq\0~\0j\0q\0~sq\0~\0iOdq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~xt\0FormalParameterssq\0~2\0q\0~sq\0~\0V$q\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nDataFieldssq\0~P\0q\0~sq\0~\0	q\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.DataFieldI3.~\0\0xq\0~\0t\0	DataFieldsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0,2q\0~t\0statuspq\0~\0sq\0~\0\0q\0~\0sq\0~\0sUq\0~t\0\0pt\0IsArraysq\0~\0\0q\0~sq\0~\07;7q\0~t\0FALSEsq\0~\0E\0\0\0w\0\0\0t\0TRUEt\0FALSExt\0DataTypesr\0(org.enhydra.shark.xpdl.elements.DataType\'4sM\0\0xq\0~\0q\0~sq\0~\0N%q\0~t\0\0sq\0~\0w\0\0\0t\0	DataTypessr\0)org.enhydra.shark.xpdl.elements.DataTypespcH,!\0Z\0\risInitializedxq\0~-q\0~sq\0~\0=!q\0~t\0\0sq\0~\0E\0\0\0	w\0\0\0	sr\0)org.enhydra.shark.xpdl.elements.BasicType)w1\0\0xq\0~\0t\0	BasicTypesq\0~\0lq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0/q\0~t\0STRINGsq\0~\0E\0\0\0w\0\0\0t\0STRINGt\0FLOATt\0INTEGERt\0	REFERENCEt\0DATETIMEt\0BOOLEANt\0	PERFORMERxxsq\0~\0E\0\0\0w\0\0\0q\0~xsr\0,org.enhydra.shark.xpdl.elements.DeclaredTypedR.\\^9\0\0xq\0~\0t\0DeclaredTypesq\0~\0r`q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0BYq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xsr\0*org.enhydra.shark.xpdl.elements.SchemaType&1oSH\0\0xq\0~\0t\0\nSchemaTypesq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0T0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0\"iq\0~ t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0q\0~ t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0vq\0~ t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~%q\0~(q\0~+xsr\0*org.enhydra.shark.xpdl.elements.RecordType%K\0\0\0xq\0~\0kt\0\nRecordTypesq\0~\0f8#bq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.UnionType5PG\0\0xq\0~\0kt\0	UnionTypesq\0~\0	kq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0/org.enhydra.shark.xpdl.elements.EnumerationTypef3b\0\0xq\0~\0kt\0EnumerationTypesq\0~\0lq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.ArrayTypeg$\0N@\0\0xq\0~\0t\0	ArrayTypesq\0~\0*0q\0~t\0\0sq\0~\0w\0\0\0t\0\nLowerIndexsq\0~\0q\0~Jsq\0~\0\ri\Z<q\0~Et\0\0pt\0\nUpperIndexsq\0~\0q\0~Nsq\0~\0:Nq\0~Et\0\0pq\0~sq\0~q\0~sq\0~\0*zq\0~Et\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~Kq\0~Oq\0~Rxsr\0(org.enhydra.shark.xpdl.elements.ListType\"ӟ\n\0\0xq\0~\0t\0ListTypesq\0~\0h\'q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~q\0~sq\0~\0-Qh=q\0~Wt\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~\\xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0InitialValuesr\0,org.enhydra.shark.xpdl.elements.InitialValuej,zR\0\0xq\0~\0#\0q\0~asq\0~\0slq\0~t\0\0t\0Lengthsr\0&org.enhydra.shark.xpdl.elements.LengthMW+-̩W\0\0xq\0~\0#\0q\0~fsq\0~\0		,q\0~t\0\0t\0Descriptionsq\0~\02\0q\0~ksq\0~\0q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~osq\0~\0#%\\q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~cq\0~hq\0~lq\0~pxsq\0~t\0	DataFieldsq\0~\0%uvq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0)MEq\0~vt\0selectApproverpq\0~\0sq\0~\0\0q\0~\0sq\0~\0)q\0~vt\0\0pq\0~sq\0~\0\0q\0~sq\0~\0q\0~vt\0FALSEsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xt\0DataTypesq\0~q\0~sq\0~\0~q\0~vt\0\0sq\0~\0w\0\0\0q\0~sq\0~q\0~sq\0~\0@q\0~t\0\0sq\0~\0E\0\0\0	w\0\0\0	sq\0~t\0	BasicTypesq\0~\0%d!\nq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0+*q\0~t\0STRINGsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~	q\0~\nq\0~q\0~q\0~\rxxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0DeclaredTypesq\0~\0	͘q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0!Fq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\nSchemaTypesq\0~\0%OOq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0Yq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0<$q\0~t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\071q\0~t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0xقyq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~/t\0\nRecordTypesq\0~\0>q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0	UnionTypesq\0~\0|eq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~=t\0EnumerationTypesq\0~\0CLq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~Dt\0	ArrayTypesq\0~\0w2q\0~t\0\0sq\0~\0w\0\0\0q\0~Jsq\0~\0q\0~Jsq\0~\0Wq\0~t\0\0pq\0~Nsq\0~\0q\0~Nsq\0~\0W&q\0~t\0\0pq\0~sq\0~q\0~sq\0~\0t&)q\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~Vt\0ListTypesq\0~\0.q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~q\0~sq\0~\0,@xq\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0InitialValuesq\0~b\0q\0~sq\0~\0Mpq\0~vt\0\0t\0Lengthsq\0~g\0q\0~sq\0~\0qq\0~vt\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0Jq\0~vt\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0`)q\0~vt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~{q\0~~q\0~q\0~q\0~q\0~q\0~q\0~xxt\0Participantssq\0~\0\0q\0~sq\0~\0Tpjrq\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Applicationssq\0~\0q\0~sq\0~\0Fq\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ActivitySetssr\0,org.enhydra.shark.xpdl.elements.ActivitySetsqV[4\0\0xq\0~\0k\0q\0~\0sq\0~\07#Fq\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nActivitiessr\0*org.enhydra.shark.xpdl.elements.Activities&G^lP\0\0xq\0~\0k\0q\0~sq\0~\0_q\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0	w\0\0\0	sr\0(org.enhydra.shark.xpdl.elements.Activityt45\Z9\0\0xq\0~\0t\0Activitysq\0~\0leq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0!\\Wq\0~t\0approve_proposalpq\0~\0sq\0~\0\0q\0~\0sq\0~\0u>q\0~t\0Approve Proposalpt\0Descriptionsq\0~\02\0q\0~\Zsq\0~\0pq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0hKq\0~t\0\0q\0~\0sr\0-org.enhydra.shark.xpdl.elements.ActivityTypeseŽ{\0\0xq\0~-q\0~\0sq\0~\0Aq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0%org.enhydra.shark.xpdl.elements.Route0e\rG\0\0xq\0~\0t\0Routesq\0~\0q\0~#t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0.org.enhydra.shark.xpdl.elements.Implementationr^%\0\0xq\0~\0t\0Implementationsq\0~\0X$;q\0~#t\0\0sq\0~\0w\0\0\0q\0~\0sr\03org.enhydra.shark.xpdl.elements.ImplementationTypes\rT١9\0\0xq\0~-q\0~\0sq\0~\0mhq\0~/t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0\"org.enhydra.shark.xpdl.elements.No{.\0\0xq\0~\0t\0Nosq\0~\02sq\0~5t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0%org.enhydra.shark.xpdl.elements.ToolsCg\0\0xq\0~\0k\0t\0Toolssq\0~\0iq\0~5t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0\'org.enhydra.shark.xpdl.elements.SubFlow;Os7:$\0\0xq\0~\0t\0SubFlowsq\0~\0̉q\0~5t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0FFq\0~Ht\0\0pt\0	Executionsq\0~\0\0q\0~Psq\0~\0i\0q\0~Hq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ASYNCHRt\0SYNCHRxt\0ActualParameterssr\00org.enhydra.shark.xpdl.elements.ActualParameters_K\0\0xq\0~\0k\0q\0~Vsq\0~\0px/q\0~Ht\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~Mq\0~Qq\0~Xxxq\0~:xsq\0~\0E\0\0\0w\0\0\0q\0~5xsr\0-org.enhydra.shark.xpdl.elements.BlockActivityqcF\0\0xq\0~\0t\0\rBlockActivitysq\0~\0p_q\0~#t\0\0sq\0~\0w\0\0\0t\0BlockIdsq\0~\0q\0~esq\0~\0Fq\0~`t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~fxxq\0~/t\0	Performersr\0)org.enhydra.shark.xpdl.elements.Performer\"1%\0\0xq\0~\0#\0q\0~jsq\0~\0)}Cq\0~t\0approvert\0	StartModesr\0)org.enhydra.shark.xpdl.elements.StartModenhS\0\0xq\0~\0\0q\0~osq\0~\0J݅q\0~t\0\0sq\0~\0w\0\0\0t\0Modesr\00org.enhydra.shark.xpdl.elements.StartFinishModes~6zX\'\0\0xq\0~-\0q\0~usq\0~\0JUKq\0~qt\0\0sq\0~\0E\0\0\0w\0\0\0sr\0,org.enhydra.shark.xpdl.XMLEmptyChoiceElement2;3_\0\0xq\0~\0\0t\0XMLEmptyChoiceElementsq\0~\0Ԁq\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.Automatict?_\0\0xq\0~\0t\0	Automaticsq\0~\0_؄q\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0&org.enhydra.shark.xpdl.elements.Manualv[ؤ\0\0xq\0~\0t\0Manualsq\0~\0Ṵq\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~|xsq\0~\0E\0\0\0w\0\0\0q\0~wxt\0\nFinishModesr\0*org.enhydra.shark.xpdl.elements.FinishMode{\0\0xq\0~\0\0q\0~sq\0~\0Y菰q\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0anpq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\01q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0IN:q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\09q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0Tq\0~t\0\0t\0	Deadlinessr\0)org.enhydra.shark.xpdl.elements.Deadlines>ɜ\0\0xq\0~\0k\0q\0~sq\0~\0WYaq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsr\05org.enhydra.shark.xpdl.elements.SimulationInformation\"|I\0\0xq\0~\0\0q\0~sq\0~\0oq\0~t\0\0sq\0~\0w\0\0\0t\0\rInstantiationsq\0~\0\0q\0~sq\0~\0r0}q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ONCEt\0MULTIPLExt\0Costsr\0$org.enhydra.shark.xpdl.elements.Cost\0\0xq\0~\0#q\0~sq\0~\08aBq\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0!#q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0|`nq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0vSyq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0C%wUq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsr\0$org.enhydra.shark.xpdl.elements.IconTU(}6\0\0xq\0~\0#\0q\0~sq\0~\0s8q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0&q\0~t\0\0t\0TransitionRestrictionssr\06org.enhydra.shark.xpdl.elements.TransitionRestrictionsC)׀i;\0\0xq\0~\0k\0q\0~sq\0~\0|h\\=q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0:q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\01org.enhydra.shark.xpdl.elements.ExtendedAttribute\\F\0\0xq\0~\0t\0ExtendedAttributesq\0~\0kq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0bƇq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpt\0Valuesq\0~\0\0q\0~sq\0~\0_f1q\0~t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0fq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0~fq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0(q\0~t\0540,584pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~	xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~#q\0~lq\0~qq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0D;q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0([xq\0~t\0	activity1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0wq\0~t\0Resubmit Proposalpt\0Descriptionsq\0~\02\0q\0~sq\0~\0o.}q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0Rq\0~t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0[bq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0$qv[q\0~!t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0=mʕq\0~!t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0yq\0~+t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0|q\0~0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0S؜q\0~0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~Gt\0SubFlowsq\0~\0\0;q\0~0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0?yq\0~@t\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0.x?-q\0~@q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~Ksq\0~\0sFq\0~@t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~Eq\0~Hq\0~Lxxq\0~4xsq\0~\0E\0\0\0w\0\0\0q\0~0xsq\0~_t\0\rBlockActivitysq\0~\0/{ q\0~!t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0|q\0~St\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Xxxq\0~+t\0	Performersq\0~k\0q\0~\\sq\0~\0c)q\0~t\0	requestert\0	StartModesq\0~p\0q\0~`sq\0~\0kq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0Dy7Jq\0~at\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0jiq\0~et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0{2&q\0~et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0.Iq\0~et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~ixsq\0~\0E\0\0\0w\0\0\0q\0~ext\0\nFinishModesq\0~\0q\0~|sq\0~\0-Eq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0V(q\0~}t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0Tq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\07q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0*:q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0z=q\0~t\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0nvq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0	q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\02dq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0%6q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0hzq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0DZq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\02?q\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0!#<q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\0q\0~sq\0~\0Ӳq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\05IAq\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0Bfq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0jq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0>e{q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0TCq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0J]q\0~t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0}q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0tq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0T\rq\0~t\01080,176pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~\Zq\0~q\0~!q\0~]q\0~aq\0~}q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0p!Rq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0%4q\0~t\0\rsend_proposalpq\0~\0sq\0~\0\0q\0~\0sq\0~\0iXq\0~t\0Finalize Proposalpt\0Descriptionsq\0~\02\0q\0~sq\0~\0?>q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0<q\0~t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0%q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0_\nq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0	q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0\09?q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0zKq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0Lq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~Gt\0SubFlowsq\0~\0rq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\\6q\0~ t\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0>q\0~ q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~+sq\0~\0 9q\0~ t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~%q\0~(q\0~,xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~_t\0\rBlockActivitysq\0~\0Zwq\0~t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0^Z\rq\0~3t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~8xxq\0~t\0	Performersq\0~k\0q\0~<sq\0~\0D$q\0~t\0	requestert\0	StartModesq\0~p\0q\0~@sq\0~\0@zq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0q\0~At\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0fq\0~Et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0D,)q\0~Et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Qq\0~Et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Ixsq\0~\0E\0\0\0w\0\0\0q\0~Ext\0\nFinishModesq\0~\0q\0~\\sq\0~\0eN/q\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0q\0~]t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0Dz$q\0~at\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0qE`q\0~at\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0yIq\0~at\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~exsq\0~\0E\0\0\0w\0\0\0q\0~axt\0Prioritysq\0~\0q\0~xsq\0~\0ZAq\0~t\0\0t\0	Deadlinessq\0~\0q\0~|sq\0~\0O q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0|ڸWq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0p6Dq\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\08O8q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0r.!q\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0[3q\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\0q\0~sq\0~\0%Lq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0!Oq\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0lPq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0f8q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0Kq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0؅q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0Q7_!q\0~t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0L5eq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0cy*q\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0\"H#\\q\0~t\0540,276pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~=q\0~Aq\0~]q\0~yq\0~}q\0~q\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0Icq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Dq\0~t\0tool1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0./q\0~t\0Email Approved Notificationpt\0Descriptionsq\0~\02\0q\0~sq\0~\0q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0gq\0~t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0Cڋq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0Tg,(q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0Cq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0;1~q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\06q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0[Vq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0$org.enhydra.shark.xpdl.elements.Tool\\6&+G\0\0xq\0~\0t\0Toolsq\0~\0/Wjq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0KKq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0APPLICATIONt\0	PROCEDURExt\0ActualParameterssq\0~W\0q\0~sq\0~\0HW=q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0t>`q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0eq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~	q\0~q\0~q\0~xxsq\0~Gt\0SubFlowsq\0~\0`_q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Pq\0~t\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0k3q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~*sq\0~\0fq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~$q\0~\'q\0~+xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~_t\0\rBlockActivitysq\0~\0Fq\0~t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0sDCq\0~2t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~7xxq\0~t\0	Performersq\0~k\0q\0~;sq\0~\0Uq\0~t\0	requestert\0	StartModesq\0~p\0q\0~?sq\0~\0SiNq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0mUq\0~@t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0(0q\0~Dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0aeZq\0~Dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0*q\0~Dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Hxsq\0~\0E\0\0\0w\0\0\0q\0~Dxt\0\nFinishModesq\0~\0q\0~[sq\0~\0\'&q\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\06iq\0~\\t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0_ߣq\0~`t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0\'lq\0~`t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\06{q\0~`t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~dxsq\0~\0E\0\0\0w\0\0\0q\0~`xt\0Prioritysq\0~\0q\0~wsq\0~\0uZq\0~t\0\0t\0	Deadlinessq\0~\0q\0~{sq\0~\0lq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0 !8|q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0Hq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0o{q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\045q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0	q\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\08.xq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0|@q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\0q\0~sq\0~\0qAcq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0^q\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0e>qq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0;q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\08Bmdq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0q\0~t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0TLq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0qq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0Zmq\0~t\0720,176pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~<q\0~@q\0~\\q\0~xq\0~|q\0~q\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0\Z#q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0+?q\0~t\0tool2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0}kq\0~t\0Email Reject Notificationpt\0Descriptionsq\0~\02\0q\0~sq\0~\0|JGq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0Eq\0~t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0[޲q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0~q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0Pq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0o%q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\00#q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0\nKq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0Toolsq\0~\0m7q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0#q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~\rxt\0ActualParameterssq\0~W\0q\0~\nsq\0~\0Rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\059q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0 Dq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~xxsq\0~Gt\0SubFlowsq\0~\0Nq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Z\'q\0~t\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0uVFq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~&sq\0~\0w:q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~ q\0~#q\0~\'xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~_t\0\rBlockActivitysq\0~\0L@q\0~t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0ojq\0~.t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~3xxq\0~t\0	Performersq\0~k\0q\0~7sq\0~\0(q\0~t\0approvert\0	StartModesq\0~p\0q\0~;sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0Oq\0~<t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0G⼃q\0~@t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0{9iq\0~@t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0%q\0~@t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Dxsq\0~\0E\0\0\0w\0\0\0q\0~@xt\0\nFinishModesq\0~\0q\0~Wsq\0~\0	Vq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0[gpGq\0~Xt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0e+0q\0~\\t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\06*q\0~\\t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0\"q\0~\\t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~`xsq\0~\0E\0\0\0w\0\0\0q\0~\\xt\0Prioritysq\0~\0q\0~ssq\0~\0S2q\0~t\0\0t\0	Deadlinessq\0~\0q\0~wsq\0~\0o\nq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~}sq\0~\0:kOq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0\Zq\0~~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0\\\"q\0~~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0+}q\0~~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0pnq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0jGq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0V\Z>q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\0q\0~sq\0~\0cq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0Vq\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0#dq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0\"Lq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\01uqq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0膴q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0RrOq\0~t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0l_>q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0u@lBq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0$Lxq\0~t\0900,584pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~8q\0~<q\0~Xq\0~tq\0~xq\0~~q\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0]q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Hq\0~t\0tool3pq\0~\0sq\0~\0\0q\0~\0sq\0~\0NwL=q\0~t\0\ZEmail Request For Approvalpt\0Descriptionsq\0~\02\0q\0~sq\0~\08q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0xBq\0~t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\01\Z`q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0Exnq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0eq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0?q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0X\"q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0^q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0Toolsq\0~\0mIlq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Ia{q\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0=9rq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~\rxt\0ActualParameterssq\0~W\0q\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0zq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0?8q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~q\0~q\0~\rq\0~xxsq\0~Gt\0SubFlowsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Kq\0~t\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~\"sq\0~\0oq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~#xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~_t\0\rBlockActivitysq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0/MTq\0~*t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~/xxq\0~t\0	Performersq\0~k\0q\0~3sq\0~\0i\\q\0~t\0approvert\0	StartModesq\0~p\0q\0~7sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0q\0~8t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0Hڑq\0~<t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0	FBq\0~<t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0q\0~<t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~@xsq\0~\0E\0\0\0w\0\0\0q\0~<xt\0\nFinishModesq\0~\0q\0~Ssq\0~\0xq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\029q\0~Tt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0OF0q\0~Xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0yq\0~Xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Q|q\0~Xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\\xsq\0~\0E\0\0\0w\0\0\0q\0~Xxt\0Prioritysq\0~\0q\0~osq\0~\0$q\0~t\0\0t\0	Deadlinessq\0~\0q\0~ssq\0~\00fq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~ysq\0~\0vq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0Cخq\0~zq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0~-q\0~zt\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0n@q\0~zt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0|q\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0Quq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0@gq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~~q\0~q\0~xt\0Iconsq\0~\0q\0~sq\0~\09^2Bq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0B-Rq\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0;{wq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\05org.enhydra.shark.xpdl.elements.TransitionRestrictionN}\0\0xq\0~\0t\0TransitionRestrictionsq\0~\02q\0~t\0\0sq\0~\0w\0\0\0t\0Joinsr\0$org.enhydra.shark.xpdl.elements.Joinڕөx)5\0\0xq\0~\0\0q\0~sq\0~\0hEq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Gq\0~t\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ANDt\0XORxxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Splitsr\0%org.enhydra.shark.xpdl.elements.Split~ѯWS\0\0xq\0~\0\0q\0~sq\0~\0,r3q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0pq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0TransitionRefssr\0.org.enhydra.shark.xpdl.elements.TransitionRefsъ\0\0xq\0~\0k\0q\0~sq\0~\0L_3q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0\0^q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0n3q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0\\Bq\0~t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0XS}q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0o.q\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0\\(q\0~t\0360,484pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~4q\0~8q\0~Tq\0~pq\0~tq\0~zq\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0Wpq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0?q\0~t\0tool4pq\0~\0sq\0~\0\0q\0~\0sq\0~\0m%Wq\0~t\0Email Resubmit Notificationpt\0Descriptionsq\0~\02\0q\0~sq\0~\0ug}q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0;q\0~t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0<q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0_tyq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0Ǹq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0BѾq\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0@,*q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0<kq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0Toolsq\0~\0fq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0 @Xq\0~	t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0m:q\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~\rxt\0ActualParameterssq\0~W\0q\0~	\'sq\0~\0v4W;q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~	-sq\0~\0}lq\0~	t\0\0t\0ExtendedAttributessq\0~\0\0q\0~	1sq\0~\04C^q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~	!q\0~	$q\0~	(q\0~	.q\0~	2xxsq\0~Gt\0SubFlowsq\0~\0;`q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0_-q\0~	8t\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0~Zq\0~	8q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~	Csq\0~\0y\nq\0~	8t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~	=q\0~	@q\0~	Dxxq\0~	xsq\0~\0E\0\0\0w\0\0\0q\0~	xsq\0~_t\0\rBlockActivitysq\0~\0=v;q\0~t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0q\0~	Kt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~	Pxxq\0~	t\0	Performersq\0~k\0q\0~	Tsq\0~\0PΩq\0~t\0	requestert\0	StartModesq\0~p\0q\0~	Xsq\0~\02Nq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0>M3q\0~	Yt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0)Dnq\0~	]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0)Zq\0~	]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\04\n4q\0~	]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	axsq\0~\0E\0\0\0w\0\0\0q\0~	]xt\0\nFinishModesq\0~\0q\0~	tsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0q\0~	ut\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\04I=q\0~	yt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0fPZq\0~	yt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0\ZPq\0~	yt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	}xsq\0~\0E\0\0\0w\0\0\0q\0~	yxt\0Prioritysq\0~\0q\0~	sq\0~\0hq\0~t\0\0t\0	Deadlinessq\0~\0q\0~	sq\0~\0PTq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~	sq\0~\0Q2l$q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\09q\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~	sq\0~\0:q\0~	t\0\0t\0TimeEstimationsq\0~q\0~	sq\0~\02q\0~	t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~	sq\0~\0Eͻq\0~	t\0\0t\0WorkingTimesq\0~\0q\0~	sq\0~\0Z~q\0~	t\0\0t\0Durationsq\0~\0q\0~	sq\0~\0zPq\0~	t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	xxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	xt\0Iconsq\0~\0q\0~	sq\0~\0F1q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~	sq\0~\0MHq\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~	sq\0~\0< 4q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~	sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0_q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\'rq\0~	t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0h6\Zq\0~	t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xsq\0~t\0ExtendedAttributesq\0~\0Eҋq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0_Wq\0~	t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0muK@q\0~	t\0900,276pxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~	Uq\0~	Yq\0~	uq\0~	q\0~	q\0~	q\0~	q\0~	q\0~	q\0~	xsq\0~t\0Activitysq\0~\04hq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0^QiMq\0~	t\0route2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0e(hq\0~	t\0\0pt\0Descriptionsq\0~\02\0q\0~	sq\0~\088q\0~	t\0\0t\0Limitsq\0~\0q\0~	sq\0~\0Peq\0~	t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0h6q\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0N:q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\06̕vq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0Jhq\0~\nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0;q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0!}q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~Gt\0SubFlowsq\0~\0sHmq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0J*q\0~\nt\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0&{a\nq\0~\nq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~\n#sq\0~\0iq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\n q\0~\n$xxq\0~\nxsq\0~\0E\0\0\0w\0\0\0q\0~\nxsq\0~_t\0\rBlockActivitysq\0~\0^X2q\0~	t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0ROEq\0~\n+t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\n0xxq\0~	t\0	Performersq\0~k\0q\0~\n4sq\0~\0/-q\0~	t\0approvert\0	StartModesq\0~p\0q\0~\n8sq\0~\0	{q\0~	t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0}v&q\0~\n9t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0%Fq\0~\n=t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0mq\0~\n=t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0c~)q\0~\n=t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\nAxsq\0~\0E\0\0\0w\0\0\0q\0~\n=xt\0\nFinishModesq\0~\0q\0~\nTsq\0~\0t3jq\0~	t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0X\r*q\0~\nUt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0zt3q\0~\nYt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0:q\0~\nYt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0K\\Xq\0~\nYt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\n]xsq\0~\0E\0\0\0w\0\0\0q\0~\nYxt\0Prioritysq\0~\0q\0~\npsq\0~\0.Oq\0~	t\0\0t\0	Deadlinessq\0~\0q\0~\ntsq\0~\0/vq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~\nzsq\0~\0qq\0~	t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\03ӿVq\0~\n{q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~\nsq\0~\0cğq\0~\n{t\0\0t\0TimeEstimationsq\0~q\0~\nsq\0~\0OHUUq\0~\n{t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~\nsq\0~\0X賾q\0~\nt\0\0t\0WorkingTimesq\0~\0q\0~\nsq\0~\0voq\0~\nt\0\0t\0Durationsq\0~\0q\0~\nsq\0~\01};q\0~\nt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nxxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nxt\0Iconsq\0~\0q\0~\nsq\0~\0<}tq\0~	t\0\0t\0\rDocumentationsq\0~\07\0q\0~\nsq\0~\0!Uq\0~	t\0\0t\0TransitionRestrictionssq\0~\0q\0~\nsq\0~\0+Eq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0TransitionRestrictionsq\0~\0\'9q\0~\nt\0\0sq\0~\0w\0\0\0t\0Joinsq\0~\0q\0~\nsq\0~\0xq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0vhq\0~\nq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\nxt\0Splitsq\0~\0q\0~\nsq\0~\0Pkq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0\Zw.q\0~\nt\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0TransitionRefssq\0~\0q\0~\nsq\0~\0Eq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0-org.enhydra.shark.xpdl.elements.TransitionRef%-a\0\0xq\0~\0t\0\rTransitionRefsq\0~\0Xq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Aq\0~\nt\0transition5pxsq\0~\0E\0\0\0w\0\0\0q\0~\nxsq\0~\nt\0\rTransitionRefsq\0~\0(q\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\03+q\0~\nt\0transition8pxsq\0~\0E\0\0\0w\0\0\0q\0~\nxsq\0~\nt\0\rTransitionRefsq\0~\0=|%q\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0tPq\0~\nt\0transition10pxsq\0~\0E\0\0\0w\0\0\0q\0~\nxxxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nxxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nxxt\0ExtendedAttributessq\0~\0\0q\0~\nsq\0~\0	̫q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0Zq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0O!q\0~\nt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0q\0~\nt\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nxsq\0~t\0ExtendedAttributesq\0~\0Hf9\rq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Fq\0~\nt\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0{q\0~\nt\0720,484pxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nxxpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	q\0~	q\0~	q\0~\n5q\0~\n9q\0~\nUq\0~\nqq\0~\nuq\0~\n{q\0~\nq\0~\nq\0~\nq\0~\nxsq\0~t\0Activitysq\0~\0jv*q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0lWxq\0~t\0route1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0֔&q\0~t\0\0pt\0Descriptionsq\0~\02\0q\0~sq\0~\0&0/q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0IuXq\0~t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0(Wq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0t+q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0)q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0Jɪq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0@q\0~#t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0k3q\0~#t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~Gt\0SubFlowsq\0~\0q\0~#t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Hq\0~3t\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0Fq\0~3q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~>sq\0~\0Yq\0~3t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~8q\0~;q\0~?xxq\0~\'xsq\0~\0E\0\0\0w\0\0\0q\0~#xsq\0~_t\0\rBlockActivitysq\0~\0%Aq\0~t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0P*Gq\0~Ft\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Kxxq\0~t\0	Performersq\0~k\0q\0~Osq\0~\0;#q\0~t\0	requestert\0	StartModesq\0~p\0q\0~Ssq\0~\0Cq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0rqq\0~Tt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0q\0~Xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\04t_q\0~Xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0aHLq\0~Xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\\xsq\0~\0E\0\0\0w\0\0\0q\0~Xxt\0\nFinishModesq\0~\0q\0~osq\0~\0tq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0P8q\0~pt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0)q\0~tt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0Rq\0~tt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0EN5q\0~tt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~txt\0Prioritysq\0~\0q\0~sq\0~\0v5q\0~t\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0gПq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\08))Aq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0gTjq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0@!q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0#lq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0R~q\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0:>q\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0Zq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\0q\0~sq\0~\0sU`q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\09V5q\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0~Oq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0jq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0\\=q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\089gq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\09Li[q\0~t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0Cyq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0p@q\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\09q\0~t\0360,176pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~	q\0~\rq\0~q\0~q\0~Pq\0~Tq\0~pq\0~q\0~q\0~q\0~q\0~q\0~q\0~xxt\0Transitionssr\0+org.enhydra.shark.xpdl.elements.Transitions9>/i\0\0xq\0~\0k\0q\0~sq\0~\0pyq\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0	w\0\0\0	sr\0*org.enhydra.shark.xpdl.elements.Transitiontx\0\0xq\0~\0t\0\nTransitionsq\0~\0VRq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0~\"q\0~t\0transition2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0%tq\0~t\0\0pt\0Fromsq\0~\0q\0~sq\0~\0d7q\0~t\0approve_proposalpt\0Tosq\0~\0q\0~sq\0~\0>q\0~t\0route2pt\0	Conditionsr\0)org.enhydra.shark.xpdl.elements.ConditionDZ;|\0\0xq\0~\0\0q\0~sq\0~\0Xzq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0-fjq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0	CONDITIONt\0	OTHERWISEt\0	EXCEPTIONt\0DEFAULTEXCEPTIONxxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~\nsq\0~\0c^|q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0X\'eq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0U;q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0,q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0Pq\0~t\0NO_ROUTING_STRAIGHTpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0$q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0leq\0~!t\0transition5pq\0~\0sq\0~\0\0q\0~\0sq\0~\0MTq\0~!t\0\0pq\0~sq\0~\0q\0~sq\0~\03q\0~!t\0route2pq\0~sq\0~\0q\0~sq\0~\0q_Kq\0~!t\0tool2pt\0	Conditionsq\0~\0q\0~2sq\0~\07Nq\0~!t\0status === \'Rejected\'sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0&{fq\0~3t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~7xt\0Descriptionsq\0~\02\0q\0~<sq\0~\0eTXq\0~!t\0\0t\0ExtendedAttributessq\0~\0\0q\0~@sq\0~\0|E7q\0~!t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0p-q\0~At\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\"rq\0~Ft\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0_Bq\0~Ft\0NO_ROUTING_STRAIGHTpxsq\0~\0E\0\0\0w\0\0\0q\0~Kq\0~Nxsq\0~t\0ExtendedAttributesq\0~\0Iq\0~At\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\08¢q\0~Rt\0PBUILDER_TRANSITION_CONDITIONSpq\0~sq\0~\0\0q\0~sq\0~\0#7,q\0~Rt\0G[{\"join\":\"&&\",\"variable\":\"status\",\"operator\":\"===\",\"value\":\"Rejected\"}]pxsq\0~\0E\0\0\0w\0\0\0q\0~Wq\0~Zxxpxsq\0~\0E\0\0\0w\0\0\0q\0~&q\0~)q\0~,q\0~/q\0~3q\0~=q\0~Axsq\0~t\0\nTransitionsq\0~\0aXzCq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Sxq\0~_t\0transition7pq\0~\0sq\0~\0\0q\0~\0sq\0~\0}q\0~_t\0\0pq\0~sq\0~\0q\0~sq\0~\0FŴuq\0~_t\0tool1pq\0~sq\0~\0q\0~sq\0~\0k;q\0~_t\0\rsend_proposalpt\0	Conditionsq\0~\0q\0~psq\0~\0_q\0~_t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\04}q\0~qq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~uxt\0Descriptionsq\0~\02\0q\0~ysq\0~\06 q\0~_t\0\0t\0ExtendedAttributessq\0~\0\0q\0~}sq\0~\0Dq\0~_t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0-:@q\0~~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\"E\0q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0Qq\0~t\0NO_ROUTING_STRAIGHTpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~dq\0~gq\0~jq\0~mq\0~qq\0~zq\0~~xsq\0~t\0\nTransitionsq\0~\0	Unq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0{0q\0~t\0transition8pq\0~\0sq\0~\0\0q\0~\0sq\0~\0kUq\0~t\0Approvedpq\0~sq\0~\0q\0~sq\0~\0p|fq\0~t\0route2pq\0~sq\0~\0q\0~sq\0~\0q\0~t\0tool1pt\0	Conditionsq\0~\0q\0~sq\0~\0]_q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Hq\0~t\0	OTHERWISEsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0Cq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0cq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0d)q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0vGq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\02q\0~t\0NO_ROUTING_STRAIGHTpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0lq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0&=q\0~t\0transition11pq\0~\0sq\0~\0\0q\0~\0sq\0~\0x5q\0~t\0\0pq\0~sq\0~\0q\0~sq\0~\0,ͭ3q\0~t\0route1pq\0~sq\0~\0q\0~sq\0~\0g)_q\0~t\0tool3pt\0	Conditionsq\0~\0q\0~sq\0~\0jpq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0+1q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0]q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0IXq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0n=(q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Yq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0Eq\0~t\0NO_ROUTING_STRAIGHTpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0vG\rq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0LJq\0~t\0transition9pq\0~\0sq\0~\0\0q\0~\0sq\0~\0LuYq\0~t\0\0pq\0~sq\0~\0q\0~sq\0~\0isq\0~t\0tool3pq\0~sq\0~\0q\0~sq\0~\0t[*q\0~t\0approve_proposalpt\0	Conditionsq\0~\0q\0~\rsq\0~\0\r\"q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0WB]q\0~\rq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\r	xt\0Descriptionsq\0~\02\0q\0~\r\rsq\0~\0\\56q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0=!iq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0,dC\\q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0pވq\0~\rt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0]q\0~\rt\0NO_ROUTING_STRAIGHTpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~\rq\0~\rq\0~\rq\0~\rxsq\0~t\0\nTransitionsq\0~\0\Z{q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\0,q\0~\r$t\0transition12pq\0~\0sq\0~\0\0q\0~\0sq\0~\0jnO\\q\0~\r$t\0\0pq\0~sq\0~\0q\0~sq\0~\0gq\0~\r$t\0	activity1pq\0~sq\0~\0q\0~sq\0~\0q\0~\r$t\0tool3pt\0	Conditionsq\0~\0q\0~\r5sq\0~\0_eq\0~\r$t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0bcjq\0~\r6q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\r:xt\0Descriptionsq\0~\02\0q\0~\r>sq\0~\0~]mq\0~\r$t\0\0t\0ExtendedAttributessq\0~\0\0q\0~\rBsq\0~\0fHq\0~\r$t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0aHq\0~\rCt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~\rHt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0fKoq\0~\rHt\0NO_ROUTING_STRAIGHTpxsq\0~\0E\0\0\0w\0\0\0q\0~\rMq\0~\rPxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\r)q\0~\r,q\0~\r/q\0~\r2q\0~\r6q\0~\r?q\0~\rCxsq\0~t\0\nTransitionsq\0~\0z&q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0$4#q\0~\rUt\0transition10pq\0~\0sq\0~\0\0q\0~\0sq\0~\0gq\0~\rUt\0\0pq\0~sq\0~\0q\0~sq\0~\0&q\0~\rUt\0route2pq\0~sq\0~\0q\0~sq\0~\0kN!q\0~\rUt\0tool4pt\0	Conditionsq\0~\0q\0~\rfsq\0~\0)Txq\0~\rUt\0status === \'Resubmit\'sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0rAq\0~\rgt\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\rkxt\0Descriptionsq\0~\02\0q\0~\rpsq\0~\0#Aq\0~\rUt\0\0t\0ExtendedAttributessq\0~\0\0q\0~\rtsq\0~\0(86q\0~\rUt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0Z[q\0~\rut\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0U!q\0~\rzt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0tkq\0~\rzt\0NO_ROUTING_STRAIGHTpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxsq\0~t\0ExtendedAttributesq\0~\0yYq\0~\rut\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0xq\0~\rt\0PBUILDER_TRANSITION_CONDITIONSpq\0~sq\0~\0\0q\0~sq\0~\0)q\0~\rt\0G[{\"join\":\"&&\",\"variable\":\"status\",\"operator\":\"===\",\"value\":\"Resubmit\"}]pxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\rZq\0~\r]q\0~\r`q\0~\rcq\0~\rgq\0~\rqq\0~\ruxsq\0~t\0\nTransitionsq\0~\057q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0.#q\0~\rt\0transition13pq\0~\0sq\0~\0\0q\0~\0sq\0~\04q\0~\rt\0\0pq\0~sq\0~\0q\0~sq\0~\04E4q\0~\rt\0tool4pq\0~sq\0~\0q\0~sq\0~\0*\\Sq\0~\rt\0	activity1pt\0	Conditionsq\0~\0q\0~\rsq\0~\0!aq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0 q\0~\rq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0Descriptionsq\0~\02\0q\0~\rsq\0~\0O^	Rq\0~\rt\0\0t\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0fq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0>q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Xkq\0~\rt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0]q\0~\rt\0NO_ROUTING_STRAIGHTpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rxxt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0\Z\\q\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\00Tq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\nxq\0~\rt\0%JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDERpq\0~sq\0~\0\0q\0~sq\0~\0j:zq\0~\rt\0requester;approverpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxsq\0~t\0ExtendedAttributesq\0~\0f̽q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\\S#q\0~\rt\0Auto_Layoutpq\0~sq\0~\0\0q\0~sq\0~\0uhq\0~\rt\0truepxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxsq\0~t\0ExtendedAttributesq\0~\0J\'q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0|q\0~\rt\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~sq\0~\0\0q\0~sq\0~\00Eq\0~\rt\0JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=send_proposal,X_OFFSET=1260,Y_OFFSET=276,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_STRAIGHT,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxsq\0~t\0ExtendedAttributesq\0~\0bnLq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0?q\0~\rt\0JaWE_GRAPH_START_OF_WORKFLOWpq\0~sq\0~\0\0q\0~sq\0~\0hq\0~\rt\0JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=route1,X_OFFSET=180,Y_OFFSET=176,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_STRAIGHT,TYPE=START_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxsq\0~t\0ExtendedAttributesq\0~\0qH<q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0hOq\0~\rt\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~sq\0~\0\0q\0~sq\0~\0`q\0~\rt\0JaWE_GRAPH_PARTICIPANT_ID=approver,CONNECTING_ACTIVITY_ID=tool2,X_OFFSET=1080,Y_OFFSET=484,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_STRAIGHT,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~xxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~cq\0~fq\0~jq\0~qq\0~q\0~q\0~q\0~q\0~q\0~q\0~	q\0~q\0~\rxxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0[sq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0>Dq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0=F@q\0~\rt\0EDITING_TOOLpq\0~sq\0~\0\0q\0~sq\0~\0^a8q\0~\rt\0Web Workflow Designerpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0h\' q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0|JMq\0~t\0EDITING_TOOL_VERSIONpq\0~sq\0~\0\0q\0~sq\0~\0wX^q\0~t\0\r5.0-pre-alphapxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~!xxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~\0q\0~\0q\0~\0q\0~\0Iq\0~\0tq\0~\0q\0~\0q\0~\0q\0~\0q\0~q\0~Qq\0~Xq\0~x\0sq\0~\0w\0\0\0\0xt\01sr\0*org.enhydra.shark.xpdl.elements.Namespaces|<.R\0\0xq\0~\0kt\0\nNamespacessq\0~\02q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.Namespacez_\0\0xq\0~\0t\0	Namespacesq\0~\0Kdq\0~)t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0)kq\0~0t\0xpdlpq\0~\0sq\0~\0q\0~\0sq\0~\0{5q\0~0t\0 http://www.wfmc.org/2002/XPDL1.0pxsq\0~\0E\0\0\0w\0\0\0q\0~5q\0~8xx',1000202,1,1000203,0),
('<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Package xmlns=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xpdl=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" Id=\"expenseclaim\" Name=\"v6 Expenses Claim\" xsi:schemaLocation=\"http://www.wfmc.org/2002/XPDL1.0 http://wfmc.org/standards/docs/TC-1025_schema_10_xpdl.xsd\">\n    <PackageHeader>\n        <XPDLVersion>1.0</XPDLVersion>\n        <Vendor/>\n        <Created/>\n    </PackageHeader>\n    <Script Type=\"text/javascript\"/>\n    <Participants>\n        <Participant Id=\"claimant\" Name=\"Claimant\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n        <Participant Id=\"approver\" Name=\"Approver\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n        <Participant Id=\"finance\" Name=\"Finance\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n    </Participants>\n    <Applications>\n        <Application Id=\"default_application\"/>\n    </Applications>\n    <WorkflowProcesses>\n        <WorkflowProcess Id=\"process1\" Name=\"Expense Approval Process\">\n            <ProcessHeader DurationUnit=\"h\"/>\n            <DataFields>\n                <DataField Id=\"status\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n                <DataField Id=\"SelectApprover\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n            </DataFields>\n            <Activities>\n                <Activity Id=\"approve_claim\" Name=\"HOD Approve\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Join Type=\"XOR\"/>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"271,11.26251220703125\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"route1\">\n                    <Route/>\n                    <Performer>approver</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Split Type=\"XOR\">\n                                <TransitionRefs>\n                                    <TransitionRef Id=\"transition10\"/>\n                                    <TransitionRef Id=\"transition14\"/>\n                                    <TransitionRef Id=\"transition16\"/>\n                                </TransitionRefs>\n                            </Split>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"468,15.024996948242176\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"verify_claim\" Name=\"Finance Verify\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>finance</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"finance\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"445,46.56248779296874\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"route2\">\n                    <Route/>\n                    <Performer>finance</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Split Type=\"XOR\">\n                                <TransitionRefs>\n                                    <TransitionRef Id=\"transition7\"/>\n                                    <TransitionRef Id=\"transition8\"/>\n                                </TransitionRefs>\n                            </Split>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"finance\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"622,50.37498779296874\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool1\" Name=\"Notify Claimant Finance Verified\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>finance</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"finance\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"754,45.58751220703124\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool2\" Name=\"Notify Claimant Finance Rejected\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>finance</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"finance\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"589,136.1625244140625\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool3\" Name=\"Notify Claimant Resubmit\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>claimant</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"claimant\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"432,33.62499923706055\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"new_claim\" Name=\"Claimant Edit\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>claimant</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"claimant\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"124,36.87499649804687\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool4\" Name=\"Update Status=Submitted\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"115.64773559570312,110.71590326953125\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"resubmit\" Name=\"Claimant Resubmit\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>claimant</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"claimant\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"259,34.66666825097656\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool5\" Name=\"Notify Approver\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"267,111.34090326953125\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool6\" Name=\"Notify Finance\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"445,111.87499140429688\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool7\" Name=\"Notify Claimant Rejected\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"697,14.962509155273438\"/>\n                    </ExtendedAttributes>\n                </Activity>\n            </Activities>\n            <Transitions>\n                <Transition From=\"approve_claim\" Id=\"transition1\" To=\"route1\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"verify_claim\" Id=\"transition4\" To=\"route2\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition7\" Name=\"verified\" To=\"tool1\">\n                    <Condition Type=\"OTHERWISE\"/>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition8\" To=\"tool2\">\n                    <Condition Type=\"CONDITION\">status===\'Rejected by Finance\'</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"new_claim\" Id=\"t_new_claim_tool4\" To=\"tool4\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"resubmit\" Id=\"t_resubmit_approve_claim\" To=\"approve_claim\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool4\" Id=\"transition11\" To=\"tool5\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_BREAK_POINTS\" Value=\"orthogonal\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool5\" Id=\"transition12\" To=\"approve_claim\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition10\" To=\"tool3\">\n                    <Condition Type=\"CONDITION\">status===\'Resubmit\'</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool3\" Id=\"transition13\" To=\"resubmit\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition14\" Name=\"approved\" To=\"tool6\">\n                    <Condition Type=\"OTHERWISE\"/>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool6\" Id=\"transition15\" To=\"verify_claim\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition16\" To=\"tool7\">\n                    <Condition Type=\"CONDITION\">status===\'Rejected by HOD\'</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n            </Transitions>\n            <ExtendedAttributes>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER\" Value=\"claimant;approver;finance\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=finance,CONNECTING_ACTIVITY_ID=tool2,X_OFFSET=758,Y_OFFSET=145,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=finance,CONNECTING_ACTIVITY_ID=tool1,X_OFFSET=915,Y_OFFSET=57,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_START_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=claimant,CONNECTING_ACTIVITY_ID=new_claim,X_OFFSET=63,Y_OFFSET=53,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=approver,CONNECTING_ACTIVITY_ID=tool7,X_OFFSET=865,Y_OFFSET=28,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n            </ExtendedAttributes>\n        </WorkflowProcess>\n    </WorkflowProcesses>\n    <ExtendedAttributes>\n        <ExtendedAttribute Name=\"EDITING_TOOL\" Value=\"Web Workflow Designer\"/>\n        <ExtendedAttribute Name=\"EDITING_TOOL_VERSION\" Value=\"5.0-pre-alpha\"/>\n    </ExtendedAttributes>\n</Package>\n','\0sr\0\'org.enhydra.shark.xpdl.elements.Package~+Vmŀ~\0Z\0isTransientL\0extPkgRefsToIdst\0.Lorg/enhydra/shark/utilities/SequencedHashMap;L\0internalVersiont\0Ljava/lang/String;L\0\nnamespacest\0,Lorg/enhydra/shark/xpdl/elements/Namespaces;xr\0(org.enhydra.shark.xpdl.XMLComplexElement>(\0\0xr\05org.enhydra.shark.xpdl.XMLBaseForCollectionAndComplex2\0L\0\nelementMapq\0~\0L\0elementst\0Ljava/util/ArrayList;xr\0!org.enhydra.shark.xpdl.XMLElement#+B#\0Z\0\nisReadOnlyZ\0\nisRequiredL\0nameq\0~\0L\0originalElementHashCodet\0Ljava/lang/Integer;L\0parentt\0#Lorg/enhydra/shark/xpdl/XMLElement;L\0valueq\0~\0xpt\0Packagesr\0java.lang.Integer⠤8\0I\0valuexr\0java.lang.Number\0\0xpf@pt\0\0sr\0,org.enhydra.shark.utilities.SequencedHashMap.\"\"&\0\0xpw\0\0\0\rt\0Idsr\0#org.enhydra.shark.xpdl.XMLAttribute#c݀M;\0L\0choicesq\0~\0xq\0~\0q\0~\0sq\0~\0Z烪q\0~\0\nt\0expenseclaimpt\0Namesq\0~\0\0q\0~\0sq\0~\07q\0~\0\nt\0v6 Expenses Claimpt\0\rPackageHeadersr\0-org.enhydra.shark.xpdl.elements.PackageHeaderv,\0\0xq\0~\0\0q\0~\0sq\0~\0R_q\0~\0\nt\0\0sq\0~\0w\0\0\0t\0XPDLVersionsr\0+org.enhydra.shark.xpdl.elements.XPDLVersion\"}Y.w\0\0xr\0\'org.enhydra.shark.xpdl.XMLSimpleElementm\0\0xq\0~\0q\0~\0!sq\0~\001q\0~\0t\01.0t\0Vendorsr\0&org.enhydra.shark.xpdl.elements.Vendor tE:\0\0xq\0~\0#q\0~\0\'sq\0~\0Vcdq\0~\0t\0\0t\0Createdsr\0\'org.enhydra.shark.xpdl.elements.CreatedzdK|[\0\0xq\0~\0#q\0~\0,sq\0~\0A,ݻq\0~\0t\0\0t\0Descriptionsr\0+org.enhydra.shark.xpdl.elements.Description۰738\0\0xq\0~\0#\0q\0~\01sq\0~\0^,q\0~\0t\0\0t\0\rDocumentationsr\0-org.enhydra.shark.xpdl.elements.Documentation`9y\0\0xq\0~\0#\0q\0~\06sq\0~\0Hq\0~\0t\0\0t\0PriorityUnitsr\0,org.enhydra.shark.xpdl.elements.PriorityUnit\0\0xq\0~\0#\0q\0~\0;sq\0~\0?q\0~\0t\0\0t\0CostUnitsr\0(org.enhydra.shark.xpdl.elements.CostUnit܎=H\0\0xq\0~\0#\0q\0~\0@sq\0~\0!q\0~\0t\0\0xsr\0java.util.ArrayListxa\0I\0sizexp\0\0\0w\0\0\0q\0~\0$q\0~\0)q\0~\0.q\0~\03q\0~\08q\0~\0=q\0~\0Bxt\0RedefinableHeadersr\01org.enhydra.shark.xpdl.elements.RedefinableHeaderMϪ\'H\0\0xq\0~\0\0q\0~\0Gsq\0~\0\" q\0~\0\nt\0\0sq\0~\0w\0\0\0t\0PublicationStatussq\0~\0\0q\0~\0Msq\0~\0\Z\'q\0~\0It\0\0sq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0UNDER_REVISIONt\0RELEASEDt\0\nUNDER_TESTxt\0Authorsr\0&org.enhydra.shark.xpdl.elements.Author5fᧆ\0\0xq\0~\0#\0q\0~\0Usq\0~\0/(q\0~\0It\0\0t\0Versionsr\0\'org.enhydra.shark.xpdl.elements.Version9=3~JQ\0\0xq\0~\0#\0q\0~\0Zsq\0~\0s>q\0~\0It\0\0t\0Codepagesr\0(org.enhydra.shark.xpdl.elements.Codepage9$me\rG\0\0xq\0~\0#\0q\0~\0_sq\0~\0~q\0~\0It\0\0t\0\nCountrykeysr\0*org.enhydra.shark.xpdl.elements.Countrykey.\0\0xq\0~\0#\0q\0~\0dsq\0~\0/q\0~\0It\0\0t\0Responsiblessr\0,org.enhydra.shark.xpdl.elements.Responsibles${S\0\0xr\0$org.enhydra.shark.xpdl.XMLCollectionjċm\0\0xq\0~\0\0q\0~\0isq\0~\0Nq\0~\0It\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0Nq\0~\0Wq\0~\0\\q\0~\0aq\0~\0fq\0~\0lxt\0ConformanceClasssr\00org.enhydra.shark.xpdl.elements.ConformanceClassy0|k\0\0xq\0~\0\0q\0~\0rsq\0~\0\\%q\0~\0\nt\0\0sq\0~\0w\0\0\0t\0GraphConformancesq\0~\0\0q\0~\0xsq\0~\0_ƛq\0~\0tq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0FULL_BLOCKEDt\0LOOP_BLOCKEDt\0NON_BLOCKEDxxsq\0~\0E\0\0\0w\0\0\0q\0~\0yxt\0Scriptsr\0&org.enhydra.shark.xpdl.elements.ScriptQjS8\0\0xq\0~\0\0q\0~\0sq\0~\0q\0~\0\nt\0\0sq\0~\0w\0\0\0t\0Typesq\0~\0q\0~\0sq\0~\0Bq\0~\0t\0text/javascriptpt\0Versionsq\0~\0\0q\0~\0sq\0~\069q\0~\0t\0\0pt\0Grammarsq\0~\0\0q\0~\0sq\0~\0wZq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExternalPackagessr\00org.enhydra.shark.xpdl.elements.ExternalPackagesw\"+Ũ\0\0xq\0~\0k\0q\0~\0sq\0~\0eųq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0TypeDeclarationssr\00org.enhydra.shark.xpdl.elements.TypeDeclarations\rOx5\0\0xq\0~\0k\0q\0~\0sq\0~\0kXq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Participantssr\0,org.enhydra.shark.xpdl.elements.Participantsh`g8J\0\0xq\0~\0k\0q\0~\0sq\0~\0!q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Participanto$rc\0\0xr\0+org.enhydra.shark.xpdl.XMLCollectionElementCxvr\0\0xq\0~\0t\0Participantsq\0~\0\ZvYq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0_q\0~\0t\0claimantpq\0~\0sq\0~\0\0q\0~\0sq\0~\0=qq\0~\0t\0Claimantpt\0ParticipantTypesr\0/org.enhydra.shark.xpdl.elements.ParticipantType>n݅\0\0xq\0~\0q\0~\0sq\0~\0-q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0~:\'q\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0t\0RESOURCE_SETt\0RESOURCEt\0ROLEt\0ORGANIZATIONAL_UNITt\0HUMANt\0SYSTEMxxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\05Yq\0~\0t\0\0t\0ExternalReferencesr\01org.enhydra.shark.xpdl.elements.ExternalReferencebQ\0\0xq\0~\0\0q\0~\0sq\0~\0\0Dq\0~\0t\0\0sq\0~\0w\0\0\0t\0xrefsq\0~\0\0q\0~\0sq\0~\0:,=q\0~\0t\0\0pt\0locationsq\0~\0q\0~\0sq\0~\0q\0~\0t\0\0pt\0	namespacesq\0~\0\0q\0~\0sq\0~\0iq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExtendedAttributessr\02org.enhydra.shark.xpdl.elements.ExtendedAttributesOUF\0L\0extAttribsStringq\0~\0xq\0~\0k\0q\0~\0sq\0~\0\"q\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xsq\0~\0t\0Participantsq\0~\0Dq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0A4q\0~\0t\0approverpq\0~\0sq\0~\0\0q\0~\0sq\0~\0t\'4q\0~\0t\0Approverpt\0ParticipantTypesq\0~\0q\0~\0sq\0~\0xq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0ݥq\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\0ǃq\0~\0t\0\0t\0ExternalReferencesq\0~\0\0q\0~\0sq\0~\0<.q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Jrq\0~\0t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0D5~`q\0~\0t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Juwq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~	xt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0.{jq\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~xsq\0~\0t\0Participantsq\0~\0.B\rq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0u]BZq\0~t\0financepq\0~\0sq\0~\0\0q\0~\0sq\0~\0Okgq\0~t\0Financept\0ParticipantTypesq\0~\0q\0~sq\0~\0:\Zq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0&q\0~ t\0ROLEsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xxsq\0~\0E\0\0\0w\0\0\0q\0~$xt\0Descriptionsq\0~\02\0q\0~)sq\0~\0q\0~t\0\0t\0ExternalReferencesq\0~\0\0q\0~-sq\0~\0{kq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\067q\0~.t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0`Jq\0~.t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0,;q\0~.t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~2q\0~5q\0~8xt\0ExtendedAttributessq\0~\0\0q\0~<sq\0~\0}vq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~ q\0~*q\0~.q\0~=xxt\0Applicationssr\0,org.enhydra.shark.xpdl.elements.Applications\0\0xq\0~\0k\0q\0~Csq\0~\0Hq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Applicationv	RS\0\0xq\0~\0t\0Applicationsq\0~\0ph8q\0~Et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0F8oBq\0~Kt\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0,dq\0~Kt\0\0pt\0Descriptionsq\0~\02\0q\0~Vsq\0~\0.q\0~Kt\0\0t\0Choicesr\00org.enhydra.shark.xpdl.elements.ApplicationTypes?!\0\0xr\0\'org.enhydra.shark.xpdl.XMLComplexChoice|\"\0L\0choicesq\0~\0L\0choosenq\0~\0	xq\0~\0q\0~Zsq\0~\0tq\0~Kt\0\0sq\0~\0E\0\0\0w\0\0\0sr\00org.enhydra.shark.xpdl.elements.FormalParameterspBÁZ\0\0xq\0~\0k\0t\0FormalParameterssq\0~\04χq\0~]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0\0t\0ExternalReferencesq\0~\0q\0~]t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0>>q\0~ht\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0&)q\0~ht\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0nq\0~ht\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~mq\0~pq\0~sxxq\0~bt\0ExtendedAttributessq\0~\0\0q\0~wsq\0~\0q\0~Kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~Pq\0~Sq\0~Wq\0~]q\0~xxxt\0\nDataFieldssr\0*org.enhydra.shark.xpdl.elements.DataFieldsʦU\0\0xq\0~\0k\0q\0~~sq\0~\0V_q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0WorkflowProcessessr\01org.enhydra.shark.xpdl.elements.WorkflowProcessesp_0,\0\0xq\0~\0k\0q\0~sq\0~\0Bjq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0/org.enhydra.shark.xpdl.elements.WorkflowProcess%v0L\0\0xq\0~\0t\0WorkflowProcesssq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\rq\0~\0sq\0~\0q\0~\0sq\0~\0;q\0~t\0process1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0hq\0~t\0Expense Approval Processpt\0AccessLevelsq\0~\0\0q\0~sq\0~\0~Nq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0PUBLICt\0PRIVATExt\0\rProcessHeadersr\0-org.enhydra.shark.xpdl.elements.ProcessHeaderLC-)\0\0xq\0~\0q\0~sq\0~\03\rZq\0~t\0\0sq\0~\0w\0\0\0t\0DurationUnitsq\0~\0\0q\0~sq\0~\0S#Cq\0~t\0hsq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0Yt\0Mt\0Dt\0ht\0mt\0sxt\0Createdsq\0~\0-\0q\0~sq\0~\0cIq\0~t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0j!-q\0~t\0\0t\0Prioritysr\0(org.enhydra.shark.xpdl.elements.Priority`Nn>b\0\0xq\0~\0#\0q\0~sq\0~\0|nq\0~t\0\0t\0Limitsr\0%org.enhydra.shark.xpdl.elements.Limit1ӗ\0\0xq\0~\0#\0q\0~sq\0~\05q\0~t\0\0t\0	ValidFromsr\0)org.enhydra.shark.xpdl.elements.ValidFromcŅ|L<\0\0xq\0~\0#\0q\0~sq\0~\0deq\0~t\0\0t\0ValidTosr\0\'org.enhydra.shark.xpdl.elements.ValidToM\0\0xq\0~\0#\0q\0~sq\0~\0:q\0~t\0\0t\0TimeEstimationsr\0.org.enhydra.shark.xpdl.elements.TimeEstimationŀ\'3\0\0xq\0~\0\0q\0~sq\0~\0?ytq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesr\0+org.enhydra.shark.xpdl.elements.WaitingTimeN/\0\0xq\0~\0#\0q\0~sq\0~\0^lPq\0~t\0\0t\0WorkingTimesr\0+org.enhydra.shark.xpdl.elements.WorkingTime~\0\0xq\0~\0#\0q\0~sq\0~\0Нq\0~t\0\0t\0Durationsr\0(org.enhydra.shark.xpdl.elements.Duration C\0\0xq\0~\0#\0q\0~sq\0~\0OUoq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xt\0RedefinableHeadersq\0~\0H\0q\0~sq\0~\0:Xa9q\0~t\0\0sq\0~\0w\0\0\0q\0~\0Msq\0~\0\0q\0~\0Msq\0~\0q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~\0Rq\0~\0Sq\0~\0Txt\0Authorsq\0~\0V\0q\0~sq\0~\0-q\0~t\0\0t\0Versionsq\0~\0[\0q\0~sq\0~\0Zq\0~t\0\0t\0Codepagesq\0~\0`\0q\0~sq\0~\0gr\0q\0~t\0\0t\0\nCountrykeysq\0~\0e\0q\0~sq\0~\02q\0~t\0\0t\0Responsiblessq\0~\0j\0q\0~sq\0~\0kdq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~xt\0FormalParameterssq\0~a\0q\0~sq\0~\0\"<q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nDataFieldssq\0~\0q\0~sq\0~\0U65q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.DataFieldI3.~\0\0xq\0~\0t\0	DataFieldsq\0~\0lq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0l)q\0~t\0statuspq\0~\0sq\0~\0\0q\0~\0sq\0~\0mq\0~t\0\0pt\0IsArraysq\0~\0\0q\0~sq\0~\0q\0~t\0FALSEsq\0~\0E\0\0\0w\0\0\0t\0TRUEt\0FALSExt\0DataTypesr\0(org.enhydra.shark.xpdl.elements.DataType\'4sM\0\0xq\0~\0q\0~ sq\0~\0iX*q\0~t\0\0sq\0~\0w\0\0\0t\0	DataTypessr\0)org.enhydra.shark.xpdl.elements.DataTypespcH,!\0Z\0\risInitializedxq\0~\\q\0~&sq\0~\0dΌq\0~\"t\0\0sq\0~\0E\0\0\0	w\0\0\0	sr\0)org.enhydra.shark.xpdl.elements.BasicType)w1\0\0xq\0~\0t\0	BasicTypesq\0~\0=q\0~(t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0!q\0~-t\0STRINGsq\0~\0E\0\0\0w\0\0\0t\0STRINGt\0FLOATt\0INTEGERt\0	REFERENCEt\0DATETIMEt\0BOOLEANt\0	PERFORMERxxsq\0~\0E\0\0\0w\0\0\0q\0~2xsr\0,org.enhydra.shark.xpdl.elements.DeclaredTypedR.\\^9\0\0xq\0~\0t\0DeclaredTypesq\0~\0.q\0~(t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\08\"|q\0~?t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Dxsr\0*org.enhydra.shark.xpdl.elements.SchemaType&1oSH\0\0xq\0~\0t\0\nSchemaTypesq\0~\0Y\"q\0~(t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0Iq\0~(t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0V||Rq\0~Ot\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0#q\0~Ot\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0L9q\0~Ot\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Tq\0~Wq\0~Zxsr\0*org.enhydra.shark.xpdl.elements.RecordType%K\0\0\0xq\0~\0kt\0\nRecordTypesq\0~\0y&szq\0~(t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.UnionType5PG\0\0xq\0~\0kt\0	UnionTypesq\0~\0Lq\0~(t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0/org.enhydra.shark.xpdl.elements.EnumerationTypef3b\0\0xq\0~\0kt\0EnumerationTypesq\0~\0[aq\0~(t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.ArrayTypeg$\0N@\0\0xq\0~\0t\0	ArrayTypesq\0~\0_/q\0~(t\0\0sq\0~\0w\0\0\0t\0\nLowerIndexsq\0~\0q\0~ysq\0~\0*q\0~tt\0\0pt\0\nUpperIndexsq\0~\0q\0~}sq\0~\01zLq\0~tt\0\0pq\0~&sq\0~\'q\0~&sq\0~\0eq\0~tt\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~zq\0~~q\0~xsr\0(org.enhydra.shark.xpdl.elements.ListType\"ӟ\n\0\0xq\0~\0t\0ListTypesq\0~\0#Cq\0~(t\0\0sq\0~\0w\0\0\0q\0~&sq\0~\'q\0~&sq\0~\0=q\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~-xsq\0~\0E\0\0\0w\0\0\0q\0~(xt\0InitialValuesr\0,org.enhydra.shark.xpdl.elements.InitialValuej,zR\0\0xq\0~\0#\0q\0~sq\0~\0tBQq\0~t\0\0t\0Lengthsr\0&org.enhydra.shark.xpdl.elements.LengthMW+-̩W\0\0xq\0~\0#\0q\0~sq\0~\0yq\0~t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0ue7q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0\rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~\Zq\0~\"q\0~q\0~q\0~q\0~xsq\0~\rt\0	DataFieldsq\0~\0§/q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0x]/q\0~t\0SelectApproverpq\0~\0sq\0~\0\0q\0~\0sq\0~\0|L+q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0:q\0~t\0FALSEsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xt\0DataTypesq\0~!q\0~sq\0~\0Iq\0~t\0\0sq\0~\0w\0\0\0q\0~&sq\0~\'q\0~&sq\0~\0]uq\0~t\0\0sq\0~\0E\0\0\0	w\0\0\0	sq\0~,t\0	BasicTypesq\0~\02q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Xdq\0~t\0STRINGsq\0~\0E\0\0\0w\0\0\0q\0~6q\0~7q\0~8q\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~>t\0DeclaredTypesq\0~\0|jۙq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\r$q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~Ht\0\nSchemaTypesq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0M|q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0gWq\0~t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0CAq\0~t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0#Jq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~^t\0\nRecordTypesq\0~\0	Ǵq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~et\0	UnionTypesq\0~\0liq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~lt\0EnumerationTypesq\0~\0=%q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~st\0	ArrayTypesq\0~\0Aq\0~t\0\0sq\0~\0w\0\0\0q\0~ysq\0~\0q\0~ysq\0~\0F+Pq\0~t\0\0pq\0~}sq\0~\0q\0~}sq\0~\0bCФq\0~t\0\0pq\0~&sq\0~\'q\0~&sq\0~\0pY!;q\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~t\0ListTypesq\0~\07A7q\0~t\0\0sq\0~\0w\0\0\0q\0~&sq\0~\'q\0~&sq\0~\0+vq\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0InitialValuesq\0~\0q\0~sq\0~\0WLq\0~t\0\0t\0Lengthsq\0~\0q\0~sq\0~\0nq\0~t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0Qxq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0Ne\'q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xxt\0Participantssq\0~\0\0q\0~#sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Applicationssq\0~D\0q\0~)sq\0~\0AZ	q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ActivitySetssr\0,org.enhydra.shark.xpdl.elements.ActivitySetsqV[4\0\0xq\0~\0k\0q\0~/sq\0~\0!q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nActivitiessr\0*org.enhydra.shark.xpdl.elements.Activities&G^lP\0\0xq\0~\0k\0q\0~6sq\0~\0}(q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\rw\0\0\0\rsr\0(org.enhydra.shark.xpdl.elements.Activityt45\Z9\0\0xq\0~\0t\0Activitysq\0~\01-?q\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0I q\0~>t\0\rapprove_claimpq\0~\0sq\0~\0\0q\0~\0sq\0~\0-U)q\0~>t\0HOD Approvept\0Descriptionsq\0~\02\0q\0~Isq\0~\0J_#q\0~>t\0\0t\0Limitsq\0~\0q\0~Msq\0~\0\ZSEq\0~>t\0\0q\0~\0sr\0-org.enhydra.shark.xpdl.elements.ActivityTypeseŽ{\0\0xq\0~\\q\0~\0sq\0~\02\r?q\0~>t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0%org.enhydra.shark.xpdl.elements.Route0e\rG\0\0xq\0~\0t\0Routesq\0~\01q\0~Rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0.org.enhydra.shark.xpdl.elements.Implementationr^%\0\0xq\0~\0t\0Implementationsq\0~\0dOAq\0~Rt\0\0sq\0~\0w\0\0\0q\0~\0sr\03org.enhydra.shark.xpdl.elements.ImplementationTypes\rT١9\0\0xq\0~\\q\0~\0sq\0~\0	=q\0~^t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0\"org.enhydra.shark.xpdl.elements.No{.\0\0xq\0~\0t\0Nosq\0~\0_ \0Pq\0~dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0%org.enhydra.shark.xpdl.elements.ToolsCg\0\0xq\0~\0k\0t\0Toolssq\0~\0;dq\0~dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0\'org.enhydra.shark.xpdl.elements.SubFlow;Os7:$\0\0xq\0~\0t\0SubFlowsq\0~\0=6q\0~dt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0p~q\0~wt\0\0pt\0	Executionsq\0~\0\0q\0~sq\0~\0/`gq\0~wq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ASYNCHRt\0SYNCHRxt\0ActualParameterssr\00org.enhydra.shark.xpdl.elements.ActualParameters_K\0\0xq\0~\0k\0q\0~sq\0~\0\'{H8q\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~|q\0~q\0~xxq\0~ixsq\0~\0E\0\0\0w\0\0\0q\0~dxsr\0-org.enhydra.shark.xpdl.elements.BlockActivityqcF\0\0xq\0~\0t\0\rBlockActivitysq\0~\0/6Rq\0~Rt\0\0sq\0~\0w\0\0\0t\0BlockIdsq\0~\0q\0~sq\0~\04 Rq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~^t\0	Performersr\0)org.enhydra.shark.xpdl.elements.Performer\"1%\0\0xq\0~\0#\0q\0~sq\0~\0z\n[q\0~>t\0approvert\0	StartModesr\0)org.enhydra.shark.xpdl.elements.StartModenhS\0\0xq\0~\0\0q\0~sq\0~\0`Dq\0~>t\0\0sq\0~\0w\0\0\0t\0Modesr\00org.enhydra.shark.xpdl.elements.StartFinishModes~6zX\'\0\0xq\0~\\\0q\0~sq\0~\0V`q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0,org.enhydra.shark.xpdl.XMLEmptyChoiceElement2;3_\0\0xq\0~\0\0t\0XMLEmptyChoiceElementsq\0~\0\'Yq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.Automatict?_\0\0xq\0~\0t\0	Automaticsq\0~\0f	9q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0&org.enhydra.shark.xpdl.elements.Manualv[ؤ\0\0xq\0~\0t\0Manualsq\0~\0E\0|q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesr\0*org.enhydra.shark.xpdl.elements.FinishMode{\0\0xq\0~\0\0q\0~sq\0~\08/q\0~>t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0L]q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0\\Oq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0\'@q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\04$q\0~>t\0\0t\0	Deadlinessr\0)org.enhydra.shark.xpdl.elements.Deadlines>ɜ\0\0xq\0~\0k\0q\0~sq\0~\0%Iq\0~>t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsr\05org.enhydra.shark.xpdl.elements.SimulationInformation\"|I\0\0xq\0~\0\0q\0~sq\0~\0SZq\0~>t\0\0sq\0~\0w\0\0\0t\0\rInstantiationsq\0~\0\0q\0~sq\0~\0Fwq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ONCEt\0MULTIPLExt\0Costsr\0$org.enhydra.shark.xpdl.elements.Cost\0\0xq\0~\0#q\0~sq\0~\0Jq\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0S\Zq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0WRq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0.b-q\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0X\\tq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsr\0$org.enhydra.shark.xpdl.elements.IconTU(}6\0\0xq\0~\0#\0q\0~sq\0~\0_Dq\0~>t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0*2!Aq\0~>t\0\0t\0TransitionRestrictionssr\06org.enhydra.shark.xpdl.elements.TransitionRestrictionsC)׀i;\0\0xq\0~\0k\0q\0~sq\0~\0hOq\0~>t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\05org.enhydra.shark.xpdl.elements.TransitionRestrictionN}\0\0xq\0~\0t\0TransitionRestrictionsq\0~\0^q\0~t\0\0sq\0~\0w\0\0\0t\0Joinsr\0$org.enhydra.shark.xpdl.elements.Joinڕөx)5\0\0xq\0~\0\0q\0~\"sq\0~\0=3Fq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Kq\0~$t\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ANDt\0XORxxsq\0~\0E\0\0\0w\0\0\0q\0~(xt\0Splitsr\0%org.enhydra.shark.xpdl.elements.Split~ѯWS\0\0xq\0~\0\0q\0~/sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~1q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~,q\0~-xt\0TransitionRefssr\0.org.enhydra.shark.xpdl.elements.TransitionRefsъ\0\0xq\0~\0k\0q\0~8sq\0~\0=fAq\0~1t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~5q\0~:xxsq\0~\0E\0\0\0w\0\0\0q\0~$q\0~1xxt\0ExtendedAttributessq\0~\0\0q\0~Asq\0~\01vWq\0~>t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\01org.enhydra.shark.xpdl.elements.ExtendedAttribute\\F\0\0xq\0~\0t\0ExtendedAttributesq\0~\0LUNq\0~Bt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Lq\0~Ht\0JaWE_GRAPH_PARTICIPANT_IDpt\0Valuesq\0~\0\0q\0~Psq\0~\0%q\0~Ht\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~Mq\0~Qxsq\0~Gt\0ExtendedAttributesq\0~\0w̭q\0~Bt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\01wsq\0~Ut\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0A:aq\0~Ut\0271,11.26251220703125pxsq\0~\0E\0\0\0w\0\0\0q\0~Zq\0~]xxpxsq\0~\0E\0\0\0w\0\0\0q\0~Cq\0~Fq\0~Jq\0~Nq\0~Rq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~Bxsq\0~=t\0Activitysq\0~\07q\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0jq\0~bt\0route1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0}Dwq\0~bt\0\0pt\0Descriptionsq\0~\02\0q\0~msq\0~\0e\r*q\0~bt\0\0t\0Limitsq\0~\0q\0~qsq\0~\0svq\0~bt\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0Eq\0~bt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0F2=$q\0~ut\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0Ǖq\0~ut\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0~Cq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\04q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0P+,q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~vt\0SubFlowsq\0~\0	q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Eq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0#q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\02彫q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0zքq\0~ut\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0\0\Zq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~yt\0	Performersq\0~\0q\0~sq\0~\02Wq\0~bt\0approvert\0	StartModesq\0~\0q\0~sq\0~\0q\0~bt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0t>lq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0Yq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0?:vq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0sq\0~bt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0S U5q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0aq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0\nq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0~īq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0q\0~bt\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0lq\0~bt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0Cdcq\0~bt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0Eq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0;q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\03q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0W}jq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0}q\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0:|q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\r\0q\0~sq\0~\09^\'q\0~bt\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0wq\0~bt\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0)[q\0~bt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0TransitionRestrictionsq\0~\0ꖖq\0~t\0\0sq\0~\0w\0\0\0t\0Joinsq\0~#\0q\0~(sq\0~\0?q\0~#t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\02Lq\0~)q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~,q\0~-xxsq\0~\0E\0\0\0w\0\0\0q\0~-xt\0Splitsq\0~0\0q\0~1sq\0~\0m~q\0~#t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\06q\0~2t\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~,q\0~-xt\0TransitionRefssq\0~9\0q\0~:sq\0~\0yEq\0~2t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0-org.enhydra.shark.xpdl.elements.TransitionRef%-a\0\0xq\0~\0t\0\rTransitionRefsq\0~\0y4q\0~;t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0].-q\0~At\0transition10pxsq\0~\0E\0\0\0w\0\0\0q\0~Fxsq\0~@t\0\rTransitionRefsq\0~\0f+q\0~;t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0D1q\0~Jt\0transition14pxsq\0~\0E\0\0\0w\0\0\0q\0~Oxsq\0~@t\0\rTransitionRefsq\0~\0dLq\0~;t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0O\0xq\0~St\0transition16pxsq\0~\0E\0\0\0w\0\0\0q\0~Xxxxsq\0~\0E\0\0\0w\0\0\0q\0~6q\0~;xxsq\0~\0E\0\0\0w\0\0\0q\0~)q\0~2xxt\0ExtendedAttributessq\0~\0\0q\0~^sq\0~\0Ov$q\0~bt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0b%q\0~_t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\\q\0~dt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0uq\0~dt\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~iq\0~lxsq\0~Gt\0ExtendedAttributesq\0~\03E	q\0~_t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~pt\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0*q\0~pt\0468,15.024996948242176pxsq\0~\0E\0\0\0w\0\0\0q\0~uq\0~xxxpxsq\0~\0E\0\0\0w\0\0\0q\0~gq\0~jq\0~nq\0~rq\0~uq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~\Zq\0~q\0~_xsq\0~=t\0Activitysq\0~\0q\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0y[-q\0~}t\0verify_claimpq\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~}t\0Finance Verifypt\0Descriptionsq\0~\02\0q\0~sq\0~\0iZzq\0~}t\0\0t\0Limitsq\0~\0q\0~sq\0~\0bq\0~}t\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0\"f6q\0~}t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0keq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0Q\rq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0JRq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0Kq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0kF\\q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~vt\0SubFlowsq\0~\0Uגq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0lQq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0tqq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0-5}q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0n7Yq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0\nq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0iq\0~}t\0financet\0	StartModesq\0~\0q\0~sq\0~\0z\nq\0~}t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0A.wq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0<d8q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0+%q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Qpq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0Mq\0~}t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0s{q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0#q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0H[jq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Vq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0PLQq\0~}t\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0-H̥q\0~}t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0>\0q\0~}t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0qq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0-q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0zDq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~\"sq\0~\0tlQq\0~t\0\0t\0WorkingTimesq\0~\0q\0~&sq\0~\02Pxq\0~t\0\0t\0Durationsq\0~\0q\0~*sq\0~\02=fq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~#q\0~\'q\0~+xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~\Zq\0~xt\0Iconsq\0~\r\0q\0~0sq\0~\0oWq\0~}t\0\0t\0\rDocumentationsq\0~\07\0q\0~4sq\0~\0y7q\0~}t\0\0t\0TransitionRestrictionssq\0~\0q\0~8sq\0~\0Lqq\0~}t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~>sq\0~\0	q\0~}t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0sz7q\0~?t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0~pq\0~Dt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0jw]q\0~Dt\0financepxsq\0~\0E\0\0\0w\0\0\0q\0~Iq\0~Lxsq\0~Gt\0ExtendedAttributesq\0~\0sΖq\0~?t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0TYq\0~Pt\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0|\rq\0~Pt\0445,46.56248779296874pxsq\0~\0E\0\0\0w\0\0\0q\0~Uq\0~Xxxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~1q\0~5q\0~9q\0~?xsq\0~=t\0Activitysq\0~\0(q\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0$q\0~]t\0route2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0/Rq\0~]t\0\0pt\0Descriptionsq\0~\02\0q\0~hsq\0~\0igq\0~]t\0\0t\0Limitsq\0~\0q\0~lsq\0~\0yQq\0~]t\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0qNxq\0~]t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0fq\0~pt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0kq\0~pt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0Uׅq\0~zt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0F{q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0yg&q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~vt\0SubFlowsq\0~\0\nQq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0aq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0ytq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0<_~q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0;{xq\0~pt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0R8Qq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~tt\0	Performersq\0~\0q\0~sq\0~\0~Dq\0~]t\0financet\0	StartModesq\0~\0q\0~sq\0~\0M	q\0~]t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0U.aq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0eq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0.8q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0wYnq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0|Mq\0~]t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0bq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0=5Xq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0O3hzq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0I#q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0\r\Z3q\0~]t\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0\Z}ʩq\0~]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0N$q\0~]t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0Qq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0\r~q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0ydq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0;Bq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0VNq\0~t\0\0t\0Durationsq\0~\0q\0~\nsq\0~\0x8q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\r\0q\0~sq\0~\0Gmq-q\0~]t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0IFq\0~]t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0y.nq\0~]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0TransitionRestrictionsq\0~\0MKq\0~t\0\0sq\0~\0w\0\0\0t\0Joinsq\0~#\0q\0~#sq\0~\0^yq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0hq\0~$q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~,q\0~-xxsq\0~\0E\0\0\0w\0\0\0q\0~(xt\0Splitsq\0~0\0q\0~,sq\0~\08Qq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0gB-q\0~-t\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~,q\0~-xt\0TransitionRefssq\0~9\0q\0~5sq\0~\0jq\0~-t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~@t\0\rTransitionRefsq\0~\0\"9Uq\0~6t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0C)yq\0~;t\0transition7pxsq\0~\0E\0\0\0w\0\0\0q\0~@xsq\0~@t\0\rTransitionRefsq\0~\0q\0~6t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0RqZq\0~Dt\0transition8pxsq\0~\0E\0\0\0w\0\0\0q\0~Ixxxsq\0~\0E\0\0\0w\0\0\0q\0~1q\0~6xxsq\0~\0E\0\0\0w\0\0\0q\0~$q\0~-xxt\0ExtendedAttributessq\0~\0\0q\0~Osq\0~\0=q\0~]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0S8q\0~Pt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0=q\0~Ut\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0\\Jq\0~Ut\0financepxsq\0~\0E\0\0\0w\0\0\0q\0~Zq\0~]xsq\0~Gt\0ExtendedAttributesq\0~\0|q\0~Pt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0TXq\0~at\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0\nq\0~at\0622,50.37498779296874pxsq\0~\0E\0\0\0w\0\0\0q\0~fq\0~ixxpxsq\0~\0E\0\0\0w\0\0\0q\0~bq\0~eq\0~iq\0~mq\0~pq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~Pxsq\0~=t\0Activitysq\0~\0\nQq\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0=q\0~nt\0tool1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0?=cq\0~nt\0 Notify Claimant Finance Verifiedpt\0Descriptionsq\0~\02\0q\0~ysq\0~\0)q\0~nt\0\0t\0Limitsq\0~\0q\0~}sq\0~\0zBXq\0~nt\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0z-q\0~nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0lq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0\"Ix\Zq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0Hq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0_iq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0ŝ:q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0$org.enhydra.shark.xpdl.elements.Tool\\6&+G\0\0xq\0~\0t\0Toolsq\0~\0UkiJq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0%=6q\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0\n1cq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0APPLICATIONt\0	PROCEDURExt\0ActualParameterssq\0~\0q\0~sq\0~\0;q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0*T\nq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0${6q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~xxsq\0~vt\0SubFlowsq\0~\0wPq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0ctq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\07>=q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0Iq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0_g9fq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0\ZVq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0Lgq\0~nt\0financet\0	StartModesq\0~\0q\0~sq\0~\0[ \"q\0~nt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0=4q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\00q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\07q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0GXq\0~nt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\01hq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0G̠q\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0J!\nq\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0oq\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Prioritysq\0~\0q\0~sq\0~\0|^q\0~nt\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0D-\rq\0~nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~!sq\0~\0&9q\0~nt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0Lq\0~\"q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~)sq\0~\0Zi\rq\0~\"t\0\0t\0TimeEstimationsq\0~q\0~-sq\0~\0noq\0~\"t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~2sq\0~\0Iq\0~.t\0\0t\0WorkingTimesq\0~\0q\0~6sq\0~\0(k^q\0~.t\0\0t\0Durationsq\0~\0q\0~:sq\0~\0:~q\0~.t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~3q\0~7q\0~;xxsq\0~\0E\0\0\0w\0\0\0q\0~&q\0~*q\0~.xt\0Iconsq\0~\r\0q\0~@sq\0~\0_q\0~nt\0\0t\0\rDocumentationsq\0~\07\0q\0~Dsq\0~\0Qkq\0~nt\0\0t\0TransitionRestrictionssq\0~\0q\0~Hsq\0~\0#Đyq\0~nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~Nsq\0~\0l-q\0~nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0ER*q\0~Ot\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0o\'Dq\0~Tt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0t\r/Wq\0~Tt\0financepxsq\0~\0E\0\0\0w\0\0\0q\0~Yq\0~\\xsq\0~Gt\0ExtendedAttributesq\0~\03q\0~Ot\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\\޽q\0~`t\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0Jwhq\0~`t\0754,45.58751220703124pxsq\0~\0E\0\0\0w\0\0\0q\0~eq\0~hxxpxsq\0~\0E\0\0\0w\0\0\0q\0~sq\0~vq\0~zq\0~~q\0~q\0~q\0~q\0~q\0~q\0~q\0~\"q\0~Aq\0~Eq\0~Iq\0~Oxsq\0~=t\0Activitysq\0~\0Wq\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0J޳nq\0~mt\0tool2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0krIq\0~mt\0 Notify Claimant Finance Rejectedpt\0Descriptionsq\0~\02\0q\0~xsq\0~\0cq\0~mt\0\0t\0Limitsq\0~\0q\0~|sq\0~\0q\0~mt\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0)<?q\0~mt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0kkq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0rjVq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0= bLq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0n q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0HSq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\'iq\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\08q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0iq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0zY{q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0W q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~xxsq\0~vt\0SubFlowsq\0~\0zWZq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Z>]q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0d2Tq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0sbhq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0+q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0xq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0tq\':q\0~mt\0financet\0	StartModesq\0~\0q\0~sq\0~\0d.q\0~mt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0iPq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\01Nq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\03\0Rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0@gq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0xضq\0~mt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0	q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0rmsq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\08):q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Xq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	\0xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~	sq\0~\0*q\0~mt\0\0t\0	Deadlinessq\0~\0q\0~	sq\0~\0B\"&q\0~mt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~	sq\0~\03mWq\0~mt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0gq\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~	%sq\0~\0Q}}q\0~	t\0\0t\0TimeEstimationsq\0~q\0~	)sq\0~\0j\0q\0~	t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~	.sq\0~\0Bq\0~	*t\0\0t\0WorkingTimesq\0~\0q\0~	2sq\0~\0@pq\0~	*t\0\0t\0Durationsq\0~\0q\0~	6sq\0~\0;oPIq\0~	*t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~	/q\0~	3q\0~	7xxsq\0~\0E\0\0\0w\0\0\0q\0~	\"q\0~	&q\0~	*xt\0Iconsq\0~\r\0q\0~	<sq\0~\0q\0~mt\0\0t\0\rDocumentationsq\0~\07\0q\0~	@sq\0~\03q\0~mt\0\0t\0TransitionRestrictionssq\0~\0q\0~	Dsq\0~\0\ZnQq\0~mt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~	Jsq\0~\0[;Rq\0~mt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0Gm)q\0~	Kt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Hq\0~	Pt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\08jq\0~	Pt\0financepxsq\0~\0E\0\0\0w\0\0\0q\0~	Uq\0~	Xxsq\0~Gt\0ExtendedAttributesq\0~\0?cq\0~	Kt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~	\\t\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0yXq\0~	\\t\0589,136.1625244140625pxsq\0~\0E\0\0\0w\0\0\0q\0~	aq\0~	dxxpxsq\0~\0E\0\0\0w\0\0\0q\0~rq\0~uq\0~yq\0~}q\0~q\0~q\0~q\0~q\0~	q\0~	q\0~	q\0~	=q\0~	Aq\0~	Eq\0~	Kxsq\0~=t\0Activitysq\0~\0sq\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0`\\q\0~	it\0tool3pq\0~\0sq\0~\0\0q\0~\0sq\0~\0]_q\0~	it\0Notify Claimant Resubmitpt\0Descriptionsq\0~\02\0q\0~	tsq\0~\0Z\'2q\0~	it\0\0t\0Limitsq\0~\0q\0~	xsq\0~\0U3q\0~	it\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0\\.q\0~	it\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0kt|q\0~	|t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0Eq\0~	|t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0>q\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0k+@q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0%q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0g$q\0~	t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~	sq\0~\0qq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~	sq\0~\0BUq\0~	t\0\0t\0ExtendedAttributessq\0~\0\0q\0~	sq\0~\0Hq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	q\0~	q\0~	xxsq\0~vt\0SubFlowsq\0~\06q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0lq\0~	t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0]>7Kq\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~	sq\0~\0oJq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	xxq\0~	xsq\0~\0E\0\0\0w\0\0\0q\0~	xsq\0~t\0\rBlockActivitysq\0~\0Ɏq\0~	|t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0y/q\0~	t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~	xxq\0~	t\0	Performersq\0~\0q\0~	sq\0~\0Uۘq\0~	it\0claimantt\0	StartModesq\0~\0q\0~	sq\0~\0nq\0~	it\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0#Eq\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0(q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0oq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	xsq\0~\0E\0\0\0w\0\0\0q\0~	xt\0\nFinishModesq\0~\0q\0~	sq\0~\0J=]Rq\0~	it\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\06q\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0qq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0t@q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0%\\q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	xsq\0~\0E\0\0\0w\0\0\0q\0~	xt\0Prioritysq\0~\0q\0~\nsq\0~\0l?q\0~	it\0\0t\0	Deadlinessq\0~\0q\0~\nsq\0~\0J[Tq\0~	it\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~\nsq\0~\0$tDq\0~	it\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0gN\'q\0~\n\Zq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~\n!sq\0~\02_q\0~\n\Zt\0\0t\0TimeEstimationsq\0~q\0~\n%sq\0~\0%>~Eq\0~\n\Zt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~\n*sq\0~\02=:q\0~\n&t\0\0t\0WorkingTimesq\0~\0q\0~\n.sq\0~\0$;q\0~\n&t\0\0t\0Durationsq\0~\0q\0~\n2sq\0~\0q\0~\n&t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~\n+q\0~\n/q\0~\n3xxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\n\"q\0~\n&xt\0Iconsq\0~\r\0q\0~\n8sq\0~\0D\r\"q\0~	it\0\0t\0\rDocumentationsq\0~\07\0q\0~\n<sq\0~\0<j;q\0~	it\0\0t\0TransitionRestrictionssq\0~\0q\0~\n@sq\0~\0bBq\0~	it\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~\nFsq\0~\0M/mfq\0~	it\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0b]q\0~\nGt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0&xq\0~\nLt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0n,#q\0~\nLt\0claimantpxsq\0~\0E\0\0\0w\0\0\0q\0~\nQq\0~\nTxsq\0~Gt\0ExtendedAttributesq\0~\0yo\"q\0~\nGt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0slfq\0~\nXt\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0~`q\0~\nXt\0432,33.62499923706055pxsq\0~\0E\0\0\0w\0\0\0q\0~\n]q\0~\n`xxpxsq\0~\0E\0\0\0w\0\0\0q\0~	nq\0~	qq\0~	uq\0~	yq\0~	|q\0~	q\0~	q\0~	q\0~\nq\0~\nq\0~\n\Zq\0~\n9q\0~\n=q\0~\nAq\0~\nGxsq\0~=t\0Activitysq\0~\0u&q\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0LYq\0~\net\0	new_claimpq\0~\0sq\0~\0\0q\0~\0sq\0~\0qq\0~\net\0\rClaimant Editpt\0Descriptionsq\0~\02\0q\0~\npsq\0~\0Aq\0~\net\0\0t\0Limitsq\0~\0q\0~\ntsq\0~\0;	q\0~\net\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0y]q\0~\net\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0o̒q\0~\nxt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0gnq\0~\nxt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\05C8q\0~\nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0mq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0<+q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~vt\0SubFlowsq\0~\06?q\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0IGq\0~\nt\0\0pq\0~sq\0~\0\0q\0~sq\0~\03lVq\0~\nq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~\nsq\0~\0Nq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nxxq\0~\nxsq\0~\0E\0\0\0w\0\0\0q\0~\nxsq\0~t\0\rBlockActivitysq\0~\0&N?q\0~\nxt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0J;q\0~\nt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\nxxq\0~\nt\0	Performersq\0~\0q\0~\nsq\0~\0q\0~\net\0claimantt\0	StartModesq\0~\0q\0~\nsq\0~\0u\0q\0~\net\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0#q\0~\nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0?q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0Zq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0jN}Yq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\nxsq\0~\0E\0\0\0w\0\0\0q\0~\nxt\0\nFinishModesq\0~\0q\0~\nsq\0~\0f~Mq\0~\net\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0@q\0~\nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0Dkq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0dWq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\05q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\nxsq\0~\0E\0\0\0w\0\0\0q\0~\nxt\0Prioritysq\0~\0q\0~\nsq\0~\0{]zq\0~\net\0\0t\0	Deadlinessq\0~\0q\0~\nsq\0~\0*q\0~\net\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~\nsq\0~\0n{1q\0~\net\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0\'Sq\0~\nq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0.o\nq\0~\nt\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0\'i6q\0~\nt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~\nsq\0~\0/q\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0*H7q\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0|0mq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~q\0~xt\0Iconsq\0~\r\0q\0~sq\0~\0H	}q\0~\net\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0iEοq\0~\net\0\0t\0TransitionRestrictionssq\0~\0q\0~ sq\0~\0YS\Zq\0~\net\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~&sq\0~\0O1>dq\0~\net\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0mq\0~\'t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0[6\"q\0~,t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0\r!q\0~,t\0claimantpxsq\0~\0E\0\0\0w\0\0\0q\0~1q\0~4xsq\0~Gt\0ExtendedAttributesq\0~\0}hwq\0~\'t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0sq\0~8t\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0\\ETpq\0~8t\0124,36.87499649804687pxsq\0~\0E\0\0\0w\0\0\0q\0~=q\0~@xxpxsq\0~\0E\0\0\0w\0\0\0q\0~\njq\0~\nmq\0~\nqq\0~\nuq\0~\nxq\0~\nq\0~\nq\0~\nq\0~\nq\0~\nq\0~\nq\0~q\0~q\0~!q\0~\'xsq\0~=t\0Activitysq\0~\0;vq\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0m\0q\0~Et\0tool4pq\0~\0sq\0~\0\0q\0~\0sq\0~\0}eq\0~Et\0Update Status=Submittedpt\0Descriptionsq\0~\02\0q\0~Psq\0~\0r2q\0~Et\0\0t\0Limitsq\0~\0q\0~Tsq\0~\0~eq\0~Et\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0vZhq\0~Et\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0(q\0~Xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\01q\0~Xt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0_Rxq\0~bt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0znq\0~gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0\"q\0~gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0!0!q\0~qt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0?+Oq\0~wt\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0B7JPq\0~wq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0mpCq\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0brq\0~wt\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0G6h3q\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~|q\0~q\0~q\0~q\0~xxsq\0~vt\0SubFlowsq\0~\0=q\0~gt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0G8q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0~q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0`Oq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~qxsq\0~\0E\0\0\0w\0\0\0q\0~gxsq\0~t\0\rBlockActivitysq\0~\0_q\0~Xt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0i۶q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~bt\0	Performersq\0~\0q\0~sq\0~\0|}\Zq\0~Et\0approvert\0	StartModesq\0~\0q\0~sq\0~\0	:tq\0~Et\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0wjZq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0<q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0ge/q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0bq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\01܏q\0~Et\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0FG\rq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0fzTq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0cq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Ogq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0;-eq\0~Et\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0Yq\0~Et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0V\';q\0~Et\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0RBq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0phq\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0?%4q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0Uq\0~t\0\0t\0WorkingTimesq\0~\0q\0~\nsq\0~\0Jq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0#[q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\r\0q\0~sq\0~\02+q\0~Et\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0oMq\0~Et\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0H\'q\0~Et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~\"sq\0~\058q\0~Et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0P>&q\0~#t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Y@8q\0~(t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0֩@q\0~(t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~-q\0~0xsq\0~Gt\0ExtendedAttributesq\0~\0^q\0~#t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0yq\0~4t\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0!_q\0~4t\0%115.64773559570312,110.71590326953125pxsq\0~\0E\0\0\0w\0\0\0q\0~9q\0~<xxpxsq\0~\0E\0\0\0w\0\0\0q\0~Jq\0~Mq\0~Qq\0~Uq\0~Xq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~#xsq\0~=t\0Activitysq\0~\0~q\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0;7mq\0~At\0resubmitpq\0~\0sq\0~\0\0q\0~\0sq\0~\0\\q\0~At\0Claimant Resubmitpt\0Descriptionsq\0~\02\0q\0~Lsq\0~\0dMq\0~At\0\0t\0Limitsq\0~\0q\0~Psq\0~\0/q\0~At\0\0q\0~\0sq\0~Qq\0~\0sq\0~\07.moq\0~At\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0AQq\0~Tt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0M1q\0~Tt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0|HNq\0~^t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\08Vq\0~ct\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0[<XUq\0~ct\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~vt\0SubFlowsq\0~\0yq\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\09*Aq\0~st\0\0pq\0~sq\0~\0\0q\0~sq\0~\01\nq\0~sq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~~sq\0~\0q\0~st\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~xq\0~{q\0~xxq\0~gxsq\0~\0E\0\0\0w\0\0\0q\0~cxsq\0~t\0\rBlockActivitysq\0~\08*q\0~Tt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Syoq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~^t\0	Performersq\0~\0q\0~sq\0~\0,tpq\0~At\0claimantt\0	StartModesq\0~\0q\0~sq\0~\0Rq\0~At\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Btq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0&aq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0R`q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0x&\nq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0 .q\0~At\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0&@q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0w&RBq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0Hq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0h5&q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0Qq\0~At\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0Rnq\0~At\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0Vq\0~At\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0d+q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0_q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0.q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0IDq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0Tq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0}q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\r\0q\0~sq\0~\0v$\nq\0~At\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0E19q\0~At\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\08v\"q\0~At\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0lq\0~At\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0veAq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0}Tq\0~\rt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0hq\0~\rt\0claimantpxsq\0~\0E\0\0\0w\0\0\0q\0~\r\rq\0~\rxsq\0~Gt\0ExtendedAttributesq\0~\0wMBq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\n+;q\0~\rt\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0iLq\0~\rt\0259,34.66666825097656pxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~Fq\0~Iq\0~Mq\0~Qq\0~Tq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~\rxsq\0~=t\0Activitysq\0~\0_Jq\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0/1q\0~\r!t\0tool5pq\0~\0sq\0~\0\0q\0~\0sq\0~\0F6q\0~\r!t\0Notify Approverpt\0Descriptionsq\0~\02\0q\0~\r,sq\0~\0\0fq\0~\r!t\0\0t\0Limitsq\0~\0q\0~\r0sq\0~\0vEW+q\0~\r!t\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0yq\0~\r!t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0Pq\0~\r4t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0\r0q\0~\r4t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0Qq\0~\r>t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0>қbq\0~\rCt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0mzq\0~\rCt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0mhrq\0~\rMt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0|4q\0~\rSt\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0\0cOq\0~\rSq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~\r^sq\0~\0>\r|nq\0~\rSt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~\rdsq\0~\0H|/q\0~\rSt\0\0t\0ExtendedAttributessq\0~\0\0q\0~\rhsq\0~\0f9q\0~\rSt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\rXq\0~\r[q\0~\r_q\0~\req\0~\rixxsq\0~vt\0SubFlowsq\0~\0g=q\0~\rCt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\06q\0~\rot\0\0pq\0~sq\0~\0\0q\0~sq\0~\068q\0~\roq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~\rzsq\0~\0&Eq\0~\rot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\rtq\0~\rwq\0~\r{xxq\0~\rMxsq\0~\0E\0\0\0w\0\0\0q\0~\rCxsq\0~t\0\rBlockActivitysq\0~\0\0q\0~\r4t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0ƻq\0~\rt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\rxxq\0~\r>t\0	Performersq\0~\0q\0~\rsq\0~\06TJq\0~\r!t\0approvert\0	StartModesq\0~\0q\0~\rsq\0~\0Z\0q\0~\r!t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0\nAf	q\0~\rt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\00q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0kq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\01q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\rxsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0\nFinishModesq\0~\0q\0~\rsq\0~\0`q\0~\r!t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\027Bq\0~\rt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0qq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0Wq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0\")q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\rxsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0Prioritysq\0~\0q\0~\rsq\0~\0o]q\0~\r!t\0\0t\0	Deadlinessq\0~\0q\0~\rsq\0~\0>eq\0~\r!t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~\rsq\0~\07Heq\0~\r!t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0R5q\0~\rq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~\rsq\0~\05q\0~\rt\0\0t\0TimeEstimationsq\0~q\0~\rsq\0~\08q\0~\rt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~\rsq\0~\0m*3q\0~\rt\0\0t\0WorkingTimesq\0~\0q\0~\rsq\0~\0>kq\0~\rt\0\0t\0Durationsq\0~\0q\0~\rsq\0~\07+q\0~\rt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rq\0~\rxxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rq\0~\rxt\0Iconsq\0~\r\0q\0~\rsq\0~\0	q\0~\r!t\0\0t\0\rDocumentationsq\0~\07\0q\0~\rsq\0~\05Vq\0~\r!t\0\0t\0TransitionRestrictionssq\0~\0q\0~\rsq\0~\0\0ꉠq\0~\r!t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0jF\nGq\0~\r!t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\07Vq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0{q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\05\Zq\0~t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~xsq\0~Gt\0ExtendedAttributesq\0~\0\'q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0 Ǒq\0~t\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0^aq\0~t\0267,111.34090326953125pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~\r&q\0~\r)q\0~\r-q\0~\r1q\0~\r4q\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rxsq\0~=t\0Activitysq\0~\0=~Pq\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0O1q\0~t\0tool6pq\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~t\0Notify Financept\0Descriptionsq\0~\02\0q\0~(sq\0~\0q\0~t\0\0t\0Limitsq\0~\0q\0~,sq\0~\0%/q\0~t\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0X~q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0pwq\0~0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0w5Gq\0~0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0@aq\0~:t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0n[pq\0~?t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0.xq\0~?t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0;Rq\0~It\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0lJZsq\0~Ot\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\08<}q\0~Oq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~Zsq\0~\0tq\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~`sq\0~\0(zq\0~Ot\0\0t\0ExtendedAttributessq\0~\0\0q\0~dsq\0~\0ejq\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~Tq\0~Wq\0~[q\0~aq\0~exxsq\0~vt\0SubFlowsq\0~\0 q\0~?t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0oEq\0~kt\0\0pq\0~sq\0~\0\0q\0~sq\0~\0s*[q\0~kq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~vsq\0~\0{cq\0~kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~pq\0~sq\0~wxxq\0~Ixsq\0~\0E\0\0\0w\0\0\0q\0~?xsq\0~t\0\rBlockActivitysq\0~\0$q\0~0t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0QD@q\0~~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~:t\0	Performersq\0~\0q\0~sq\0~\0vq\0~t\0approvert\0	StartModesq\0~\0q\0~sq\0~\0,mq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0]:6q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0,rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0U@dq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Qq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0&5>|q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0,cq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0PBq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0>q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Gq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0yhq\0~t\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0wG<q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0ylq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0BIq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\06\rq\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0sIq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0Qq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0Q{:\"q\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0Aq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\r\0q\0~sq\0~\0q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0:q\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\02W>q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0[3q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0n;Lq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0[-q\0~\0t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0>P#q\0~\0t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~Gt\0ExtendedAttributesq\0~\0@eq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0:Ղq\0~t\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0s+;q\0~t\0445,111.87499140429688pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~\"q\0~%q\0~)q\0~-q\0~0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~=t\0Activitysq\0~\0I`q\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0 Qbq\0~t\0tool7pq\0~\0sq\0~\0\0q\0~\0sq\0~\0RNq\0~t\0Notify Claimant Rejectedpt\0Descriptionsq\0~\02\0q\0~$sq\0~\0DFWq\0~t\0\0t\0Limitsq\0~\0q\0~(sq\0~\0k&q\0~t\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0%Iq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0im\"q\0~,t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0^*q\0~,t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0Cq\0~6t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0gq-q\0~;t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0Rq\0~;t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0Uq\0~Et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0wrq\0~Kt\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0PC4/q\0~Kq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~Vsq\0~\03q\0~Kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~\\sq\0~\0@3q\0~Kt\0\0t\0ExtendedAttributessq\0~\0\0q\0~`sq\0~\0>9q\0~Kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~Pq\0~Sq\0~Wq\0~]q\0~axxsq\0~vt\0SubFlowsq\0~\0?Kq\0~;t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0(iTaq\0~gt\0\0pq\0~sq\0~\0\0q\0~sq\0~\0\'Xq\0~gq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~rsq\0~\0*Sq\0~gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~lq\0~oq\0~sxxq\0~Exsq\0~\0E\0\0\0w\0\0\0q\0~;xsq\0~t\0\rBlockActivitysq\0~\0Mq\0~,t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0/kLJq\0~zt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~6t\0	Performersq\0~\0q\0~sq\0~\0\Z:q\0~t\0approvert\0	StartModesq\0~\0q\0~sq\0~\0(iq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0{ъtq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0i@xq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0\rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0M]Qq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0}5q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0.qq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0T	q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\04fq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0gZq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\08q\0~t\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0?q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0Xwq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0jq49q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0&q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0Opm>q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0oq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0?q\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0v\"zq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\r\0q\0~sq\0~\0:wrq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0qDq\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0@7Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0% biq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0\rQq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0fg[q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0Pq\0~t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~Gt\0ExtendedAttributesq\0~\0\'iɶq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\05rq\0~t\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0i|q\0~t\0697,14.962509155273438pxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~!q\0~%q\0~)q\0~,q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xxt\0Transitionssr\0+org.enhydra.shark.xpdl.elements.Transitions9>/i\0\0xq\0~\0k\0q\0~sq\0~\01Gq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\rw\0\0\0\rsr\0*org.enhydra.shark.xpdl.elements.Transitiontx\0\0xq\0~\0t\0\nTransitionsq\0~\0nGq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0ulq\0~t\0transition1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0L\Zq\0~t\0\0pt\0Fromsq\0~\0q\0~(sq\0~\0Ζq\0~t\0\rapprove_claimpt\0Tosq\0~\0q\0~,sq\0~\0 k#q\0~t\0route1pt\0	Conditionsr\0)org.enhydra.shark.xpdl.elements.ConditionDZ;|\0\0xq\0~\0\0q\0~0sq\0~\0sq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0vg%q\0~2q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0	CONDITIONt\0	OTHERWISEt\0	EXCEPTIONt\0DEFAULTEXCEPTIONxxsq\0~\0E\0\0\0w\0\0\0q\0~6xt\0Descriptionsq\0~\02\0q\0~>sq\0~\0`q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~Bsq\0~\0t˵q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0/h?q\0~Ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Wq\0~Ht\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0\"q\0~Ht\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~Mq\0~Pxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\"q\0~%q\0~)q\0~-q\0~2q\0~?q\0~Cxsq\0~t\0\nTransitionsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0CTq\0~Ut\0transition4pq\0~\0sq\0~\0\0q\0~\0sq\0~\0]H.q\0~Ut\0\0pq\0~(sq\0~\0q\0~(sq\0~\0{wq\0~Ut\0verify_claimpq\0~,sq\0~\0q\0~,sq\0~\0W}Fq\0~Ut\0route2pt\0	Conditionsq\0~1\0q\0~fsq\0~\0||q\0~Ut\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\099q\0~gq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~kxt\0Descriptionsq\0~\02\0q\0~osq\0~\0G@q\0~Ut\0\0t\0ExtendedAttributessq\0~\0\0q\0~ssq\0~\0Sq\0~Ut\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\01!q\0~tt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\01Cq\0~yt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\03q\0~yt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~Zq\0~]q\0~`q\0~cq\0~gq\0~pq\0~txsq\0~t\0\nTransitionsq\0~\0-bBq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0(Rq\0~t\0transition7pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Wq\0~t\0verifiedpq\0~(sq\0~\0q\0~(sq\0~\0}\Z?q\0~t\0route2pq\0~,sq\0~\0q\0~,sq\0~\0nZq\0~t\0tool1pt\0	Conditionsq\0~1\0q\0~sq\0~\0eq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0ISq\0~t\0	OTHERWISEsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0%zf3q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0Hq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0`q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0zq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0{Z\Z\"q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0ZSq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0z>\rq\0~t\0transition8pq\0~\0sq\0~\0\0q\0~\0sq\0~\0}Yq\0~t\0\0pq\0~(sq\0~\0q\0~(sq\0~\0\Z:zq\0~t\0route2pq\0~,sq\0~\0q\0~,sq\0~\0Vwaq\0~t\0tool2pt\0	Conditionsq\0~1\0q\0~sq\0~\0 q\0~t\0status===\'Rejected by Finance\'sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0HMq\0~t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0nq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0,ɑq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0HMq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Vq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0}q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0P2.q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0h\ZWq\0~t\0t_new_claim_tool4pq\0~\0sq\0~\0\0q\0~\0sq\0~\0!kDq\0~t\0\0pq\0~(sq\0~\0q\0~(sq\0~\0cq\0~t\0	new_claimpq\0~,sq\0~\0q\0~,sq\0~\0,q\0~t\0tool4pt\0	Conditionsq\0~1\0q\0~sq\0~\0`lpq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0ۥ7q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0Sq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0ks`q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0`vq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0aq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0QI}q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~	xsq\0~t\0\nTransitionsq\0~\0\'q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Ρq\0~t\0t_resubmit_approve_claimpq\0~\0sq\0~\0\0q\0~\0sq\0~\0o}%q\0~t\0\0pq\0~(sq\0~\0q\0~(sq\0~\0q\0~t\0resubmitpq\0~,sq\0~\0q\0~,sq\0~\0uq\0~t\0\rapprove_claimpt\0	Conditionsq\0~1\0q\0~,sq\0~\0bчq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0oX)q\0~-q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~1xt\0Descriptionsq\0~\02\0q\0~5sq\0~\0fq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~9sq\0~\0Yq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0|*q\0~:t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0mDsq\0~?t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0+/q\0~?t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~Dq\0~Gxxpxsq\0~\0E\0\0\0w\0\0\0q\0~ q\0~#q\0~&q\0~)q\0~-q\0~6q\0~:xsq\0~t\0\nTransitionsq\0~\0lxq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\nq\0~Lt\0transition11pq\0~\0sq\0~\0\0q\0~\0sq\0~\0\\q\0~Lt\0\0pq\0~(sq\0~\0q\0~(sq\0~\0@Zq\0~Lt\0tool4pq\0~,sq\0~\0q\0~,sq\0~\0	,q\0~Lt\0tool5pt\0	Conditionsq\0~1\0q\0~]sq\0~\0?Qq\0~Lt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0*q\0~^q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~bxt\0Descriptionsq\0~\02\0q\0~fsq\0~\0CYq\0~Lt\0\0t\0ExtendedAttributessq\0~\0\0q\0~jsq\0~\07mRq\0~Lt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0k҉q\0~kt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0lIq\0~pt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0nq\0~pt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~uq\0~xxsq\0~Gt\0ExtendedAttributesq\0~\0+b.q\0~kt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0T8Iq\0~|t\0JaWE_GRAPH_BREAK_POINTSpq\0~Psq\0~\0\0q\0~Psq\0~\0vq\0~|t\0\northogonalpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~Qq\0~Tq\0~Wq\0~Zq\0~^q\0~gq\0~kxsq\0~t\0\nTransitionsq\0~\0Fq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Nq\0~t\0transition12pq\0~\0sq\0~\0\0q\0~\0sq\0~\0:Akq\0~t\0\0pq\0~(sq\0~\0q\0~(sq\0~\0|I0|q\0~t\0tool5pq\0~,sq\0~\0q\0~,sq\0~\0\nq\0~t\0\rapprove_claimpt\0	Conditionsq\0~1\0q\0~sq\0~\0[Jwjq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0nfq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0wq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0F3\\q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0gCiMq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0fiq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0v;q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0\05q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0t͡q\0~t\0transition10pq\0~\0sq\0~\0\0q\0~\0sq\0~\08q\0~t\0\0pq\0~(sq\0~\0q\0~(sq\0~\0|@q\0~t\0route1pq\0~,sq\0~\0q\0~,sq\0~\0Z:q\0~t\0tool3pt\0	Conditionsq\0~1\0q\0~sq\0~\0q\0~t\0status===\'Resubmit\'sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0lmq\0~t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0/lq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0Gq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0PU7q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0ciq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\02\Z7q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\03q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0ndq\0~t\0transition13pq\0~\0sq\0~\0\0q\0~\0sq\0~\0#q\0~t\0\0pq\0~(sq\0~\0q\0~(sq\0~\0Moq\0~t\0tool3pq\0~,sq\0~\0q\0~,sq\0~\0aVq\0~t\0resubmitpt\0	Conditionsq\0~1\0q\0~sq\0~\0!V\'rq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0oFq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0PJq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~\nsq\0~\0^q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\05-q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0leq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0l{q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0Zhq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0mtq\0~t\0transition14pq\0~\0sq\0~\0\0q\0~\0sq\0~\07Ŧq\0~t\0approvedpq\0~(sq\0~\0q\0~(sq\0~\0E&q\0~t\0route1pq\0~,sq\0~\0q\0~,sq\0~\0rq\0~t\0tool6pt\0	Conditionsq\0~1\0q\0~.sq\0~\0y=q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0=q\0~/t\0	OTHERWISEsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~3xt\0Descriptionsq\0~\02\0q\0~8sq\0~\0.i|yq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~<sq\0~\04\0.q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0`Bq\0~=t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0vq\0~Bt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0|5q\0~Bt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~Gq\0~Jxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\"q\0~%q\0~(q\0~+q\0~/q\0~9q\0~=xsq\0~t\0\nTransitionsq\0~\0WYq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0,eLq\0~Ot\0transition15pq\0~\0sq\0~\0\0q\0~\0sq\0~\0cueHq\0~Ot\0\0pq\0~(sq\0~\0q\0~(sq\0~\0U3];q\0~Ot\0tool6pq\0~,sq\0~\0q\0~,sq\0~\06q\0~Ot\0verify_claimpt\0	Conditionsq\0~1\0q\0~`sq\0~\0^cq\0~Ot\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\07q\0~aq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~ext\0Descriptionsq\0~\02\0q\0~isq\0~\0aq\0~Ot\0\0t\0ExtendedAttributessq\0~\0\0q\0~msq\0~\0)Vq\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0=gq\0~nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0R\Zq\0~st\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0?Xq\0~st\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~xq\0~{xxpxsq\0~\0E\0\0\0w\0\0\0q\0~Tq\0~Wq\0~Zq\0~]q\0~aq\0~jq\0~nxsq\0~t\0\nTransitionsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0vq\0~t\0transition16pq\0~\0sq\0~\0\0q\0~\0sq\0~\0>42q\0~t\0\0pq\0~(sq\0~\0q\0~(sq\0~\0q\0~t\0route1pq\0~,sq\0~\0q\0~,sq\0~\0Cqq\0~t\0tool7pt\0	Conditionsq\0~1\0q\0~sq\0~\0&,q\0~t\0\Zstatus===\'Rejected by HOD\'sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0)2q\0~t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0^Sq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0Alq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0}ܱq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0rq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0lq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0.q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0(9q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0%JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDERpq\0~Psq\0~\0\0q\0~Psq\0~\0^Bq\0~t\0claimant;approver;financepxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~Gt\0ExtendedAttributesq\0~\00KEq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0dq\0~t\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~Psq\0~\0\0q\0~Psq\0~\0nlq\0~t\0JaWE_GRAPH_PARTICIPANT_ID=finance,CONNECTING_ACTIVITY_ID=tool2,X_OFFSET=758,Y_OFFSET=145,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~Gt\0ExtendedAttributesq\0~\0\"+q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0H%q\0~t\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~Psq\0~\0\0q\0~Psq\0~\0\\<q\0~t\0JaWE_GRAPH_PARTICIPANT_ID=finance,CONNECTING_ACTIVITY_ID=tool1,X_OFFSET=915,Y_OFFSET=57,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~Gt\0ExtendedAttributesq\0~\0aPq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0FXq\0~t\0JaWE_GRAPH_START_OF_WORKFLOWpq\0~Psq\0~\0\0q\0~Psq\0~\0Gq\0~t\0JaWE_GRAPH_PARTICIPANT_ID=claimant,CONNECTING_ACTIVITY_ID=new_claim,X_OFFSET=63,Y_OFFSET=53,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~Gt\0ExtendedAttributesq\0~\0{qq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0,q\0~t\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~Psq\0~\0\0q\0~Psq\0~\0.q\0~t\0JaWE_GRAPH_PARTICIPANT_ID=approver,CONNECTING_ACTIVITY_ID=tool7,X_OFFSET=865,Y_OFFSET=28,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~$q\0~*q\0~1q\0~8q\0~q\0~xxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0]q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0Gɏ.q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0ʀq\0~t\0EDITING_TOOLpq\0~Psq\0~\0\0q\0~Psq\0~\0{2Yq\0~t\0Web Workflow Designerpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~xsq\0~Gt\0ExtendedAttributesq\0~\0Rq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0YȩOq\0~t\0EDITING_TOOL_VERSIONpq\0~Psq\0~\0\0q\0~Psq\0~\0Q<q\0~t\0\r5.0-pre-alphapxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~\0q\0~\0q\0~\0q\0~\0Iq\0~\0tq\0~\0q\0~\0q\0~\0q\0~\0q\0~Eq\0~q\0~q\0~x\0sq\0~\0w\0\0\0\0xt\01sr\0*org.enhydra.shark.xpdl.elements.Namespaces|<.R\0\0xq\0~\0kt\0\nNamespacessq\0~\0qaq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.Namespacez_\0\0xq\0~\0t\0	Namespacesq\0~\0?;rq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0+/q\0~t\0xpdlpq\0~\0sq\0~\0q\0~\0sq\0~\0{q\0~t\0 http://www.wfmc.org/2002/XPDL1.0pxsq\0~\0E\0\0\0w\0\0\0q\0~#q\0~&xx',1000206,2,1000207,0),
('<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Package xmlns=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xpdl=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" Id=\"isr\" Name=\"Internal Service Request\" xsi:schemaLocation=\"http://www.wfmc.org/2002/XPDL1.0 http://wfmc.org/standards/docs/TC-1025_schema_10_xpdl.xsd\">\n    <PackageHeader>\n        <XPDLVersion>1.0</XPDLVersion>\n        <Vendor/>\n        <Created/>\n    </PackageHeader>\n    <Script Type=\"text/javascript\"/>\n    <Participants>\n        <Participant Id=\"requester\" Name=\"Requester\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n        <Participant Id=\"hod\" Name=\"HOD\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n        <Participant Id=\"assignee\" Name=\"Assignee\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n    </Participants>\n    <Applications>\n        <Application Id=\"default_application\"/>\n    </Applications>\n    <WorkflowProcesses>\n        <WorkflowProcess Id=\"isr\" Name=\"ISR Process\">\n            <ProcessHeader DurationUnit=\"h\"/>\n            <DataFields>\n                <DataField Id=\"status\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n                <DataField Id=\"attention\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n                <DataField Id=\"assignee\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n            </DataFields>\n            <Activities>\n                <Activity Id=\"resolve_request\" Name=\"Resolve Request\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>hod</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"hod\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"216,43.72727869677735\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"resolve_assigned_request\" Name=\"Resolve Request\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>assignee</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"assignee\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"568,21.51249999999999\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"send_rejected_notifiction\" Name=\"Send Rejected Notification\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"493,64.37500666308594\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"route1\" Name=\"Route 1\">\n                    <Route/>\n                    <Performer>hod</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Join Type=\"XOR\"/>\n                            <Split Type=\"XOR\">\n                                <TransitionRefs>\n                                    <TransitionRef Id=\"transition4\"/>\n                                    <TransitionRef Id=\"transition3\"/>\n                                    <TransitionRef Id=\"transition12\"/>\n                                </TransitionRefs>\n                            </Split>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"hod\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"392,49.72727869677735\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"verifiy_resolved_request\" Name=\"Verify Resolved Request\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Join Type=\"XOR\"/>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"834,27\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"route2\" Name=\"Route 2\">\n                    <Route/>\n                    <Performer>requester</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Split Type=\"XOR\">\n                                <TransitionRefs>\n                                    <TransitionRef Id=\"transition10\"/>\n                                    <TransitionRef Id=\"transition9\"/>\n                                </TransitionRefs>\n                            </Split>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"995,30.45453547167969\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"send_verified_notification\" Name=\"Send Verified Notification\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"963,132.3374816894531\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"resolve_reopened_request\" Name=\"Resolve Reopened Request\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>hod</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"hod\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"956,39.44319056201172\"/>\n                    </ExtendedAttributes>\n                </Activity>\n            </Activities>\n            <Transitions>\n                <Transition From=\"resolve_request\" Id=\"transition1\" To=\"route1\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition3\" To=\"send_rejected_notifiction\">\n                    <Condition Type=\"OTHERWISE\"/>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_BREAK_POINTS\" Value=\"orthogonal\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition4\" To=\"resolve_assigned_request\">\n                    <Condition Type=\"CONDITION\">status === \"Assigned\"</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_BREAK_POINTS\" Value=\"orthogonal\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"resolve_assigned_request\" Id=\"transition6\" To=\"verifiy_resolved_request\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_BREAK_POINTS\" Value=\"orthogonal\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"verifiy_resolved_request\" Id=\"transition8\" To=\"route2\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition9\" To=\"resolve_reopened_request\">\n                    <Condition Type=\"OTHERWISE\"/>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_BREAK_POINTS\" Value=\"orthogonal\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition10\" To=\"send_verified_notification\">\n                    <Condition Type=\"CONDITION\">status === \"Verified\"</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_BREAK_POINTS\" Value=\"orthogonal\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition12\" To=\"verifiy_resolved_request\">\n                    <Condition Type=\"CONDITION\">status === \"Resolved\"</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_BREAK_POINTS\" Value=\"orthogonal\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"resolve_reopened_request\" Id=\"transition13\" To=\"route1\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n            </Transitions>\n            <ExtendedAttributes>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER\" Value=\"hod;requester;assignee\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_START_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=resolve_request,X_OFFSET=257,Y_OFFSET=83,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=send_verified_notification,X_OFFSET=1156,Y_OFFSET=140,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=send_rejected_notifiction,X_OFFSET=671,Y_OFFSET=76,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n            </ExtendedAttributes>\n        </WorkflowProcess>\n    </WorkflowProcesses>\n    <ExtendedAttributes>\n        <ExtendedAttribute Name=\"EDITING_TOOL\" Value=\"Web Workflow Designer\"/>\n        <ExtendedAttribute Name=\"EDITING_TOOL_VERSION\" Value=\"5.0-pre-alpha\"/>\n    </ExtendedAttributes>\n</Package>\n','\0sr\0\'org.enhydra.shark.xpdl.elements.Package~+Vmŀ~\0Z\0isTransientL\0extPkgRefsToIdst\0.Lorg/enhydra/shark/utilities/SequencedHashMap;L\0internalVersiont\0Ljava/lang/String;L\0\nnamespacest\0,Lorg/enhydra/shark/xpdl/elements/Namespaces;xr\0(org.enhydra.shark.xpdl.XMLComplexElement>(\0\0xr\05org.enhydra.shark.xpdl.XMLBaseForCollectionAndComplex2\0L\0\nelementMapq\0~\0L\0elementst\0Ljava/util/ArrayList;xr\0!org.enhydra.shark.xpdl.XMLElement#+B#\0Z\0\nisReadOnlyZ\0\nisRequiredL\0nameq\0~\0L\0originalElementHashCodet\0Ljava/lang/Integer;L\0parentt\0#Lorg/enhydra/shark/xpdl/XMLElement;L\0valueq\0~\0xpt\0Packagesr\0java.lang.Integer⠤8\0I\0valuexr\0java.lang.Number\0\0xp8aUpt\0\0sr\0,org.enhydra.shark.utilities.SequencedHashMap.\"\"&\0\0xpw\0\0\0\rt\0Idsr\0#org.enhydra.shark.xpdl.XMLAttribute#c݀M;\0L\0choicesq\0~\0xq\0~\0q\0~\0sq\0~\0f	q\0~\0\nt\0isrpt\0Namesq\0~\0\0q\0~\0sq\0~\0I:.q\0~\0\nt\0Internal Service Requestpt\0\rPackageHeadersr\0-org.enhydra.shark.xpdl.elements.PackageHeaderv,\0\0xq\0~\0\0q\0~\0sq\0~\0lq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0XPDLVersionsr\0+org.enhydra.shark.xpdl.elements.XPDLVersion\"}Y.w\0\0xr\0\'org.enhydra.shark.xpdl.XMLSimpleElementm\0\0xq\0~\0q\0~\0!sq\0~\00: q\0~\0t\01.0t\0Vendorsr\0&org.enhydra.shark.xpdl.elements.Vendor tE:\0\0xq\0~\0#q\0~\0\'sq\0~\0zEAq\0~\0t\0\0t\0Createdsr\0\'org.enhydra.shark.xpdl.elements.CreatedzdK|[\0\0xq\0~\0#q\0~\0,sq\0~\0\nRq\0~\0t\0\0t\0Descriptionsr\0+org.enhydra.shark.xpdl.elements.Description۰738\0\0xq\0~\0#\0q\0~\01sq\0~\0iq\0~\0t\0\0t\0\rDocumentationsr\0-org.enhydra.shark.xpdl.elements.Documentation`9y\0\0xq\0~\0#\0q\0~\06sq\0~\0hq\0~\0t\0\0t\0PriorityUnitsr\0,org.enhydra.shark.xpdl.elements.PriorityUnit\0\0xq\0~\0#\0q\0~\0;sq\0~\0Xrq\0~\0t\0\0t\0CostUnitsr\0(org.enhydra.shark.xpdl.elements.CostUnit܎=H\0\0xq\0~\0#\0q\0~\0@sq\0~\0Hq\0~\0t\0\0xsr\0java.util.ArrayListxa\0I\0sizexp\0\0\0w\0\0\0q\0~\0$q\0~\0)q\0~\0.q\0~\03q\0~\08q\0~\0=q\0~\0Bxt\0RedefinableHeadersr\01org.enhydra.shark.xpdl.elements.RedefinableHeaderMϪ\'H\0\0xq\0~\0\0q\0~\0Gsq\0~\06Ͱq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0PublicationStatussq\0~\0\0q\0~\0Msq\0~\0{bdq\0~\0It\0\0sq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0UNDER_REVISIONt\0RELEASEDt\0\nUNDER_TESTxt\0Authorsr\0&org.enhydra.shark.xpdl.elements.Author5fᧆ\0\0xq\0~\0#\0q\0~\0Usq\0~\03q\0~\0It\0\0t\0Versionsr\0\'org.enhydra.shark.xpdl.elements.Version9=3~JQ\0\0xq\0~\0#\0q\0~\0Zsq\0~\0Dw0q\0~\0It\0\0t\0Codepagesr\0(org.enhydra.shark.xpdl.elements.Codepage9$me\rG\0\0xq\0~\0#\0q\0~\0_sq\0~\0݇q\0~\0It\0\0t\0\nCountrykeysr\0*org.enhydra.shark.xpdl.elements.Countrykey.\0\0xq\0~\0#\0q\0~\0dsq\0~\0q\0~\0It\0\0t\0Responsiblessr\0,org.enhydra.shark.xpdl.elements.Responsibles${S\0\0xr\0$org.enhydra.shark.xpdl.XMLCollectionjċm\0\0xq\0~\0\0q\0~\0isq\0~\08Rq\0~\0It\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0Nq\0~\0Wq\0~\0\\q\0~\0aq\0~\0fq\0~\0lxt\0ConformanceClasssr\00org.enhydra.shark.xpdl.elements.ConformanceClassy0|k\0\0xq\0~\0\0q\0~\0rsq\0~\0EPq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0GraphConformancesq\0~\0\0q\0~\0xsq\0~\0%^\0q\0~\0tq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0FULL_BLOCKEDt\0LOOP_BLOCKEDt\0NON_BLOCKEDxxsq\0~\0E\0\0\0w\0\0\0q\0~\0yxt\0Scriptsr\0&org.enhydra.shark.xpdl.elements.ScriptQjS8\0\0xq\0~\0\0q\0~\0sq\0~\0!+q\0~\0\nt\0\0sq\0~\0w\0\0\0t\0Typesq\0~\0q\0~\0sq\0~\0q\0~\0t\0text/javascriptpt\0Versionsq\0~\0\0q\0~\0sq\0~\01q\0~\0t\0\0pt\0Grammarsq\0~\0\0q\0~\0sq\0~\0G*Feq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExternalPackagessr\00org.enhydra.shark.xpdl.elements.ExternalPackagesw\"+Ũ\0\0xq\0~\0k\0q\0~\0sq\0~\0wq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0TypeDeclarationssr\00org.enhydra.shark.xpdl.elements.TypeDeclarations\rOx5\0\0xq\0~\0k\0q\0~\0sq\0~\00?Xq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Participantssr\0,org.enhydra.shark.xpdl.elements.Participantsh`g8J\0\0xq\0~\0k\0q\0~\0sq\0~\0P/Eq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Participanto$rc\0\0xr\0+org.enhydra.shark.xpdl.XMLCollectionElementCxvr\0\0xq\0~\0t\0Participantsq\0~\0WP*q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Ncq\0~\0t\0	requesterpq\0~\0sq\0~\0\0q\0~\0sq\0~\0\"kq\0~\0t\0	Requesterpt\0ParticipantTypesr\0/org.enhydra.shark.xpdl.elements.ParticipantType>n݅\0\0xq\0~\0q\0~\0sq\0~\0Dq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0UI\rq\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0t\0RESOURCE_SETt\0RESOURCEt\0ROLEt\0ORGANIZATIONAL_UNITt\0HUMANt\0SYSTEMxxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\0v<hq\0~\0t\0\0t\0ExternalReferencesr\01org.enhydra.shark.xpdl.elements.ExternalReferencebQ\0\0xq\0~\0\0q\0~\0sq\0~\0(fq\0~\0t\0\0sq\0~\0w\0\0\0t\0xrefsq\0~\0\0q\0~\0sq\0~\0 wq\0~\0t\0\0pt\0locationsq\0~\0q\0~\0sq\0~\0=q\0~\0t\0\0pt\0	namespacesq\0~\0\0q\0~\0sq\0~\0-!q\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExtendedAttributessr\02org.enhydra.shark.xpdl.elements.ExtendedAttributesOUF\0L\0extAttribsStringq\0~\0xq\0~\0k\0q\0~\0sq\0~\05.\0q\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xsq\0~\0t\0Participantsq\0~\0s(q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0jr/q\0~\0t\0hodpq\0~\0sq\0~\0\0q\0~\0sq\0~\0gq\0~\0t\0HODpt\0ParticipantTypesq\0~\0q\0~\0sq\0~\0,\Zq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0[2Aq\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\0aWeq\0~\0t\0\0t\0ExternalReferencesq\0~\0\0q\0~\0sq\0~\0+Eyq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\01q\0~\0t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0xyq\0~\0t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0\"\\\nVq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~	xt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0;Hq\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~xsq\0~\0t\0Participantsq\0~\0^B@\"q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0.F	xq\0~t\0assigneepq\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~t\0Assigneept\0ParticipantTypesq\0~\0q\0~sq\0~\0g8q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0v q\0~ t\0ROLEsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xxsq\0~\0E\0\0\0w\0\0\0q\0~$xt\0Descriptionsq\0~\02\0q\0~)sq\0~\0T\\q\0~t\0\0t\0ExternalReferencesq\0~\0\0q\0~-sq\0~\0?d\Zq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~.t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0 T)q\0~.t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0<oq\0~.t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~2q\0~5q\0~8xt\0ExtendedAttributessq\0~\0\0q\0~<sq\0~\0&NStq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~ q\0~*q\0~.q\0~=xxt\0Applicationssr\0,org.enhydra.shark.xpdl.elements.Applications\0\0xq\0~\0k\0q\0~Csq\0~\0EBYq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Applicationv	RS\0\0xq\0~\0t\0Applicationsq\0~\0i$q\0~Et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0T`q\0~Kt\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0SG/q\0~Kt\0\0pt\0Descriptionsq\0~\02\0q\0~Vsq\0~\0m%q\0~Kt\0\0t\0Choicesr\00org.enhydra.shark.xpdl.elements.ApplicationTypes?!\0\0xr\0\'org.enhydra.shark.xpdl.XMLComplexChoice|\"\0L\0choicesq\0~\0L\0choosenq\0~\0	xq\0~\0q\0~Zsq\0~\0&3q\0~Kt\0\0sq\0~\0E\0\0\0w\0\0\0sr\00org.enhydra.shark.xpdl.elements.FormalParameterspBÁZ\0\0xq\0~\0k\0t\0FormalParameterssq\0~\0tq\0~]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0\0t\0ExternalReferencesq\0~\0[I@q\0~]t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0gq\0~ht\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0hq\0~ht\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0%=q\0~ht\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~mq\0~pq\0~sxxq\0~bt\0ExtendedAttributessq\0~\0\0q\0~wsq\0~\01+q\0~Kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~Pq\0~Sq\0~Wq\0~]q\0~xxxt\0\nDataFieldssr\0*org.enhydra.shark.xpdl.elements.DataFieldsʦU\0\0xq\0~\0k\0q\0~~sq\0~\0e\"qq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0WorkflowProcessessr\01org.enhydra.shark.xpdl.elements.WorkflowProcessesp_0,\0\0xq\0~\0k\0q\0~sq\0~\0Hq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0/org.enhydra.shark.xpdl.elements.WorkflowProcess%v0L\0\0xq\0~\0t\0WorkflowProcesssq\0~\02wq\0~t\0\0sq\0~\0w\0\0\0\rq\0~\0sq\0~\0q\0~\0sq\0~\0\nq\0~t\0isrpq\0~\0sq\0~\0\0q\0~\0sq\0~\0 Lq\0~t\0ISR Processpt\0AccessLevelsq\0~\0\0q\0~sq\0~\0x:q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0PUBLICt\0PRIVATExt\0\rProcessHeadersr\0-org.enhydra.shark.xpdl.elements.ProcessHeaderLC-)\0\0xq\0~\0q\0~sq\0~\0\nEq\0~t\0\0sq\0~\0w\0\0\0t\0DurationUnitsq\0~\0\0q\0~sq\0~\0U^wq\0~t\0hsq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0Yt\0Mt\0Dt\0ht\0mt\0sxt\0Createdsq\0~\0-\0q\0~sq\0~\0V\Z<q\0~t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0Uq\0~t\0\0t\0Prioritysr\0(org.enhydra.shark.xpdl.elements.Priority`Nn>b\0\0xq\0~\0#\0q\0~sq\0~\0y)q\0~t\0\0t\0Limitsr\0%org.enhydra.shark.xpdl.elements.Limit1ӗ\0\0xq\0~\0#\0q\0~sq\0~\0XHq\0~t\0\0t\0	ValidFromsr\0)org.enhydra.shark.xpdl.elements.ValidFromcŅ|L<\0\0xq\0~\0#\0q\0~sq\0~\0_F#q\0~t\0\0t\0ValidTosr\0\'org.enhydra.shark.xpdl.elements.ValidToM\0\0xq\0~\0#\0q\0~sq\0~\0Bpq\0~t\0\0t\0TimeEstimationsr\0.org.enhydra.shark.xpdl.elements.TimeEstimationŀ\'3\0\0xq\0~\0\0q\0~sq\0~\0uQPq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesr\0+org.enhydra.shark.xpdl.elements.WaitingTimeN/\0\0xq\0~\0#\0q\0~sq\0~\0G|tq\0~t\0\0t\0WorkingTimesr\0+org.enhydra.shark.xpdl.elements.WorkingTime~\0\0xq\0~\0#\0q\0~sq\0~\0)Gq\0~t\0\0t\0Durationsr\0(org.enhydra.shark.xpdl.elements.Duration C\0\0xq\0~\0#\0q\0~sq\0~\0X+\0q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xt\0RedefinableHeadersq\0~\0H\0q\0~sq\0~\0Jq\0~t\0\0sq\0~\0w\0\0\0q\0~\0Msq\0~\0\0q\0~\0Msq\0~\05dq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~\0Rq\0~\0Sq\0~\0Txt\0Authorsq\0~\0V\0q\0~sq\0~\0Kjq\0~t\0\0t\0Versionsq\0~\0[\0q\0~sq\0~\0Kǋ<q\0~t\0\0t\0Codepagesq\0~\0`\0q\0~sq\0~\0|Vq\0~t\0\0t\0\nCountrykeysq\0~\0e\0q\0~sq\0~\0:q\0~t\0\0t\0Responsiblessq\0~\0j\0q\0~sq\0~\00^q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~xt\0FormalParameterssq\0~a\0q\0~sq\0~\0oYq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nDataFieldssq\0~\0q\0~sq\0~\0a4Sq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.DataFieldI3.~\0\0xq\0~\0t\0	DataFieldsq\0~\0{q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0:DDq\0~t\0statuspq\0~\0sq\0~\0\0q\0~\0sq\0~\0xyq\0~t\0\0pt\0IsArraysq\0~\0\0q\0~sq\0~\0`Yq\0~t\0FALSEsq\0~\0E\0\0\0w\0\0\0t\0TRUEt\0FALSExt\0DataTypesr\0(org.enhydra.shark.xpdl.elements.DataType\'4sM\0\0xq\0~\0q\0~ sq\0~\03Dq\0~t\0\0sq\0~\0w\0\0\0t\0	DataTypessr\0)org.enhydra.shark.xpdl.elements.DataTypespcH,!\0Z\0\risInitializedxq\0~\\q\0~&sq\0~\03ټ+q\0~\"t\0\0sq\0~\0E\0\0\0	w\0\0\0	sr\0)org.enhydra.shark.xpdl.elements.BasicType)w1\0\0xq\0~\0t\0	BasicTypesq\0~\0]#q\0~(t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0c!Qq\0~-t\0STRINGsq\0~\0E\0\0\0w\0\0\0t\0STRINGt\0FLOATt\0INTEGERt\0	REFERENCEt\0DATETIMEt\0BOOLEANt\0	PERFORMERxxsq\0~\0E\0\0\0w\0\0\0q\0~2xsr\0,org.enhydra.shark.xpdl.elements.DeclaredTypedR.\\^9\0\0xq\0~\0t\0DeclaredTypesq\0~\0f\0q\0~(t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~?t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Dxsr\0*org.enhydra.shark.xpdl.elements.SchemaType&1oSH\0\0xq\0~\0t\0\nSchemaTypesq\0~\0ZXq\0~(t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\05dҊq\0~(t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0C`>q\0~Ot\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0}j[q\0~Ot\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0cȝ\\q\0~Ot\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Tq\0~Wq\0~Zxsr\0*org.enhydra.shark.xpdl.elements.RecordType%K\0\0\0xq\0~\0kt\0\nRecordTypesq\0~\0p+-q\0~(t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.UnionType5PG\0\0xq\0~\0kt\0	UnionTypesq\0~\062Xq\0~(t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0/org.enhydra.shark.xpdl.elements.EnumerationTypef3b\0\0xq\0~\0kt\0EnumerationTypesq\0~\0-q\0~(t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.ArrayTypeg$\0N@\0\0xq\0~\0t\0	ArrayTypesq\0~\08Rq\0~(t\0\0sq\0~\0w\0\0\0t\0\nLowerIndexsq\0~\0q\0~ysq\0~\0q\0~tt\0\0pt\0\nUpperIndexsq\0~\0q\0~}sq\0~\0@zq\0~tt\0\0pq\0~&sq\0~\'q\0~&sq\0~\03q\0~tt\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~zq\0~~q\0~xsr\0(org.enhydra.shark.xpdl.elements.ListType\"ӟ\n\0\0xq\0~\0t\0ListTypesq\0~\0Mhq\0~(t\0\0sq\0~\0w\0\0\0q\0~&sq\0~\'q\0~&sq\0~\0uȌYq\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~-xsq\0~\0E\0\0\0w\0\0\0q\0~(xt\0InitialValuesr\0,org.enhydra.shark.xpdl.elements.InitialValuej,zR\0\0xq\0~\0#\0q\0~sq\0~\0V2_q\0~t\0\0t\0Lengthsr\0&org.enhydra.shark.xpdl.elements.LengthMW+-̩W\0\0xq\0~\0#\0q\0~sq\0~\0S9`(q\0~t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0	hq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\08Aq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~\Zq\0~\"q\0~q\0~q\0~q\0~xsq\0~\rt\0	DataFieldsq\0~\0hzq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0ETq\0~t\0	attentionpq\0~\0sq\0~\0\0q\0~\0sq\0~\0l^q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0Uq\0~t\0FALSEsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xt\0DataTypesq\0~!q\0~sq\0~\08q\0~t\0\0sq\0~\0w\0\0\0q\0~&sq\0~\'q\0~&sq\0~\0Iq\0~t\0\0sq\0~\0E\0\0\0	w\0\0\0	sq\0~,t\0	BasicTypesq\0~\0F:xq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0c	}q\0~t\0STRINGsq\0~\0E\0\0\0w\0\0\0q\0~6q\0~7q\0~8q\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~>t\0DeclaredTypesq\0~\0|q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0@Bq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~Ht\0\nSchemaTypesq\0~\0R!qq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0|q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0`~q\0~t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0n+l4q\0~t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0-1)q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~^t\0\nRecordTypesq\0~\0gE(q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~et\0	UnionTypesq\0~\0pqJq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~lt\0EnumerationTypesq\0~\0Eq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~st\0	ArrayTypesq\0~\0aMq\0~t\0\0sq\0~\0w\0\0\0q\0~ysq\0~\0q\0~ysq\0~\0.Mq\0~t\0\0pq\0~}sq\0~\0q\0~}sq\0~\0RVWq\0~t\0\0pq\0~&sq\0~\'q\0~&sq\0~\0g`Pq\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~t\0ListTypesq\0~\0qq\0~t\0\0sq\0~\0w\0\0\0q\0~&sq\0~\'q\0~&sq\0~\056q\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0InitialValuesq\0~\0q\0~sq\0~\0RX(q\0~t\0\0t\0Lengthsq\0~\0q\0~sq\0~\03˂q\0~t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0z7q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0hrq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~\rt\0	DataFieldsq\0~\0|>Aq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0gvq\0~#t\0assigneepq\0~\0sq\0~\0\0q\0~\0sq\0~\0ZϧWq\0~#t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0<\"q\0~#t\0FALSEsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xt\0DataTypesq\0~!q\0~2sq\0~\0:kXCq\0~#t\0\0sq\0~\0w\0\0\0q\0~&sq\0~\'q\0~&sq\0~\0\0q\0~3t\0\0sq\0~\0E\0\0\0	w\0\0\0	sq\0~,t\0	BasicTypesq\0~\0wtq\0~7t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0{Dq\0~;t\0STRINGsq\0~\0E\0\0\0w\0\0\0q\0~6q\0~7q\0~8q\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~@xsq\0~>t\0DeclaredTypesq\0~\0	q\0~7t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\01H@q\0~Et\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Jxsq\0~Ht\0\nSchemaTypesq\0~\0`jq\0~7t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0<Fq\0~7t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0O3q\0~Tt\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\09Omq\0~Tt\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0ôq\0~Tt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Yq\0~\\q\0~_xsq\0~^t\0\nRecordTypesq\0~\0SJ0q\0~7t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~et\0	UnionTypesq\0~\0\0cq\0~7t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~lt\0EnumerationTypesq\0~\0Gq\0~7t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~st\0	ArrayTypesq\0~\0Lq\0~7t\0\0sq\0~\0w\0\0\0q\0~ysq\0~\0q\0~ysq\0~\0O¦q\0~ut\0\0pq\0~}sq\0~\0q\0~}sq\0~\0T1q\0~ut\0\0pq\0~&sq\0~\'q\0~&sq\0~\0S/q\0~ut\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~zq\0~}q\0~xsq\0~t\0ListTypesq\0~\0JdXq\0~7t\0\0sq\0~\0w\0\0\0q\0~&sq\0~\'q\0~&sq\0~\0tq\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~;xsq\0~\0E\0\0\0w\0\0\0q\0~7xt\0InitialValuesq\0~\0q\0~sq\0~\0JWoq\0~#t\0\0t\0Lengthsq\0~\0q\0~sq\0~\0+q\0~#t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0oq\0~#t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0/$]q\0~#t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~(q\0~+q\0~.q\0~3q\0~q\0~q\0~q\0~xxt\0Participantssq\0~\0\0q\0~sq\0~\0Zhq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Applicationssq\0~D\0q\0~sq\0~\0B\"q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ActivitySetssr\0,org.enhydra.shark.xpdl.elements.ActivitySetsqV[4\0\0xq\0~\0k\0q\0~sq\0~\0b>q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nActivitiessr\0*org.enhydra.shark.xpdl.elements.Activities&G^lP\0\0xq\0~\0k\0q\0~sq\0~\0uq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0(org.enhydra.shark.xpdl.elements.Activityt45\Z9\0\0xq\0~\0t\0Activitysq\0~\0x}Mq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0IUaq\0~t\0resolve_requestpq\0~\0sq\0~\0\0q\0~\0sq\0~\0!pTq\0~t\0Resolve Requestpt\0Descriptionsq\0~\02\0q\0~sq\0~\0@S\\q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0Zq\0~t\0\0q\0~\0sr\0-org.enhydra.shark.xpdl.elements.ActivityTypeseŽ{\0\0xq\0~\\q\0~\0sq\0~\0AYq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0%org.enhydra.shark.xpdl.elements.Route0e\rG\0\0xq\0~\0t\0Routesq\0~\0`Oq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0.org.enhydra.shark.xpdl.elements.Implementationr^%\0\0xq\0~\0t\0Implementationsq\0~\0=q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sr\03org.enhydra.shark.xpdl.elements.ImplementationTypes\rT١9\0\0xq\0~\\q\0~\0sq\0~\0B;0Yq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0\"org.enhydra.shark.xpdl.elements.No{.\0\0xq\0~\0t\0Nosq\0~\0O	q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0%org.enhydra.shark.xpdl.elements.ToolsCg\0\0xq\0~\0k\0t\0Toolssq\0~\0=q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0\'org.enhydra.shark.xpdl.elements.SubFlow;Os7:$\0\0xq\0~\0t\0SubFlowsq\0~\06w_q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0-0$q\0~t\0\0pt\0	Executionsq\0~\0\0q\0~sq\0~\0/.q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ASYNCHRt\0SYNCHRxt\0ActualParameterssr\00org.enhydra.shark.xpdl.elements.ActualParameters_K\0\0xq\0~\0k\0q\0~sq\0~\0hq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsr\0-org.enhydra.shark.xpdl.elements.BlockActivityqcF\0\0xq\0~\0t\0\rBlockActivitysq\0~\0	Zq\0~t\0\0sq\0~\0w\0\0\0t\0BlockIdsq\0~\0q\0~sq\0~\0\\q\0~\rt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersr\0)org.enhydra.shark.xpdl.elements.Performer\"1%\0\0xq\0~\0#\0q\0~sq\0~\0-.Eq\0~t\0hodt\0	StartModesr\0)org.enhydra.shark.xpdl.elements.StartModenhS\0\0xq\0~\0\0q\0~sq\0~\0qq\0~t\0\0sq\0~\0w\0\0\0t\0Modesr\00org.enhydra.shark.xpdl.elements.StartFinishModes~6zX\'\0\0xq\0~\\\0q\0~\"sq\0~\0gFq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0,org.enhydra.shark.xpdl.XMLEmptyChoiceElement2;3_\0\0xq\0~\0\0t\0XMLEmptyChoiceElementsq\0~\0i qq\0~$t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.Automatict?_\0\0xq\0~\0t\0	Automaticsq\0~\0@q\0~$t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0&org.enhydra.shark.xpdl.elements.Manualv[ؤ\0\0xq\0~\0t\0Manualsq\0~\0qq\0~$t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~)xsq\0~\0E\0\0\0w\0\0\0q\0~$xt\0\nFinishModesr\0*org.enhydra.shark.xpdl.elements.FinishMode{\0\0xq\0~\0\0q\0~>sq\0~\0vY\"q\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0(q\0~@t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0 6q\0~Dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\08ʎq\0~Dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0ykڼq\0~Dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Hxsq\0~\0E\0\0\0w\0\0\0q\0~Dxt\0Prioritysq\0~\0q\0~[sq\0~\0fM3q\0~t\0\0t\0	Deadlinessr\0)org.enhydra.shark.xpdl.elements.Deadlines>ɜ\0\0xq\0~\0k\0q\0~_sq\0~\0;Eq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsr\05org.enhydra.shark.xpdl.elements.SimulationInformation\"|I\0\0xq\0~\0\0q\0~fsq\0~\0iq\0~t\0\0sq\0~\0w\0\0\0t\0\rInstantiationsq\0~\0\0q\0~lsq\0~\0NĆ;q\0~hq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ONCEt\0MULTIPLExt\0Costsr\0$org.enhydra.shark.xpdl.elements.Cost\0\0xq\0~\0#q\0~rsq\0~\0:q\0~ht\0\0t\0TimeEstimationsq\0~q\0~wsq\0~\0T\0q\0~ht\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~|sq\0~\0U +q\0~xt\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0?%q\0~xt\0\0t\0Durationsq\0~\0q\0~sq\0~\0Zhq\0~xt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~}q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~mq\0~tq\0~xxt\0Iconsr\0$org.enhydra.shark.xpdl.elements.IconTU(}6\0\0xq\0~\0#\0q\0~sq\0~\0\nq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0[/q\0~t\0\0t\0TransitionRestrictionssr\06org.enhydra.shark.xpdl.elements.TransitionRestrictionsC)׀i;\0\0xq\0~\0k\0q\0~sq\0~\0Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\01org.enhydra.shark.xpdl.elements.ExtendedAttribute\\F\0\0xq\0~\0t\0ExtendedAttributesq\0~\0WAwq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\08gHeq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpt\0Valuesq\0~\0\0q\0~sq\0~\00\0q\0~t\0hodpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\09Wq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0e^\'q\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0gq\0~t\0216,43.72727869677735pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~@q\0~\\q\0~aq\0~hq\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0SGq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\02wq\0~t\0resolve_assigned_requestpq\0~\0sq\0~\0\0q\0~\0sq\0~\0`uq\0~t\0Resolve Requestpt\0Descriptionsq\0~\02\0q\0~sq\0~\0\'4Jq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0P^q\0~t\0\0q\0~\0sq\0~q\0~\0sq\0~\0[wccq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0>?q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0\rٖq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0wlq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0uwq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0n q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0/q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0kgVq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0/nq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0Xq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0Rq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0/cq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~	sq\0~\0ucq\0~t\0assigneet\0	StartModesq\0~\0q\0~\rsq\0~\0Iq\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0APJq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0|`Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\03kcq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0D<q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~?\0q\0~)sq\0~\0pHEq\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0q\0~*t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0{5-q\0~.t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0tSq\0~.t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0q\0~.t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~2xsq\0~\0E\0\0\0w\0\0\0q\0~.xt\0Prioritysq\0~\0q\0~Esq\0~\0miJq\0~t\0\0t\0	Deadlinessq\0~`\0q\0~Isq\0~\0/q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~g\0q\0~Osq\0~\0Qq\0~t\0\0sq\0~\0w\0\0\0q\0~lsq\0~\0\0q\0~lsq\0~\0V(>q\0~Pq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~pq\0~qxt\0Costsq\0~sq\0~Wsq\0~\0u>:q\0~Pt\0\0t\0TimeEstimationsq\0~q\0~[sq\0~\0uϠFq\0~Pt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~`sq\0~\0bJq\0~\\t\0\0t\0WorkingTimesq\0~\0q\0~dsq\0~\0bq\0~\\t\0\0t\0Durationsq\0~\0q\0~hsq\0~\0~Dw5q\0~\\t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~aq\0~eq\0~ixxsq\0~\0E\0\0\0w\0\0\0q\0~Tq\0~Xq\0~\\xt\0Iconsq\0~\0q\0~nsq\0~\0v%+q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~rsq\0~\0{;Aq\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~vsq\0~\0\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~|sq\0~\0Mq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0$q\0~}t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0d)q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0`Uq\0~t\0assigneepxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0pKq\0~}t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0@i{q\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0mq\0~t\0568,21.51249999999999pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~\nq\0~q\0~*q\0~Fq\0~Jq\0~Pq\0~oq\0~sq\0~wq\0~}xsq\0~t\0Activitysq\0~\0#q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0iq\0~t\0send_rejected_notifictionpq\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~t\0\ZSend Rejected Notificationpt\0Descriptionsq\0~\02\0q\0~sq\0~\0\rq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0jIFq\0~t\0\0q\0~\0sq\0~q\0~\0sq\0~\0Gtq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0xOSq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0@q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0 rq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0Pq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0L5;q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0$org.enhydra.shark.xpdl.elements.Tool\\6&+G\0\0xq\0~\0t\0Toolsq\0~\02^q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0cһq\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0h	q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0APPLICATIONt\0	PROCEDURExt\0ActualParameterssq\0~\0q\0~sq\0~\0Ucq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0vrdq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0CӍq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~xxsq\0~t\0SubFlowsq\0~\0O.q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0L@q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0u^ݴq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0-Hq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0f(q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0f{q\0~t\0	requestert\0	StartModesq\0~\0q\0~sq\0~\0eSinq\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0bq\0~\rt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0d~q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0n\nRq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~?\0q\0~(sq\0~\0*q\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0J/Fq\0~)t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0#mq\0~-t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0* Sq\0~-t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0Xq\0~-t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~1xsq\0~\0E\0\0\0w\0\0\0q\0~-xt\0Prioritysq\0~\0q\0~Dsq\0~\0&Ńhq\0~t\0\0t\0	Deadlinessq\0~`\0q\0~Hsq\0~\0jq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~g\0q\0~Nsq\0~\0BVq\0~t\0\0sq\0~\0w\0\0\0q\0~lsq\0~\0\0q\0~lsq\0~\0~؇q\0~Oq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~pq\0~qxt\0Costsq\0~sq\0~Vsq\0~\0tq\0~Ot\0\0t\0TimeEstimationsq\0~q\0~Zsq\0~\0~q\0~Ot\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~_sq\0~\0\\Eq\0~[t\0\0t\0WorkingTimesq\0~\0q\0~csq\0~\0fNXq\0~[t\0\0t\0Durationsq\0~\0q\0~gsq\0~\0vnxq\0~[t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~`q\0~dq\0~hxxsq\0~\0E\0\0\0w\0\0\0q\0~Sq\0~Wq\0~[xt\0Iconsq\0~\0q\0~msq\0~\07gq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~qsq\0~\0qHq\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~usq\0~\0e4q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~{sq\0~\0cjq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0D5|q\0~|t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\07q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0Gq\0~t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0;rqq\0~|t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0^q\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0n(q\0~t\0493,64.37500666308594pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~	q\0~\rq\0~)q\0~Eq\0~Iq\0~Oq\0~nq\0~rq\0~vq\0~|xsq\0~t\0Activitysq\0~\0T0\rAq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\069q\0~t\0route1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0|zq\0~t\0Route 1pt\0Descriptionsq\0~\02\0q\0~sq\0~\0giq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0\r Hq\0~t\0\0q\0~\0sq\0~q\0~\0sq\0~\0Ll\rq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0Kx\Zq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0:]q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0m2q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0ם\nq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\06jq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0ff)q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0C|Ƿq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0Txq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0ŨPq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0P9Zq\0~t\0hodt\0	StartModesq\0~\0q\0~sq\0~\0u]nq\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0dbDgq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0<^q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0\r|Eoq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0lq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~?\0q\0~sq\0~\0\rq\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0Cq\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0!q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0WGwq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0Vq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0Prioritysq\0~\0q\0~$sq\0~\05b~\"q\0~t\0\0t\0	Deadlinessq\0~`\0q\0~(sq\0~\0tq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~g\0q\0~.sq\0~\0|bq\0~t\0\0sq\0~\0w\0\0\0q\0~lsq\0~\0\0q\0~lsq\0~\0`1-q\0~/q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~pq\0~qxt\0Costsq\0~sq\0~6sq\0~\0Fq\0~/t\0\0t\0TimeEstimationsq\0~q\0~:sq\0~\0 q\0~/t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~?sq\0~\0`q\0~;t\0\0t\0WorkingTimesq\0~\0q\0~Csq\0~\0	zq\0~;t\0\0t\0Durationsq\0~\0q\0~Gsq\0~\0iq q\0~;t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~@q\0~Dq\0~Hxxsq\0~\0E\0\0\0w\0\0\0q\0~3q\0~7q\0~;xt\0Iconsq\0~\0q\0~Msq\0~\0jq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~Qsq\0~\0]q\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~Usq\0~\0!pҳq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\05org.enhydra.shark.xpdl.elements.TransitionRestrictionN}\0\0xq\0~\0t\0TransitionRestrictionsq\0~\0x)rrq\0~Vt\0\0sq\0~\0w\0\0\0t\0Joinsr\0$org.enhydra.shark.xpdl.elements.Joinڕөx)5\0\0xq\0~\0\0q\0~asq\0~\0Sq\0~\\t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0/sq\0~ct\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ANDt\0XORxxsq\0~\0E\0\0\0w\0\0\0q\0~gxt\0Splitsr\0%org.enhydra.shark.xpdl.elements.Split~ѯWS\0\0xq\0~\0\0q\0~nsq\0~\0\0\0q\0~\\t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\03Hq\0~pt\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~kq\0~lxt\0TransitionRefssr\0.org.enhydra.shark.xpdl.elements.TransitionRefsъ\0\0xq\0~\0k\0q\0~xsq\0~\0}Q\0q\0~pt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0-org.enhydra.shark.xpdl.elements.TransitionRef%-a\0\0xq\0~\0t\0\rTransitionRefsq\0~\08פq\0~zt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0MtMq\0~t\0transition4pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rTransitionRefsq\0~\0\\\"0q\0~zt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0*vLBq\0~t\0transition3pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rTransitionRefsq\0~\0/gq\0~zt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0@utjq\0~t\0transition12pxsq\0~\0E\0\0\0w\0\0\0q\0~xxxsq\0~\0E\0\0\0w\0\0\0q\0~tq\0~zxxsq\0~\0E\0\0\0w\0\0\0q\0~cq\0~pxxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0+q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0gq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Dfq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0aq\0~t\0hodpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0F9q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0iq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0)WYq\0~t\0392,49.72727869677735pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~	q\0~%q\0~)q\0~/q\0~Nq\0~Rq\0~Vq\0~xsq\0~t\0Activitysq\0~\084q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Eֵkq\0~t\0verifiy_resolved_requestpq\0~\0sq\0~\0\0q\0~\0sq\0~\0>_yq\0~t\0Verify Resolved Requestpt\0Descriptionsq\0~\02\0q\0~sq\0~\0Aq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0q\0~t\0\0q\0~\0sq\0~q\0~\0sq\0~\0.Fq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0h4q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0\nq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0A8q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0Ni^q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0{q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0R!@q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0n4Yq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0Mq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\01(̟q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0r3q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~\nsq\0~\0]6*q\0~t\0	requestert\0	StartModesq\0~\0q\0~sq\0~\0Zc\rq\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0-؝q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0\0e\'q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\04^\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0D آq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~?\0q\0~*sq\0~\0AVGq\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0Z9\0q\0~+t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0naq\0~/t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0p61q\0~/t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0shq\0~/t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~3xsq\0~\0E\0\0\0w\0\0\0q\0~/xt\0Prioritysq\0~\0q\0~Fsq\0~\0z_*q\0~t\0\0t\0	Deadlinessq\0~`\0q\0~Jsq\0~\0W]q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~g\0q\0~Psq\0~\06q\0~t\0\0sq\0~\0w\0\0\0q\0~lsq\0~\0\0q\0~lsq\0~\08A*q\0~Qq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~pq\0~qxt\0Costsq\0~sq\0~Xsq\0~\0=ߨq\0~Qt\0\0t\0TimeEstimationsq\0~q\0~\\sq\0~\0Xq\0~Qt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~asq\0~\0JRq\0~]t\0\0t\0WorkingTimesq\0~\0q\0~esq\0~\0&kq\0~]t\0\0t\0Durationsq\0~\0q\0~isq\0~\0Sq\0~]t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~bq\0~fq\0~jxxsq\0~\0E\0\0\0w\0\0\0q\0~Uq\0~Yq\0~]xt\0Iconsq\0~\0q\0~osq\0~\06q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~ssq\0~\0GRD_q\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~wsq\0~\0|6q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~[t\0TransitionRestrictionsq\0~\00q\0~xt\0\0sq\0~\0w\0\0\0t\0Joinsq\0~b\0q\0~sq\0~\0F!%+q\0~}t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0F\0q\0~t\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~kq\0~lxxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Splitsq\0~o\0q\0~sq\0~\0q\0~}t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0QZq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~kq\0~lxt\0TransitionRefssq\0~y\0q\0~sq\0~\0C%q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0Ogq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\03q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\07q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0CKeq\0~t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0SP:q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0L>q\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0$+q\0~t\0834,27pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~+q\0~Gq\0~Kq\0~Qq\0~pq\0~tq\0~xq\0~xsq\0~t\0Activitysq\0~\0!6w&q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0ijiq\0~t\0route2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Hq\0~t\0Route 2pt\0Descriptionsq\0~\02\0q\0~sq\0~\0rk,q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0yxq\0~t\0\0q\0~\0sq\0~q\0~\0sq\0~\0Zq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0Yq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\04q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0qaq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0Heq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0lq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0L/7q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0rw8q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0M}Fq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0t9q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0J*bq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0^fq\0~	\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~	xxq\0~t\0	Performersq\0~\0q\0~		sq\0~\0\"^q\0~t\0	requestert\0	StartModesq\0~\0q\0~	\rsq\0~\0~q\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0\r.Zq\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0Pq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0|pbq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0&2q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	xsq\0~\0E\0\0\0w\0\0\0q\0~	xt\0\nFinishModesq\0~?\0q\0~	)sq\0~\0eeq\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0Yvq\0~	*t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0-71q\0~	.t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0yCQVq\0~	.t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0VKq\0~	.t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	2xsq\0~\0E\0\0\0w\0\0\0q\0~	.xt\0Prioritysq\0~\0q\0~	Esq\0~\0\\t^q\0~t\0\0t\0	Deadlinessq\0~`\0q\0~	Isq\0~\00q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~g\0q\0~	Osq\0~\0SUq\0~t\0\0sq\0~\0w\0\0\0q\0~lsq\0~\0\0q\0~lsq\0~\0rq\0~	Pq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~pq\0~qxt\0Costsq\0~sq\0~	Wsq\0~\0aq\0~	Pt\0\0t\0TimeEstimationsq\0~q\0~	[sq\0~\0Kq\0~	Pt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~	`sq\0~\0Sb)q\0~	\\t\0\0t\0WorkingTimesq\0~\0q\0~	dsq\0~\0Ygq\0~	\\t\0\0t\0Durationsq\0~\0q\0~	hsq\0~\0F=q\0~	\\t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~	aq\0~	eq\0~	ixxsq\0~\0E\0\0\0w\0\0\0q\0~	Tq\0~	Xq\0~	\\xt\0Iconsq\0~\0q\0~	nsq\0~\0g釆q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~	rsq\0~\0%q\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~	vsq\0~\0kHq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~[t\0TransitionRestrictionsq\0~\0\r6q\0~	wt\0\0sq\0~\0w\0\0\0t\0Joinsq\0~b\0q\0~	sq\0~\0`q\0~	|t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0?}\'q\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~kq\0~lxxsq\0~\0E\0\0\0w\0\0\0q\0~	xt\0Splitsq\0~o\0q\0~	sq\0~\0YК3q\0~	|t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0`q\0~	t\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~kq\0~lxt\0TransitionRefssq\0~y\0q\0~	sq\0~\08q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0\rTransitionRefsq\0~\0q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0_q\0~	t\0transition10pxsq\0~\0E\0\0\0w\0\0\0q\0~	xsq\0~t\0\rTransitionRefsq\0~\0L)q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0b\nuq\0~	t\0transition9pxsq\0~\0E\0\0\0w\0\0\0q\0~	xxxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xxt\0ExtendedAttributessq\0~\0\0q\0~	sq\0~\0B+q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0c]_q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0&q\0~	t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0Aq\0~	t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xsq\0~t\0ExtendedAttributesq\0~\0+q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0jEOq\0~	t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0LPq\0~	t\0995,30.45453547167969pxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~	\nq\0~	q\0~	*q\0~	Fq\0~	Jq\0~	Pq\0~	oq\0~	sq\0~	wq\0~	xsq\0~t\0Activitysq\0~\0 q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0n;q\0~	t\0\Zsend_verified_notificationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0|Wq\0~	t\0\ZSend Verified Notificationpt\0Descriptionsq\0~\02\0q\0~	sq\0~\0`q\0~	t\0\0t\0Limitsq\0~\0q\0~	sq\0~\0P9<lq\0~	t\0\0q\0~\0sq\0~q\0~\0sq\0~\0uq\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0h}q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0*q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\03q\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0\ru:q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0^90q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0+Tnq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0x q\0~	t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0*Vq\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~\n	sq\0~\0\n[q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~\nsq\0~\0mMq\0~	t\0\0t\0ExtendedAttributessq\0~\0\0q\0~\nsq\0~\0eVpq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\n\nq\0~\nq\0~\nxxsq\0~t\0SubFlowsq\0~\0Ӽq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0[\"q\0~\n\Zt\0\0pq\0~sq\0~\0\0q\0~sq\0~\0dq\0~\n\Zq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~\n%sq\0~\0hq\0~\n\Zt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\n\"q\0~\n&xxq\0~	xsq\0~\0E\0\0\0w\0\0\0q\0~	xsq\0~t\0\rBlockActivitysq\0~\0i8q\0~	t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0{Qq\0~\n-t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\n2xxq\0~	t\0	Performersq\0~\0q\0~\n6sq\0~\0pxq\0~	t\0	requestert\0	StartModesq\0~\0q\0~\n:sq\0~\08r2q\0~	t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0L\nsq\0~\n;t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\07Xq\0~\n?t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0Sf]Xq\0~\n?t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0ODq\0~\n?t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\nCxsq\0~\0E\0\0\0w\0\0\0q\0~\n?xt\0\nFinishModesq\0~?\0q\0~\nVsq\0~\0=\nq\0~	t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0Pjq\0~\nWt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0&$q\0~\n[t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0\\q\0~\n[t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0Y.q\0~\n[t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\n_xsq\0~\0E\0\0\0w\0\0\0q\0~\n[xt\0Prioritysq\0~\0q\0~\nrsq\0~\0;vSq\0~	t\0\0t\0	Deadlinessq\0~`\0q\0~\nvsq\0~\08q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~g\0q\0~\n|sq\0~\0Aq\0~	t\0\0sq\0~\0w\0\0\0q\0~lsq\0~\0\0q\0~lsq\0~\0<MPq\0~\n}q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~pq\0~qxt\0Costsq\0~sq\0~\nsq\0~\0]q\0~\n}t\0\0t\0TimeEstimationsq\0~q\0~\nsq\0~\0*q\0~\n}t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~\nsq\0~\0BΨAq\0~\nt\0\0t\0WorkingTimesq\0~\0q\0~\nsq\0~\00+q\0~\nt\0\0t\0Durationsq\0~\0q\0~\nsq\0~\01/Wq\0~\nt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nxxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nxt\0Iconsq\0~\0q\0~\nsq\0~\0{Uq\0~	t\0\0t\0\rDocumentationsq\0~\07\0q\0~\nsq\0~\0Ln;fq\0~	t\0\0t\0TransitionRestrictionssq\0~\0q\0~\nsq\0~\0-9mq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~\nsq\0~\0=\nq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0\\bdq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\nNq\0~\nt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0Jeq\0~\nt\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nxsq\0~t\0ExtendedAttributesq\0~\0aq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\00?q\0~\nt\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0@wq\0~\nt\0963,132.3374816894531pxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nxxpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	q\0~	q\0~	q\0~\n7q\0~\n;q\0~\nWq\0~\nsq\0~\nwq\0~\n}q\0~\nq\0~\nq\0~\nq\0~\nxsq\0~t\0Activitysq\0~\06mq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\08Qq\0~\nt\0resolve_reopened_requestpq\0~\0sq\0~\0\0q\0~\0sq\0~\0bBq\0~\nt\0Resolve Reopened Requestpt\0Descriptionsq\0~\02\0q\0~\nsq\0~\0+\nq\0~\nt\0\0t\0Limitsq\0~\0q\0~\nsq\0~\0Ulq\0~\nt\0\0q\0~\0sq\0~q\0~\0sq\0~\0*q\0~\nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0onq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0q\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0r5q\0~\nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0Xq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0Q	-q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0\Z.yq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0	a;q\0~\nt\0\0pq\0~sq\0~\0\0q\0~sq\0~\0yq\0~\nq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0pq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~q\0~xxq\0~\nxsq\0~\0E\0\0\0w\0\0\0q\0~\nxsq\0~t\0\rBlockActivitysq\0~\0c+q\0~\nt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0^nq\0~\rt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~\nt\0	Performersq\0~\0q\0~sq\0~\0|Yq\0~\nt\0hodt\0	StartModesq\0~\0q\0~\Zsq\0~\0Lq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0Ljq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0Jd{q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0Iq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0orsq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~#xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~?\0q\0~6sq\0~\0_.fq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\00Ęq\0~7t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0&FCq\0~;t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0Dsq\0~;t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0I~q\0~;t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~?xsq\0~\0E\0\0\0w\0\0\0q\0~;xt\0Prioritysq\0~\0q\0~Rsq\0~\0yq\0~\nt\0\0t\0	Deadlinessq\0~`\0q\0~Vsq\0~\0iUq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~g\0q\0~\\sq\0~\0Nq\0~\nt\0\0sq\0~\0w\0\0\0q\0~lsq\0~\0\0q\0~lsq\0~\0S;q\0~]q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~pq\0~qxt\0Costsq\0~sq\0~dsq\0~\0M0q\0~]t\0\0t\0TimeEstimationsq\0~q\0~hsq\0~\0# hq\0~]t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~msq\0~\0S%q\0~it\0\0t\0WorkingTimesq\0~\0q\0~qsq\0~\0]Tѿq\0~it\0\0t\0Durationsq\0~\0q\0~usq\0~\0!Ȋq\0~it\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~nq\0~rq\0~vxxsq\0~\0E\0\0\0w\0\0\0q\0~aq\0~eq\0~ixt\0Iconsq\0~\0q\0~{sq\0~\0/q\0~\nt\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0l{Dq\0~\nt\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0$Bq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0r)cq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0H4q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0=1Uq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0{pHq\0~t\0hodpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0G$\rq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\Zq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\08lDq\0~t\0956,39.44319056201172pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nq\0~\nq\0~\nq\0~q\0~q\0~7q\0~Sq\0~Wq\0~]q\0~|q\0~q\0~q\0~xxt\0Transitionssr\0+org.enhydra.shark.xpdl.elements.Transitions9>/i\0\0xq\0~\0k\0q\0~sq\0~\0ln3?q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0	w\0\0\0	sr\0*org.enhydra.shark.xpdl.elements.Transitiontx\0\0xq\0~\0t\0\nTransitionsq\0~\0~q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\04tq\0~t\0transition1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0j\rq\0~t\0\0pt\0Fromsq\0~\0q\0~sq\0~\0l6q\0~t\0resolve_requestpt\0Tosq\0~\0q\0~sq\0~\0&q\0~t\0route1pt\0	Conditionsr\0)org.enhydra.shark.xpdl.elements.ConditionDZ;|\0\0xq\0~\0\0q\0~sq\0~\0?}{q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0b|q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0	CONDITIONt\0	OTHERWISEt\0	EXCEPTIONt\0DEFAULTEXCEPTIONxxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0$l8q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0`q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0B/q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0:qq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0qIq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0$ALq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0oq\0~t\0transition3pq\0~\0sq\0~\0\0q\0~\0sq\0~\0tq\0~t\0\0pq\0~sq\0~\0q\0~sq\0~\0smhq\0~t\0route1pq\0~sq\0~\0q\0~sq\0~\0Mq\0~t\0send_rejected_notifictionpt\0	Conditionsq\0~\0q\0~sq\0~\0ZEq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0B/gq\0~t\0	OTHERWISEsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0;]q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0J\'[q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0cbq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\08xq\0~\rt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0\"\n\'q\0~\rt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0Aϲq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0m9$q\0~t\0JaWE_GRAPH_BREAK_POINTSpq\0~sq\0~\0\0q\0~sq\0~\0~q\0~t\0\northogonalpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~!xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0suAq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\niq\0~&t\0transition4pq\0~\0sq\0~\0\0q\0~\0sq\0~\0\rq\0~&t\0\0pq\0~sq\0~\0q\0~sq\0~\0Orq\0~&t\0route1pq\0~sq\0~\0q\0~sq\0~\0+:,q\0~&t\0resolve_assigned_requestpt\0	Conditionsq\0~\0q\0~7sq\0~\0-Nq\0~&t\0status === \"Assigned\"sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0	tq\0~8t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~<xt\0Descriptionsq\0~\02\0q\0~Asq\0~\0+=q\0~&t\0\0t\0ExtendedAttributessq\0~\0\0q\0~Esq\0~\0!@9Fq\0~&t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0X\"q\0~Ft\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0,q\0~Kt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0q\0~Kt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~Pq\0~Sxsq\0~t\0ExtendedAttributesq\0~\0X.q\0~Ft\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0da.q\0~Wt\0JaWE_GRAPH_BREAK_POINTSpq\0~sq\0~\0\0q\0~sq\0~\0\'}q\0~Wt\0\northogonalpxsq\0~\0E\0\0\0w\0\0\0q\0~\\q\0~_xxpxsq\0~\0E\0\0\0w\0\0\0q\0~+q\0~.q\0~1q\0~4q\0~8q\0~Bq\0~Fxsq\0~t\0\nTransitionsq\0~\0Z9q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Xv;Lq\0~dt\0transition6pq\0~\0sq\0~\0\0q\0~\0sq\0~\0>>q\0~dt\0\0pq\0~sq\0~\0q\0~sq\0~\0Nq\0~dt\0resolve_assigned_requestpq\0~sq\0~\0q\0~sq\0~\0o԰q\0~dt\0verifiy_resolved_requestpt\0	Conditionsq\0~\0q\0~usq\0~\0g7qq\0~dt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0&xRq\0~vq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~zxt\0Descriptionsq\0~\02\0q\0~~sq\0~\0l`!q\0~dt\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0]q\0~dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0^Uq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0jvq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0`+q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0aq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0&Oq\0~t\0JaWE_GRAPH_BREAK_POINTSpq\0~sq\0~\0\0q\0~sq\0~\0V,#q\0~t\0\northogonalpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~iq\0~lq\0~oq\0~rq\0~vq\0~q\0~xsq\0~t\0\nTransitionsq\0~\0gpq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0:@q\0~t\0transition8pq\0~\0sq\0~\0\0q\0~\0sq\0~\0iTq\0~t\0\0pq\0~sq\0~\0q\0~sq\0~\0uq\0~t\0verifiy_resolved_requestpq\0~sq\0~\0q\0~sq\0~\0fq\0~t\0route2pt\0	Conditionsq\0~\0q\0~sq\0~\0i&q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0LGnq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0/24q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0l4~q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0$ԫq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0)@q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0[Cq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\09&+q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0#kq\0~t\0transition9pq\0~\0sq\0~\0\0q\0~\0sq\0~\0mEq\0~t\0\0pq\0~sq\0~\0q\0~sq\0~\0:q\0~t\0route2pq\0~sq\0~\0q\0~sq\0~\0*q\0~t\0resolve_reopened_requestpt\0	Conditionsq\0~\0q\0~sq\0~\0#n5q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\08ZFq\0~t\0	OTHERWISEsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0^iq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0N̂q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0yq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\00	q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0:hq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0@0;q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0]Wq\0~\rt\0JaWE_GRAPH_BREAK_POINTSpq\0~sq\0~\0\0q\0~sq\0~\0q\0~\rt\0\northogonalpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0`v\nq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0}q\0~\rt\0transition10pq\0~\0sq\0~\0\0q\0~\0sq\0~\0cJq\0~\rt\0\0pq\0~sq\0~\0q\0~sq\0~\0igq\0~\rt\0route2pq\0~sq\0~\0q\0~sq\0~\0\n1]q\0~\rt\0\Zsend_verified_notificationpt\0	Conditionsq\0~\0q\0~\r!sq\0~\04q\0~\rt\0status === \"Verified\"sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0fHdq\0~\r\"t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\r&xt\0Descriptionsq\0~\02\0q\0~\r+sq\0~\0fzCq\0~\rt\0\0t\0ExtendedAttributessq\0~\0\0q\0~\r/sq\0~\0U\0Uq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0wbq\0~\r0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0:]=fq\0~\r5t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0oVWq\0~\r5t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~\r:q\0~\r=xsq\0~t\0ExtendedAttributesq\0~\0#q\0~\r0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\07Eq\0~\rAt\0JaWE_GRAPH_BREAK_POINTSpq\0~sq\0~\0\0q\0~sq\0~\0dq\0~\rAt\0\northogonalpxsq\0~\0E\0\0\0w\0\0\0q\0~\rFq\0~\rIxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rq\0~\rq\0~\rq\0~\r\"q\0~\r,q\0~\r0xsq\0~t\0\nTransitionsq\0~\0aUq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0on< q\0~\rNt\0transition12pq\0~\0sq\0~\0\0q\0~\0sq\0~\00q\0~\rNt\0\0pq\0~sq\0~\0q\0~sq\0~\0Neq\0~\rNt\0route1pq\0~sq\0~\0q\0~sq\0~\039q\0~\rNt\0verifiy_resolved_requestpt\0	Conditionsq\0~\0q\0~\r_sq\0~\0cZXq\0~\rNt\0status === \"Resolved\"sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~\r`t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\rdxt\0Descriptionsq\0~\02\0q\0~\risq\0~\0~p0q\0~\rNt\0\0t\0ExtendedAttributessq\0~\0\0q\0~\rmsq\0~\0ZK.8q\0~\rNt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0Dq\0~\rnt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Eq\0~\rst\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\00,Eq\0~\rst\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~\rxq\0~\r{xsq\0~t\0ExtendedAttributesq\0~\04q\0~\rnt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0#Jq\0~\rt\0JaWE_GRAPH_BREAK_POINTSpq\0~sq\0~\0\0q\0~sq\0~\0;\\q\0~\rt\0\northogonalpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\rSq\0~\rVq\0~\rYq\0~\r\\q\0~\r`q\0~\rjq\0~\rnxsq\0~t\0\nTransitionsq\0~\0ZU3q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~\rt\0transition13pq\0~\0sq\0~\0\0q\0~\0sq\0~\0|ݭuq\0~\rt\0\0pq\0~sq\0~\0q\0~sq\0~\0Wᄠq\0~\rt\0resolve_reopened_requestpq\0~sq\0~\0q\0~sq\0~\0!q\0~\rt\0route1pt\0	Conditionsq\0~\0q\0~\rsq\0~\0q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Tzq\0~\rq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0Descriptionsq\0~\02\0q\0~\rsq\0~\0*4q\0~\rt\0\0t\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0;9q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0SAнq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\04бq\0~\rt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0C\nq\0~\rt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rxxt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\09֢ q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0Sq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0N\Z/q\0~\rt\0%JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDERpq\0~sq\0~\0\0q\0~sq\0~\0A{\rq\0~\rt\0hod;requester;assigneepxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxsq\0~t\0ExtendedAttributesq\0~\0ė4q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\04^Zq\0~\rt\0JaWE_GRAPH_START_OF_WORKFLOWpq\0~sq\0~\0\0q\0~sq\0~\0+\nq\0~\rt\0JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=resolve_request,X_OFFSET=257,Y_OFFSET=83,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxsq\0~t\0ExtendedAttributesq\0~\07*q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0|@Pq\0~\rt\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~sq\0~\0\0q\0~sq\0~\0Zzq\0~\rt\0JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=send_verified_notification,X_OFFSET=1156,Y_OFFSET=140,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxsq\0~t\0ExtendedAttributesq\0~\0_i#q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\08A[q\0~\rt\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~sq\0~\0\0q\0~sq\0~\0FAnq\0~\rt\0JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=send_rejected_notifiction,X_OFFSET=671,Y_OFFSET=76,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~\rxxt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0Ijq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0z\'~q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Rˣq\0~\rt\0EDITING_TOOLpq\0~sq\0~\0\0q\0~sq\0~\0V@q\0~\rt\0Web Workflow Designerpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~xsq\0~t\0ExtendedAttributesq\0~\0Sq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Aq\0~t\0EDITING_TOOL_VERSIONpq\0~sq\0~\0\0q\0~sq\0~\0[q\0~t\0\r5.0-pre-alphapxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~\0q\0~\0q\0~\0q\0~\0Iq\0~\0tq\0~\0q\0~\0q\0~\0q\0~\0q\0~Eq\0~q\0~q\0~\rx\0sq\0~\0w\0\0\0\0xt\01sr\0*org.enhydra.shark.xpdl.elements.Namespaces|<.R\0\0xq\0~\0kt\0\nNamespacessq\0~\0>!Sq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.Namespacez_\0\0xq\0~\0t\0	Namespacesq\0~\0_q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0cq\0~t\0xpdlpq\0~\0sq\0~\0q\0~\0sq\0~\0	˭q\0~t\0 http://www.wfmc.org/2002/XPDL1.0pxsq\0~\0E\0\0\0w\0\0\0q\0~\"q\0~%xx',1000210,3,1000211,0),
('<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Package xmlns=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xpdl=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" Id=\"JogetDxShowcase\" Name=\"Joget DX Showcase\" xsi:schemaLocation=\"http://www.wfmc.org/2002/XPDL1.0 http://wfmc.org/standards/docs/TC-1025_schema_10_xpdl.xsd\">\n    <PackageHeader>\n        <XPDLVersion>1.0</XPDLVersion>\n        <Vendor/>\n        <Created/>\n    </PackageHeader>\n    <Script Type=\"text/javascript\"/>\n    <Participants>\n        <Participant Id=\"requester\" Name=\"requester\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n        <Participant Id=\"approver1\" Name=\"approver1\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n        <Participant Id=\"approver2\" Name=\"approver2\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n        <Participant Id=\"participant4\" Name=\"Participant 4\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n    </Participants>\n    <Applications>\n        <Application Id=\"default_application\"/>\n    </Applications>\n    <WorkflowProcesses>\n        <WorkflowProcess Id=\"process1\" Name=\"Process 1\">\n            <ProcessHeader DurationUnit=\"h\"/>\n            <DataFields>\n                <DataField Id=\"approvalStatus1\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n                <DataField Id=\"approvalStatus2\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n                <DataField Id=\"approverUsername1\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n                <DataField Id=\"approverUsername2\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n            </DataFields>\n            <Activities>\n                <Activity Id=\"route1\">\n                    <Route/>\n                    <Performer>requester</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Join Type=\"XOR\"/>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"540,60\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"route2\">\n                    <Route/>\n                    <Performer>approver1</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Split Type=\"XOR\">\n                                <TransitionRefs>\n                                    <TransitionRef Id=\"transition4\"/>\n                                    <TransitionRef Id=\"transition8\"/>\n                                    <TransitionRef Id=\"transition15\"/>\n                                </TransitionRefs>\n                            </Split>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver1\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"720,280\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"route3\">\n                    <Route/>\n                    <Performer>approver2</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Split Type=\"XOR\">\n                                <TransitionRefs>\n                                    <TransitionRef Id=\"transition11\"/>\n                                    <TransitionRef Id=\"transition12\"/>\n                                </TransitionRefs>\n                            </Split>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver2\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"1080,500\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"email2\" Name=\"Email Notify Requester Resubmit\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Join Type=\"XOR\"/>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"1080,60\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"email3\" Name=\"Email Notify Approver2\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver2</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver2\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"720,500\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"email1\" Name=\"Email Notify Approver1\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"360,60\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"approver1\" Name=\"Pending Approver 1\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>approver1</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver1\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"540,280\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"approver2\" Name=\"Pending Approver 2\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>approver2</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver2\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"900,500\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"email4\" Name=\"Email Notify Requester Complete\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver2</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver2\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"1260,500\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"resubmit\" Name=\"Requester to Resubmit\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"900,60\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool5\" Name=\"Update Approver 2 Status\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver1</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver1\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"1440,280\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool6\" Name=\"Email Notify Requester Rejected\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver1</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver1\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"1620,280\"/>\n                    </ExtendedAttributes>\n                </Activity>\n            </Activities>\n            <Transitions>\n                <Transition From=\"email1\" Id=\"transition1\" To=\"route1\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"approver1\" Id=\"transition3\" To=\"route2\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition4\" To=\"email2\">\n                    <Condition Type=\"CONDITION\">approvalStatus1 === \'Resubmit\'</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"PBUILDER_TRANSITION_CONDITIONS\" Value=\"[{&quot;join&quot;:&quot;&amp;&amp;&quot;,&quot;variable&quot;:&quot;approvalStatus1&quot;,&quot;operator&quot;:&quot;===&quot;,&quot;value&quot;:&quot;Resubmit&quot;}]\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"email2\" Id=\"transition5\" To=\"resubmit\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"resubmit\" Id=\"transition7\" To=\"route1\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition8\" To=\"email3\">\n                    <Condition Type=\"OTHERWISE\"/>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"email3\" Id=\"transition9\" To=\"approver2\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"approver2\" Id=\"transition10\" To=\"route3\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition13\" To=\"approver1\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route3\" Id=\"transition11\" To=\"email2\">\n                    <Condition Type=\"CONDITION\">approvalStatus2 === \'Resubmit\'</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"PBUILDER_TRANSITION_CONDITIONS\" Value=\"[{&quot;join&quot;:&quot;&amp;&amp;&quot;,&quot;variable&quot;:&quot;approvalStatus2&quot;,&quot;operator&quot;:&quot;===&quot;,&quot;value&quot;:&quot;Resubmit&quot;}]\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route3\" Id=\"transition12\" To=\"email4\">\n                    <Condition Type=\"OTHERWISE\"/>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition15\" To=\"tool5\">\n                    <Condition Type=\"CONDITION\">approvalStatus1 === \'Rejected\'</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"PBUILDER_TRANSITION_CONDITIONS\" Value=\"[{&quot;join&quot;:&quot;&amp;&amp;&quot;,&quot;variable&quot;:&quot;approvalStatus1&quot;,&quot;operator&quot;:&quot;===&quot;,&quot;value&quot;:&quot;Rejected&quot;}]\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool5\" Id=\"transition16\" To=\"tool6\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n            </Transitions>\n            <ExtendedAttributes>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER\" Value=\"requester;approver1;approver2\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_START_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=email1,X_OFFSET=180,Y_OFFSET=60,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=approver2,CONNECTING_ACTIVITY_ID=email4,X_OFFSET=1440,Y_OFFSET=500,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=approver1,CONNECTING_ACTIVITY_ID=tool6,X_OFFSET=1800,Y_OFFSET=280,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n                <ExtendedAttribute Name=\"Auto_Layout\" Value=\"true\"/>\n            </ExtendedAttributes>\n        </WorkflowProcess>\n        <WorkflowProcess Id=\"populateChart2\" Name=\"Populate Data For Charts\">\n            <ProcessHeader DurationUnit=\"h\"/>\n            <Activities>\n                <Activity Id=\"tool2\" Name=\"Populate Stock Data Tables\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>participant4</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"participant4\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"540,280\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"populateDataChart2\" Name=\"Populate Standard Data Tables\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>participant4</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"participant4\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"360,280\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"populateMeetingData\" Name=\"Populate Meeting Data\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>participant4</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"participant4\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"720,280\"/>\n                    </ExtendedAttributes>\n                </Activity>\n            </Activities>\n            <Transitions>\n                <Transition From=\"populateDataChart2\" Id=\"transition1\" To=\"tool2\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool2\" Id=\"transition2\" To=\"populateMeetingData\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n            </Transitions>\n            <ExtendedAttributes>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER\" Value=\"participant4\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_START_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=participant4,CONNECTING_ACTIVITY_ID=populateDataChart2,X_OFFSET=180,Y_OFFSET=280,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=participant4,CONNECTING_ACTIVITY_ID=populateMeetingData,X_OFFSET=900,Y_OFFSET=280,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n                <ExtendedAttribute Name=\"Auto_Layout\" Value=\"true\"/>\n            </ExtendedAttributes>\n        </WorkflowProcess>\n    </WorkflowProcesses>\n    <ExtendedAttributes>\n        <ExtendedAttribute Name=\"EDITING_TOOL\" Value=\"Web Workflow Designer\"/>\n        <ExtendedAttribute Name=\"EDITING_TOOL_VERSION\" Value=\"5.0-pre-alpha\"/>\n    </ExtendedAttributes>\n</Package>\n','\0sr\0\'org.enhydra.shark.xpdl.elements.Package~+Vmŀ~\0Z\0isTransientL\0extPkgRefsToIdst\0.Lorg/enhydra/shark/utilities/SequencedHashMap;L\0internalVersiont\0Ljava/lang/String;L\0\nnamespacest\0,Lorg/enhydra/shark/xpdl/elements/Namespaces;xr\0(org.enhydra.shark.xpdl.XMLComplexElement>(\0\0xr\05org.enhydra.shark.xpdl.XMLBaseForCollectionAndComplex2\0L\0\nelementMapq\0~\0L\0elementst\0Ljava/util/ArrayList;xr\0!org.enhydra.shark.xpdl.XMLElement#+B#\0Z\0\nisReadOnlyZ\0\nisRequiredL\0nameq\0~\0L\0originalElementHashCodet\0Ljava/lang/Integer;L\0parentt\0#Lorg/enhydra/shark/xpdl/XMLElement;L\0valueq\0~\0xpt\0Packagesr\0java.lang.Integer⠤8\0I\0valuexr\0java.lang.Number\0\0xp pt\0\0sr\0,org.enhydra.shark.utilities.SequencedHashMap.\"\"&\0\0xpw\0\0\0\rt\0Idsr\0#org.enhydra.shark.xpdl.XMLAttribute#c݀M;\0L\0choicesq\0~\0xq\0~\0q\0~\0sq\0~\0#\0q\0~\0\nt\0JogetDxShowcasept\0Namesq\0~\0\0q\0~\0sq\0~\0;Mq\0~\0\nt\0Joget DX Showcasept\0\rPackageHeadersr\0-org.enhydra.shark.xpdl.elements.PackageHeaderv,\0\0xq\0~\0\0q\0~\0sq\0~\0\rqpq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0XPDLVersionsr\0+org.enhydra.shark.xpdl.elements.XPDLVersion\"}Y.w\0\0xr\0\'org.enhydra.shark.xpdl.XMLSimpleElementm\0\0xq\0~\0q\0~\0!sq\0~\09;ߊq\0~\0t\01.0t\0Vendorsr\0&org.enhydra.shark.xpdl.elements.Vendor tE:\0\0xq\0~\0#q\0~\0\'sq\0~\03j,q\0~\0t\0\0t\0Createdsr\0\'org.enhydra.shark.xpdl.elements.CreatedzdK|[\0\0xq\0~\0#q\0~\0,sq\0~\0e4~q\0~\0t\0\0t\0Descriptionsr\0+org.enhydra.shark.xpdl.elements.Description۰738\0\0xq\0~\0#\0q\0~\01sq\0~\0g<kq\0~\0t\0\0t\0\rDocumentationsr\0-org.enhydra.shark.xpdl.elements.Documentation`9y\0\0xq\0~\0#\0q\0~\06sq\0~\0\0?%q\0~\0t\0\0t\0PriorityUnitsr\0,org.enhydra.shark.xpdl.elements.PriorityUnit\0\0xq\0~\0#\0q\0~\0;sq\0~\0bt	q\0~\0t\0\0t\0CostUnitsr\0(org.enhydra.shark.xpdl.elements.CostUnit܎=H\0\0xq\0~\0#\0q\0~\0@sq\0~\0\'@q\0~\0t\0\0xsr\0java.util.ArrayListxa\0I\0sizexp\0\0\0w\0\0\0q\0~\0$q\0~\0)q\0~\0.q\0~\03q\0~\08q\0~\0=q\0~\0Bxt\0RedefinableHeadersr\01org.enhydra.shark.xpdl.elements.RedefinableHeaderMϪ\'H\0\0xq\0~\0\0q\0~\0Gsq\0~\0#uq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0PublicationStatussq\0~\0\0q\0~\0Msq\0~\0Bq\0~\0It\0\0sq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0UNDER_REVISIONt\0RELEASEDt\0\nUNDER_TESTxt\0Authorsr\0&org.enhydra.shark.xpdl.elements.Author5fᧆ\0\0xq\0~\0#\0q\0~\0Usq\0~\0\0\nnoq\0~\0It\0\0t\0Versionsr\0\'org.enhydra.shark.xpdl.elements.Version9=3~JQ\0\0xq\0~\0#\0q\0~\0Zsq\0~\0q\0~\0It\0\0t\0Codepagesr\0(org.enhydra.shark.xpdl.elements.Codepage9$me\rG\0\0xq\0~\0#\0q\0~\0_sq\0~\05q\0~\0It\0\0t\0\nCountrykeysr\0*org.enhydra.shark.xpdl.elements.Countrykey.\0\0xq\0~\0#\0q\0~\0dsq\0~\0Sqq\0~\0It\0\0t\0Responsiblessr\0,org.enhydra.shark.xpdl.elements.Responsibles${S\0\0xr\0$org.enhydra.shark.xpdl.XMLCollectionjċm\0\0xq\0~\0\0q\0~\0isq\0~\0\0Ugq\0~\0It\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0Nq\0~\0Wq\0~\0\\q\0~\0aq\0~\0fq\0~\0lxt\0ConformanceClasssr\00org.enhydra.shark.xpdl.elements.ConformanceClassy0|k\0\0xq\0~\0\0q\0~\0rsq\0~\0jŋq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0GraphConformancesq\0~\0\0q\0~\0xsq\0~\0J2q\0~\0tq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0FULL_BLOCKEDt\0LOOP_BLOCKEDt\0NON_BLOCKEDxxsq\0~\0E\0\0\0w\0\0\0q\0~\0yxt\0Scriptsr\0&org.enhydra.shark.xpdl.elements.ScriptQjS8\0\0xq\0~\0\0q\0~\0sq\0~\0g3q\0~\0\nt\0\0sq\0~\0w\0\0\0t\0Typesq\0~\0q\0~\0sq\0~\0J0q\0~\0t\0text/javascriptpt\0Versionsq\0~\0\0q\0~\0sq\0~\0ot6q\0~\0t\0\0pt\0Grammarsq\0~\0\0q\0~\0sq\0~\0V*Wq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExternalPackagessr\00org.enhydra.shark.xpdl.elements.ExternalPackagesw\"+Ũ\0\0xq\0~\0k\0q\0~\0sq\0~\0.w\nq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0TypeDeclarationssr\00org.enhydra.shark.xpdl.elements.TypeDeclarations\rOx5\0\0xq\0~\0k\0q\0~\0sq\0~\0b5q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Participantssr\0,org.enhydra.shark.xpdl.elements.Participantsh`g8J\0\0xq\0~\0k\0q\0~\0sq\0~\0q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Participanto$rc\0\0xr\0+org.enhydra.shark.xpdl.XMLCollectionElementCxvr\0\0xq\0~\0t\0Participantsq\0~\0Rq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~\0t\0	requesterpq\0~\0sq\0~\0\0q\0~\0sq\0~\0F>q\0~\0t\0	requesterpt\0ParticipantTypesr\0/org.enhydra.shark.xpdl.elements.ParticipantType>n݅\0\0xq\0~\0q\0~\0sq\0~\0.BUq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\03dq\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0t\0RESOURCE_SETt\0RESOURCEt\0ROLEt\0ORGANIZATIONAL_UNITt\0HUMANt\0SYSTEMxxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\0\nq\0~\0t\0\0t\0ExternalReferencesr\01org.enhydra.shark.xpdl.elements.ExternalReferencebQ\0\0xq\0~\0\0q\0~\0sq\0~\0Nѽq\0~\0t\0\0sq\0~\0w\0\0\0t\0xrefsq\0~\0\0q\0~\0sq\0~\0tjIq\0~\0t\0\0pt\0locationsq\0~\0q\0~\0sq\0~\0	dMq\0~\0t\0\0pt\0	namespacesq\0~\0\0q\0~\0sq\0~\0pAq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExtendedAttributessr\02org.enhydra.shark.xpdl.elements.ExtendedAttributesOUF\0L\0extAttribsStringq\0~\0xq\0~\0k\0q\0~\0sq\0~\03q\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xsq\0~\0t\0Participantsq\0~\05NAq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\02²q\0~\0t\0	approver1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Wq\0~\0t\0	approver1pt\0ParticipantTypesq\0~\0q\0~\0sq\0~\0q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Oq\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\0\0q\0~\0t\0\0t\0ExternalReferencesq\0~\0\0q\0~\0sq\0~\0K]q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0cEq\0~\0t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0Yq\0~\0t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0TXq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~	xt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0}zaq\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~xsq\0~\0t\0Participantsq\0~\0MӮq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\rnq\0~t\0	approver2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0;Bq\0~t\0	approver2pt\0ParticipantTypesq\0~\0q\0~sq\0~\0%q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\00q\0~ t\0ROLEsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xxsq\0~\0E\0\0\0w\0\0\0q\0~$xt\0Descriptionsq\0~\02\0q\0~)sq\0~\07q\0~t\0\0t\0ExternalReferencesq\0~\0\0q\0~-sq\0~\0 q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~.t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0Lq\0~.t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0+*oq\0~.t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~2q\0~5q\0~8xt\0ExtendedAttributessq\0~\0\0q\0~<sq\0~\0!q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~ q\0~*q\0~.q\0~=xsq\0~\0t\0Participantsq\0~\0h!q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Lq\0~Ct\0participant4pq\0~\0sq\0~\0\0q\0~\0sq\0~\0R\n]q\0~Ct\0\rParticipant 4pt\0ParticipantTypesq\0~\0q\0~Nsq\0~\0\\q\0~Ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\02q\0~Ot\0ROLEsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xxsq\0~\0E\0\0\0w\0\0\0q\0~Sxt\0Descriptionsq\0~\02\0q\0~Xsq\0~\0VWq\0~Ct\0\0t\0ExternalReferencesq\0~\0\0q\0~\\sq\0~\0Vq\0~Ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0_fq\0~]t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0\rq\0~]t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0esq\0~]t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~aq\0~dq\0~gxt\0ExtendedAttributessq\0~\0\0q\0~ksq\0~\0%)q\0~Ct\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~Hq\0~Kq\0~Oq\0~Yq\0~]q\0~lxxt\0Applicationssr\0,org.enhydra.shark.xpdl.elements.Applications\0\0xq\0~\0k\0q\0~rsq\0~\0*Bq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Applicationv	RS\0\0xq\0~\0t\0Applicationsq\0~\0Wحq\0~tt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0:q1|q\0~zt\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0+\n q\0~zt\0\0pt\0Descriptionsq\0~\02\0q\0~sq\0~\0&:q\0~zt\0\0t\0Choicesr\00org.enhydra.shark.xpdl.elements.ApplicationTypes?!\0\0xr\0\'org.enhydra.shark.xpdl.XMLComplexChoice|\"\0L\0choicesq\0~\0L\0choosenq\0~\0	xq\0~\0q\0~sq\0~\0.Eq\0~zt\0\0sq\0~\0E\0\0\0w\0\0\0sr\00org.enhydra.shark.xpdl.elements.FormalParameterspBÁZ\0\0xq\0~\0k\0t\0FormalParameterssq\0~\0|q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0\0t\0ExternalReferencesq\0~\0}atBq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0\r,q\0~t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\05ԅq\0~t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\05]N^q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0Cq\0~zt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~xxt\0\nDataFieldssr\0*org.enhydra.shark.xpdl.elements.DataFieldsʦU\0\0xq\0~\0k\0q\0~sq\0~\0(#q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0WorkflowProcessessr\01org.enhydra.shark.xpdl.elements.WorkflowProcessesp_0,\0\0xq\0~\0k\0q\0~sq\0~\0J\rmq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0/org.enhydra.shark.xpdl.elements.WorkflowProcess%v0L\0\0xq\0~\0t\0WorkflowProcesssq\0~\07K0q\0~t\0\0sq\0~\0w\0\0\0\rq\0~\0sq\0~\0q\0~\0sq\0~\0Xf{q\0~t\0process1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Mfyq\0~t\0	Process 1pt\0AccessLevelsq\0~\0\0q\0~sq\0~\0?45q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0PUBLICt\0PRIVATExt\0\rProcessHeadersr\0-org.enhydra.shark.xpdl.elements.ProcessHeaderLC-)\0\0xq\0~\0q\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0t\0DurationUnitsq\0~\0\0q\0~sq\0~\0eq\0~t\0hsq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0Yt\0Mt\0Dt\0ht\0mt\0sxt\0Createdsq\0~\0-\0q\0~sq\0~\0oq\0~t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0,q\0~t\0\0t\0Prioritysr\0(org.enhydra.shark.xpdl.elements.Priority`Nn>b\0\0xq\0~\0#\0q\0~sq\0~\0!ɨq\0~t\0\0t\0Limitsr\0%org.enhydra.shark.xpdl.elements.Limit1ӗ\0\0xq\0~\0#\0q\0~sq\0~\07q\0~t\0\0t\0	ValidFromsr\0)org.enhydra.shark.xpdl.elements.ValidFromcŅ|L<\0\0xq\0~\0#\0q\0~sq\0~\0uS\\q\0~t\0\0t\0ValidTosr\0\'org.enhydra.shark.xpdl.elements.ValidToM\0\0xq\0~\0#\0q\0~sq\0~\0q\0~t\0\0t\0TimeEstimationsr\0.org.enhydra.shark.xpdl.elements.TimeEstimationŀ\'3\0\0xq\0~\0\0q\0~sq\0~\0eq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesr\0+org.enhydra.shark.xpdl.elements.WaitingTimeN/\0\0xq\0~\0#\0q\0~\0sq\0~\0X&q\0~t\0\0t\0WorkingTimesr\0+org.enhydra.shark.xpdl.elements.WorkingTime~\0\0xq\0~\0#\0q\0~sq\0~\0isq\0~t\0\0t\0Durationsr\0(org.enhydra.shark.xpdl.elements.Duration C\0\0xq\0~\0#\0q\0~\nsq\0~\0-q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xt\0RedefinableHeadersq\0~\0H\0q\0~sq\0~\0toq\0~t\0\0sq\0~\0w\0\0\0q\0~\0Msq\0~\0\0q\0~\0Msq\0~\0Wq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~\0Rq\0~\0Sq\0~\0Txt\0Authorsq\0~\0V\0q\0~sq\0~\0oq\0~t\0\0t\0Versionsq\0~\0[\0q\0~sq\0~\0G-q\0~t\0\0t\0Codepagesq\0~\0`\0q\0~!sq\0~\0yq\0~t\0\0t\0\nCountrykeysq\0~\0e\0q\0~%sq\0~\0PKLq\0~t\0\0t\0Responsiblessq\0~\0j\0q\0~)sq\0~\0Cq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~\Zq\0~q\0~\"q\0~&q\0~*xt\0FormalParameterssq\0~\0q\0~0sq\0~\0kCq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nDataFieldssq\0~\0q\0~6sq\0~\0\\.q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.DataFieldI3.~\0\0xq\0~\0t\0	DataFieldsq\0~\0||-q\0~7t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\039`q\0~=t\0approvalStatus1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0bSq\0~=t\0\0pt\0IsArraysq\0~\0\0q\0~Hsq\0~\04cgq\0~=t\0FALSEsq\0~\0E\0\0\0w\0\0\0t\0TRUEt\0FALSExt\0DataTypesr\0(org.enhydra.shark.xpdl.elements.DataType\'4sM\0\0xq\0~\0q\0~Osq\0~\01>q\0~=t\0\0sq\0~\0w\0\0\0t\0	DataTypessr\0)org.enhydra.shark.xpdl.elements.DataTypespcH,!\0Z\0\risInitializedxq\0~q\0~Usq\0~\0bݧq\0~Qt\0\0sq\0~\0E\0\0\0	w\0\0\0	sr\0)org.enhydra.shark.xpdl.elements.BasicType)w1\0\0xq\0~\0t\0	BasicTypesq\0~\0Λq\0~Wt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\01eaq\0~\\t\0STRINGsq\0~\0E\0\0\0w\0\0\0t\0STRINGt\0FLOATt\0INTEGERt\0	REFERENCEt\0DATETIMEt\0BOOLEANt\0	PERFORMERxxsq\0~\0E\0\0\0w\0\0\0q\0~axsr\0,org.enhydra.shark.xpdl.elements.DeclaredTypedR.\\^9\0\0xq\0~\0t\0DeclaredTypesq\0~\0wkq\0~Wt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Keq\0~nt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~sxsr\0*org.enhydra.shark.xpdl.elements.SchemaType&1oSH\0\0xq\0~\0t\0\nSchemaTypesq\0~\0/q\0~Wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0yq\0~Wt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0.桲q\0~~t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0n%q\0~~t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0vqq\0~~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsr\0*org.enhydra.shark.xpdl.elements.RecordType%K\0\0\0xq\0~\0kt\0\nRecordTypesq\0~\0(q\0~Wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.UnionType5PG\0\0xq\0~\0kt\0	UnionTypesq\0~\03H=q\0~Wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0/org.enhydra.shark.xpdl.elements.EnumerationTypef3b\0\0xq\0~\0kt\0EnumerationTypesq\0~\0q\0~Wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.ArrayTypeg$\0N@\0\0xq\0~\0t\0	ArrayTypesq\0~\0<$iq\0~Wt\0\0sq\0~\0w\0\0\0t\0\nLowerIndexsq\0~\0q\0~sq\0~\0Tq\0~t\0\0pt\0\nUpperIndexsq\0~\0q\0~sq\0~\0!q\0~t\0\0pq\0~Usq\0~Vq\0~Usq\0~\0;#6q\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsr\0(org.enhydra.shark.xpdl.elements.ListType\"ӟ\n\0\0xq\0~\0t\0ListTypesq\0~\0!fAq\0~Wt\0\0sq\0~\0w\0\0\0q\0~Usq\0~Vq\0~Usq\0~\0z$q\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~\\xsq\0~\0E\0\0\0w\0\0\0q\0~Wxt\0InitialValuesr\0,org.enhydra.shark.xpdl.elements.InitialValuej,zR\0\0xq\0~\0#\0q\0~sq\0~\0v4q\0~=t\0\0t\0Lengthsr\0&org.enhydra.shark.xpdl.elements.LengthMW+-̩W\0\0xq\0~\0#\0q\0~sq\0~\0U|nq\0~=t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0F,_q\0~=t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0,OLq\0~=t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~Bq\0~Eq\0~Iq\0~Qq\0~q\0~q\0~q\0~xsq\0~<t\0	DataFieldsq\0~\0IFpq\0~7t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\\q\0~t\0approvalStatus2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0i&U!q\0~t\0\0pq\0~Hsq\0~\0\0q\0~Hsq\0~\0}_q\0~t\0FALSEsq\0~\0E\0\0\0w\0\0\0q\0~Mq\0~Nxt\0DataTypesq\0~Pq\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~Usq\0~Vq\0~Usq\0~\07\03)q\0~t\0\0sq\0~\0E\0\0\0	w\0\0\0	sq\0~[t\0	BasicTypesq\0~\0uYq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0.\0q\0~t\0STRINGsq\0~\0E\0\0\0w\0\0\0q\0~eq\0~fq\0~gq\0~hq\0~iq\0~jq\0~kxxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~mt\0DeclaredTypesq\0~\06q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\00Zq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~wt\0\nSchemaTypesq\0~\0Oq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0	)q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0QJdq\0~t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0@k$q\0~t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0:\'q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\rq\0~xsq\0~t\0\nRecordTypesq\0~\0}_q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	UnionTypesq\0~\0dq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0EnumerationTypesq\0~\0b5Aq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	ArrayTypesq\0~\0dA+q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0g[nq\0~&t\0\0pq\0~sq\0~\0q\0~sq\0~\0%q\0~&t\0\0pq\0~Usq\0~Vq\0~Usq\0~\0F5q\0~&t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~+q\0~.q\0~1xsq\0~t\0ListTypesq\0~\0+Sq\0~t\0\0sq\0~\0w\0\0\0q\0~Usq\0~Vq\0~Usq\0~\0Dq\0~5t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~:xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0InitialValuesq\0~\0q\0~?sq\0~\07\"oq\0~t\0\0t\0Lengthsq\0~\0q\0~Csq\0~\0HTuq\0~t\0\0t\0Descriptionsq\0~\02\0q\0~Gsq\0~\0}`q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~Ksq\0~\0Mq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~@q\0~Dq\0~Hq\0~Lxsq\0~<t\0	DataFieldsq\0~\01!q\0~7t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0dcfq\0~Rt\0approverUsername1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0ztq\0~Rt\0\0pq\0~Hsq\0~\0\0q\0~Hsq\0~\0@q\0~Rt\0FALSEsq\0~\0E\0\0\0w\0\0\0q\0~Mq\0~Nxt\0DataTypesq\0~Pq\0~asq\0~\0jq\0~Rt\0\0sq\0~\0w\0\0\0q\0~Usq\0~Vq\0~Usq\0~\0C2Qq\0~bt\0\0sq\0~\0E\0\0\0	w\0\0\0	sq\0~[t\0	BasicTypesq\0~\0B]cq\0~ft\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0*25q\0~jt\0STRINGsq\0~\0E\0\0\0w\0\0\0q\0~eq\0~fq\0~gq\0~hq\0~iq\0~jq\0~kxxsq\0~\0E\0\0\0w\0\0\0q\0~oxsq\0~mt\0DeclaredTypesq\0~\0?V\nq\0~ft\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\05g2q\0~tt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~yxsq\0~wt\0\nSchemaTypesq\0~\05q\0~ft\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0\'*Fq\0~ft\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0-Vq\0~t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0!-XGq\0~t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0\\tMq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~t\0\nRecordTypesq\0~\0)2q\0~ft\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	UnionTypesq\0~\02Q=q\0~ft\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0EnumerationTypesq\0~\0y@q\0~ft\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	ArrayTypesq\0~\08Nq\0~ft\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0S0q\0~t\0\0pq\0~sq\0~\0q\0~sq\0~\0SQq\0~t\0\0pq\0~Usq\0~Vq\0~Usq\0~\0<쮯q\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~t\0ListTypesq\0~\0\n%4q\0~ft\0\0sq\0~\0w\0\0\0q\0~Usq\0~Vq\0~Usq\0~\08U-q\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~jxsq\0~\0E\0\0\0w\0\0\0q\0~fxt\0InitialValuesq\0~\0q\0~sq\0~\0u?q\0~Rt\0\0t\0Lengthsq\0~\0q\0~sq\0~\0,~bq\0~Rt\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0WUBq\0~Rt\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0F|@q\0~Rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~Wq\0~Zq\0~]q\0~bq\0~q\0~q\0~q\0~xsq\0~<t\0	DataFieldsq\0~\0G\"_q\0~7t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\nq\0~t\0approverUsername2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0>ıq\0~t\0\0pq\0~Hsq\0~\0\0q\0~Hsq\0~\0qfq\0~t\0FALSEsq\0~\0E\0\0\0w\0\0\0q\0~Mq\0~Nxt\0DataTypesq\0~Pq\0~sq\0~\0Bq\0~t\0\0sq\0~\0w\0\0\0q\0~Usq\0~Vq\0~Usq\0~\0Hjq\0~t\0\0sq\0~\0E\0\0\0	w\0\0\0	sq\0~[t\0	BasicTypesq\0~\0WaVq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0nq\0~t\0STRINGsq\0~\0E\0\0\0w\0\0\0q\0~eq\0~fq\0~gq\0~hq\0~iq\0~jq\0~kxxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~mt\0DeclaredTypesq\0~\0$q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\rA^q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~wt\0\nSchemaTypesq\0~\0PSq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0\"q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0f[q\0~t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0{q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~	q\0~xsq\0~t\0\nRecordTypesq\0~\0lq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	UnionTypesq\0~\0HJq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0EnumerationTypesq\0~\0Vq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	ArrayTypesq\0~\0\"q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0`!q\0~\"t\0\0pq\0~sq\0~\0q\0~sq\0~\0q\0~\"t\0\0pq\0~Usq\0~Vq\0~Usq\0~\0&(q\0~\"t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~\'q\0~*q\0~-xsq\0~t\0ListTypesq\0~\01Dq\0~t\0\0sq\0~\0w\0\0\0q\0~Usq\0~Vq\0~Usq\0~\0Xq\0~1t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~6xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0InitialValuesq\0~\0q\0~;sq\0~\0W~0q\0~t\0\0t\0Lengthsq\0~\0q\0~?sq\0~\0w7xq\0~t\0\0t\0Descriptionsq\0~\02\0q\0~Csq\0~\0aoq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~Gsq\0~\0[q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~<q\0~@q\0~Dq\0~Hxxt\0Participantssq\0~\0\0q\0~Nsq\0~\0Nq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Applicationssq\0~s\0q\0~Tsq\0~\0Zs1q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ActivitySetssr\0,org.enhydra.shark.xpdl.elements.ActivitySetsqV[4\0\0xq\0~\0k\0q\0~Zsq\0~\0-}q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nActivitiessr\0*org.enhydra.shark.xpdl.elements.Activities&G^lP\0\0xq\0~\0k\0q\0~asq\0~\09=q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0(org.enhydra.shark.xpdl.elements.Activityt45\Z9\0\0xq\0~\0t\0Activitysq\0~\0R~1q\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0;lq\0~it\0route1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0I蘕q\0~it\0\0pt\0Descriptionsq\0~\02\0q\0~tsq\0~\0Um]q\0~it\0\0t\0Limitsq\0~\0q\0~xsq\0~\0E q\0~it\0\0q\0~\0sr\0-org.enhydra.shark.xpdl.elements.ActivityTypeseŽ{\0\0xq\0~q\0~\0sq\0~\0YXq\0~it\0\0sq\0~\0E\0\0\0w\0\0\0sr\0%org.enhydra.shark.xpdl.elements.Route0e\rG\0\0xq\0~\0t\0Routesq\0~\0Wdq\0~}t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0.org.enhydra.shark.xpdl.elements.Implementationr^%\0\0xq\0~\0t\0Implementationsq\0~\0/NWq\0~}t\0\0sq\0~\0w\0\0\0q\0~\0sr\03org.enhydra.shark.xpdl.elements.ImplementationTypes\rT١9\0\0xq\0~q\0~\0sq\0~\0;ڞq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0\"org.enhydra.shark.xpdl.elements.No{.\0\0xq\0~\0t\0Nosq\0~\0zTq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0%org.enhydra.shark.xpdl.elements.ToolsCg\0\0xq\0~\0k\0t\0Toolssq\0~\0nyq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0\'org.enhydra.shark.xpdl.elements.SubFlow;Os7:$\0\0xq\0~\0t\0SubFlowsq\0~\0LAbq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\n^q\0~t\0\0pt\0	Executionsq\0~\0\0q\0~sq\0~\0~jq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ASYNCHRt\0SYNCHRxt\0ActualParameterssr\00org.enhydra.shark.xpdl.elements.ActualParameters_K\0\0xq\0~\0k\0q\0~sq\0~\0*cq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsr\0-org.enhydra.shark.xpdl.elements.BlockActivityqcF\0\0xq\0~\0t\0\rBlockActivitysq\0~\0^\ZRq\0~}t\0\0sq\0~\0w\0\0\0t\0BlockIdsq\0~\0q\0~sq\0~\0xD5q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersr\0)org.enhydra.shark.xpdl.elements.Performer\"1%\0\0xq\0~\0#\0q\0~sq\0~\0Qrq\0~it\0	requestert\0	StartModesr\0)org.enhydra.shark.xpdl.elements.StartModenhS\0\0xq\0~\0\0q\0~sq\0~\0OPq\0~it\0\0sq\0~\0w\0\0\0t\0Modesr\00org.enhydra.shark.xpdl.elements.StartFinishModes~6zX\'\0\0xq\0~\0q\0~sq\0~\0Dq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0,org.enhydra.shark.xpdl.XMLEmptyChoiceElement2;3_\0\0xq\0~\0\0t\0XMLEmptyChoiceElementsq\0~\0hh]q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.Automatict?_\0\0xq\0~\0t\0	Automaticsq\0~\0Phq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0&org.enhydra.shark.xpdl.elements.Manualv[ؤ\0\0xq\0~\0t\0Manualsq\0~\0&q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesr\0*org.enhydra.shark.xpdl.elements.FinishMode{\0\0xq\0~\0\0q\0~sq\0~\0}qxq\0~it\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0WVBq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0xq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0[/8Gq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Bܜq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0\".q\0~it\0\0t\0	Deadlinessr\0)org.enhydra.shark.xpdl.elements.Deadlines>ɜ\0\0xq\0~\0k\0q\0~sq\0~\0nsq\0~it\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsr\05org.enhydra.shark.xpdl.elements.SimulationInformation\"|I\0\0xq\0~\0\0q\0~sq\0~\0L,q\0~it\0\0sq\0~\0w\0\0\0t\0\rInstantiationsq\0~\0\0q\0~sq\0~\0h!q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ONCEt\0MULTIPLExt\0Costsr\0$org.enhydra.shark.xpdl.elements.Cost\0\0xq\0~\0#q\0~sq\0~\0J\0q\0~t\0\0t\0TimeEstimationsq\0~q\0~$sq\0~\0AAq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~)sq\0~\0Vq\0~%t\0\0t\0WorkingTimesq\0~\0q\0~-sq\0~\0OZ+q\0~%t\0\0t\0Durationsq\0~\0q\0~1sq\0~\0ntq\0~%t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~*q\0~.q\0~2xxsq\0~\0E\0\0\0w\0\0\0q\0~\Zq\0~!q\0~%xt\0Iconsr\0$org.enhydra.shark.xpdl.elements.IconTU(}6\0\0xq\0~\0#\0q\0~7sq\0~\0?Qq\0~it\0\0t\0\rDocumentationsq\0~\07\0q\0~<sq\0~\0vCq\0~it\0\0t\0TransitionRestrictionssr\06org.enhydra.shark.xpdl.elements.TransitionRestrictionsC)׀i;\0\0xq\0~\0k\0q\0~@sq\0~\0oq\0~it\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\05org.enhydra.shark.xpdl.elements.TransitionRestrictionN}\0\0xq\0~\0t\0TransitionRestrictionsq\0~\0aJèq\0~Bt\0\0sq\0~\0w\0\0\0t\0Joinsr\0$org.enhydra.shark.xpdl.elements.Joinڕөx)5\0\0xq\0~\0\0q\0~Msq\0~\00Y;q\0~Ht\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Jq\0~Ot\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ANDt\0XORxxsq\0~\0E\0\0\0w\0\0\0q\0~Sxt\0Splitsr\0%org.enhydra.shark.xpdl.elements.Split~ѯWS\0\0xq\0~\0\0q\0~Zsq\0~\0U?/q\0~Ht\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0b_Lq\0~\\q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Wq\0~Xxt\0TransitionRefssr\0.org.enhydra.shark.xpdl.elements.TransitionRefsъ\0\0xq\0~\0k\0q\0~csq\0~\0!Aq\0~\\t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~`q\0~exxsq\0~\0E\0\0\0w\0\0\0q\0~Oq\0~\\xxt\0ExtendedAttributessq\0~\0\0q\0~lsq\0~\0r>q\0~it\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\01org.enhydra.shark.xpdl.elements.ExtendedAttribute\\F\0\0xq\0~\0t\0ExtendedAttributesq\0~\0{)q\0~mt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0>{q\0~st\0JaWE_GRAPH_PARTICIPANT_IDpt\0Valuesq\0~\0\0q\0~{sq\0~\0<*bq\0~st\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~xq\0~|xsq\0~rt\0ExtendedAttributesq\0~\0aq\0~mt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0TBq\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0iq\0~t\0540,60pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~nq\0~qq\0~uq\0~yq\0~}q\0~q\0~q\0~q\0~	q\0~q\0~q\0~9q\0~=q\0~Bq\0~mxsq\0~ht\0Activitysq\0~\0Xq\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\04\\q\0~t\0route2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0yq\0~t\0\0pt\0Descriptionsq\0~\02\0q\0~sq\0~\0Urq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0m_q\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0iq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\03Oq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0#ьq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\05Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\05q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0]O-uq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0\'q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0<V5q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0փq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Wκq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0nT9q\0~t\0	approver1t\0	StartModesq\0~\0q\0~sq\0~\0c!q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0OmZq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\04q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0\"9rVq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Xbq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0Uoq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0$Lq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0EtJq\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0)q\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0&8,#q\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Prioritysq\0~\0q\0~sq\0~\0]Bq\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~sq\0~\0	q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~!sq\0~\0Eq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0\"0q\0~\"q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~)sq\0~\0[q\0~\"t\0\0t\0TimeEstimationsq\0~q\0~-sq\0~\0ܡq\0~\"t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~2sq\0~\05q\0~.t\0\0t\0WorkingTimesq\0~\0q\0~6sq\0~\0ARq\0~.t\0\0t\0Durationsq\0~\0q\0~:sq\0~\0=NPq\0~.t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~3q\0~7q\0~;xxsq\0~\0E\0\0\0w\0\0\0q\0~&q\0~*q\0~.xt\0Iconsq\0~8\0q\0~@sq\0~\0]JAq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~Dsq\0~\0agq\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~Hsq\0~\0S{dq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0TransitionRestrictionsq\0~\0Wq\0~It\0\0sq\0~\0w\0\0\0t\0Joinsq\0~N\0q\0~Ssq\0~\07s4q\0~Nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0LRq\0~Tq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Wq\0~Xxxsq\0~\0E\0\0\0w\0\0\0q\0~Xxt\0Splitsq\0~[\0q\0~\\sq\0~\0Y`q\0~Nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0>^Qq\0~]t\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Wq\0~Xxt\0TransitionRefssq\0~d\0q\0~esq\0~\0\ns\0}q\0~]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0-org.enhydra.shark.xpdl.elements.TransitionRef%-a\0\0xq\0~\0t\0\rTransitionRefsq\0~\0@q\0~ft\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0_q\0~lt\0transition4pxsq\0~\0E\0\0\0w\0\0\0q\0~qxsq\0~kt\0\rTransitionRefsq\0~\0Tq\0~ft\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Uq\0~ut\0transition8pxsq\0~\0E\0\0\0w\0\0\0q\0~zxsq\0~kt\0\rTransitionRefsq\0~\0!Eq\0~ft\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~~t\0transition15pxsq\0~\0E\0\0\0w\0\0\0q\0~xxxsq\0~\0E\0\0\0w\0\0\0q\0~aq\0~fxxsq\0~\0E\0\0\0w\0\0\0q\0~Tq\0~]xxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\06q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\06-q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\09iq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0tq\0~t\0	approver1pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\0^Aq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0u	/q\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0݅q\0~t\0720,280pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~\"q\0~Aq\0~Eq\0~Iq\0~xsq\0~ht\0Activitysq\0~\0gq\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0`q\0~t\0route3pq\0~\0sq\0~\0\0q\0~\0sq\0~\0NOq\0~t\0\0pt\0Descriptionsq\0~\02\0q\0~sq\0~\0*q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0ISwq\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0hD>q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0FDq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\03:q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0gq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0ePáq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0Vq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\03q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\"q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0A/w%q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0\"q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0.q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0nq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\09B˽q\0~t\0	approver2t\0	StartModesq\0~\0q\0~sq\0~\0k<q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0Dq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0wNgq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0j\r_q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0Tq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\04Skq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0vDq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0r?Fq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0b{<q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~2sq\0~\0Qq\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~6sq\0~\0Uܑq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~<sq\0~\0Neq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0pܠq\0~=q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~Dsq\0~\0w>E|q\0~=t\0\0t\0TimeEstimationsq\0~q\0~Hsq\0~\0D^q\0~=t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~Msq\0~\0\rq\0~It\0\0t\0WorkingTimesq\0~\0q\0~Qsq\0~\0q\0~It\0\0t\0Durationsq\0~\0q\0~Usq\0~\0Rcgq\0~It\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~Nq\0~Rq\0~Vxxsq\0~\0E\0\0\0w\0\0\0q\0~Aq\0~Eq\0~Ixt\0Iconsq\0~8\0q\0~[sq\0~\0r(q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~_sq\0~\0hq\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~csq\0~\0ϛq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0TransitionRestrictionsq\0~\0:1q\0~dt\0\0sq\0~\0w\0\0\0t\0Joinsq\0~N\0q\0~nsq\0~\0p:q\0~it\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0^Saq\0~oq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Wq\0~Xxxsq\0~\0E\0\0\0w\0\0\0q\0~sxt\0Splitsq\0~[\0q\0~wsq\0~\06q\0~it\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\03#q\0~xt\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Wq\0~Xxt\0TransitionRefssq\0~d\0q\0~sq\0~\0F<q\0~xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~kt\0\rTransitionRefsq\0~\0wlq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0v[q\0~t\0transition11pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~kt\0\rTransitionRefsq\0~\0GKq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0XIq\0~t\0transition12pxsq\0~\0E\0\0\0w\0\0\0q\0~xxxsq\0~\0E\0\0\0w\0\0\0q\0~|q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~oq\0~xxxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0xq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0$Hq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0F1[q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0Q q\0~t\0	approver2pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\0)f3q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0h9q\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0#q\0~t\01080,500pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~3q\0~7q\0~=q\0~\\q\0~`q\0~dq\0~xsq\0~ht\0Activitysq\0~\0w|q\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0eQq\0~t\0email2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0e]@q\0~t\0Email Notify Requester Resubmitpt\0Descriptionsq\0~\02\0q\0~sq\0~\0L1)q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0l[q\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0Taq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0_orq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0\Z{q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\07:q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0w^q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0sq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0$org.enhydra.shark.xpdl.elements.Tool\\6&+G\0\0xq\0~\0t\0Toolsq\0~\0p^q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Fq\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0g(q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0APPLICATIONt\0	PROCEDURExt\0ActualParameterssq\0~\0q\0~sq\0~\0)Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\00Wq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0x>q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~\0q\0~xxsq\0~t\0SubFlowsq\0~\0j0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0O-q\0~\nt\0\0pq\0~sq\0~\0\0q\0~sq\0~\0:B\rq\0~\nq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0ilq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0-?Bq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0o:\nq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\"xxq\0~t\0	Performersq\0~\0q\0~&sq\0~\0Ehq\0~t\0	requestert\0	StartModesq\0~\0q\0~*sq\0~\0o|,q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0\"<xq\0~+t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0q\0~/t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0#>Jq\0~/t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0^@q\0~/t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~3xsq\0~\0E\0\0\0w\0\0\0q\0~/xt\0\nFinishModesq\0~\0q\0~Fsq\0~\0>zq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0U#q\0~Gt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0M*\\q\0~Kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0w4nYq\0~Kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0\n q\0~Kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Oxsq\0~\0E\0\0\0w\0\0\0q\0~Kxt\0Prioritysq\0~\0q\0~bsq\0~\0Xq\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~fsq\0~\0A,/q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~lsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0;\Zq\0~mq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~tsq\0~\0js>q\0~mt\0\0t\0TimeEstimationsq\0~q\0~xsq\0~\0L\0a<q\0~mt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~}sq\0~\0)dVq\0~yt\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0k%\'q\0~yt\0\0t\0Durationsq\0~\0q\0~sq\0~\0SAq\0~yt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~qq\0~uq\0~yxt\0Iconsq\0~8\0q\0~sq\0~\0W@q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0\\Me2q\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~sq\0~\0iq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0TransitionRestrictionsq\0~\0`|Eq\0~t\0\0sq\0~\0w\0\0\0t\0Joinsq\0~N\0q\0~sq\0~\0a=^q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0sx$q\0~t\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Wq\0~Xxxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Splitsq\0~[\0q\0~sq\0~\0=q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0&{q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Wq\0~Xxt\0TransitionRefssq\0~d\0q\0~sq\0~\0-\\5q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0Iq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0gq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0y&Ȣq\0~t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\0-@q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q	q\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0_Sq\0~t\01080,60pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~\'q\0~+q\0~Gq\0~cq\0~gq\0~mq\0~q\0~q\0~q\0~xsq\0~ht\0Activitysq\0~\0q\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0ޯq\0~t\0email3pq\0~\0sq\0~\0\0q\0~\0sq\0~\0=b~\0q\0~t\0Email Notify Approver2pt\0Descriptionsq\0~\02\0q\0~sq\0~\0zq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0>֫q\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0&q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0-Dqq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0~[q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0{q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0?\'\nq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0]	Sq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0{sͦq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Z=q\0~		t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0b%}q\0~		q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~	sq\0~\0oB/q\0~		t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~	\Zsq\0~\0sݏq\0~		t\0\0t\0ExtendedAttributessq\0~\0\0q\0~	sq\0~\0rq\0~		t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	q\0~	q\0~	xxsq\0~t\0SubFlowsq\0~\00)q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0{ޡ(q\0~	%t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0zuq\0~	%q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~	0sq\0~\0jTq\0~	%t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~	*q\0~	-q\0~	1xxq\0~	xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0~V_oq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0pflq\0~	8t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~	=xxq\0~t\0	Performersq\0~\0q\0~	Asq\0~\0Iq\0~t\0	approver2t\0	StartModesq\0~\0q\0~	Esq\0~\0UR[q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\03q\0~	Ft\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0t5q\0~	Jt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0,xȱq\0~	Jt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0gɜq\0~	Jt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	Nxsq\0~\0E\0\0\0w\0\0\0q\0~	Jxt\0\nFinishModesq\0~\0q\0~	asq\0~\0Bqq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0~-\\@q\0~	bt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\07[q\0~	ft\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0rXq\0~	ft\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0:,r6q\0~	ft\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	jxsq\0~\0E\0\0\0w\0\0\0q\0~	fxt\0Prioritysq\0~\0q\0~	}sq\0~\0yϽq\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~	sq\0~\0raq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~	sq\0~\0:q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0cx=q\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~	sq\0~\06)q\0~	t\0\0t\0TimeEstimationsq\0~q\0~	sq\0~\0gCq\0~	t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~	sq\0~\09N,hq\0~	t\0\0t\0WorkingTimesq\0~\0q\0~	sq\0~\0esq\0~	t\0\0t\0Durationsq\0~\0q\0~	sq\0~\0eq\0~	t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	xxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	xt\0Iconsq\0~8\0q\0~	sq\0~\0рuq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~	sq\0~\0J+q\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~	sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~	sq\0~\0\r%Jq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0bCq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0kq\0~	t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0\']\Zq\0~	t\0	approver2pxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xsq\0~rt\0ExtendedAttributesq\0~\06q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0 Xuq\0~	t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0$q\0~	t\0720,500pxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~	Bq\0~	Fq\0~	bq\0~	~q\0~	q\0~	q\0~	q\0~	q\0~	q\0~	xsq\0~ht\0Activitysq\0~\0orH.q\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~	t\0email1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0G26q\0~	t\0Email Notify Approver1pt\0Descriptionsq\0~\02\0q\0~	sq\0~\0$\'Jq\0~	t\0\0t\0Limitsq\0~\0q\0~	sq\0~\0\'Oeq\0~	t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0Zjnq\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0ՍKq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0vq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0I> q\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0=aq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\08\"`q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0e&Oq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0QVq\0~\nt\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\05q\0~\nq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~\nsq\0~\0-q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~\nsq\0~\0gq\0~\nt\0\0t\0ExtendedAttributessq\0~\0\0q\0~\n\Zsq\0~\0q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\n\nq\0~\n\rq\0~\nq\0~\nq\0~\nxxsq\0~t\0SubFlowsq\0~\0 Xaq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0>q\0~\n!t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0k\Zq\0~\n!q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~\n,sq\0~\0Cҟq\0~\n!t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\n&q\0~\n)q\0~\n-xxq\0~	xsq\0~\0E\0\0\0w\0\0\0q\0~	xsq\0~t\0\rBlockActivitysq\0~\0 q\0~	t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0atq\0~\n4t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\n9xxq\0~	t\0	Performersq\0~\0q\0~\n=sq\0~\0_@Lq\0~	t\0	requestert\0	StartModesq\0~\0q\0~\nAsq\0~\06\Zq\0~	t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0&Bq\0~\nBt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0fԍ\\q\0~\nFt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0amdq\0~\nFt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Bq\0~\nFt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\nJxsq\0~\0E\0\0\0w\0\0\0q\0~\nFxt\0\nFinishModesq\0~\0q\0~\n]sq\0~\0|k*dq\0~	t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0>q\0~\n^t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0ulcq\0~\nbt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0f!q\0~\nbt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0I5q\0~\nbt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\nfxsq\0~\0E\0\0\0w\0\0\0q\0~\nbxt\0Prioritysq\0~\0q\0~\nysq\0~\0*q\0~	t\0\0t\0	Deadlinessq\0~\r\0q\0~\n}sq\0~\0Lq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~\nsq\0~\0sq\0~	t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\03q\0~\nq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~\nsq\0~\0]IWq\0~\nt\0\0t\0TimeEstimationsq\0~q\0~\nsq\0~\0mq\0~\nt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~\nsq\0~\03=3q\0~\nt\0\0t\0WorkingTimesq\0~\0q\0~\nsq\0~\0EUq\0~\nt\0\0t\0Durationsq\0~\0q\0~\nsq\0~\0\ntq\0~\nt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nxxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nxt\0Iconsq\0~8\0q\0~\nsq\0~\0+q\0~	t\0\0t\0\rDocumentationsq\0~\07\0q\0~\nsq\0~\0%Lq\0~	t\0\0t\0TransitionRestrictionssq\0~A\0q\0~\nsq\0~\0z]q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~\nsq\0~\0Ws^q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\02hq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\'[q\0~\nt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0]T14q\0~\nt\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nxsq\0~rt\0ExtendedAttributesq\0~\0]Lq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0)/q\0~\nt\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0dq\0~\nt\0360,60pxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nxxpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	q\0~	q\0~	q\0~\n>q\0~\nBq\0~\n^q\0~\nzq\0~\n~q\0~\nq\0~\nq\0~\nq\0~\nq\0~\nxsq\0~ht\0Activitysq\0~\0q\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0@^q\0~\nt\0	approver1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0 q\0~\nt\0Pending Approver 1pt\0Descriptionsq\0~\02\0q\0~\nsq\0~\08Q]q\0~\nt\0\0t\0Limitsq\0~\0q\0~\nsq\0~\0\nsq\0~\nt\0\0q\0~\0sq\0~|q\0~\0sq\0~\0N7q\0~\nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0V\rq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0[q\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0Z\'q\0~\nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0Umq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0tq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0jbFq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0(ԉq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0$=q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~	q\0~\rxxq\0~\nxsq\0~\0E\0\0\0w\0\0\0q\0~\nxsq\0~t\0\rBlockActivitysq\0~\0ymq\0~\nt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0&r3q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~\nt\0	Performersq\0~\0q\0~sq\0~\0[Aq\0~\nt\0	approver1t\0	StartModesq\0~\0q\0~!sq\0~\0xN[q\0~\nt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0\n+q\0~\"t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0q\0~&t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0&7q\0~&t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\01tq\0~&t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~*xsq\0~\0E\0\0\0w\0\0\0q\0~&xt\0\nFinishModesq\0~\0q\0~=sq\0~\0Wq\0~\nt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Q\'Kq\0~>t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0BP\"q\0~Bt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0_q\0~Bt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0q\0~Bt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Fxsq\0~\0E\0\0\0w\0\0\0q\0~Bxt\0Prioritysq\0~\0q\0~Ysq\0~\0m\nq\0~\nt\0\0t\0	Deadlinessq\0~\r\0q\0~]sq\0~\0E]q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~csq\0~\0ZZe\rq\0~\nt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\01q\0~dq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~ksq\0~\0q\0~dt\0\0t\0TimeEstimationsq\0~q\0~osq\0~\0?[q\0~dt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~tsq\0~\063\nq\0~pt\0\0t\0WorkingTimesq\0~\0q\0~xsq\0~\0\'q\0~pt\0\0t\0Durationsq\0~\0q\0~|sq\0~\0V\'q\0~pt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~uq\0~yq\0~}xxsq\0~\0E\0\0\0w\0\0\0q\0~hq\0~lq\0~pxt\0Iconsq\0~8\0q\0~sq\0~\0k.q\0~\nt\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0q\0~\nt\0\0t\0TransitionRestrictionssq\0~A\0q\0~sq\0~\0k{q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0\\q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0hxq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0`)q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0	q\0~t\0	approver1pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\0sq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0 Xq\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0\rq\0~t\0540,280pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nq\0~\nq\0~\nq\0~q\0~\"q\0~>q\0~Zq\0~^q\0~dq\0~q\0~q\0~q\0~xsq\0~ht\0Activitysq\0~\0D]q\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0v\0qq\0~t\0	approver2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0xVO7q\0~t\0Pending Approver 2pt\0Descriptionsq\0~\02\0q\0~sq\0~\0i`q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0JqJq\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0bq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0()Fq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\03Pq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0sۈq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0v1q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0lNR*q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0C}q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0TJq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\07	q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0)Pq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\04wq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0(Aq\0~t\0	approver2t\0	StartModesq\0~\0q\0~sq\0~\0Iĥq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\04Eq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0kDq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0C;q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\nxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\02$q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0+vq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0Eq\0~\"t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0V}cq\0~\"t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0h^;q\0~\"t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~&xsq\0~\0E\0\0\0w\0\0\0q\0~\"xt\0Prioritysq\0~\0q\0~9sq\0~\0\0\'|q\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~=sq\0~\01q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~Csq\0~\0\nz@5q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0Zuq\0~Dq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~Ksq\0~\0.7q\0~Dt\0\0t\0TimeEstimationsq\0~q\0~Osq\0~\0 dq\0~Dt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~Tsq\0~\0x\rq\0~Pt\0\0t\0WorkingTimesq\0~\0q\0~Xsq\0~\0?8q\0~Pt\0\0t\0Durationsq\0~\0q\0~\\sq\0~\0\0|q\0~Pt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~Uq\0~Yq\0~]xxsq\0~\0E\0\0\0w\0\0\0q\0~Hq\0~Lq\0~Pxt\0Iconsq\0~8\0q\0~bsq\0~\0b=q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~fsq\0~\0DI{q\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~jsq\0~\0;8q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~psq\0~\0l6q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0Zq\0~qt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0n-ůq\0~vt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0 BFq\0~vt\0	approver2pxsq\0~\0E\0\0\0w\0\0\0q\0~{q\0~~xsq\0~rt\0ExtendedAttributesq\0~\0tf@.q\0~qt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0	q\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0\"q\0~t\0900,500pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~:q\0~>q\0~Dq\0~cq\0~gq\0~kq\0~qxsq\0~ht\0Activitysq\0~\0&\"q\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0email4pq\0~\0sq\0~\0\0q\0~\0sq\0~\0UXq\0~t\0Email Notify Requester Completept\0Descriptionsq\0~\02\0q\0~sq\0~\0TlLq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0P{q\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0u1q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0=q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0*q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0%kq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0kTvXq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0~2q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0z<׊q\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0{cJq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0kB\'=q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\04q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~xxsq\0~t\0SubFlowsq\0~\0Mzq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\07\rq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0XJ.q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0.\"Eq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Mtv}q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0gq\0~t\0	approver2t\0	StartModesq\0~\0q\0~sq\0~\0w?_q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0pq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0v(q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0_0q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0wcq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\rxsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0\nFinishModesq\0~\0q\0~\rsq\0~\0eq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Vq\0~\r\Zt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0}q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0[q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0(q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\r\"xsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0Prioritysq\0~\0q\0~\r5sq\0~\0\ZgYq\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~\r9sq\0~\0G(q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~\r?sq\0~\0&q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0	<q\0~\r@q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~\rGsq\0~\0)q\0~\r@t\0\0t\0TimeEstimationsq\0~q\0~\rKsq\0~\0/\'4q\0~\r@t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~\rPsq\0~\0\\vq\0~\rLt\0\0t\0WorkingTimesq\0~\0q\0~\rTsq\0~\0gq\0~\rLt\0\0t\0Durationsq\0~\0q\0~\rXsq\0~\0a7Hq\0~\rLt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~\rQq\0~\rUq\0~\rYxxsq\0~\0E\0\0\0w\0\0\0q\0~\rDq\0~\rHq\0~\rLxt\0Iconsq\0~8\0q\0~\r^sq\0~\0vq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~\rbsq\0~\0bq\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~\rfsq\0~\0Ɗq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~\rlsq\0~\0M\rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0Qq\0~\rmt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0lMq\0~\rrt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0nPq\0~\rrt\0	approver2pxsq\0~\0E\0\0\0w\0\0\0q\0~\rwq\0~\rzxsq\0~rt\0ExtendedAttributesq\0~\0^q\0~\rmt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0RAq\0~\r~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0	Δq\0~\r~t\01260,500pxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~\r\Zq\0~\r6q\0~\r:q\0~\r@q\0~\r_q\0~\rcq\0~\rgq\0~\rmxsq\0~ht\0Activitysq\0~\0e_q\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0dӟq\0~\rt\0resubmitpq\0~\0sq\0~\0\0q\0~\0sq\0~\0uq\0~\rt\0Requester to Resubmitpt\0Descriptionsq\0~\02\0q\0~\rsq\0~\0+=4q\0~\rt\0\0t\0Limitsq\0~\0q\0~\rsq\0~\0Sq\0~\rt\0\0q\0~\0sq\0~|q\0~\0sq\0~\0hq\0~\rt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\04q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0n@q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0e9q\0~\rt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0Nq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0hq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0y2Қq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0uNDq\0~\rt\0\0pq\0~sq\0~\0\0q\0~sq\0~\0w)q\0~\rq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~\rsq\0~\0%$q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rq\0~\rxxq\0~\rxsq\0~\0E\0\0\0w\0\0\0q\0~\rxsq\0~t\0\rBlockActivitysq\0~\0Jmq\0~\rt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0MI2q\0~\rt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\rxxq\0~\rt\0	Performersq\0~\0q\0~\rsq\0~\0gWq\0~\rt\0	requestert\0	StartModesq\0~\0q\0~\rsq\0~\0g7q\0~\rt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Ei*q\0~\rt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0ZMq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0hq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0QMq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\rxsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0\nFinishModesq\0~\0q\0~\rsq\0~\0>#q\0~\rt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Vy q\0~\rt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0(;tq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0iF~q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Kq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0Prioritysq\0~\0q\0~sq\0~\0DTLq\0~\rt\0\0t\0	Deadlinessq\0~\r\0q\0~sq\0~\00*q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0#<Iq\0~\rt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0{nq\0~ q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~\'sq\0~\0EHq\0~ t\0\0t\0TimeEstimationsq\0~q\0~+sq\0~\0l5q\0~ t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~0sq\0~\0*Hq\0~,t\0\0t\0WorkingTimesq\0~\0q\0~4sq\0~\0mq\0~,t\0\0t\0Durationsq\0~\0q\0~8sq\0~\0\rq\0~,t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~1q\0~5q\0~9xxsq\0~\0E\0\0\0w\0\0\0q\0~$q\0~(q\0~,xt\0Iconsq\0~8\0q\0~>sq\0~\0Xq\0~\rt\0\0t\0\rDocumentationsq\0~\07\0q\0~Bsq\0~\0Vq\0~\rt\0\0t\0TransitionRestrictionssq\0~A\0q\0~Fsq\0~\0ASKq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~Lsq\0~\0\ZsRq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0Ctq\0~Mt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0|q\0~Rt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\04Hgq\0~Rt\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~Wq\0~Zxsq\0~rt\0ExtendedAttributesq\0~\0q\0~Mt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0`nq\0~^t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0P },q\0~^t\0900,60pxsq\0~\0E\0\0\0w\0\0\0q\0~cq\0~fxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~q\0~\Zq\0~ q\0~?q\0~Cq\0~Gq\0~Mxsq\0~ht\0Activitysq\0~\0eb`?q\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\04vq\0~kt\0tool5pq\0~\0sq\0~\0\0q\0~\0sq\0~\0\Z:q\0~kt\0Update Approver 2 Statuspt\0Descriptionsq\0~\02\0q\0~vsq\0~\0\r/q\0~kt\0\0t\0Limitsq\0~\0q\0~zsq\0~\0^wq\0~kt\0\0q\0~\0sq\0~|q\0~\0sq\0~\0(\Zq\0~kt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0SFq\0~~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0cPq\0~~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0Vsq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0FĴLq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0oq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\06Oq\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0Vq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0][\Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0Bg҄q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0=_q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~xxsq\0~t\0SubFlowsq\0~\0Q8q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0jq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0xq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0B1q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0Q\"q\0~~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0^9sq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0Zq\0~kt\0	approver1t\0	StartModesq\0~\0q\0~sq\0~\0ex;q\0~kt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0xaq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0ho7q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0aLq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0-o\"q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0q\0~kt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0\r-q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0uq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\09ޡq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0nq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0}Vq\0~kt\0\0t\0	Deadlinessq\0~\r\0q\0~sq\0~\02С*q\0~kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0-.q\0~kt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0kpq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~#sq\0~\0*$q\0~t\0\0t\0TimeEstimationsq\0~q\0~\'sq\0~\0(D&\Zq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~,sq\0~\0u7=q\0~(t\0\0t\0WorkingTimesq\0~\0q\0~0sq\0~\0Uq\0~(t\0\0t\0Durationsq\0~\0q\0~4sq\0~\0\ZUq\0~(t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~-q\0~1q\0~5xxsq\0~\0E\0\0\0w\0\0\0q\0~ q\0~$q\0~(xt\0Iconsq\0~8\0q\0~:sq\0~\0zq\0~kt\0\0t\0\rDocumentationsq\0~\07\0q\0~>sq\0~\0[,q\0~kt\0\0t\0TransitionRestrictionssq\0~A\0q\0~Bsq\0~\0Qcq\0~kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~Hsq\0~\0s-_-q\0~kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0#Tq\0~It\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\nRq\0~Nt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0Nq\0~Nt\0	approver1pxsq\0~\0E\0\0\0w\0\0\0q\0~Sq\0~Vxsq\0~rt\0ExtendedAttributesq\0~\0`q\0~It\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0qv2q\0~Zt\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0o7?&q\0~Zt\01440,280pxsq\0~\0E\0\0\0w\0\0\0q\0~_q\0~bxxpxsq\0~\0E\0\0\0w\0\0\0q\0~pq\0~sq\0~wq\0~{q\0~~q\0~q\0~q\0~q\0~q\0~q\0~q\0~;q\0~?q\0~Cq\0~Ixsq\0~ht\0Activitysq\0~\0Dq\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0D{q\0~gt\0tool6pq\0~\0sq\0~\0\0q\0~\0sq\0~\0R}viq\0~gt\0Email Notify Requester Rejectedpt\0Descriptionsq\0~\02\0q\0~rsq\0~\0tDcq\0~gt\0\0t\0Limitsq\0~\0q\0~vsq\0~\0Bq\0~gt\0\0q\0~\0sq\0~|q\0~\0sq\0~\0n)q\0~gt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0Wq\0~zt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0aE\roq\0~zt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0Gt$q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\06Rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0A,dq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0h0wq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\051q\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0@q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0Nkq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0lq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0R`q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~xxsq\0~t\0SubFlowsq\0~\0K7&q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Dr_q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0\"\0q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0\0?q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0QDq\0~zt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0.7q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0uhq\0~gt\0	approver1t\0	StartModesq\0~\0q\0~sq\0~\0y8Qq\0~gt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0J8q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0pq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0f\'q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0G=9q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0%01q\0~gt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0?eq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0!p,q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0|$q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0j==q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~\rsq\0~\06Iq\0~gt\0\0t\0	Deadlinessq\0~\r\0q\0~sq\0~\0\\q\0~gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\06fq\0~gt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\05q¬q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~sq\0~\0q\0~t\0\0t\0TimeEstimationsq\0~q\0~#sq\0~\0raq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~(sq\0~\0t֗q\0~$t\0\0t\0WorkingTimesq\0~\0q\0~,sq\0~\0OO{q\0~$t\0\0t\0Durationsq\0~\0q\0~0sq\0~\0\\=q\0~$t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~)q\0~-q\0~1xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~ q\0~$xt\0Iconsq\0~8\0q\0~6sq\0~\0~6+q\0~gt\0\0t\0\rDocumentationsq\0~\07\0q\0~:sq\0~\0>3q\0~gt\0\0t\0TransitionRestrictionssq\0~A\0q\0~>sq\0~\0;hq\0~gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~Dsq\0~\0-q\0~gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0mLq\0~Et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Sq\0~Jt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0.#\0q\0~Jt\0	approver1pxsq\0~\0E\0\0\0w\0\0\0q\0~Oq\0~Rxsq\0~rt\0ExtendedAttributesq\0~\0@U̶q\0~Et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0O q\0~Vt\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0kNq\0~Vt\01620,280pxsq\0~\0E\0\0\0w\0\0\0q\0~[q\0~^xxpxsq\0~\0E\0\0\0w\0\0\0q\0~lq\0~oq\0~sq\0~wq\0~zq\0~q\0~q\0~q\0~q\0~q\0~q\0~7q\0~;q\0~?q\0~Exxt\0Transitionssr\0+org.enhydra.shark.xpdl.elements.Transitions9>/i\0\0xq\0~\0k\0q\0~csq\0~\09q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\rw\0\0\0\rsr\0*org.enhydra.shark.xpdl.elements.Transitiontx\0\0xq\0~\0t\0\nTransitionsq\0~\0[iq\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0zaGq\0~kt\0transition1pq\0~\0sq\0~\0\0q\0~\0sq\0~\09sq\0~kt\0\0pt\0Fromsq\0~\0q\0~vsq\0~\0.9q\0~kt\0email1pt\0Tosq\0~\0q\0~zsq\0~\07q\0~kt\0route1pt\0	Conditionsr\0)org.enhydra.shark.xpdl.elements.ConditionDZ;|\0\0xq\0~\0\0q\0~~sq\0~\0.{q\0~kt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Hq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0	CONDITIONt\0	OTHERWISEt\0	EXCEPTIONt\0DEFAULTEXCEPTIONxxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0.hq\0~kt\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0q\0~kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0,q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0֮q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0Zomq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~pq\0~sq\0~wq\0~{q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\0\")3q\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0yq\0~t\0transition3pq\0~\0sq\0~\0\0q\0~\0sq\0~\0a<q\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0~lq\0~t\0	approver1pq\0~zsq\0~\0q\0~zsq\0~\0HUJq\0~t\0route2pt\0	Conditionsq\0~\0q\0~sq\0~\0\n1vq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Oe\'q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0\rq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0~fq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\04Wq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0/Omq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0\n%MYq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\0,yq\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0vq\0~t\0transition4pq\0~\0sq\0~\0\0q\0~\0sq\0~\019q\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0BP{&q\0~t\0route2pq\0~zsq\0~\0q\0~zsq\0~\0q\0~t\0email2pt\0	Conditionsq\0~\0q\0~sq\0~\0P}-q\0~t\0approvalStatus1 === \'Resubmit\'sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0+q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0OÐq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0̽q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0 HJq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0zq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\0p#$q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0p;q\0~t\0PBUILDER_TRANSITION_CONDITIONSpq\0~{sq\0~\0\0q\0~{sq\0~\0\r-3q\0~t\0P[{\"join\":\"&&\",\"variable\":\"approvalStatus1\",\"operator\":\"===\",\"value\":\"Resubmit\"}]pxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\0xɈq\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0H$q\0~t\0transition5pq\0~\0sq\0~\0\0q\0~\0sq\0~\0rdXq\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0Aq\0~t\0email2pq\0~zsq\0~\0q\0~zsq\0~\0q\0~t\0resubmitpt\0	Conditionsq\0~\0q\0~#sq\0~\0,B7q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0<Hgq\0~$q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~(xt\0Descriptionsq\0~\02\0q\0~,sq\0~\0%deq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~0sq\0~\0uq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0	q\0~1t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0U!Oq\0~6t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0hIq\0~6t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~;q\0~>xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~\Zq\0~q\0~ q\0~$q\0~-q\0~1xsq\0~jt\0\nTransitionsq\0~\0I\"q\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0$q\0~Ct\0transition7pq\0~\0sq\0~\0\0q\0~\0sq\0~\0c\Zq\0~Ct\0\0pq\0~vsq\0~\0q\0~vsq\0~\0q\0~Ct\0resubmitpq\0~zsq\0~\0q\0~zsq\0~\0Iuq\0~Ct\0route1pt\0	Conditionsq\0~\0q\0~Tsq\0~\0K\\M-q\0~Ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0La!q\0~Uq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~Yxt\0Descriptionsq\0~\02\0q\0~]sq\0~\0q\0~Ct\0\0t\0ExtendedAttributessq\0~\0\0q\0~asq\0~\0\r\\q\0~Ct\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0﫤q\0~bt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0p?q\0~gt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0[2q\0~gt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~lq\0~oxxpxsq\0~\0E\0\0\0w\0\0\0q\0~Hq\0~Kq\0~Nq\0~Qq\0~Uq\0~^q\0~bxsq\0~jt\0\nTransitionsq\0~\0peq\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\"{q\0~tt\0transition8pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Lhq\0~tt\0\0pq\0~vsq\0~\0q\0~vsq\0~\04q\0~tt\0route2pq\0~zsq\0~\0q\0~zsq\0~\0\nq\0~tt\0email3pt\0	Conditionsq\0~\0q\0~sq\0~\07q\0~tt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0&Cnq\0~t\0	OTHERWISEsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0D0 q\0~tt\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0,q\0~tt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0:yq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\01qq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0n?-;q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~yq\0~|q\0~q\0~q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\0eTq\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0ײq\0~t\0transition9pq\0~\0sq\0~\0\0q\0~\0sq\0~\07$q\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0kxWq\0~t\0email3pq\0~zsq\0~\0q\0~zsq\0~\0 +q\0~t\0	approver2pt\0	Conditionsq\0~\0q\0~sq\0~\0vi;q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\01emq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0\0?q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0+\01Xq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0Dq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0ZXZq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0wʹq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\0s\Zq\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0P3^q\0~t\0transition10pq\0~\0sq\0~\0\0q\0~\0sq\0~\0]8q\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0_ܗ\rq\0~t\0	approver2pq\0~zsq\0~\0q\0~zsq\0~\0GHq\0~t\0route3pt\0	Conditionsq\0~\0q\0~sq\0~\0~q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Eqq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0G/Mq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0dq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0tLq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\08^>q\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0#Hq\0~t\0transition13pq\0~\0sq\0~\0\0q\0~\0sq\0~\0y1q\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0:Lq\0~t\0route1pq\0~zsq\0~\0q\0~zsq\0~\0(0q\0~t\0	approver1pt\0	Conditionsq\0~\0q\0~sq\0~\0?#q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\06&q\0~\Zq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~\"sq\0~\0Fq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~&sq\0~\0^ڀq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0ayq\0~\'t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0lTFq\0~,t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\049q\0~,t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~1q\0~4xxpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~q\0~q\0~q\0~\Zq\0~#q\0~\'xsq\0~jt\0\nTransitionsq\0~\0R1q\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0p6q\0~9t\0transition11pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Ayq\0~9t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0=Zq\0~9t\0route3pq\0~zsq\0~\0q\0~zsq\0~\0sp7q\0~9t\0email2pt\0	Conditionsq\0~\0q\0~Jsq\0~\0GLsq\0~9t\0approvalStatus2 === \'Resubmit\'sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0/kQq\0~Kt\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~Oxt\0Descriptionsq\0~\02\0q\0~Tsq\0~\0]Vcq\0~9t\0\0t\0ExtendedAttributessq\0~\0\0q\0~Xsq\0~\0Rq\0~9t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0%q\0~Yt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0!q\0~^t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\05q\0~^t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~cq\0~fxsq\0~rt\0ExtendedAttributesq\0~\0+q\0~Yt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0	A0q\0~jt\0PBUILDER_TRANSITION_CONDITIONSpq\0~{sq\0~\0\0q\0~{sq\0~\0p-q\0~jt\0P[{\"join\":\"&&\",\"variable\":\"approvalStatus2\",\"operator\":\"===\",\"value\":\"Resubmit\"}]pxsq\0~\0E\0\0\0w\0\0\0q\0~oq\0~rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~>q\0~Aq\0~Dq\0~Gq\0~Kq\0~Uq\0~Yxsq\0~jt\0\nTransitionsq\0~\0r8zq\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0NOq\0~wt\0transition12pq\0~\0sq\0~\0\0q\0~\0sq\0~\0	>jq\0~wt\0\0pq\0~vsq\0~\0q\0~vsq\0~\0&3q\0~wt\0route3pq\0~zsq\0~\0q\0~zsq\0~\0 aq\0~wt\0email4pt\0	Conditionsq\0~\0q\0~sq\0~\08`q\0~wt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\07Űq\0~t\0	OTHERWISEsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\01q\0~wt\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0v~q\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0}q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0fRq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0]9o)q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~|q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\0,q\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0uniq\0~t\0transition15pq\0~\0sq\0~\0\0q\0~\0sq\0~\0<q\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0{q\0~t\0route2pq\0~zsq\0~\0q\0~zsq\0~\0*q\0~t\0tool5pt\0	Conditionsq\0~\0q\0~sq\0~\0q\0~t\0approvalStatus1 === \'Rejected\'sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0a4Uq\0~t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0vq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0Dv`gq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0=},q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0	!Lq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0xYq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\0o@7q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0;q\0~t\0PBUILDER_TRANSITION_CONDITIONSpq\0~{sq\0~\0\0q\0~{sq\0~\0#q\0~t\0P[{\"join\":\"&&\",\"variable\":\"approvalStatus1\",\"operator\":\"===\",\"value\":\"Rejected\"}]pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\0i\'q\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\087q\0~t\0transition16pq\0~\0sq\0~\0\0q\0~\0sq\0~\0KFq\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0:q\0~t\0tool5pq\0~zsq\0~\0q\0~zsq\0~\0[cq\0~t\0tool6pt\0	Conditionsq\0~\0q\0~sq\0~\0Xq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0@]q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0hKq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0o<q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0b˅q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0*\rq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0z~Gq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0eq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0j Gq\0~t\0%JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDERpq\0~{sq\0~\0\0q\0~{sq\0~\0*Oq\0~t\0requester;approver1;approver2pxsq\0~\0E\0\0\0w\0\0\0q\0~#q\0~&xsq\0~rt\0ExtendedAttributesq\0~\0\nHHq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0(q\0~*t\0JaWE_GRAPH_START_OF_WORKFLOWpq\0~{sq\0~\0\0q\0~{sq\0~\0@Mtq\0~*t\0JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=email1,X_OFFSET=180,Y_OFFSET=60,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~/q\0~2xsq\0~rt\0ExtendedAttributesq\0~\0xq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Wq\0~6t\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~{sq\0~\0\0q\0~{sq\0~\09Hq\0~6t\0JaWE_GRAPH_PARTICIPANT_ID=approver2,CONNECTING_ACTIVITY_ID=email4,X_OFFSET=1440,Y_OFFSET=500,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~;q\0~>xsq\0~rt\0ExtendedAttributesq\0~\0;JCq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0-5q\0~Bt\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~{sq\0~\0\0q\0~{sq\0~\0wtq\0~Bt\0JaWE_GRAPH_PARTICIPANT_ID=approver1,CONNECTING_ACTIVITY_ID=tool6,X_OFFSET=1800,Y_OFFSET=280,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~Gq\0~Jxsq\0~rt\0ExtendedAttributesq\0~\0V6_q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0ބq\0~Nt\0Auto_Layoutpq\0~{sq\0~\0\0q\0~{sq\0~\0/qq\0~Nt\0truepxsq\0~\0E\0\0\0w\0\0\0q\0~Sq\0~Vxxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~q\0~q\0~q\0~q\0~q\0~1q\0~7q\0~Oq\0~Uq\0~\\q\0~cq\0~eq\0~xsq\0~t\0WorkflowProcesssq\0~\0:EIq\0~t\0\0sq\0~\0w\0\0\0\rq\0~\0sq\0~\0q\0~\0sq\0~\0jc.q\0~[t\0populateChart2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0dq\0~[t\0Populate Data For Chartspq\0~sq\0~\0\0q\0~sq\0~\0bq\0~[q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0\rProcessHeadersq\0~q\0~isq\0~\0o0wq\0~[t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0+q\0~jt\0hsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~q\0~q\0~xt\0Createdsq\0~\0-\0q\0~rsq\0~\0	c%#q\0~jt\0\0t\0Descriptionsq\0~\02\0q\0~vsq\0~\0nq\0~jt\0\0t\0Prioritysq\0~\0q\0~zsq\0~\0mq\0~jt\0\0t\0Limitsq\0~\0q\0~~sq\0~\0\"G3q\0~jt\0\0t\0	ValidFromsq\0~\0q\0~sq\0~\02Pq\0~jt\0\0t\0ValidTosq\0~\0q\0~sq\0~\07^q\0~jt\0\0t\0TimeEstimationsq\0~\0q\0~sq\0~\0~q\0~jt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0e丯q\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0=$q\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0ZSq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~nq\0~sq\0~wq\0~{q\0~q\0~q\0~q\0~xt\0RedefinableHeadersq\0~\0H\0q\0~sq\0~\07q\0~[t\0\0sq\0~\0w\0\0\0q\0~\0Msq\0~\0\0q\0~\0Msq\0~\0\\tq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~\0Rq\0~\0Sq\0~\0Txt\0Authorsq\0~\0V\0q\0~sq\0~\0Aq\0~t\0\0t\0Versionsq\0~\0[\0q\0~sq\0~\0q\0~t\0\0t\0Codepagesq\0~\0`\0q\0~sq\0~\01Sq\0~t\0\0t\0\nCountrykeysq\0~\0e\0q\0~sq\0~\0KW]q\0~t\0\0t\0Responsiblessq\0~\0j\0q\0~sq\0~\0et q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~xt\0FormalParameterssq\0~\0q\0~sq\0~\0<:Nq\0~[t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nDataFieldssq\0~\0q\0~sq\0~\0(ȗLq\0~[t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Participantssq\0~\0\0q\0~sq\0~\0qiUq\0~[t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Applicationssq\0~s\0q\0~sq\0~\05Hq\0~[t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ActivitySetssq\0~[\0q\0~sq\0~\0[q\0~[t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nActivitiessq\0~b\0q\0~sq\0~\07aq\0~[t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Activitysq\0~\0d\0Iq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\\ׇq\0~t\0tool2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0\n4[]q\0~t\0\ZPopulate Stock Data Tablespt\0Descriptionsq\0~\02\0q\0~sq\0~\0Iq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0(\0\rq\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0NQq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0fhq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0+Lq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0\'m}q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0=Iq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\09Zq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0,q\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0c!q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0idq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~#sq\0~\0Z\"<q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~\'sq\0~\0Xq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~\Zq\0~q\0~$q\0~(xxsq\0~t\0SubFlowsq\0~\0h\n.q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0 sq\0~.t\0\0pq\0~sq\0~\0\0q\0~sq\0~\073q\0~.q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~9sq\0~\0YLq\0~.t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~3q\0~6q\0~:xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\07ڰq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0t^q\0~At\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Fxxq\0~t\0	Performersq\0~\0q\0~Jsq\0~\0Sq\0~t\0participant4t\0	StartModesq\0~\0q\0~Nsq\0~\0wq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0T}q\0~Ot\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0q\0~St\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0w7q\0~St\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0^Aq\0~St\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Wxsq\0~\0E\0\0\0w\0\0\0q\0~Sxt\0\nFinishModesq\0~\0q\0~jsq\0~\0{q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0$$q\0~kt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0t߲q\0~ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0zq\0~ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\01q\0~ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~sxsq\0~\0E\0\0\0w\0\0\0q\0~oxt\0Prioritysq\0~\0q\0~sq\0~\0sICq\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~sq\0~\0!r{zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0CIVq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0Sq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~sq\0~\0jqIq\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0Xq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0S1!q\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0v/Jq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0:q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~8\0q\0~sq\0~\0q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0Hq\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~sq\0~\0Rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0]q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0!Yq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0J{q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0il9)q\0~t\0participant4pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\0Qfq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0>q\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0wq\0~t\0540,280pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~Kq\0~Oq\0~kq\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~ht\0Activitysq\0~\0({kq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0kq\0~t\0populateDataChart2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0EI3q\0~t\0Populate Standard Data Tablespt\0Descriptionsq\0~\02\0q\0~sq\0~\0f_~q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0<q\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0\0\'q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0Eq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0>mq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0\\}q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0T\rGsq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0W?q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\Z?q\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0m6۫q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0sq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~#sq\0~\0Ahq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~\Zq\0~ q\0~$xxsq\0~t\0SubFlowsq\0~\0hgq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\\q\0~*t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0bjq\0~*q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~5sq\0~\0=wq\0~*t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~/q\0~2q\0~6xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0vq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0=q\0~=t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Bxxq\0~t\0	Performersq\0~\0q\0~Fsq\0~\0ftq\0~t\0participant4t\0	StartModesq\0~\0q\0~Jsq\0~\0BZq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0M13q\0~Kt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0	#q\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0.(q\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Seq\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Sxsq\0~\0E\0\0\0w\0\0\0q\0~Oxt\0\nFinishModesq\0~\0q\0~fsq\0~\0>q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0^q\0~gt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0r~q\0~kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0rq\0~kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Eq\0~kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~oxsq\0~\0E\0\0\0w\0\0\0q\0~kxt\0Prioritysq\0~\0q\0~sq\0~\0p{q\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~sq\0~\0vc9q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\09q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0xMnq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~sq\0~\0TXq\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0?*q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0EWq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0PJq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0H9q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~8\0q\0~sq\0~\0vq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0yY3q\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~sq\0~\0|Bq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0x\"Fq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0̑q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Bccq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0\0]]q\0~t\0participant4pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\0-^dq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0r|<\Zq\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0	EMq\0~t\0360,280pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~Gq\0~Kq\0~gq\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~ht\0Activitysq\0~\0gq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0*դq\0~t\0populateMeetingDatapq\0~\0sq\0~\0\0q\0~\0sq\0~\0>f*q\0~t\0Populate Meeting Datapt\0Descriptionsq\0~\02\0q\0~sq\0~\0-iq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0lq\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0bq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0vErq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0G?q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0XJq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0t.q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0tlq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0#stq\0~\nt\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0r:q\0~\nq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0mq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0P%q\0~\nt\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0hJ\0q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~ xxsq\0~t\0SubFlowsq\0~\0)q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0`q\0~&t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0 5q\0~&q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~1sq\0~\0#Lq\0~&t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~+q\0~.q\0~2xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0\'N>q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0 Eq\0~9t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~>xxq\0~t\0	Performersq\0~\0q\0~Bsq\0~\0	zxq\0~t\0participant4t\0	StartModesq\0~\0q\0~Fsq\0~\08S\Zq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0llq\0~Gt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\01Iq\0~Kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0_xyq\0~Kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0u	q\0~Kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Oxsq\0~\0E\0\0\0w\0\0\0q\0~Kxt\0\nFinishModesq\0~\0q\0~bsq\0~\00&q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Kq\0~ct\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0sAq\0~gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0:Pжq\0~gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0I#q\0~gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~kxsq\0~\0E\0\0\0w\0\0\0q\0~gxt\0Prioritysq\0~\0q\0~~sq\0~\0<Gq\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~sq\0~\0	Xq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\05{q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0eq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~sq\0~\0q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0l;q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0jUKq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0aq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0W0q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~8\0q\0~sq\0~\0|zq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0<q\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~sq\0~\0N/q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0gtq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0v݀q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0yfq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0XCq\0~t\0participant4pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\03q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Cq\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0-Tq\0~t\0720,280pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~Cq\0~Gq\0~cq\0~q\0~q\0~q\0~q\0~q\0~q\0~xxt\0Transitionssq\0~d\0q\0~sq\0~\0q\0~[t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~jt\0\nTransitionsq\0~\01q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0x/q\0~t\0transition1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0`uq\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0%Dq\0~t\0populateDataChart2pq\0~zsq\0~\0q\0~zsq\0~\01\ZBq\0~t\0tool2pt\0	Conditionsq\0~\0q\0~sq\0~\0XJ;q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Y+|5q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0>䙄q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0q\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0zq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0Dq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\0Ϣq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0t4q\0~t\0transition2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0_Aq\0~t\0tool2pq\0~zsq\0~\0q\0~zsq\0~\0?R5q\0~t\0populateMeetingDatapt\0	Conditionsq\0~\0q\0~sq\0~\0m18q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Dq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~!xt\0Descriptionsq\0~\02\0q\0~%sq\0~\0Qq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~)sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0	q\0~*t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0d>q\0~/t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0dSqq\0~/t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~4q\0~7xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~&q\0~*xxt\0ExtendedAttributessq\0~\0\0q\0~<sq\0~\0IG{q\0~[t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0/ݧq\0~=t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~Bt\0%JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDERpq\0~{sq\0~\0\0q\0~{sq\0~\0?Nq\0~Bt\0participant4pxsq\0~\0E\0\0\0w\0\0\0q\0~Gq\0~Jxsq\0~rt\0ExtendedAttributesq\0~\0C<q\0~=t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0O_q\0~Nt\0JaWE_GRAPH_START_OF_WORKFLOWpq\0~{sq\0~\0\0q\0~{sq\0~\01oSVq\0~Nt\0JaWE_GRAPH_PARTICIPANT_ID=participant4,CONNECTING_ACTIVITY_ID=populateDataChart2,X_OFFSET=180,Y_OFFSET=280,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~Sq\0~Vxsq\0~rt\0ExtendedAttributesq\0~\0RFq\0~=t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0tQGq\0~Zt\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~{sq\0~\0\0q\0~{sq\0~\0O%q\0~Zt\0JaWE_GRAPH_PARTICIPANT_ID=participant4,CONNECTING_ACTIVITY_ID=populateMeetingData,X_OFFSET=900,Y_OFFSET=280,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~_q\0~bxsq\0~rt\0ExtendedAttributesq\0~\0Dyq\0~=t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0&ۡQq\0~ft\0Auto_Layoutpq\0~{sq\0~\0\0q\0~{sq\0~\0\\6q\0~ft\0truepxsq\0~\0E\0\0\0w\0\0\0q\0~kq\0~nxxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~`q\0~cq\0~fq\0~jq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~=xxt\0ExtendedAttributessq\0~\0\0q\0~ssq\0~\08$q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\00{q\0~tt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Cq\0~yt\0EDITING_TOOLpq\0~{sq\0~\0\0q\0~{sq\0~\0Pq\0~yt\0Web Workflow Designerpxsq\0~\0E\0\0\0w\0\0\0q\0~~q\0~xsq\0~rt\0ExtendedAttributesq\0~\0o~q\0~tt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0xq\0~t\0EDITING_TOOL_VERSIONpq\0~{sq\0~\0\0q\0~{sq\0~\0v8q\0~t\0\r5.0-pre-alphapxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~\0q\0~\0q\0~\0q\0~\0Iq\0~\0tq\0~\0q\0~\0q\0~\0q\0~\0q\0~tq\0~q\0~q\0~tx\0sq\0~\0w\0\0\0\0xt\01sr\0*org.enhydra.shark.xpdl.elements.Namespaces|<.R\0\0xq\0~\0kt\0\nNamespacessq\0~\0POq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.Namespacez_\0\0xq\0~\0t\0	Namespacesq\0~\0Lq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0t q\0~t\0xpdlpq\0~\0sq\0~\0q\0~\0sq\0~\0ZMq\0~t\0 http://www.wfmc.org/2002/XPDL1.0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xx',1000214,4,1000215,0);
/*!40000 ALTER TABLE `SHKXPDLData` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLHistory`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKXPDLHistory` (
  `XPDLId` varchar(90) NOT NULL,
  `XPDLVersion` varchar(20) NOT NULL,
  `XPDLClassVersion` bigint(20) NOT NULL,
  `XPDLUploadTime` datetime NOT NULL,
  `XPDLHistoryUploadTime` datetime NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLHistory` (`XPDLId`,`XPDLVersion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLHistory`
--

LOCK TABLES `SHKXPDLHistory` WRITE;
/*!40000 ALTER TABLE `SHKXPDLHistory` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKXPDLHistory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLHistoryData`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKXPDLHistoryData` (
  `XPDLContent` mediumblob NOT NULL,
  `XPDLClassContent` mediumblob NOT NULL,
  `XPDLHistory` decimal(19,0) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLHistoryData` (`CNT`),
  KEY `SHKXPDLHistoryData_XPDLHistory` (`XPDLHistory`),
  CONSTRAINT `SHKXPDLHistoryData_XPDLHistory` FOREIGN KEY (`XPDLHistory`) REFERENCES `SHKXPDLHistory` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLHistoryData`
--

LOCK TABLES `SHKXPDLHistoryData` WRITE;
/*!40000 ALTER TABLE `SHKXPDLHistoryData` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKXPDLHistoryData` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLParticipantPackage`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKXPDLParticipantPackage` (
  `PACKAGE_ID` varchar(90) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLParticipantPackage` (`PACKAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLParticipantPackage`
--

LOCK TABLES `SHKXPDLParticipantPackage` WRITE;
/*!40000 ALTER TABLE `SHKXPDLParticipantPackage` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKXPDLParticipantPackage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLParticipantProcess`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKXPDLParticipantProcess` (
  `PROCESS_ID` varchar(90) NOT NULL,
  `PACKAGEOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLParticipantProcess` (`PROCESS_ID`,`PACKAGEOID`),
  KEY `SHKXPDLParticipantProcess_PACKAGEOID` (`PACKAGEOID`),
  CONSTRAINT `SHKXPDLParticipantProcess_PACKAGEOID` FOREIGN KEY (`PACKAGEOID`) REFERENCES `SHKXPDLParticipantPackage` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLParticipantProcess`
--

LOCK TABLES `SHKXPDLParticipantProcess` WRITE;
/*!40000 ALTER TABLE `SHKXPDLParticipantProcess` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKXPDLParticipantProcess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLReferences`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKXPDLReferences` (
  `ReferredXPDLId` varchar(90) NOT NULL,
  `ReferringXPDL` decimal(19,0) NOT NULL,
  `ReferredXPDLNumber` int(11) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLReferences` (`ReferredXPDLId`,`ReferringXPDL`),
  KEY `SHKXPDLReferences_ReferringXPDL` (`ReferringXPDL`),
  CONSTRAINT `SHKXPDLReferences_ReferringXPDL` FOREIGN KEY (`ReferringXPDL`) REFERENCES `SHKXPDLS` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLReferences`
--

LOCK TABLES `SHKXPDLReferences` WRITE;
/*!40000 ALTER TABLE `SHKXPDLReferences` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKXPDLReferences` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLS`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `SHKXPDLS` (
  `XPDLId` varchar(90) NOT NULL,
  `XPDLVersion` varchar(20) NOT NULL,
  `XPDLClassVersion` bigint(20) NOT NULL,
  `XPDLUploadTime` datetime NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLS` (`XPDLId`,`XPDLVersion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLS`
--

LOCK TABLES `SHKXPDLS` WRITE;
/*!40000 ALTER TABLE `SHKXPDLS` DISABLE KEYS */;
INSERT INTO `SHKXPDLS` VALUES
('crm','1',1184650391000,'2025-11-27 08:11:10',1000202,0),
('expenseclaim','1',1184650391000,'2025-11-27 08:11:15',1000206,0),
('isr','1',1184650391000,'2025-11-27 08:11:17',1000210,0),
('JogetDxShowcase','1',1184650391000,'2025-11-27 08:11:19',1000214,0);
/*!40000 ALTER TABLE `SHKXPDLS` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_app`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `app_app` (
  `appId` varchar(255) NOT NULL,
  `appVersion` bigint(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `published` bit(1) DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `dateModified` datetime DEFAULT NULL,
  `license` text DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `meta` longtext DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`appId`,`appVersion`),
  KEY `idx_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_app`
--

LOCK TABLES `app_app` WRITE;
/*!40000 ALTER TABLE `app_app` DISABLE KEYS */;
INSERT INTO `app_app` VALUES
('appcenter',1,'App Center',0x01,'2025-11-27 08:11:33','2025-11-27 08:11:33','oRIgWuw8ed5OmS98TSZFxocskOFXU0v3VPneM0k80NqSBK2r6RhNzTNTryZkuj4W',NULL,NULL,'roleSystem'),
('competitor_research',1,'Competitor Research',0x01,'2025-11-27 08:11:13','2025-11-27 08:11:15','SZ8eX4bCumZvfT27zOsOD+NA+Bjnrk0CmNP2XykzIylMviGR6KN1UN+McwU4ucGlRdLsR13ku2Fy7RrEiWRymg==',NULL,NULL,'roleSystem'),
('crm',1,'Customer Relationship Management',0x01,'2025-11-27 08:11:09','2025-11-27 08:11:13','Vfe6Df5AdlrGEPqFYgTt8XuGJ4XiTt2NnBLEovw3qoQ=',NULL,NULL,'roleSystem'),
('expenseclaim',1,'Expenses Claim',0x01,'2025-11-27 08:11:15','2025-11-27 08:11:17','cggLRcAgu9fsi9+Evtai7+EX+Fx2lx0tRzfPsTbAfbQCrT5RWUgR7w==',NULL,NULL,'roleSystem'),
('isr',1,'Internal Service Request',0x01,'2025-11-27 08:11:17','2025-11-27 08:11:18','BXiIDyi75K/balSfhqm1i7aycpqYcRKBBPMkO7zfnto=',NULL,NULL,'roleSystem'),
('JogetDxShowcase',1,'Joget DX Showcase',0x01,'2025-11-27 08:11:18','2025-11-27 08:11:30','1i44Neuka7RRu+22/jBpdqFp/tdq4ijmTtjtQIzB0iiChu98G79hNHSaJF+QK4EE',NULL,NULL,'roleSystem');
/*!40000 ALTER TABLE `app_app` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_builder`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `app_builder` (
  `appId` varchar(255) NOT NULL,
  `appVersion` bigint(20) NOT NULL,
  `id` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `dateModified` datetime DEFAULT NULL,
  `json` longtext DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  PRIMARY KEY (`appId`,`appVersion`,`id`),
  KEY `idx_name` (`name`),
  KEY `idx_type` (`type`),
  CONSTRAINT `FK_idup4nrrc79iy4kc46wf5919j` FOREIGN KEY (`appId`, `appVersion`) REFERENCES `app_app` (`appId`, `appVersion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_builder`
--

LOCK TABLES `app_builder` WRITE;
/*!40000 ALTER TABLE `app_builder` DISABLE KEYS */;
INSERT INTO `app_builder` VALUES
('appcenter',1,'APP_OVERVIEW_DEFINITION','-1702905276',NULL,'2025-06-05 11:20:15','2025-06-05 11:20:15','{\"datalist:list_newTemplate\":{\"data\":[{\"path\":\"rowActions[1].properties.href\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"javascript:AdminBar.showQuickOverlay(\'#request.contextPath#/web/desktop/marketplace/app?url=\' + encodeURIComponent(\'#platform.marketplaceUrl#/jw/web/userview/mp/mpp/_/vad?id={id}\'))\"},{\"path\":\"rowActions[1].properties.href\",\"isError\":false,\"label\":\"#platform.marketplaceUrl#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"javascript:AdminBar.showQuickOverlay(\'#request.contextPath#/web/desktop/marketplace/app?url=\' + encodeURIComponent(\'#platform.marketplaceUrl#/jw/web/userview/mp/mpp/_/vad?id={id}\'))\"},{\"path\":\"binder.properties.jsonUrl\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#request.baseURL#/web/json/marketplace/list?type=Template&isNew=true&rows=2&sort=name&desc=false\"},{\"badgeColor\":\"#2e7d32\",\"path\":\"binder.properties.jsonUrl\",\"badge\":\"JSON\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.IntegrationOverviewTool\",\"content\":\"#request.baseURL#/web/json/marketplace/list?type=Template&isNew=true&rows=2&sort=name&desc=false\"}],\"lastModifiedDate\":\"Feb 6, 2025, 1:33:17\\u202fPM\"},\"datalist:list_appList\":{\"data\":[{\"path\":\"columns[0].format.properties.script\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.BeanShellOverviewTool\",\"content\":\"return value + \\\" <i class=\\\\\\\"fas fa-star\\\\\\\" style=\\\\\\\"color:#FDDA0D;\\\\\\\"><\\/i>\\\" \"},{\"path\":\"columns[1].format.properties.script\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.BeanShellOverviewTool\",\"content\":\"return \\\"by\\\" + (value.equals(\\\"Joget, Inc.\\\")?\\\"<span class=\\\\\\\"badge badge-light-primary\\\\\\\">Joget, Inc.<\\/span>\\\":\\\"<span class=\\\\\\\"badge badge-light-info\\\\\\\">\\\"+value+\\\"<\\/span>\\\")\"},{\"path\":\"columns[4].format.properties.script\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.BeanShellOverviewTool\",\"content\":\"return \\\"<i class=\\\\\\\"zmdi zmdi-download\\\\\\\"><\\/i> \\\" + value;\"},{\"path\":\"rowActions[1].properties.href\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"javascript:AdminBar.showQuickOverlay(\'#request.contextPath#/web/desktop/marketplace/app?url=\' + encodeURIComponent(\'#platform.marketplaceUrl#/jw/web/userview/mp/mpp/_/vad?id={id}\'))\"},{\"path\":\"rowActions[1].properties.href\",\"isError\":false,\"label\":\"#platform.marketplaceUrl#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"javascript:AdminBar.showQuickOverlay(\'#request.contextPath#/web/desktop/marketplace/app?url=\' + encodeURIComponent(\'#platform.marketplaceUrl#/jw/web/userview/mp/mpp/_/vad?id={id}\'))\"},{\"path\":\"binder.properties.jsonUrl\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#request.baseURL#/web/json/marketplace/list?type=Template&search={name}\"},{\"badgeColor\":\"#2e7d32\",\"path\":\"binder.properties.jsonUrl\",\"badge\":\"JSON\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.IntegrationOverviewTool\",\"content\":\"#request.baseURL#/web/json/marketplace/list?type=Template&search={name}\"}],\"lastModifiedDate\":\"Feb 6, 2025, 1:33:17\\u202fPM\"},\"datalist:applist\":{\"data\":[{\"path\":\"columns[0].format.properties.script\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.BeanShellOverviewTool\",\"content\":\"return \\\"v\\\" + value;\"},{\"path\":\"columns[1].format.properties.script\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.BeanShellOverviewTool\",\"content\":\"import org.joget.workflow.model.service.WorkflowManager;\\nimport org.joget.apps.app.service.AppUtil;\\n\\n    int count = 0; // Initialize count to avoid uninitialized variable error\\n    try {\\n        String appId = value;\\n        WorkflowManager wm = (WorkflowManager) AppUtil.getApplicationContext().getBean(\\\"workflowManager\\\");\\n\\n        if (wm != null) { // Ensure wm is not null before calling the method\\n            count = wm.getAssignmentSize(appId, null, null);\\n        } \\n    } catch (Exception e) {}\\n\\n\\tif (count > 0) {\\n    return \\\"<span class=\\\\\\\"jgt-count-badge\\\\\\\">\\\" \\n         + \\\"<i class=\\\\\\\"far fa-bell\\\\\\\"><\\/i>\\\" + \\t\\t\\t  \\t\\t\\t\\t\\tString.valueOf(count) \\n         + \\\"<\\/span>\\\";\\n\\t}\\n    \\n\"},{\"path\":\"rowActions[0].properties.href\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#request.baseURL#/web/console/app\"},{\"path\":\"rowAction_card[0].properties.href\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#request.baseURL#/web/userview\"},{\"path\":\"binder.properties.jsonUrl\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#request.baseURL#/web/json/apps/published/userviews?appCenter=true\"},{\"badgeColor\":\"#2e7d32\",\"path\":\"binder.properties.jsonUrl\",\"badge\":\"JSON\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.IntegrationOverviewTool\",\"content\":\"#request.baseURL#/web/json/apps/published/userviews?appCenter=true\"},{\"path\":\"column_image[0].format.properties.defaultImage\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#request.baseURL#/web/userview/screenshot/appcenter/v\"}],\"lastModifiedDate\":\"Feb 6, 2025, 1:33:16\\u202fPM\"},\"userview:home\":{\"data\":[{\"path\":\"properties.footerMessage\",\"isError\":false,\"label\":\"#i18n.Powered by Joget#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#i18n.Powered by Joget#\"},{\"path\":\"categories[0].menus[0].referencePage.elements[0].properties.style-mobile-background-image\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#request.contextPath#/images/dx9AppCenter/appCenterBannerMobile.png\"},{\"path\":\"categories[0].menus[0].referencePage.elements[0].properties.style-background-image\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#request.contextPath#/images/dx9AppCenter/appCenterBanner.png\"},{\"path\":\"categories[0].menus[0].referencePage.elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<div class=\\\"bannerContent\\\">\\n        <\\/div>\\n<style>\\n.bannerContent {\\n            position: absolute;\\n            top: 0;\\n            left: 0;\\n            width: 100%;\\n            height: 100%;\\n            display: flex;\\n            align-items: center;\\n            justify-content: center;\\n            color: white; /* Adjust based on background image */\\n        }<\\/style>\"},{\"path\":\"categories[0].menus[0].referencePage.elements[1].elements[1].elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<span class=\\\"appCenterLabel\\\">\\n  App Center<\\/span>\\n<script>\\n    $(document).ready(function () {\\n    $(\'main #home.main-body-content #filters_applist\').hide();\\n    $(\\\"main #home.main-body-content\\\").before(\'<div id=\\\"customSearchSection\\\" style=\\\"display: flex; justify-content: center;\\\"><input id=\\\"customSearchInput\\\" type=\\\"text\\\" placeholder=\\\"Search Apps\\\"/><\\/div>\');\\n    $(\\\"#customSearchInput\\\").off(\\\"input\\\").on(\\\"input\\\", function () {\\n        const input = this.value.trim().toLowerCase();\\n        const apps = $(\\\"#dataList_applist .table-wrapper .cards.row\\\").children();\\n        if (input === \\\"\\\") {\\n            apps.show();\\n            return;\\n        }\\n        apps.each(function () {\\n            const $this = $(this);\\n            const name = $this.find(\\\".card-title\\\").text().trim().toLowerCase();\\n            const toggleCondition = name.includes(input) || name.replace(/[^\\\\p{L}\\\\p{N}]/gu, \'\').includes(input);\\n            $this.toggle(toggleCondition);\\n        });\\n    });\\n});\\n\\n$(document).ready(function () {\\n    setTimeout(function() {\\n        var $targetElement = $(\'#page > header > div > div > div.nav-no-collapse.header-nav > ul > li.inbox-notification.dropdown > a > span\');\\n        \\n        if ($targetElement.length) {\\n            var taskCount = $targetElement[0].innerText;\\n            var taskReminder;\\n\\t\\t\\tif($(\'.taskReminder\').length){\\n              $(\'.taskReminder\').remove();\\n            }\\n            if(taskCount > 0){\\n                taskReminder = `<a class=\\\"taskReminder badge badge-light\\\" href=\\\"/jw/web/userview/appcenter/home/_/_ja_inbox\\\">${taskCount} task(s)<span class=\\\"badge red\\\"><\\/span><\\/a>`;\\n            } else {\\n                taskReminder = `<a class=\\\"taskReminder badge badge-light\\\" href=\\\"/jw/web/userview/appcenter/home/_/_ja_inbox\\\">${taskCount} task(s)<\\/a>`;\\n            }\\n            \\n            $(\\\".appCenterLabel\\\").after(taskReminder);\\n        }\\n    }, 1000); // Delay execution by 1000 milliseconds (1 second)\\n});\\n<\\/script>\\n<style>\\n  /*General Styles*/\\n  button.primary {\\n    display: inline-block;\\n    font-size: 0.8rem;\\n    color: #fff !important;\\n    background: rgb(var(--vs-primary)/100%);\\n    padding: 13px 25px;\\n    border-radius: 17px;\\n    transition: background-color 0.1s ease;\\n    box-sizing: border-box;\\n    transition: all 0.25s ease;\\n    border: 0;\\n    cursor: pointer;\\n    box-shadow: 0 10px 20px -10px rgb(var(--vs-primary)/50%);\\n  }\\n\\n  button.primary:hover {\\n    box-shadow: 0 20px 20px -10px rgb(var(--vs-primary)/50%);\\n    transform: translateY(-5px);\\n  }\\n<\\/style>\"},{\"path\":\"categories[0].menus[0].referencePage.elements[1].elements[1].elements[1].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<div class=\\\"addNew dropdown dataList\\\">\\n  <button class=\\\"btn btn-primary dropdown-toggle more-action\\\" type=\\\"button\\\" id=\\\"dropdownMenuButton\\\" data-toggle=\\\"dropdown\\\" aria-haspopup=\\\"true\\\" aria-expanded=\\\"false\\\">\\n    Add New\\n  <\\/button>\\n  <div class=\\\"dropdown-menu dropdown-menu-right\\\" aria-labelledby=\\\"dropdownMenuButton\\\">\\n    <a onclick=\\\"document.getElementById(\'dialog\').close();\\\" data-pc-id=\\\"8EFC9D21190A4BFBE31A945826FF6B34\\\" href=\\\"design_app\\\" id=\\\"pc-8EFC9D21190A4BFBE31A945826FF6B34\\\" class=\\\"dropdown-item\\\"><i class=\\\"fas fa-pencil-ruler\\\"><\\/i>Design App<\\/a>\\n    <a class=\\\"dropdown-item\\\" onclick=\\\"appImport(); document.getElementById(\'dialog\').close(); return false;\\\" data-pc-id=\\\"10862931081E4DF47D44CCDFC696CAD6\\\" href=\\\"#\\\"><i class=\\\"zmdi zmdi-square-down\\\"><\\/i>Import App<\\/a>\\n    <a class=\\\"dropdown-item\\\" onclick=\\\"AdminBar.showQuickOverlay(\'/jw/web/desktop/marketplace/app?url=\' + encodeURIComponent(\'https://marketplace.joget.org\')); document.getElementById(\'dialog\').close(); return false;\\\" href=\\\"#\\\"><i class=\\\"fas fa-file-download\\\"><\\/i>Download From Marketplace<\\/a>\\n  <\\/div>\\n<\\/div>\"},{\"path\":\"categories[1].menus[0].properties.content\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<p>_<\\/p>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[0].elements[0].elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Start by creating a plain new app or using an existing template.\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[0].elements[0].elements[1].elements[0]\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.IntegrationOverviewTool\",\"content\":\"templates\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[0].elements[1].elements[0].elements[0].elements[0].properties.template\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<style>\\n    @media only screen and (min-width: 1681px) {\\n      .row_clone {\\n            display: none;\\n        }\\n    }\\n<\\/style>\\n<div class=\\\"card data-row\\\">\\n    <div class=\\\"card-body\\\">\\n        <div class=\\\"ph_columns column_5 column_body column_img body_column_5 card-text mb-1\\\">\\n            <div style=\\\"background-image:url(\'#request.contextPath#/images/dx9AppCenter/appCenterCreateApp.png\');height:0;padding-bottom:50%;width:100%;background-size:cover;background-repeat: no-repeat;display:inline-block;border-radius:0.625rem\\\"><\\/div>\\n        <\\/div> \\n        <div style=\\\"\\\" class=\\\"ph_columns column_0 column_body column_name body_column_0 card-text mb-1\\\">\\n            Create Your App\\n        <\\/div>     \\n        <div style=\\\"\\\" class=\\\"ph_columns column_6 column_body column_desc body_column_6 card-text mb-1\\\">\\n            <p>Create your own enterprise application with Joget. Get started now!<\\/p>\\n        <\\/div>\\n        <div class=\\\"card-actions\\\">\\n            <a href=\\\"javascript:appCreate(\'\');\\\" target=\\\"_self\\\" class=\\\"ph_rowActions rowAction_0 rowaction_body body_rowAction_0  btn btn-sm btn-primary link_rowAction_0\\\">Create New App<\\/a>\\n            <a href=\\\"\\\" style=\\\"visibility:hidden;\\\" class=\\\"ph_rowActions rowAction_0 rowaction_body body_rowAction_0  btn btn-sm btn-primary link_rowAction_0 row_clone\\\">Create New App<\\/a>\\n        <\\/div>\\n    <\\/div>\\n<\\/div>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[1].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Community\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[1].elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<div class=\\\"fs-5 text-dark fw-bold text-hover-primary text-dark lh-base text-gray-600\\\"><span>Joget provides an all encompassing ecosystem that supports community learning and adoption.<\\/span><\\/div>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[1].elements[2].elements[0].elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<div class=\\\"main-wrapper\\\">\\n\\t<a href=\\\"https://marketplace.joget.org/\\\" title=\\\"Visit Marketplace\\\" target=\\\"_blank\\\"><i class=\\\"material-icons fas fa-cart-arrow-down\\\"><\\/i><\\/a>\\n<\\/div>\\n<style>\\n.main-wrapper {\\n\\t\\tborder-radius: 4px;\\n\\t\\tpadding: 10px;\\n  \\t\\tpadding-left: 0px;\\n\\t\\tposition: relative;\\n\\t\\ttext-align: left;\\n}\\n\\ni.material-icons {\\n  \\t\\tborder: 2px solid var(--jgt-btn-colorPrimary);\\n\\t\\tfont-size: 1.5rem;\\n\\t\\tcolor: white;\\n\\t\\tposition: relative;\\n\\t\\tborder-radius: 20%;\\n\\t\\tpadding: 5px;\\n\\t\\twidth: 70px;\\n\\t\\theight: 70px;\\n\\t\\ttext-align:center;\\n\\t\\tbox-shadow: 0 1px 3px rgba(0, 0, 0, 0.12), 0 1px 2px rgba(0, 0, 0, 0.24);\\n\\t\\ttransition: color 0.2s ease, background-color 0.2s ease, transform 0.3s ease;\\n}\\n\\ni.material-icons:nth-of-type(1) {\\n\\t\\tbackground-color: var(--jgt-btn-colorPrimary);\\n}\\n\\ni.material-icons:nth-of-type(1):hover {\\n\\t\\tcolor: var(--jgt-btn-colorPrimary);\\n}\\n\\ni.material-icons:hover {\\n\\t\\tbackground-color: transparent;\\n\\t\\tcursor: pointer;\\n\\t\\tbox-shadow: none;\\n      \\tborder: 2px solid var(--jgt-btn-colorPrimary);\\n}\\n\\n\\ti.material-icons {\\n\\t\\tpadding:20px;\\n\\t\\tmargin-bottom:10px;\\n\\t}\\n\\ti.material-icons:after {\\n\\t\\tborder-width:3px;\\n\\t\\ttop:-3px;\\n\\t\\tleft:-3px;\\n}\\n<\\/style>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[1].elements[2].elements[0].elements[0].elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Marketplace\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[1].elements[2].elements[0].elements[0].elements[2].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<p class=\\\"CDesc\\\" style=\\\"text-align: left;\\\">Download ready made apps, plugins, templates and more from the Joget Marketplace.<\\/p>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[1].elements[2].elements[1].elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<div class=\\\"main-wrapper\\\">\\n    <a class=\\\"d-block overlay\\\" title=\\\"Join Q&A\\\" data-fslightbox=\\\"lightbox-hot-sales\\\" href=\\\"https://answers.joget.org/\\\" target=\\\"_blank\\\">\\n    <i class=\\\"material-icons far fa-comment\\\"><\\/i><\\/a><\\/div>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[1].elements[2].elements[1].elements[0].elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Community\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[1].elements[2].elements[1].elements[0].elements[2].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<p class=\\\"CDesc\\\" style=\\\"text-align: left;\\\">Join the Community Q&amp;A Site to ask questions, get answers, and help others in the Joget Community.<\\/p>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[1].elements[2].elements[2].elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<div class=\\\"main-wrapper\\\">\\n    <a href=\\\"https://community.joget.org/\\\" title=\\\"Learn More\\\"  target=\\\"_blank\\\">\\n        <i class=\\\"material-icons fas fa-book\\\"><\\/i>\\n    <\\/a>\\n<\\/div>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[1].elements[2].elements[2].elements[0].elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Knowledge Base\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[1].elements[2].elements[2].elements[0].elements[2].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<p class=\\\"CDesc\\\" style=\\\"text-align: left;\\\">Access additional tutorials, user and developer reference, samples and other documentation.<\\/p>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[1].elements[2].elements[3].elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<div class=\\\"main-wrapper\\\">\\n    <a href=\\\"https://github.com/jogetworkflow/jw-community\\\" title=\\\"Contribute\\\" target=\\\"_blank\\\">\\n    <i class=\\\"material-icons fas fa-code-branch\\\"><\\/i><\\/a><\\/div>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[1].elements[2].elements[3].elements[0].elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Open Source\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[1].elements[2].elements[3].elements[0].elements[2].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<p class=\\\"CDesc\\\" style=\\\"text-align: left;\\\">Join the open source GitHub project to access and contribute to the source code.<\\/p>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[1].elements[2].elements[4].elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<div class=\\\"main-wrapper\\\">\\n    <a href=\\\"https://translate.joget.org/\\\" title=\\\"Contribute\\\" target=\\\"_blank\\\">\\n\\t<i class=\\\"material-icons zmdi zmdi-translate\\\"><\\/i>\\n\\t<\\/a>\\n<\\/div>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[1].elements[2].elements[4].elements[0].elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Translations\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[1].elements[2].elements[4].elements[0].elements[2].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<p class=\\\"CDesc\\\" style=\\\"text-align: left;\\\">Get translations for more than 20 languages, and contribute to the translation effort in Joget Translations.<\\/p>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[2].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Tutorial\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[2].elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<div class=\\\"fs-5 text-dark fw-bold text-hover-primary text-dark lh-base text-gray-600\\\">\\n<div class=\\\"fs-5 text-dark fw-bold text-hover-primary text-dark lh-base text-gray-600\\\">Get a quick overview of Joget from the introductory and overview video tutorials or learn the in-depth workings of Joget by signing up for a free course at the Joget Academy.<\\/div>\\n<\\/div>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[2].elements[2].elements[0].elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<iframe class=\\\"embed-responsive-item card-rounded h-275px w-100\\\" src=\\\"https://www.youtube.com/embed/BXeqa6qkvUM\\\" allowfullscreen=\\\"allowfullscreen\\\" data-gtm-yt-inspected-11=\\\"true\\\" id=\\\"video1\\\" data-gtm-yt-inspected-31871541_91=\\\"true\\\" title=\\\"Part 1 -Designing a New App\\\" style=\\\"height: 250px;border: none;border-radius: 0.625rem;\\\"><\\/iframe>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[2].elements[2].elements[0].elements[0].elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Part 1 \\u2013 Designing a New App\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[2].elements[2].elements[1].elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<iframe class=\\\"embed-responsive-item card-rounded h-275px w-100\\\" style=\\\"height: 250px;border: none;border-radius: 0.625rem;\\\" src=\\\"https://www.youtube.com/embed/ANmu9ckiqvI\\\" allowfullscreen=\\\"allowfullscreen\\\" data-gtm-yt-inspected-11=\\\"true\\\" id=\\\"video2\\\" data-gtm-yt-inspected-31871541_91=\\\"true\\\" title=\\\"Part 2 - Designing a Form\\\"><\\/iframe>\\n\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[2].elements[2].elements[1].elements[0].elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Part 2 \\u2013 Designing a Form\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[2].elements[2].elements[2].elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<iframe class=\\\"embed-responsive-item card-rounded h-275px w-100\\\" style=\\\"height: 250px;border: none;border-radius: 0.625rem;\\\" src=\\\"https://www.youtube.com/embed/Z_mlAfVS_oQ\\\" allowfullscreen=\\\"allowfullscreen\\\" data-gtm-yt-inspected-11=\\\"true\\\" id=\\\"video3\\\" data-gtm-yt-inspected-31871541_91=\\\"true\\\" title=\\\"Part 3 - Designing a List\\\"><\\/iframe>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[2].elements[2].elements[2].elements[0].elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Part 3 \\u2013 Designing a List\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[2].elements[3].elements[0].elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<iframe class=\\\"embed-responsive-item card-rounded h-275px w-100\\\" style=\\\"height: 250px;border: none;border-radius: 0.625rem;\\\" src=\\\"https://www.youtube.com/embed/FxD6olBFwhc\\\" allowfullscreen=\\\"allowfullscreen\\\" data-gtm-yt-inspected-11=\\\"true\\\" id=\\\"video4\\\" data-gtm-yt-inspected-31871541_91=\\\"true\\\" title=\\\"Part 4 - Designing a UI\\\"><\\/iframe>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[2].elements[3].elements[0].elements[0].elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Part 4 \\u2013 Designing a Userview\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[2].elements[3].elements[1].elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<iframe class=\\\"embed-responsive-item card-rounded h-275px w-100\\\" style=\\\"height: 250px;border: none;border-radius: 0.625rem;\\\" src=\\\"https://www.youtube.com/embed/nzM_UtLzutA\\\" allowfullscreen=\\\"allowfullscreen\\\" data-gtm-yt-inspected-11=\\\"true\\\" id=\\\"video5\\\" data-gtm-yt-inspected-31871541_91=\\\"true\\\" title=\\\"Part 5 - Designing a Process\\\"><\\/iframe>\\n\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[2].elements[3].elements[1].elements[0].elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Part 5 \\u2013 Designing a Process\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[2].elements[3].elements[2].elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<iframe class=\\\"embed-responsive-item card-rounded h-275px w-100\\\" style=\\\"height: 250px;border: none;border-radius: 0.625rem;\\\" src=\\\"https://www.youtube.com/embed/TyEuH2roCDs\\\" allowfullscreen=\\\"allowfullscreen\\\" data-gtm-yt-inspected-11=\\\"true\\\" id=\\\"video6\\\" data-gtm-yt-inspected-31871541_91=\\\"true\\\" title=\\\"Watch Joget Generative AI in Action: Build Apps Faster Than Ever!\\\"><\\/iframe>\\n\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[2].elements[3].elements[2].elements[0].elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Joget Generative AI - Build Apps Faster Than Ever!\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[3].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Joget Academy\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[3].elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<div class=\\\"fs-5 text-dark fw-bold text-hover-primary text-dark lh-base text-gray-600\\\">\\n<div class=\\\"fs-5 text-dark fw-bold text-hover-primary text-dark lh-base text-gray-600\\\"><span>Joget Academy is a learning center for anyone to start learning how to build applications and automate business processes with or without coding.<\\/span><\\/div>\\n<\\/div>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[3].elements[2].elements[0].elements[0].elements[0].elements[0].properties.attr-src\",\"isError\":false,\"label\":\"#request.contextPath?html#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#request.contextPath?html#/images/dx9AppCenter/appCenterAcademy.png\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[3].elements[2].elements[0].elements[1].elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<span class=\\\"vc_icon_element-icon fa fa-graduation-cap\\\"><\\/span> Joget Courses - Learn at your own pace\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[3].elements[2].elements[0].elements[1].elements[0].elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<p>Discover expertise through our curated video courses<\\/p>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[3].elements[2].elements[0].elements[1].elements[0].elements[2]\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.IntegrationOverviewTool\",\"content\":\"https://academy.joget.org/lms/courses\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[4].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Connect With Us\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[4].elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<div class=\\\"fs-5 text-dark fw-bold text-hover-primary text-dark lh-base text-gray-600\\\">Stay updated with the latest information by joining us on our social media channels! Follow us to get real-time updates, news, and more.<\\/div>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[0].elements[4].elements[2].elements[0].elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"\\n<div class=\\\"social-btns\\\">\\n  <a class=\\\"btn facebook\\\" target=\\\"_blank\\\" href=\\\"https://www.facebook.com/jogetworkflow\\\"><i class=\\\"fa fa-facebook\\\"><\\/i><\\/a>\\n  <a class=\\\"btn twitter\\\" target=\\\"_blank\\\" href=\\\"https://x.com/jogetworkflow\\\"><i class=\\\"fa fa-twitter\\\"><\\/i><\\/a>\\n  <a class=\\\"btn linkin\\\" target=\\\"_blank\\\" href=\\\"https://www.linkedin.com/company/joget/\\\"><i class=\\\"fa fa-linkedin-in\\\"><\\/i><\\/a>\\n  <a class=\\\"btn youtube\\\" target=\\\"_blank\\\" href=\\\"https://www.youtube.com/user/jogetworkflow\\\"><i class=\\\"fa fa-youtube-play\\\"><\\/i><\\/a>\\n<\\/div>\\n\\n<style>\\n.social-btns .btn,\\n.social-btns .btn:before,\\n.social-btns .btn .fa {\\n  transition: all 0.35s;\\n  transition-timing-function: cubic-bezier(0.31, -0.105, 0.43, 1.59);\\n}\\n.social-btns .btn:before {\\n  top: 90%;\\n  left: -110%;\\n}\\n.social-btns .btn .fa {\\n  transform: scale(0.8);\\n}\\n.social-btns .btn.facebook:before {\\n  background-color: #3b5998;\\n}\\n.social-btns .btn.facebook .fa {\\n  color: #3b5998;\\n}\\n.social-btns .btn.twitter:before {\\n  background-color: #3cf;\\n}\\n.social-btns .btn.twitter .fa {\\n  color: #3cf;\\n}\\n.social-btns .btn.linkin:before {\\n  background-color: #0a66c1;\\n}\\n.social-btns .btn.linkin .fa {\\n  color: #0a66c1;\\n}\\n.social-btns .btn.youtube:before {\\n  background-color: #ff0f00;\\n}\\n.social-btns .btn.youtube .fa {\\n  color: #ff0f00;\\n}\\n.social-btns .btn:focus:before,\\n.social-btns .btn:hover:before {\\n  top: -10%;\\n  left: -10%;\\n}\\n.social-btns .btn:focus .fa,\\n.social-btns .btn:hover .fa {\\n  color: #fff;\\n  transform: scale(1);\\n}\\n.social-btns {\\n  margin: auto;\\n  font-size: 0;\\n  text-align: center;\\n  top: 0;\\n  bottom: 0;\\n  left: 0;\\n  right: 0;\\n}\\n.social-btns .btn {\\n  display: inline-block;\\n  background-color: #fff !important;\\n  width: 80px;\\n  height: 80px;\\n  line-height: 80px;\\n  margin: 0 10px;\\n  text-align: center;\\n  position: relative;\\n  overflow: hidden;\\n  border-radius: 28%;\\n  box-shadow: 0 5px 15px -5px rgba(0,0,0,0.1) !important;\\n  opacity: 0.99;\\n  border-color: transparent !important;\\n}\\n.social-btns .btn:before {\\n  content: \'\';\\n  width: 120%;\\n  height: 120%;\\n  position: absolute;\\n  transform: rotate(45deg);\\n}\\n.social-btns .btn .fa {\\n  font-size: 38px;\\n}\\n<\\/style>\"},{\"path\":\"categories[2].menus[0].referencePage.elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<p>Joget app templates are pre-built applications that help speed up the development process on the Joget platform. These templates include essential components like forms, lists, user interfaces, and workflows, making it easy to customize and deploy apps for specific business needs.<\\/p>\"},{\"path\":\"categories[3].menus[0].properties.content\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<p>_<\\/p>\"},{\"path\":\"categories[3].menus[0].referencePage.elements[0].elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Monitor\"},{\"path\":\"categories[3].menus[0].referencePage.elements[0].elements[0].elements[1].properties.link\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\"},{\"path\":\"categories[3].menus[0].referencePage.elements[0].elements[0].elements[1].properties.repeat\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#348FE2\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Transactions\\\",\\\"value\\\":\\\"#stats.transactionCount#\\\"},{\\\"color\\\":\\\"#ECBB0D\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Slow Traces\\\",\\\"value\\\":\\\"#stats.slowTrace#\\\"},{\\\"color\\\":\\\"#E2344F\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Error Count\\\",\\\"value\\\":\\\"#stats.errorCount#\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[0].elements[0].elements[1].properties.repeat\",\"isError\":false,\"label\":\"#stats.transactionCount#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#348FE2\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Transactions\\\",\\\"value\\\":\\\"#stats.transactionCount#\\\"},{\\\"color\\\":\\\"#ECBB0D\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Slow Traces\\\",\\\"value\\\":\\\"#stats.slowTrace#\\\"},{\\\"color\\\":\\\"#E2344F\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Error Count\\\",\\\"value\\\":\\\"#stats.errorCount#\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[0].elements[0].elements[1].properties.repeat\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#348FE2\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Transactions\\\",\\\"value\\\":\\\"#stats.transactionCount#\\\"},{\\\"color\\\":\\\"#ECBB0D\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Slow Traces\\\",\\\"value\\\":\\\"#stats.slowTrace#\\\"},{\\\"color\\\":\\\"#E2344F\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Error Count\\\",\\\"value\\\":\\\"#stats.errorCount#\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[0].elements[0].elements[1].properties.repeat\",\"isError\":false,\"label\":\"#stats.slowTrace#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#348FE2\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Transactions\\\",\\\"value\\\":\\\"#stats.transactionCount#\\\"},{\\\"color\\\":\\\"#ECBB0D\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Slow Traces\\\",\\\"value\\\":\\\"#stats.slowTrace#\\\"},{\\\"color\\\":\\\"#E2344F\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Error Count\\\",\\\"value\\\":\\\"#stats.errorCount#\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[0].elements[0].elements[1].properties.repeat\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#348FE2\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Transactions\\\",\\\"value\\\":\\\"#stats.transactionCount#\\\"},{\\\"color\\\":\\\"#ECBB0D\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Slow Traces\\\",\\\"value\\\":\\\"#stats.slowTrace#\\\"},{\\\"color\\\":\\\"#E2344F\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Error Count\\\",\\\"value\\\":\\\"#stats.errorCount#\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[0].elements[0].elements[1].properties.repeat\",\"isError\":false,\"label\":\"#stats.errorCount#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#348FE2\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Transactions\\\",\\\"value\\\":\\\"#stats.transactionCount#\\\"},{\\\"color\\\":\\\"#ECBB0D\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Slow Traces\\\",\\\"value\\\":\\\"#stats.slowTrace#\\\"},{\\\"color\\\":\\\"#E2344F\\\",\\\"link\\\":\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\",\\\"title\\\":\\\"Total Error Count\\\",\\\"value\\\":\\\"#stats.errorCount#\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[0].elements[0].elements[1].properties.repeat[0].link\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\"},{\"path\":\"categories[3].menus[0].referencePage.elements[0].elements[0].elements[1].properties.repeat[0].value\",\"isError\":false,\"label\":\"#stats.transactionCount#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.transactionCount#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[0].elements[0].elements[1].properties.repeat[1].link\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\"},{\"path\":\"categories[3].menus[0].referencePage.elements[0].elements[0].elements[1].properties.repeat[1].value\",\"isError\":false,\"label\":\"#stats.slowTrace#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.slowTrace#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[0].elements[0].elements[1].properties.repeat[2].link\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\"},{\"path\":\"categories[3].menus[0].referencePage.elements[0].elements[0].elements[1].properties.repeat[2].value\",\"isError\":false,\"label\":\"#stats.errorCount#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.errorCount#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[0].elements[0].properties.link\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/running\');\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[0].elements[0].properties.repeat\",\"isError\":false,\"label\":\"#stats.runningProcess#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#119C5D\\\",\\\"subvalue\\\":\\\"\\\",\\\"subtitle\\\":\\\"Running Process\\\",\\\"value\\\":\\\"#stats.runningProcess#\\\"},{\\\"color\\\":\\\"#B2B2B2\\\",\\\"subvalue\\\":\\\"\\\",\\\"subtitle\\\":\\\"Completed Process\\\",\\\"value\\\":\\\"#stats.completedProcess#\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[0].elements[0].properties.repeat\",\"isError\":false,\"label\":\"#stats.completedProcess#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#119C5D\\\",\\\"subvalue\\\":\\\"\\\",\\\"subtitle\\\":\\\"Running Process\\\",\\\"value\\\":\\\"#stats.runningProcess#\\\"},{\\\"color\\\":\\\"#B2B2B2\\\",\\\"subvalue\\\":\\\"\\\",\\\"subtitle\\\":\\\"Completed Process\\\",\\\"value\\\":\\\"#stats.completedProcess#\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[0].elements[0].properties.repeat[0].value\",\"isError\":false,\"label\":\"#stats.runningProcess#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.runningProcess#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[0].elements[0].properties.repeat[1].value\",\"isError\":false,\"label\":\"#stats.completedProcess#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.completedProcess#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[0].elements[1].elements[0].elements[0].properties.link\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/slogs\');\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[0].elements[1].elements[1].elements[0].properties.template\",\"isError\":false,\"label\":\"#stats.nodeCount#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'250px\', tags: \'dark-bg icon\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height||}}; \\n            background-color:{{color||#FFFFFF}};\\n            background-image:url(\'{{bgImg||}}\');\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload||<a class=\\\"reload\\\" style=\\\"color:inherit; opacity: 0.6; margin-left:5px;\\\" href=\\\"\\\"><i class=\\\"fas fa-redo\\\"><\\/i><\\/a>}}\\n    <\\/div>\\n    <div class=\\\"card-body text-center\\\">\\n        <div class=\\\"stats-icon\\\" \\n             style=\\\"font-size: 42px;\\n                    line-height:0;\\\">\\n            {{icon||<i class=\\\"fas fa-server\\\"> <\\/i>}}\\n        <\\/div>\\n        <div class=\\\"stats-info\\\">\\n            <p style=\\\"font-size: 18px;\\n                      font-weight: 600; \\n                      margin-bottom: 0;\\\">\\n                {{value||<br>}}\\n            <\\/p>\\n            <h4 style=\\\"font-size: 12px;\\n                       font-weight:bold; \\n                       margin: 5px 0;\\\">\\n                {{title||#stats.nodeCount#}}\\n            <\\/h4>\\n            {{description||Cluster Nodes Found}}\\n        <\\/div>\\n    <\\/div>\\n<\\/div>\\n<!---->\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[0].elements[1].elements[1].elements[0].properties.link\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[0].elements[1].elements[1].elements[0].properties.title\",\"isError\":false,\"label\":\"#stats.nodeCount#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.nodeCount#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.template\",\"isError\":false,\"label\":\"#stats.performance#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height||}};\\n            background-color:{{bgColor||}}; \\n            background-image:url(\'{{bgImg||}}\');\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row\\\">\\n            <div class=\\\"header-title col-8\\\" style=\\\"color:#000;height: auto;overflow: hidden;height:55px;white-space: nowrap;text-overflow: ellipsis;\\\">\\n                {{header||Governance Health Check (%)}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right pl-0\\\">\\n                <span class=\\\"badge\\\" \\n                      style=\\\"background-color:{{tagColor||#0BAB73}}; \\n                             color:#fff;font-weight: 500;\\\">\\n                    {{headerTag||Latest}}\\n                <\\/span>\\n                {{reload||<a class=\\\"reload\\\" style=\\\"color:inherit; opacity: 0.6; margin-left:5px;\\\" href=\\\"\\\"><i class=\\\"fas fa-redo\\\"><\\/i><\\/a>}}\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div> \\n    <div class=\\\"pt-3 pb-2 GHCInfo\\\" style=\\\"padding-inline: 13px;\\\">\\n        {{repeat||[{\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\"},{\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\"},{\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\"},{\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\"},{\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"},{\\\"title\\\":\\\"CPU Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#348FE2\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"}]}}\\n            <div class=\\\"px-3 pb-3\\\">\\n                <div class=\\\"mb-1\\\">\\n                    <span>\\n                        {{repeat.title}}\\n                    <\\/span>\\n                    <small class=\\\"float-right\\\">\\n                        {{repeat.value}}\\n                    <\\/small>\\n                <\\/div>\\n                <div class=\\\"progress progress-small\\\">\\n                    <div class=\\\"progress-bar\\\" \\n                         style=\\\"width: {{repeat.progressbar-value}}%; \\n                                transition: width .6s ease; \\n                                background-color:{{repeat.color}};\\\">\\n                    <\\/div>\\n                <\\/div>\\n            <\\/div>\\n        {{repeat}}\\n    <\\/div>\\n<\\/div>\\n<!---->\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.template\",\"isError\":false,\"label\":\"#stats.performance#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height||}};\\n            background-color:{{bgColor||}}; \\n            background-image:url(\'{{bgImg||}}\');\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row\\\">\\n            <div class=\\\"header-title col-8\\\" style=\\\"color:#000;height: auto;overflow: hidden;height:55px;white-space: nowrap;text-overflow: ellipsis;\\\">\\n                {{header||Governance Health Check (%)}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right pl-0\\\">\\n                <span class=\\\"badge\\\" \\n                      style=\\\"background-color:{{tagColor||#0BAB73}}; \\n                             color:#fff;font-weight: 500;\\\">\\n                    {{headerTag||Latest}}\\n                <\\/span>\\n                {{reload||<a class=\\\"reload\\\" style=\\\"color:inherit; opacity: 0.6; margin-left:5px;\\\" href=\\\"\\\"><i class=\\\"fas fa-redo\\\"><\\/i><\\/a>}}\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div> \\n    <div class=\\\"pt-3 pb-2 GHCInfo\\\" style=\\\"padding-inline: 13px;\\\">\\n        {{repeat||[{\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\"},{\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\"},{\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\"},{\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\"},{\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"},{\\\"title\\\":\\\"CPU Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#348FE2\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"}]}}\\n            <div class=\\\"px-3 pb-3\\\">\\n                <div class=\\\"mb-1\\\">\\n                    <span>\\n                        {{repeat.title}}\\n                    <\\/span>\\n                    <small class=\\\"float-right\\\">\\n                        {{repeat.value}}\\n                    <\\/small>\\n                <\\/div>\\n                <div class=\\\"progress progress-small\\\">\\n                    <div class=\\\"progress-bar\\\" \\n                         style=\\\"width: {{repeat.progressbar-value}}%; \\n                                transition: width .6s ease; \\n                                background-color:{{repeat.color}};\\\">\\n                    <\\/div>\\n                <\\/div>\\n            <\\/div>\\n        {{repeat}}\\n    <\\/div>\\n<\\/div>\\n<!---->\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.template\",\"isError\":false,\"label\":\"#stats.security#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height||}};\\n            background-color:{{bgColor||}}; \\n            background-image:url(\'{{bgImg||}}\');\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row\\\">\\n            <div class=\\\"header-title col-8\\\" style=\\\"color:#000;height: auto;overflow: hidden;height:55px;white-space: nowrap;text-overflow: ellipsis;\\\">\\n                {{header||Governance Health Check (%)}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right pl-0\\\">\\n                <span class=\\\"badge\\\" \\n                      style=\\\"background-color:{{tagColor||#0BAB73}}; \\n                             color:#fff;font-weight: 500;\\\">\\n                    {{headerTag||Latest}}\\n                <\\/span>\\n                {{reload||<a class=\\\"reload\\\" style=\\\"color:inherit; opacity: 0.6; margin-left:5px;\\\" href=\\\"\\\"><i class=\\\"fas fa-redo\\\"><\\/i><\\/a>}}\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div> \\n    <div class=\\\"pt-3 pb-2 GHCInfo\\\" style=\\\"padding-inline: 13px;\\\">\\n        {{repeat||[{\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\"},{\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\"},{\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\"},{\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\"},{\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"},{\\\"title\\\":\\\"CPU Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#348FE2\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"}]}}\\n            <div class=\\\"px-3 pb-3\\\">\\n                <div class=\\\"mb-1\\\">\\n                    <span>\\n                        {{repeat.title}}\\n                    <\\/span>\\n                    <small class=\\\"float-right\\\">\\n                        {{repeat.value}}\\n                    <\\/small>\\n                <\\/div>\\n                <div class=\\\"progress progress-small\\\">\\n                    <div class=\\\"progress-bar\\\" \\n                         style=\\\"width: {{repeat.progressbar-value}}%; \\n                                transition: width .6s ease; \\n                                background-color:{{repeat.color}};\\\">\\n                    <\\/div>\\n                <\\/div>\\n            <\\/div>\\n        {{repeat}}\\n    <\\/div>\\n<\\/div>\\n<!---->\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.template\",\"isError\":false,\"label\":\"#stats.security#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height||}};\\n            background-color:{{bgColor||}}; \\n            background-image:url(\'{{bgImg||}}\');\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row\\\">\\n            <div class=\\\"header-title col-8\\\" style=\\\"color:#000;height: auto;overflow: hidden;height:55px;white-space: nowrap;text-overflow: ellipsis;\\\">\\n                {{header||Governance Health Check (%)}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right pl-0\\\">\\n                <span class=\\\"badge\\\" \\n                      style=\\\"background-color:{{tagColor||#0BAB73}}; \\n                             color:#fff;font-weight: 500;\\\">\\n                    {{headerTag||Latest}}\\n                <\\/span>\\n                {{reload||<a class=\\\"reload\\\" style=\\\"color:inherit; opacity: 0.6; margin-left:5px;\\\" href=\\\"\\\"><i class=\\\"fas fa-redo\\\"><\\/i><\\/a>}}\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div> \\n    <div class=\\\"pt-3 pb-2 GHCInfo\\\" style=\\\"padding-inline: 13px;\\\">\\n        {{repeat||[{\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\"},{\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\"},{\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\"},{\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\"},{\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"},{\\\"title\\\":\\\"CPU Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#348FE2\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"}]}}\\n            <div class=\\\"px-3 pb-3\\\">\\n                <div class=\\\"mb-1\\\">\\n                    <span>\\n                        {{repeat.title}}\\n                    <\\/span>\\n                    <small class=\\\"float-right\\\">\\n                        {{repeat.value}}\\n                    <\\/small>\\n                <\\/div>\\n                <div class=\\\"progress progress-small\\\">\\n                    <div class=\\\"progress-bar\\\" \\n                         style=\\\"width: {{repeat.progressbar-value}}%; \\n                                transition: width .6s ease; \\n                                background-color:{{repeat.color}};\\\">\\n                    <\\/div>\\n                <\\/div>\\n            <\\/div>\\n        {{repeat}}\\n    <\\/div>\\n<\\/div>\\n<!---->\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.template\",\"isError\":false,\"label\":\"#stats.qualityAssurance#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height||}};\\n            background-color:{{bgColor||}}; \\n            background-image:url(\'{{bgImg||}}\');\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row\\\">\\n            <div class=\\\"header-title col-8\\\" style=\\\"color:#000;height: auto;overflow: hidden;height:55px;white-space: nowrap;text-overflow: ellipsis;\\\">\\n                {{header||Governance Health Check (%)}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right pl-0\\\">\\n                <span class=\\\"badge\\\" \\n                      style=\\\"background-color:{{tagColor||#0BAB73}}; \\n                             color:#fff;font-weight: 500;\\\">\\n                    {{headerTag||Latest}}\\n                <\\/span>\\n                {{reload||<a class=\\\"reload\\\" style=\\\"color:inherit; opacity: 0.6; margin-left:5px;\\\" href=\\\"\\\"><i class=\\\"fas fa-redo\\\"><\\/i><\\/a>}}\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div> \\n    <div class=\\\"pt-3 pb-2 GHCInfo\\\" style=\\\"padding-inline: 13px;\\\">\\n        {{repeat||[{\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\"},{\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\"},{\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\"},{\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\"},{\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"},{\\\"title\\\":\\\"CPU Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#348FE2\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"}]}}\\n            <div class=\\\"px-3 pb-3\\\">\\n                <div class=\\\"mb-1\\\">\\n                    <span>\\n                        {{repeat.title}}\\n                    <\\/span>\\n                    <small class=\\\"float-right\\\">\\n                        {{repeat.value}}\\n                    <\\/small>\\n                <\\/div>\\n                <div class=\\\"progress progress-small\\\">\\n                    <div class=\\\"progress-bar\\\" \\n                         style=\\\"width: {{repeat.progressbar-value}}%; \\n                                transition: width .6s ease; \\n                                background-color:{{repeat.color}};\\\">\\n                    <\\/div>\\n                <\\/div>\\n            <\\/div>\\n        {{repeat}}\\n    <\\/div>\\n<\\/div>\\n<!---->\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.template\",\"isError\":false,\"label\":\"#stats.qualityAssurance#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height||}};\\n            background-color:{{bgColor||}}; \\n            background-image:url(\'{{bgImg||}}\');\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row\\\">\\n            <div class=\\\"header-title col-8\\\" style=\\\"color:#000;height: auto;overflow: hidden;height:55px;white-space: nowrap;text-overflow: ellipsis;\\\">\\n                {{header||Governance Health Check (%)}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right pl-0\\\">\\n                <span class=\\\"badge\\\" \\n                      style=\\\"background-color:{{tagColor||#0BAB73}}; \\n                             color:#fff;font-weight: 500;\\\">\\n                    {{headerTag||Latest}}\\n                <\\/span>\\n                {{reload||<a class=\\\"reload\\\" style=\\\"color:inherit; opacity: 0.6; margin-left:5px;\\\" href=\\\"\\\"><i class=\\\"fas fa-redo\\\"><\\/i><\\/a>}}\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div> \\n    <div class=\\\"pt-3 pb-2 GHCInfo\\\" style=\\\"padding-inline: 13px;\\\">\\n        {{repeat||[{\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\"},{\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\"},{\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\"},{\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\"},{\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"},{\\\"title\\\":\\\"CPU Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#348FE2\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"}]}}\\n            <div class=\\\"px-3 pb-3\\\">\\n                <div class=\\\"mb-1\\\">\\n                    <span>\\n                        {{repeat.title}}\\n                    <\\/span>\\n                    <small class=\\\"float-right\\\">\\n                        {{repeat.value}}\\n                    <\\/small>\\n                <\\/div>\\n                <div class=\\\"progress progress-small\\\">\\n                    <div class=\\\"progress-bar\\\" \\n                         style=\\\"width: {{repeat.progressbar-value}}%; \\n                                transition: width .6s ease; \\n                                background-color:{{repeat.color}};\\\">\\n                    <\\/div>\\n                <\\/div>\\n            <\\/div>\\n        {{repeat}}\\n    <\\/div>\\n<\\/div>\\n<!---->\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.template\",\"isError\":false,\"label\":\"#stats.DbConnectionsCheck#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height||}};\\n            background-color:{{bgColor||}}; \\n            background-image:url(\'{{bgImg||}}\');\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row\\\">\\n            <div class=\\\"header-title col-8\\\" style=\\\"color:#000;height: auto;overflow: hidden;height:55px;white-space: nowrap;text-overflow: ellipsis;\\\">\\n                {{header||Governance Health Check (%)}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right pl-0\\\">\\n                <span class=\\\"badge\\\" \\n                      style=\\\"background-color:{{tagColor||#0BAB73}}; \\n                             color:#fff;font-weight: 500;\\\">\\n                    {{headerTag||Latest}}\\n                <\\/span>\\n                {{reload||<a class=\\\"reload\\\" style=\\\"color:inherit; opacity: 0.6; margin-left:5px;\\\" href=\\\"\\\"><i class=\\\"fas fa-redo\\\"><\\/i><\\/a>}}\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div> \\n    <div class=\\\"pt-3 pb-2 GHCInfo\\\" style=\\\"padding-inline: 13px;\\\">\\n        {{repeat||[{\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\"},{\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\"},{\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\"},{\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\"},{\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"},{\\\"title\\\":\\\"CPU Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#348FE2\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"}]}}\\n            <div class=\\\"px-3 pb-3\\\">\\n                <div class=\\\"mb-1\\\">\\n                    <span>\\n                        {{repeat.title}}\\n                    <\\/span>\\n                    <small class=\\\"float-right\\\">\\n                        {{repeat.value}}\\n                    <\\/small>\\n                <\\/div>\\n                <div class=\\\"progress progress-small\\\">\\n                    <div class=\\\"progress-bar\\\" \\n                         style=\\\"width: {{repeat.progressbar-value}}%; \\n                                transition: width .6s ease; \\n                                background-color:{{repeat.color}};\\\">\\n                    <\\/div>\\n                <\\/div>\\n            <\\/div>\\n        {{repeat}}\\n    <\\/div>\\n<\\/div>\\n<!---->\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.template\",\"isError\":false,\"label\":\"#stats.DbConnectionsCheck#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height||}};\\n            background-color:{{bgColor||}}; \\n            background-image:url(\'{{bgImg||}}\');\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row\\\">\\n            <div class=\\\"header-title col-8\\\" style=\\\"color:#000;height: auto;overflow: hidden;height:55px;white-space: nowrap;text-overflow: ellipsis;\\\">\\n                {{header||Governance Health Check (%)}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right pl-0\\\">\\n                <span class=\\\"badge\\\" \\n                      style=\\\"background-color:{{tagColor||#0BAB73}}; \\n                             color:#fff;font-weight: 500;\\\">\\n                    {{headerTag||Latest}}\\n                <\\/span>\\n                {{reload||<a class=\\\"reload\\\" style=\\\"color:inherit; opacity: 0.6; margin-left:5px;\\\" href=\\\"\\\"><i class=\\\"fas fa-redo\\\"><\\/i><\\/a>}}\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div> \\n    <div class=\\\"pt-3 pb-2 GHCInfo\\\" style=\\\"padding-inline: 13px;\\\">\\n        {{repeat||[{\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\"},{\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\"},{\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\"},{\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\"},{\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"},{\\\"title\\\":\\\"CPU Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#348FE2\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"}]}}\\n            <div class=\\\"px-3 pb-3\\\">\\n                <div class=\\\"mb-1\\\">\\n                    <span>\\n                        {{repeat.title}}\\n                    <\\/span>\\n                    <small class=\\\"float-right\\\">\\n                        {{repeat.value}}\\n                    <\\/small>\\n                <\\/div>\\n                <div class=\\\"progress progress-small\\\">\\n                    <div class=\\\"progress-bar\\\" \\n                         style=\\\"width: {{repeat.progressbar-value}}%; \\n                                transition: width .6s ease; \\n                                background-color:{{repeat.color}};\\\">\\n                    <\\/div>\\n                <\\/div>\\n            <\\/div>\\n        {{repeat}}\\n    <\\/div>\\n<\\/div>\\n<!---->\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.template\",\"isError\":false,\"label\":\"#stats.MemoryUsageCheck#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height||}};\\n            background-color:{{bgColor||}}; \\n            background-image:url(\'{{bgImg||}}\');\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row\\\">\\n            <div class=\\\"header-title col-8\\\" style=\\\"color:#000;height: auto;overflow: hidden;height:55px;white-space: nowrap;text-overflow: ellipsis;\\\">\\n                {{header||Governance Health Check (%)}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right pl-0\\\">\\n                <span class=\\\"badge\\\" \\n                      style=\\\"background-color:{{tagColor||#0BAB73}}; \\n                             color:#fff;font-weight: 500;\\\">\\n                    {{headerTag||Latest}}\\n                <\\/span>\\n                {{reload||<a class=\\\"reload\\\" style=\\\"color:inherit; opacity: 0.6; margin-left:5px;\\\" href=\\\"\\\"><i class=\\\"fas fa-redo\\\"><\\/i><\\/a>}}\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div> \\n    <div class=\\\"pt-3 pb-2 GHCInfo\\\" style=\\\"padding-inline: 13px;\\\">\\n        {{repeat||[{\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\"},{\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\"},{\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\"},{\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\"},{\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"},{\\\"title\\\":\\\"CPU Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#348FE2\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"}]}}\\n            <div class=\\\"px-3 pb-3\\\">\\n                <div class=\\\"mb-1\\\">\\n                    <span>\\n                        {{repeat.title}}\\n                    <\\/span>\\n                    <small class=\\\"float-right\\\">\\n                        {{repeat.value}}\\n                    <\\/small>\\n                <\\/div>\\n                <div class=\\\"progress progress-small\\\">\\n                    <div class=\\\"progress-bar\\\" \\n                         style=\\\"width: {{repeat.progressbar-value}}%; \\n                                transition: width .6s ease; \\n                                background-color:{{repeat.color}};\\\">\\n                    <\\/div>\\n                <\\/div>\\n            <\\/div>\\n        {{repeat}}\\n    <\\/div>\\n<\\/div>\\n<!---->\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.template\",\"isError\":false,\"label\":\"#stats.MemoryUsageCheck#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height||}};\\n            background-color:{{bgColor||}}; \\n            background-image:url(\'{{bgImg||}}\');\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row\\\">\\n            <div class=\\\"header-title col-8\\\" style=\\\"color:#000;height: auto;overflow: hidden;height:55px;white-space: nowrap;text-overflow: ellipsis;\\\">\\n                {{header||Governance Health Check (%)}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right pl-0\\\">\\n                <span class=\\\"badge\\\" \\n                      style=\\\"background-color:{{tagColor||#0BAB73}}; \\n                             color:#fff;font-weight: 500;\\\">\\n                    {{headerTag||Latest}}\\n                <\\/span>\\n                {{reload||<a class=\\\"reload\\\" style=\\\"color:inherit; opacity: 0.6; margin-left:5px;\\\" href=\\\"\\\"><i class=\\\"fas fa-redo\\\"><\\/i><\\/a>}}\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div> \\n    <div class=\\\"pt-3 pb-2 GHCInfo\\\" style=\\\"padding-inline: 13px;\\\">\\n        {{repeat||[{\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\"},{\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\"},{\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\"},{\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\"},{\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"},{\\\"title\\\":\\\"CPU Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#348FE2\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"}]}}\\n            <div class=\\\"px-3 pb-3\\\">\\n                <div class=\\\"mb-1\\\">\\n                    <span>\\n                        {{repeat.title}}\\n                    <\\/span>\\n                    <small class=\\\"float-right\\\">\\n                        {{repeat.value}}\\n                    <\\/small>\\n                <\\/div>\\n                <div class=\\\"progress progress-small\\\">\\n                    <div class=\\\"progress-bar\\\" \\n                         style=\\\"width: {{repeat.progressbar-value}}%; \\n                                transition: width .6s ease; \\n                                background-color:{{repeat.color}};\\\">\\n                    <\\/div>\\n                <\\/div>\\n            <\\/div>\\n        {{repeat}}\\n    <\\/div>\\n<\\/div>\\n<!---->\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.template\",\"isError\":false,\"label\":\"#stats.MemoryUsageCheck#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height||}};\\n            background-color:{{bgColor||}}; \\n            background-image:url(\'{{bgImg||}}\');\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row\\\">\\n            <div class=\\\"header-title col-8\\\" style=\\\"color:#000;height: auto;overflow: hidden;height:55px;white-space: nowrap;text-overflow: ellipsis;\\\">\\n                {{header||Governance Health Check (%)}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right pl-0\\\">\\n                <span class=\\\"badge\\\" \\n                      style=\\\"background-color:{{tagColor||#0BAB73}}; \\n                             color:#fff;font-weight: 500;\\\">\\n                    {{headerTag||Latest}}\\n                <\\/span>\\n                {{reload||<a class=\\\"reload\\\" style=\\\"color:inherit; opacity: 0.6; margin-left:5px;\\\" href=\\\"\\\"><i class=\\\"fas fa-redo\\\"><\\/i><\\/a>}}\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div> \\n    <div class=\\\"pt-3 pb-2 GHCInfo\\\" style=\\\"padding-inline: 13px;\\\">\\n        {{repeat||[{\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\"},{\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\"},{\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\"},{\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\"},{\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"},{\\\"title\\\":\\\"CPU Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#348FE2\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"}]}}\\n            <div class=\\\"px-3 pb-3\\\">\\n                <div class=\\\"mb-1\\\">\\n                    <span>\\n                        {{repeat.title}}\\n                    <\\/span>\\n                    <small class=\\\"float-right\\\">\\n                        {{repeat.value}}\\n                    <\\/small>\\n                <\\/div>\\n                <div class=\\\"progress progress-small\\\">\\n                    <div class=\\\"progress-bar\\\" \\n                         style=\\\"width: {{repeat.progressbar-value}}%; \\n                                transition: width .6s ease; \\n                                background-color:{{repeat.color}};\\\">\\n                    <\\/div>\\n                <\\/div>\\n            <\\/div>\\n        {{repeat}}\\n    <\\/div>\\n<\\/div>\\n<!---->\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.template\",\"isError\":false,\"label\":\"#stats.MemoryUsageCheck#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height||}};\\n            background-color:{{bgColor||}}; \\n            background-image:url(\'{{bgImg||}}\');\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row\\\">\\n            <div class=\\\"header-title col-8\\\" style=\\\"color:#000;height: auto;overflow: hidden;height:55px;white-space: nowrap;text-overflow: ellipsis;\\\">\\n                {{header||Governance Health Check (%)}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right pl-0\\\">\\n                <span class=\\\"badge\\\" \\n                      style=\\\"background-color:{{tagColor||#0BAB73}}; \\n                             color:#fff;font-weight: 500;\\\">\\n                    {{headerTag||Latest}}\\n                <\\/span>\\n                {{reload||<a class=\\\"reload\\\" style=\\\"color:inherit; opacity: 0.6; margin-left:5px;\\\" href=\\\"\\\"><i class=\\\"fas fa-redo\\\"><\\/i><\\/a>}}\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div> \\n    <div class=\\\"pt-3 pb-2 GHCInfo\\\" style=\\\"padding-inline: 13px;\\\">\\n        {{repeat||[{\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\"},{\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\"},{\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\"},{\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\"},{\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"},{\\\"title\\\":\\\"CPU Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#348FE2\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"}]}}\\n            <div class=\\\"px-3 pb-3\\\">\\n                <div class=\\\"mb-1\\\">\\n                    <span>\\n                        {{repeat.title}}\\n                    <\\/span>\\n                    <small class=\\\"float-right\\\">\\n                        {{repeat.value}}\\n                    <\\/small>\\n                <\\/div>\\n                <div class=\\\"progress progress-small\\\">\\n                    <div class=\\\"progress-bar\\\" \\n                         style=\\\"width: {{repeat.progressbar-value}}%; \\n                                transition: width .6s ease; \\n                                background-color:{{repeat.color}};\\\">\\n                    <\\/div>\\n                <\\/div>\\n            <\\/div>\\n        {{repeat}}\\n    <\\/div>\\n<\\/div>\\n<!---->\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.link\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/governance\');\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat\",\"isError\":false,\"label\":\"#stats.performance#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\",\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\",\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\",\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\",\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\",\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat\",\"isError\":false,\"label\":\"#stats.performance#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\",\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\",\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\",\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\",\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\",\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat\",\"isError\":false,\"label\":\"#stats.security#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\",\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\",\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\",\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\",\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\",\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat\",\"isError\":false,\"label\":\"#stats.security#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\",\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\",\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\",\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\",\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\",\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat\",\"isError\":false,\"label\":\"#stats.qualityAssurance#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\",\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\",\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\",\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\",\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\",\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat\",\"isError\":false,\"label\":\"#stats.qualityAssurance#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\",\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\",\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\",\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\",\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\",\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat\",\"isError\":false,\"label\":\"#stats.DbConnectionsCheck#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\",\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\",\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\",\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\",\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\",\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat\",\"isError\":false,\"label\":\"#stats.DbConnectionsCheck#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\",\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\",\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\",\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\",\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\",\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat\",\"isError\":false,\"label\":\"#stats.MemoryUsageCheck#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\",\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\",\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\",\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\",\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\",\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat\",\"isError\":false,\"label\":\"#stats.MemoryUsageCheck#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\",\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\",\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\",\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\",\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\"},{\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\",\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\"}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat[0].progressbar-value\",\"isError\":false,\"label\":\"#stats.performance#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.performance#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat[0].value\",\"isError\":false,\"label\":\"#stats.performance#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.performance#  %\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat[1].progressbar-value\",\"isError\":false,\"label\":\"#stats.security#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.security#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat[1].value\",\"isError\":false,\"label\":\"#stats.security#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.security#  %\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat[2].progressbar-value\",\"isError\":false,\"label\":\"#stats.qualityAssurance#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.qualityAssurance#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat[2].value\",\"isError\":false,\"label\":\"#stats.qualityAssurance#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.qualityAssurance#  %\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat[3].progressbar-value\",\"isError\":false,\"label\":\"#stats.DbConnectionsCheck#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.DbConnectionsCheck#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat[3].value\",\"isError\":false,\"label\":\"#stats.DbConnectionsCheck#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.DbConnectionsCheck#  %\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat[4].progressbar-value\",\"isError\":false,\"label\":\"#stats.MemoryUsageCheck#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.MemoryUsageCheck#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].elements[1].elements[0].properties.repeat[4].value\",\"isError\":false,\"label\":\"#stats.MemoryUsageCheck#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.MemoryUsageCheck# %\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[0].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Apps\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[0].elements[1].elements[0].elements[0].properties.link\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/desktop/apps\');\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[0].elements[1].elements[0].elements[0].properties.chartData\",\"isError\":false,\"label\":\"#stats.publishedAppCount#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"{data: [#stats.publishedAppCount#,#stats.unpublishedAppCount#]}\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[0].elements[1].elements[0].elements[0].properties.chartData\",\"isError\":false,\"label\":\"#stats.unpublishedAppCount#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"{data: [#stats.publishedAppCount#,#stats.unpublishedAppCount#]}\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[0].elements[1].elements[0].elements[0].properties.value\",\"isError\":false,\"label\":\"#stats.app.total#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.app.total#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[0].elements[1].elements[1].elements[0].properties.chartData\",\"isError\":false,\"label\":\"#stats.form.countPerApp#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"{data:[#stats.form.countPerApp#]}\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[0].elements[1].elements[1].elements[0].properties.value\",\"isError\":false,\"label\":\"#stats.form.total#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.form.total#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[0].elements[1].elements[1].elements[0].properties.chartLabels\",\"isError\":false,\"label\":\"#stats.appList#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.appList#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[0].elements[2].elements[0].elements[0].properties.chartData\",\"isError\":false,\"label\":\"#stats.list.countPerApp#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"{data:[#stats.list.countPerApp#]}\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[0].elements[2].elements[0].elements[0].properties.value\",\"isError\":false,\"label\":\"#stats.list.total#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.list.total#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[0].elements[2].elements[0].elements[0].properties.chartLabels\",\"isError\":false,\"label\":\"#stats.appList#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.appList#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[0].elements[2].elements[1].elements[0].properties.chartData\",\"isError\":false,\"label\":\"#stats.UI.countPerApp#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"{data:[#stats.UI.countPerApp#]}\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[0].elements[2].elements[1].elements[0].properties.value\",\"isError\":false,\"label\":\"#stats.UI.total#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.UI.total#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[0].elements[2].elements[1].elements[0].properties.chartLabels\",\"isError\":false,\"label\":\"#stats.appList#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.appList#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[1].elements[0].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Users\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[1].elements[1].elements[0].elements[0].properties.link\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/directory/users\');\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[1].elements[1].elements[0].elements[0].properties.chartData\",\"isError\":false,\"label\":\"#stats.user.active#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"{data: [#stats.user.active#,#stats.user.inactive#]}\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[1].elements[1].elements[0].elements[0].properties.chartData\",\"isError\":false,\"label\":\"#stats.user.inactive#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"{data: [#stats.user.active#,#stats.user.inactive#]}\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[1].elements[1].elements[0].elements[0].properties.value\",\"isError\":false,\"label\":\"#stats.user.total#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.user.total#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[1].elements[1].elements[1].elements[0].properties.link\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/directory/groups\');\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[1].elements[1].elements[1].elements[0].properties.chartData\",\"isError\":false,\"label\":\"#stats.group.countPerGroup#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{data:[#stats.group.countPerGroup#]}]\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[1].elements[1].elements[1].elements[0].properties.value\",\"isError\":false,\"label\":\"#stats.group.total#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.group.total#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[1].elements[1].elements[1].elements[0].properties.chartLabels\",\"isError\":false,\"label\":\"#stats.groupList#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#stats.groupList#\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[1].elements[2].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"Settings\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[1].elements[3].elements[0].elements[0].properties.link\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/setting/general\');\"},{\"path\":\"categories[3].menus[0].referencePage.elements[2].elements[1].elements[3].elements[1].elements[0].properties.link\",\"isError\":false,\"label\":\"#request.baseURL#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/setting/sysinfo\');\"},{\"path\":\"properties.footerMessage\",\"isError\":false,\"label\":\"#i18n.Powered by Joget#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#i18n.Powered by Joget#\"},{\"path\":\"setting.properties.theme.properties.org.joget.theme.lib.LoginPageComponent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.appCenterBanner.png#\"},{\"path\":\"setting.properties.theme.properties.template\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\"},{\"path\":\"setting.properties.theme.properties.template\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-matreding-10410088.jpg#\"},{\"path\":\"setting.properties.theme.properties.template\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-thisisengineering-3861959.jpg#\"},{\"path\":\"setting.properties.theme.properties.repeat\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\"},{\"path\":\"setting.properties.theme.properties.repeat\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-matreding-10410088.jpg#\"},{\"path\":\"setting.properties.theme.properties.repeat\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-thisisengineering-3861959.jpg#\"},{\"path\":\"setting.properties.theme.properties.css\",\"isError\":false,\"label\":\"#request.baseURL?html#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<\\/style>\\n<link rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"#request.baseURL?html#/css/appCenter9.css?build=#platform.build?html#\\\" />\\n<style>\\n#dataList_applist > form > div > div.cards.row > div > div > h5 > div{\\n    box-shadow: rgba(17, 17, 26, 0.1) 0px 1px 0px;\\n    border-radius: 20%;\\n}\\n#home #dataList_applist .card-icon:hover .card-actions a{\\n    display:block !important;\\n}\"},{\"path\":\"setting.properties.theme.properties.css\",\"isError\":false,\"label\":\"#platform.build?html#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<\\/style>\\n<link rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"#request.baseURL?html#/css/appCenter9.css?build=#platform.build?html#\\\" />\\n<style>\\n#dataList_applist > form > div > div.cards.row > div > div > h5 > div{\\n    box-shadow: rgba(17, 17, 26, 0.1) 0px 1px 0px;\\n    border-radius: 20%;\\n}\\n#home #dataList_applist .card-icon:hover .card-actions a{\\n    display:block !important;\\n}\"},{\"path\":\"setting.properties.theme.properties.logo\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#request.contextPath#/images/dx9AppCenter/appCenterJogetVerticalWhite.png\"},{\"path\":\"setting.properties.theme.properties.template\",\"isError\":false,\"label\":\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'carousel\'}-->\\r\\n<style>\\r\\n  body#login{\\r\\n      background-color: {{bgColor||#F4F6FA}};\\r\\n  }\\r\\n  .login-container-5 {\\r\\n    display: flex !important;\\r\\n    height: 100% !important;\\r\\n    background-size: cover !important;\\r\\n    background-position: center !important;\\r\\n    color: black;\\r\\n    background-color: {{bgColor||#F4F6FA}};\\r\\n  }\\r\\n  .login-form-5 {\\r\\n    border-radius: .8rem;\\r\\n    width: 100% !important;\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    background: {{cardColor||#FFFFFF}} !important;\\r\\n    height: 100% !important;\\r\\n  }\\r\\n  .input-container-5 {\\r\\n    position: relative !important;\\r\\n    margin-bottom: 1rem !important;\\r\\n  }\\r\\n  .login-form-5 input {\\r\\n    height: 45px !important;\\r\\n  }\\r\\n  .login-form-5 input::placeholder {\\r\\n    color: rgba(0, 0, 0, 0.5) !important;\\r\\n  }\\r\\n  .login-form-5 form button {\\r\\n    border-color: {{btnColor||#289FF5}};\\r\\n    background-color: {{btnColor||#289FF5}};\\r\\n    border: none;\\r\\n    height: 48px !important;\\r\\n  }\\r\\n  .login-form-5 label {\\r\\n    font-weight: 600;\\r\\n    margin-bottom: 4px;\\r\\n    text-align: left;\\r\\n    float: left;\\r\\n  }\\r\\n  .car-5 .carousel-inner img {\\r\\n    width: 100%;\\r\\n    height: auto;\\r\\n  }\\r\\n  .car-5 .carousel-control-prev, .carousel .carousel-control-next {\\r\\n    display:none;\\r\\n  }\\r\\n  .car-5 .carousel-indicators button{\\r\\n    background-color: #fff;\\r\\n    border: none;\\r\\n    margin-bottom: 5px;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-background {\\r\\n      background-repeat: no-repeat;\\r\\n  \\t  background-size: cover;\\r\\n  \\t  height: 100%;\\r\\n  } \\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    filter: contrast(85%) !important;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    background-color: rgba(0, 0, 0, 0.4) !important;\\r\\n    width: 100% !important;\\r\\n    bottom: 0px !important;\\r\\n    left:0px !important;\\r\\n    height: 200px;\\r\\n  }\\r\\n  .login-form-5 p {\\r\\n    color: var(--jgt-tpgh-colorTextDescription);\\r\\n    font-weight: 700;\\r\\n    font-size: 16px;\\r\\n  }\\r\\n  .login-form-5 #loginButton {\\r\\n    font-weight: 500;\\r\\n  }\\r\\n  .login-form-5 form {\\r\\n    padding: 3.75rem !important;\\r\\n    width: 100%;\\r\\n    max-width: 500px;\\r\\n    margin: auto;\\r\\n    height: 700px;\\r\\n    text-align: center;\\r\\n  }\\r\\n  .login-form-5 .carousel-indicators{\\r\\n      margin-bottom: 20px;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-5\\\">\\r\\n  <div class=\\\"login-form-5\\\">\\r\\n    <div class=\\\"row h-100\\\" style=\\\"margin:0\\\">\\r\\n      <div class=\\\"col-4 d-none d-sm-none d-md-block d-lg-block p-0 h-100\\\">\\r\\n        <!-- Carousel -->\\r\\n        <div id=\\\"carousel_{{id||}}\\\" class=\\\"carousel slide car-5\\\" data-ride=\\\"carousel\\\" style=\\\"height:100%\\\">\\r\\n          <div class=\\\"carousel-indicators\\\" data-hide=\\\"{{hideIndicator||false}}\\\"><\\/div>\\r\\n          <div class=\\\"carousel-inner\\\" style=\\\"height:100%\\\">\\r\\n            {{repeat||[{\\\"title\\\":\\\"Start Curious, Scale Serious.\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform With No-Code Simplicity\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\\\"},{\\\"title\\\":\\\"Step Up to Joget DX 8\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control With Enhanced Governance and UX.\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-matreding-10410088.jpg#\\\"},{\\\"title\\\":\\\"Future Ready\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-thisisengineering-3861959.jpg#\\\"}]}}\\r\\n            <div class=\\\"carousel-item carousel-background\\\" style=\\\"background-image:url(\'{{repeat.image}}\');\\\">\\r\\n              <div class=\\\"carousel-caption d-none d-md-block\\\" style=\\\"bottom:0px;\\\">\\r\\n                <h4 style=\\\"color:{{repeat.titleColor}};font-weight:700;\\\">{{repeat.title}}<\\/h4>\\r\\n                <p style=\\\"color:{{repeat.subtitleColor}}\\\">{{repeat.subtitle}}<\\/p>\\r\\n              <\\/div>\\r\\n            <\\/div>\\r\\n            {{repeat}}\\r\\n          <\\/div>\\r\\n        <\\/div>\\r\\n      <\\/div>\\r\\n      <div class=\\\"col-sm-12 col-md-8 p-4 p-lg-5 d-flex flex-column h-100\\\" style=\\\"justify-content: center;align-items: center;\\\">\\r\\n        <img src=\\\"/jw/web/app/appcenter/resources/Joget_Horizontal_Green.png\\\" loading=\\\"lazy\\\" alt=\\\"\\\" class=\\\"image\\\" style=\\\"width: 200px;\\\">\\r\\n        <form>\\r\\n          <h3 class=\\\"mb-2\\\" style=\\\"color: #000000;\\\">Sign In to App Center<\\/h3>\\r\\n          <p class=\\\"mb-4\\\">Welcome back! Please enter your details.<\\/p>\\r\\n          <div class=\\\"mb-3 input-container-5\\\">\\r\\n            <label>Username<\\/label>\\r\\n            <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"Enter your username\\\">\\r\\n          <\\/div>\\r\\n          <div class=\\\"mb-3 input-container-5\\\">\\r\\n            <label>Password<\\/label>\\r\\n            <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"Enter your password\\\">\\r\\n          <\\/div>\\r\\n          <button type=\\\"button\\\" class=\\\"btn btn-primary w-100 mt-4\\\" id=\\\"loginButton\\\">Sign In<\\/button>\\r\\n        <\\/form>\\r\\n      <\\/div>\\r\\n        <script>\\r\\n              $(function(){\\r\\n                  var carousel = $(\\\"#carousel_{{id||}}\\\");\\r\\n                  //create navigation link\\r\\n                  $(carousel).find(\\\".carousel-item\\\").each(function(i){\\r\\n                      $(carousel).find(\'.carousel-indicators\').append(\'<button class=\\\"mx-1\\\" data-target=\\\"#carousel_{{id||}}\\\" data-slide-to=\\\"\'+i+\'\\\"><\\/button>\');\\r\\n                  });\\r\\n                  //active first slide\\r\\n                  $(carousel).find(\\\".carousel-item:first-child, .carousel-indicators button:first-child\\\").addClass(\\\"active\\\");\\r\\n                  //Initialise carousel\\r\\n                  $(carousel).carousel();\\r\\n            });\\r\\n        <\\/script>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"setting.properties.theme.properties.template\",\"isError\":false,\"label\":\"#appResource.pexels-matreding-10410088.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'carousel\'}-->\\r\\n<style>\\r\\n  body#login{\\r\\n      background-color: {{bgColor||#F4F6FA}};\\r\\n  }\\r\\n  .login-container-5 {\\r\\n    display: flex !important;\\r\\n    height: 100% !important;\\r\\n    background-size: cover !important;\\r\\n    background-position: center !important;\\r\\n    color: black;\\r\\n    background-color: {{bgColor||#F4F6FA}};\\r\\n  }\\r\\n  .login-form-5 {\\r\\n    border-radius: .8rem;\\r\\n    width: 100% !important;\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    background: {{cardColor||#FFFFFF}} !important;\\r\\n    height: 100% !important;\\r\\n  }\\r\\n  .input-container-5 {\\r\\n    position: relative !important;\\r\\n    margin-bottom: 1rem !important;\\r\\n  }\\r\\n  .login-form-5 input {\\r\\n    height: 45px !important;\\r\\n  }\\r\\n  .login-form-5 input::placeholder {\\r\\n    color: rgba(0, 0, 0, 0.5) !important;\\r\\n  }\\r\\n  .login-form-5 form button {\\r\\n    border-color: {{btnColor||#289FF5}};\\r\\n    background-color: {{btnColor||#289FF5}};\\r\\n    border: none;\\r\\n    height: 48px !important;\\r\\n  }\\r\\n  .login-form-5 label {\\r\\n    font-weight: 600;\\r\\n    margin-bottom: 4px;\\r\\n    text-align: left;\\r\\n    float: left;\\r\\n  }\\r\\n  .car-5 .carousel-inner img {\\r\\n    width: 100%;\\r\\n    height: auto;\\r\\n  }\\r\\n  .car-5 .carousel-control-prev, .carousel .carousel-control-next {\\r\\n    display:none;\\r\\n  }\\r\\n  .car-5 .carousel-indicators button{\\r\\n    background-color: #fff;\\r\\n    border: none;\\r\\n    margin-bottom: 5px;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-background {\\r\\n      background-repeat: no-repeat;\\r\\n  \\t  background-size: cover;\\r\\n  \\t  height: 100%;\\r\\n  } \\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    filter: contrast(85%) !important;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    background-color: rgba(0, 0, 0, 0.4) !important;\\r\\n    width: 100% !important;\\r\\n    bottom: 0px !important;\\r\\n    left:0px !important;\\r\\n    height: 200px;\\r\\n  }\\r\\n  .login-form-5 p {\\r\\n    color: var(--jgt-tpgh-colorTextDescription);\\r\\n    font-weight: 700;\\r\\n    font-size: 16px;\\r\\n  }\\r\\n  .login-form-5 #loginButton {\\r\\n    font-weight: 500;\\r\\n  }\\r\\n  .login-form-5 form {\\r\\n    padding: 3.75rem !important;\\r\\n    width: 100%;\\r\\n    max-width: 500px;\\r\\n    margin: auto;\\r\\n    height: 700px;\\r\\n    text-align: center;\\r\\n  }\\r\\n  .login-form-5 .carousel-indicators{\\r\\n      margin-bottom: 20px;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-5\\\">\\r\\n  <div class=\\\"login-form-5\\\">\\r\\n    <div class=\\\"row h-100\\\" style=\\\"margin:0\\\">\\r\\n      <div class=\\\"col-4 d-none d-sm-none d-md-block d-lg-block p-0 h-100\\\">\\r\\n        <!-- Carousel -->\\r\\n        <div id=\\\"carousel_{{id||}}\\\" class=\\\"carousel slide car-5\\\" data-ride=\\\"carousel\\\" style=\\\"height:100%\\\">\\r\\n          <div class=\\\"carousel-indicators\\\" data-hide=\\\"{{hideIndicator||false}}\\\"><\\/div>\\r\\n          <div class=\\\"carousel-inner\\\" style=\\\"height:100%\\\">\\r\\n            {{repeat||[{\\\"title\\\":\\\"Start Curious, Scale Serious.\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform With No-Code Simplicity\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\\\"},{\\\"title\\\":\\\"Step Up to Joget DX 8\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control With Enhanced Governance and UX.\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-matreding-10410088.jpg#\\\"},{\\\"title\\\":\\\"Future Ready\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-thisisengineering-3861959.jpg#\\\"}]}}\\r\\n            <div class=\\\"carousel-item carousel-background\\\" style=\\\"background-image:url(\'{{repeat.image}}\');\\\">\\r\\n              <div class=\\\"carousel-caption d-none d-md-block\\\" style=\\\"bottom:0px;\\\">\\r\\n                <h4 style=\\\"color:{{repeat.titleColor}};font-weight:700;\\\">{{repeat.title}}<\\/h4>\\r\\n                <p style=\\\"color:{{repeat.subtitleColor}}\\\">{{repeat.subtitle}}<\\/p>\\r\\n              <\\/div>\\r\\n            <\\/div>\\r\\n            {{repeat}}\\r\\n          <\\/div>\\r\\n        <\\/div>\\r\\n      <\\/div>\\r\\n      <div class=\\\"col-sm-12 col-md-8 p-4 p-lg-5 d-flex flex-column h-100\\\" style=\\\"justify-content: center;align-items: center;\\\">\\r\\n        <img src=\\\"/jw/web/app/appcenter/resources/Joget_Horizontal_Green.png\\\" loading=\\\"lazy\\\" alt=\\\"\\\" class=\\\"image\\\" style=\\\"width: 200px;\\\">\\r\\n        <form>\\r\\n          <h3 class=\\\"mb-2\\\" style=\\\"color: #000000;\\\">Sign In to App Center<\\/h3>\\r\\n          <p class=\\\"mb-4\\\">Welcome back! Please enter your details.<\\/p>\\r\\n          <div class=\\\"mb-3 input-container-5\\\">\\r\\n            <label>Username<\\/label>\\r\\n            <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"Enter your username\\\">\\r\\n          <\\/div>\\r\\n          <div class=\\\"mb-3 input-container-5\\\">\\r\\n            <label>Password<\\/label>\\r\\n            <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"Enter your password\\\">\\r\\n          <\\/div>\\r\\n          <button type=\\\"button\\\" class=\\\"btn btn-primary w-100 mt-4\\\" id=\\\"loginButton\\\">Sign In<\\/button>\\r\\n        <\\/form>\\r\\n      <\\/div>\\r\\n        <script>\\r\\n              $(function(){\\r\\n                  var carousel = $(\\\"#carousel_{{id||}}\\\");\\r\\n                  //create navigation link\\r\\n                  $(carousel).find(\\\".carousel-item\\\").each(function(i){\\r\\n                      $(carousel).find(\'.carousel-indicators\').append(\'<button class=\\\"mx-1\\\" data-target=\\\"#carousel_{{id||}}\\\" data-slide-to=\\\"\'+i+\'\\\"><\\/button>\');\\r\\n                  });\\r\\n                  //active first slide\\r\\n                  $(carousel).find(\\\".carousel-item:first-child, .carousel-indicators button:first-child\\\").addClass(\\\"active\\\");\\r\\n                  //Initialise carousel\\r\\n                  $(carousel).carousel();\\r\\n            });\\r\\n        <\\/script>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"setting.properties.theme.properties.template\",\"isError\":false,\"label\":\"#appResource.pexels-thisisengineering-3861959.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'carousel\'}-->\\r\\n<style>\\r\\n  body#login{\\r\\n      background-color: {{bgColor||#F4F6FA}};\\r\\n  }\\r\\n  .login-container-5 {\\r\\n    display: flex !important;\\r\\n    height: 100% !important;\\r\\n    background-size: cover !important;\\r\\n    background-position: center !important;\\r\\n    color: black;\\r\\n    background-color: {{bgColor||#F4F6FA}};\\r\\n  }\\r\\n  .login-form-5 {\\r\\n    border-radius: .8rem;\\r\\n    width: 100% !important;\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    background: {{cardColor||#FFFFFF}} !important;\\r\\n    height: 100% !important;\\r\\n  }\\r\\n  .input-container-5 {\\r\\n    position: relative !important;\\r\\n    margin-bottom: 1rem !important;\\r\\n  }\\r\\n  .login-form-5 input {\\r\\n    height: 45px !important;\\r\\n  }\\r\\n  .login-form-5 input::placeholder {\\r\\n    color: rgba(0, 0, 0, 0.5) !important;\\r\\n  }\\r\\n  .login-form-5 form button {\\r\\n    border-color: {{btnColor||#289FF5}};\\r\\n    background-color: {{btnColor||#289FF5}};\\r\\n    border: none;\\r\\n    height: 48px !important;\\r\\n  }\\r\\n  .login-form-5 label {\\r\\n    font-weight: 600;\\r\\n    margin-bottom: 4px;\\r\\n    text-align: left;\\r\\n    float: left;\\r\\n  }\\r\\n  .car-5 .carousel-inner img {\\r\\n    width: 100%;\\r\\n    height: auto;\\r\\n  }\\r\\n  .car-5 .carousel-control-prev, .carousel .carousel-control-next {\\r\\n    display:none;\\r\\n  }\\r\\n  .car-5 .carousel-indicators button{\\r\\n    background-color: #fff;\\r\\n    border: none;\\r\\n    margin-bottom: 5px;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-background {\\r\\n      background-repeat: no-repeat;\\r\\n  \\t  background-size: cover;\\r\\n  \\t  height: 100%;\\r\\n  } \\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    filter: contrast(85%) !important;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    background-color: rgba(0, 0, 0, 0.4) !important;\\r\\n    width: 100% !important;\\r\\n    bottom: 0px !important;\\r\\n    left:0px !important;\\r\\n    height: 200px;\\r\\n  }\\r\\n  .login-form-5 p {\\r\\n    color: var(--jgt-tpgh-colorTextDescription);\\r\\n    font-weight: 700;\\r\\n    font-size: 16px;\\r\\n  }\\r\\n  .login-form-5 #loginButton {\\r\\n    font-weight: 500;\\r\\n  }\\r\\n  .login-form-5 form {\\r\\n    padding: 3.75rem !important;\\r\\n    width: 100%;\\r\\n    max-width: 500px;\\r\\n    margin: auto;\\r\\n    height: 700px;\\r\\n    text-align: center;\\r\\n  }\\r\\n  .login-form-5 .carousel-indicators{\\r\\n      margin-bottom: 20px;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-5\\\">\\r\\n  <div class=\\\"login-form-5\\\">\\r\\n    <div class=\\\"row h-100\\\" style=\\\"margin:0\\\">\\r\\n      <div class=\\\"col-4 d-none d-sm-none d-md-block d-lg-block p-0 h-100\\\">\\r\\n        <!-- Carousel -->\\r\\n        <div id=\\\"carousel_{{id||}}\\\" class=\\\"carousel slide car-5\\\" data-ride=\\\"carousel\\\" style=\\\"height:100%\\\">\\r\\n          <div class=\\\"carousel-indicators\\\" data-hide=\\\"{{hideIndicator||false}}\\\"><\\/div>\\r\\n          <div class=\\\"carousel-inner\\\" style=\\\"height:100%\\\">\\r\\n            {{repeat||[{\\\"title\\\":\\\"Start Curious, Scale Serious.\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform With No-Code Simplicity\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\\\"},{\\\"title\\\":\\\"Step Up to Joget DX 8\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control With Enhanced Governance and UX.\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-matreding-10410088.jpg#\\\"},{\\\"title\\\":\\\"Future Ready\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-thisisengineering-3861959.jpg#\\\"}]}}\\r\\n            <div class=\\\"carousel-item carousel-background\\\" style=\\\"background-image:url(\'{{repeat.image}}\');\\\">\\r\\n              <div class=\\\"carousel-caption d-none d-md-block\\\" style=\\\"bottom:0px;\\\">\\r\\n                <h4 style=\\\"color:{{repeat.titleColor}};font-weight:700;\\\">{{repeat.title}}<\\/h4>\\r\\n                <p style=\\\"color:{{repeat.subtitleColor}}\\\">{{repeat.subtitle}}<\\/p>\\r\\n              <\\/div>\\r\\n            <\\/div>\\r\\n            {{repeat}}\\r\\n          <\\/div>\\r\\n        <\\/div>\\r\\n      <\\/div>\\r\\n      <div class=\\\"col-sm-12 col-md-8 p-4 p-lg-5 d-flex flex-column h-100\\\" style=\\\"justify-content: center;align-items: center;\\\">\\r\\n        <img src=\\\"/jw/web/app/appcenter/resources/Joget_Horizontal_Green.png\\\" loading=\\\"lazy\\\" alt=\\\"\\\" class=\\\"image\\\" style=\\\"width: 200px;\\\">\\r\\n        <form>\\r\\n          <h3 class=\\\"mb-2\\\" style=\\\"color: #000000;\\\">Sign In to App Center<\\/h3>\\r\\n          <p class=\\\"mb-4\\\">Welcome back! Please enter your details.<\\/p>\\r\\n          <div class=\\\"mb-3 input-container-5\\\">\\r\\n            <label>Username<\\/label>\\r\\n            <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"Enter your username\\\">\\r\\n          <\\/div>\\r\\n          <div class=\\\"mb-3 input-container-5\\\">\\r\\n            <label>Password<\\/label>\\r\\n            <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"Enter your password\\\">\\r\\n          <\\/div>\\r\\n          <button type=\\\"button\\\" class=\\\"btn btn-primary w-100 mt-4\\\" id=\\\"loginButton\\\">Sign In<\\/button>\\r\\n        <\\/form>\\r\\n      <\\/div>\\r\\n        <script>\\r\\n              $(function(){\\r\\n                  var carousel = $(\\\"#carousel_{{id||}}\\\");\\r\\n                  //create navigation link\\r\\n                  $(carousel).find(\\\".carousel-item\\\").each(function(i){\\r\\n                      $(carousel).find(\'.carousel-indicators\').append(\'<button class=\\\"mx-1\\\" data-target=\\\"#carousel_{{id||}}\\\" data-slide-to=\\\"\'+i+\'\\\"><\\/button>\');\\r\\n                  });\\r\\n                  //active first slide\\r\\n                  $(carousel).find(\\\".carousel-item:first-child, .carousel-indicators button:first-child\\\").addClass(\\\"active\\\");\\r\\n                  //Initialise carousel\\r\\n                  $(carousel).carousel();\\r\\n            });\\r\\n        <\\/script>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"setting.properties.theme.properties.js\",\"isError\":false,\"label\":\"#request.baseURL?html#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<\\/script>\\n<script type=\\\"text/javascript\\\" src=\\\"#request.baseURL?html#/js/appCenter9.js?build=#platform.build?html#\\\"><\\/script>\\n<script>\"},{\"path\":\"setting.properties.theme.properties.js\",\"isError\":false,\"label\":\"#platform.build?html#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<\\/script>\\n<script type=\\\"text/javascript\\\" src=\\\"#request.baseURL?html#/js/appCenter9.js?build=#platform.build?html#\\\"><\\/script>\\n<script>\"},{\"path\":\"setting.properties.theme.properties.repeat\",\"isError\":false,\"label\":\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"image\\\":\\\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform With No-Code Simplicity\\\",\\\"title\\\":\\\"Start Curious, Scale Serious.\\\"},{\\\"image\\\":\\\"#appResource.pexels-matreding-10410088.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control With Enhanced Governance and UX.\\\",\\\"title\\\":\\\"Step Up to Joget DX 8\\\"},{\\\"image\\\":\\\"#appResource.pexels-thisisengineering-3861959.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"title\\\":\\\"Future Ready\\\"}]\"},{\"path\":\"setting.properties.theme.properties.repeat\",\"isError\":false,\"label\":\"#appResource.pexels-matreding-10410088.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"image\\\":\\\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform With No-Code Simplicity\\\",\\\"title\\\":\\\"Start Curious, Scale Serious.\\\"},{\\\"image\\\":\\\"#appResource.pexels-matreding-10410088.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control With Enhanced Governance and UX.\\\",\\\"title\\\":\\\"Step Up to Joget DX 8\\\"},{\\\"image\\\":\\\"#appResource.pexels-thisisengineering-3861959.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"title\\\":\\\"Future Ready\\\"}]\"},{\"path\":\"setting.properties.theme.properties.repeat\",\"isError\":false,\"label\":\"#appResource.pexels-thisisengineering-3861959.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"image\\\":\\\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform With No-Code Simplicity\\\",\\\"title\\\":\\\"Start Curious, Scale Serious.\\\"},{\\\"image\\\":\\\"#appResource.pexels-matreding-10410088.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control With Enhanced Governance and UX.\\\",\\\"title\\\":\\\"Step Up to Joget DX 8\\\"},{\\\"image\\\":\\\"#appResource.pexels-thisisengineering-3861959.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"title\\\":\\\"Future Ready\\\"}]\"},{\"path\":\"setting.properties.theme\",\"isError\":false,\"label\":\"org.joget.plugin.enterprise.BuilderTheme.theme_app_center_theme (Missing)\",\"tool\":\"org.joget.apps.app.lib.InstalledPluginOverviewTool\",\"content\":\"org.joget.plugin.enterprise.BuilderTheme.theme_app_center_theme\"},{\"path\":\"setting.properties.theme.properties.org.joget.theme.lib.LoginPageComponent.properties.image\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.appCenterBanner.png#\"},{\"path\":\"setting.properties.theme.properties.org.joget.theme.lib.LoginPageComponent.properties.template\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'carousel\'}-->\\r\\n<style>\\r\\n  #loginButton{\\r\\n      margin-top:15px;\\r\\n  }\\r\\n  body#login{\\r\\n      background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-container-5 {\\r\\n    display: flex !important;\\r\\n    height: 100% !important;\\r\\n    background-size: cover !important;\\r\\n    background-position: center !important;\\r\\n    color: black;\\r\\n    background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-form-5 {\\r\\n    border-radius: .8rem;\\r\\n    width: 100% !important;\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    background: #FFFFFF !important;\\r\\n    height: 100% !important;\\r\\n  }\\r\\n  .input-container-5 {\\r\\n    position: relative !important;\\r\\n    margin-bottom: 1rem !important;\\r\\n  }\\r\\n  .login-form-5 input {\\r\\n    height: 45px !important;\\r\\n  }\\r\\n  .login-form-5 input::placeholder {\\r\\n    color: rgba(0, 0, 0, 0.5) !important;\\r\\n  }\\r\\n  .login-form-5 form button {\\r\\n    border-color: #289FF5;\\r\\n    background-color: #289FF5;\\r\\n    border: none;\\r\\n    height: 48px !important;\\r\\n  }\\r\\n  .login-form-5 label {\\r\\n    font-weight: 600;\\r\\n    margin-bottom: 4px;\\r\\n    text-align: left;\\r\\n    float: left;\\r\\n  }\\r\\n  .car-5 .carousel-inner img {\\r\\n    width: 100%;\\r\\n    height: auto;\\r\\n  }\\r\\n  .car-5 .carousel-control-prev, .carousel .carousel-control-next {\\r\\n    display:none;\\r\\n  }\\r\\n  .car-5 .carousel-indicators button{\\r\\n    background-color: #fff;\\r\\n    border: none;\\r\\n    margin-bottom: 5px;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-background {\\r\\n      background-repeat: no-repeat;\\r\\n  \\t  background-size: cover;\\r\\n  \\t  height: 100%;\\r\\n  } \\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    filter: contrast(85%) !important;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    background-color: rgba(0, 0, 0, 0.4) !important;\\r\\n    width: 100% !important;\\r\\n    bottom: 0px !important;\\r\\n    left:0px !important;\\r\\n    height: 200px;\\r\\n  }\\r\\n  .login-form-5 p {\\r\\n    color: var(--jgt-tpgh-colorTextDescription);\\r\\n    font-weight: 700;\\r\\n    font-size: 16px;\\r\\n  }\\r\\n  .login-form-5 #loginButton {\\r\\n    font-weight: 500;\\r\\n  }\\r\\n  .login-form-5 form {\\r\\n    padding: 3.75rem !important;\\r\\n    width: 100%;\\r\\n    max-width: 500px;\\r\\n    margin: auto;\\r\\n    height: 700px;\\r\\n    text-align: center;\\r\\n  }\\r\\n  .login-form-5 .carousel-indicators{\\r\\n      margin-bottom: 20px;\\r\\n  }\\r\\n  @media (max-width: 767px){\\r\\n    .login-form-5 form {\\r\\n        padding: 3.75rem 0rem !important;\\r\\n    }\\r\\n  }\\r\\n  .login-form-5 input:focus:not([disabled]):not([readonly]),\\r\\n  .login-form-5 input:hover{\\r\\n      border-color: #009265 !important;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-5\\\">\\r\\n      <div class=\\\"login-form-5\\\">\\r\\n        <div class=\\\"row h-100\\\" style=\\\"margin:0\\\">\\r\\n          <div class=\\\"col-4 d-none d-sm-none d-md-block d-lg-block p-0 h-100\\\">\\r\\n            <!-- Carousel -->\\r\\n            <div id=\\\"carousel_{{id||}}\\\" class=\\\"carousel slide car-5\\\" data-ride=\\\"carousel\\\" style=\\\"height:100%\\\">\\r\\n              <div class=\\\"carousel-indicators\\\" data-hide=\\\"{{hideIndicator||false}}\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"carousel-inner\\\" style=\\\"height:100%\\\">\\r\\n              {{repeat||[{\\\"title\\\":\\\"Step Up to Joget DX 8\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control <br> With Enhanced Governance and UX.\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\\\"},{\\\"title\\\":\\\"Future Ready\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\\\"},{\\\"title\\\":\\\"Start Curious, Scale Serious.\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform <br> With No-Code Simplicity\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\\\"}]}}\\r\\n                <div class=\\\"carousel-item carousel-background\\\" style=\\\"background-image:url(\'{{repeat.image}}\');\\\">\\r\\n                  <div class=\\\"carousel-caption d-none d-md-block\\\" style=\\\"bottom:0px;\\\">\\r\\n                    <h4 style=\\\"color:{{repeat.titleColor}};font-weight:700;\\\">{{repeat.title}}<\\/h4>\\r\\n                      <p style=\\\"color:{{repeat.subtitleColor}}\\\">{{repeat.subtitle}}<\\/p>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n                {{repeat}}\\r\\n              <\\/div>\\r\\n            <\\/div>\\r\\n          <\\/div>\\r\\n          <div class=\\\"col-sm-12 col-md-8 p-4 p-lg-5 d-flex align-items-center justify-content-center h-100 flex-column text-center\\\">\\r\\n              <img src=\\\"#request.contextPath#/images/dx9AppCenter/appCenterJogetHorizontalGreen.png\\\" loading=\\\"lazy\\\" alt=\\\"\\\" class=\\\"image\\\" style=\\\"width: 200px;\\\">\\r\\n            <form style=\\\"width:100%;\\\">\\r\\n              <h2 class=\\\"mb-2\\\" style=\\\"{{titleColor||#000000}};\\\">{{title||Sign In to App Center}}<\\/h2>\\r\\n              <p class=\\\"mb-4\\\">Welcome back! Please enter your details.<\\/p>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customUsername||Username}}<\\/label>\\r\\n                <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"Enter your username\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customPassword||Password}}<\\/label>\\r\\n                <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"Enter your password\\\">\\r\\n              <\\/div>\\r\\n              <button type=\\\"button\\\" style=\\\"background-color:{{btnColor||#009265}};\\\" class=\\\"btn btn-primary w-100\\\" id=\\\"loginButton\\\">{{btnText||Sign In}}<\\/button>\\r\\n            <\\/form>\\r\\n          <\\/div>\\r\\n          <script>\\r\\n              $(function(){\\r\\n                  var carousel = $(\\\"#carousel_{{id||}}\\\");\\r\\n                  //create navigation link\\r\\n                  $(carousel).find(\\\".carousel-item\\\").each(function(i){\\r\\n                      $(carousel).find(\'.carousel-indicators\').append(\'<button class=\\\"mx-1\\\" data-target=\\\"#carousel_{{id||}}\\\" data-slide-to=\\\"\'+i+\'\\\"><\\/button>\');\\r\\n                  });\\r\\n                  //active first slide\\r\\n                  $(carousel).find(\\\".carousel-item:first-child, .carousel-indicators button:first-child\\\").addClass(\\\"active\\\");\\r\\n                  //Initialise carousel\\r\\n                  $(carousel).carousel();\\r\\n            });\\r\\n          <\\/script> \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"setting.properties.theme.properties.org.joget.theme.lib.LoginPageComponent.properties.template\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'carousel\'}-->\\r\\n<style>\\r\\n  #loginButton{\\r\\n      margin-top:15px;\\r\\n  }\\r\\n  body#login{\\r\\n      background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-container-5 {\\r\\n    display: flex !important;\\r\\n    height: 100% !important;\\r\\n    background-size: cover !important;\\r\\n    background-position: center !important;\\r\\n    color: black;\\r\\n    background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-form-5 {\\r\\n    border-radius: .8rem;\\r\\n    width: 100% !important;\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    background: #FFFFFF !important;\\r\\n    height: 100% !important;\\r\\n  }\\r\\n  .input-container-5 {\\r\\n    position: relative !important;\\r\\n    margin-bottom: 1rem !important;\\r\\n  }\\r\\n  .login-form-5 input {\\r\\n    height: 45px !important;\\r\\n  }\\r\\n  .login-form-5 input::placeholder {\\r\\n    color: rgba(0, 0, 0, 0.5) !important;\\r\\n  }\\r\\n  .login-form-5 form button {\\r\\n    border-color: #289FF5;\\r\\n    background-color: #289FF5;\\r\\n    border: none;\\r\\n    height: 48px !important;\\r\\n  }\\r\\n  .login-form-5 label {\\r\\n    font-weight: 600;\\r\\n    margin-bottom: 4px;\\r\\n    text-align: left;\\r\\n    float: left;\\r\\n  }\\r\\n  .car-5 .carousel-inner img {\\r\\n    width: 100%;\\r\\n    height: auto;\\r\\n  }\\r\\n  .car-5 .carousel-control-prev, .carousel .carousel-control-next {\\r\\n    display:none;\\r\\n  }\\r\\n  .car-5 .carousel-indicators button{\\r\\n    background-color: #fff;\\r\\n    border: none;\\r\\n    margin-bottom: 5px;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-background {\\r\\n      background-repeat: no-repeat;\\r\\n  \\t  background-size: cover;\\r\\n  \\t  height: 100%;\\r\\n  } \\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    filter: contrast(85%) !important;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    background-color: rgba(0, 0, 0, 0.4) !important;\\r\\n    width: 100% !important;\\r\\n    bottom: 0px !important;\\r\\n    left:0px !important;\\r\\n    height: 200px;\\r\\n  }\\r\\n  .login-form-5 p {\\r\\n    color: var(--jgt-tpgh-colorTextDescription);\\r\\n    font-weight: 700;\\r\\n    font-size: 16px;\\r\\n  }\\r\\n  .login-form-5 #loginButton {\\r\\n    font-weight: 500;\\r\\n  }\\r\\n  .login-form-5 form {\\r\\n    padding: 3.75rem !important;\\r\\n    width: 100%;\\r\\n    max-width: 500px;\\r\\n    margin: auto;\\r\\n    height: 700px;\\r\\n    text-align: center;\\r\\n  }\\r\\n  .login-form-5 .carousel-indicators{\\r\\n      margin-bottom: 20px;\\r\\n  }\\r\\n  @media (max-width: 767px){\\r\\n    .login-form-5 form {\\r\\n        padding: 3.75rem 0rem !important;\\r\\n    }\\r\\n  }\\r\\n  .login-form-5 input:focus:not([disabled]):not([readonly]),\\r\\n  .login-form-5 input:hover{\\r\\n      border-color: #009265 !important;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-5\\\">\\r\\n      <div class=\\\"login-form-5\\\">\\r\\n        <div class=\\\"row h-100\\\" style=\\\"margin:0\\\">\\r\\n          <div class=\\\"col-4 d-none d-sm-none d-md-block d-lg-block p-0 h-100\\\">\\r\\n            <!-- Carousel -->\\r\\n            <div id=\\\"carousel_{{id||}}\\\" class=\\\"carousel slide car-5\\\" data-ride=\\\"carousel\\\" style=\\\"height:100%\\\">\\r\\n              <div class=\\\"carousel-indicators\\\" data-hide=\\\"{{hideIndicator||false}}\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"carousel-inner\\\" style=\\\"height:100%\\\">\\r\\n              {{repeat||[{\\\"title\\\":\\\"Step Up to Joget DX 8\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control <br> With Enhanced Governance and UX.\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\\\"},{\\\"title\\\":\\\"Future Ready\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\\\"},{\\\"title\\\":\\\"Start Curious, Scale Serious.\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform <br> With No-Code Simplicity\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\\\"}]}}\\r\\n                <div class=\\\"carousel-item carousel-background\\\" style=\\\"background-image:url(\'{{repeat.image}}\');\\\">\\r\\n                  <div class=\\\"carousel-caption d-none d-md-block\\\" style=\\\"bottom:0px;\\\">\\r\\n                    <h4 style=\\\"color:{{repeat.titleColor}};font-weight:700;\\\">{{repeat.title}}<\\/h4>\\r\\n                      <p style=\\\"color:{{repeat.subtitleColor}}\\\">{{repeat.subtitle}}<\\/p>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n                {{repeat}}\\r\\n              <\\/div>\\r\\n            <\\/div>\\r\\n          <\\/div>\\r\\n          <div class=\\\"col-sm-12 col-md-8 p-4 p-lg-5 d-flex align-items-center justify-content-center h-100 flex-column text-center\\\">\\r\\n              <img src=\\\"#request.contextPath#/images/dx9AppCenter/appCenterJogetHorizontalGreen.png\\\" loading=\\\"lazy\\\" alt=\\\"\\\" class=\\\"image\\\" style=\\\"width: 200px;\\\">\\r\\n            <form style=\\\"width:100%;\\\">\\r\\n              <h2 class=\\\"mb-2\\\" style=\\\"{{titleColor||#000000}};\\\">{{title||Sign In to App Center}}<\\/h2>\\r\\n              <p class=\\\"mb-4\\\">Welcome back! Please enter your details.<\\/p>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customUsername||Username}}<\\/label>\\r\\n                <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"Enter your username\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customPassword||Password}}<\\/label>\\r\\n                <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"Enter your password\\\">\\r\\n              <\\/div>\\r\\n              <button type=\\\"button\\\" style=\\\"background-color:{{btnColor||#009265}};\\\" class=\\\"btn btn-primary w-100\\\" id=\\\"loginButton\\\">{{btnText||Sign In}}<\\/button>\\r\\n            <\\/form>\\r\\n          <\\/div>\\r\\n          <script>\\r\\n              $(function(){\\r\\n                  var carousel = $(\\\"#carousel_{{id||}}\\\");\\r\\n                  //create navigation link\\r\\n                  $(carousel).find(\\\".carousel-item\\\").each(function(i){\\r\\n                      $(carousel).find(\'.carousel-indicators\').append(\'<button class=\\\"mx-1\\\" data-target=\\\"#carousel_{{id||}}\\\" data-slide-to=\\\"\'+i+\'\\\"><\\/button>\');\\r\\n                  });\\r\\n                  //active first slide\\r\\n                  $(carousel).find(\\\".carousel-item:first-child, .carousel-indicators button:first-child\\\").addClass(\\\"active\\\");\\r\\n                  //Initialise carousel\\r\\n                  $(carousel).carousel();\\r\\n            });\\r\\n          <\\/script> \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"setting.properties.theme.properties.org.joget.theme.lib.LoginPageComponent.properties.template\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'carousel\'}-->\\r\\n<style>\\r\\n  #loginButton{\\r\\n      margin-top:15px;\\r\\n  }\\r\\n  body#login{\\r\\n      background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-container-5 {\\r\\n    display: flex !important;\\r\\n    height: 100% !important;\\r\\n    background-size: cover !important;\\r\\n    background-position: center !important;\\r\\n    color: black;\\r\\n    background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-form-5 {\\r\\n    border-radius: .8rem;\\r\\n    width: 100% !important;\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    background: #FFFFFF !important;\\r\\n    height: 100% !important;\\r\\n  }\\r\\n  .input-container-5 {\\r\\n    position: relative !important;\\r\\n    margin-bottom: 1rem !important;\\r\\n  }\\r\\n  .login-form-5 input {\\r\\n    height: 45px !important;\\r\\n  }\\r\\n  .login-form-5 input::placeholder {\\r\\n    color: rgba(0, 0, 0, 0.5) !important;\\r\\n  }\\r\\n  .login-form-5 form button {\\r\\n    border-color: #289FF5;\\r\\n    background-color: #289FF5;\\r\\n    border: none;\\r\\n    height: 48px !important;\\r\\n  }\\r\\n  .login-form-5 label {\\r\\n    font-weight: 600;\\r\\n    margin-bottom: 4px;\\r\\n    text-align: left;\\r\\n    float: left;\\r\\n  }\\r\\n  .car-5 .carousel-inner img {\\r\\n    width: 100%;\\r\\n    height: auto;\\r\\n  }\\r\\n  .car-5 .carousel-control-prev, .carousel .carousel-control-next {\\r\\n    display:none;\\r\\n  }\\r\\n  .car-5 .carousel-indicators button{\\r\\n    background-color: #fff;\\r\\n    border: none;\\r\\n    margin-bottom: 5px;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-background {\\r\\n      background-repeat: no-repeat;\\r\\n  \\t  background-size: cover;\\r\\n  \\t  height: 100%;\\r\\n  } \\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    filter: contrast(85%) !important;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    background-color: rgba(0, 0, 0, 0.4) !important;\\r\\n    width: 100% !important;\\r\\n    bottom: 0px !important;\\r\\n    left:0px !important;\\r\\n    height: 200px;\\r\\n  }\\r\\n  .login-form-5 p {\\r\\n    color: var(--jgt-tpgh-colorTextDescription);\\r\\n    font-weight: 700;\\r\\n    font-size: 16px;\\r\\n  }\\r\\n  .login-form-5 #loginButton {\\r\\n    font-weight: 500;\\r\\n  }\\r\\n  .login-form-5 form {\\r\\n    padding: 3.75rem !important;\\r\\n    width: 100%;\\r\\n    max-width: 500px;\\r\\n    margin: auto;\\r\\n    height: 700px;\\r\\n    text-align: center;\\r\\n  }\\r\\n  .login-form-5 .carousel-indicators{\\r\\n      margin-bottom: 20px;\\r\\n  }\\r\\n  @media (max-width: 767px){\\r\\n    .login-form-5 form {\\r\\n        padding: 3.75rem 0rem !important;\\r\\n    }\\r\\n  }\\r\\n  .login-form-5 input:focus:not([disabled]):not([readonly]),\\r\\n  .login-form-5 input:hover{\\r\\n      border-color: #009265 !important;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-5\\\">\\r\\n      <div class=\\\"login-form-5\\\">\\r\\n        <div class=\\\"row h-100\\\" style=\\\"margin:0\\\">\\r\\n          <div class=\\\"col-4 d-none d-sm-none d-md-block d-lg-block p-0 h-100\\\">\\r\\n            <!-- Carousel -->\\r\\n            <div id=\\\"carousel_{{id||}}\\\" class=\\\"carousel slide car-5\\\" data-ride=\\\"carousel\\\" style=\\\"height:100%\\\">\\r\\n              <div class=\\\"carousel-indicators\\\" data-hide=\\\"{{hideIndicator||false}}\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"carousel-inner\\\" style=\\\"height:100%\\\">\\r\\n              {{repeat||[{\\\"title\\\":\\\"Step Up to Joget DX 8\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control <br> With Enhanced Governance and UX.\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\\\"},{\\\"title\\\":\\\"Future Ready\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\\\"},{\\\"title\\\":\\\"Start Curious, Scale Serious.\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform <br> With No-Code Simplicity\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\\\"}]}}\\r\\n                <div class=\\\"carousel-item carousel-background\\\" style=\\\"background-image:url(\'{{repeat.image}}\');\\\">\\r\\n                  <div class=\\\"carousel-caption d-none d-md-block\\\" style=\\\"bottom:0px;\\\">\\r\\n                    <h4 style=\\\"color:{{repeat.titleColor}};font-weight:700;\\\">{{repeat.title}}<\\/h4>\\r\\n                      <p style=\\\"color:{{repeat.subtitleColor}}\\\">{{repeat.subtitle}}<\\/p>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n                {{repeat}}\\r\\n              <\\/div>\\r\\n            <\\/div>\\r\\n          <\\/div>\\r\\n          <div class=\\\"col-sm-12 col-md-8 p-4 p-lg-5 d-flex align-items-center justify-content-center h-100 flex-column text-center\\\">\\r\\n              <img src=\\\"#request.contextPath#/images/dx9AppCenter/appCenterJogetHorizontalGreen.png\\\" loading=\\\"lazy\\\" alt=\\\"\\\" class=\\\"image\\\" style=\\\"width: 200px;\\\">\\r\\n            <form style=\\\"width:100%;\\\">\\r\\n              <h2 class=\\\"mb-2\\\" style=\\\"{{titleColor||#000000}};\\\">{{title||Sign In to App Center}}<\\/h2>\\r\\n              <p class=\\\"mb-4\\\">Welcome back! Please enter your details.<\\/p>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customUsername||Username}}<\\/label>\\r\\n                <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"Enter your username\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customPassword||Password}}<\\/label>\\r\\n                <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"Enter your password\\\">\\r\\n              <\\/div>\\r\\n              <button type=\\\"button\\\" style=\\\"background-color:{{btnColor||#009265}};\\\" class=\\\"btn btn-primary w-100\\\" id=\\\"loginButton\\\">{{btnText||Sign In}}<\\/button>\\r\\n            <\\/form>\\r\\n          <\\/div>\\r\\n          <script>\\r\\n              $(function(){\\r\\n                  var carousel = $(\\\"#carousel_{{id||}}\\\");\\r\\n                  //create navigation link\\r\\n                  $(carousel).find(\\\".carousel-item\\\").each(function(i){\\r\\n                      $(carousel).find(\'.carousel-indicators\').append(\'<button class=\\\"mx-1\\\" data-target=\\\"#carousel_{{id||}}\\\" data-slide-to=\\\"\'+i+\'\\\"><\\/button>\');\\r\\n                  });\\r\\n                  //active first slide\\r\\n                  $(carousel).find(\\\".carousel-item:first-child, .carousel-indicators button:first-child\\\").addClass(\\\"active\\\");\\r\\n                  //Initialise carousel\\r\\n                  $(carousel).carousel();\\r\\n            });\\r\\n          <\\/script> \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"setting.properties.theme.properties.org.joget.theme.lib.LoginPageComponent.properties.template\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'carousel\'}-->\\r\\n<style>\\r\\n  #loginButton{\\r\\n      margin-top:15px;\\r\\n  }\\r\\n  body#login{\\r\\n      background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-container-5 {\\r\\n    display: flex !important;\\r\\n    height: 100% !important;\\r\\n    background-size: cover !important;\\r\\n    background-position: center !important;\\r\\n    color: black;\\r\\n    background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-form-5 {\\r\\n    border-radius: .8rem;\\r\\n    width: 100% !important;\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    background: #FFFFFF !important;\\r\\n    height: 100% !important;\\r\\n  }\\r\\n  .input-container-5 {\\r\\n    position: relative !important;\\r\\n    margin-bottom: 1rem !important;\\r\\n  }\\r\\n  .login-form-5 input {\\r\\n    height: 45px !important;\\r\\n  }\\r\\n  .login-form-5 input::placeholder {\\r\\n    color: rgba(0, 0, 0, 0.5) !important;\\r\\n  }\\r\\n  .login-form-5 form button {\\r\\n    border-color: #289FF5;\\r\\n    background-color: #289FF5;\\r\\n    border: none;\\r\\n    height: 48px !important;\\r\\n  }\\r\\n  .login-form-5 label {\\r\\n    font-weight: 600;\\r\\n    margin-bottom: 4px;\\r\\n    text-align: left;\\r\\n    float: left;\\r\\n  }\\r\\n  .car-5 .carousel-inner img {\\r\\n    width: 100%;\\r\\n    height: auto;\\r\\n  }\\r\\n  .car-5 .carousel-control-prev, .carousel .carousel-control-next {\\r\\n    display:none;\\r\\n  }\\r\\n  .car-5 .carousel-indicators button{\\r\\n    background-color: #fff;\\r\\n    border: none;\\r\\n    margin-bottom: 5px;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-background {\\r\\n      background-repeat: no-repeat;\\r\\n  \\t  background-size: cover;\\r\\n  \\t  height: 100%;\\r\\n  } \\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    filter: contrast(85%) !important;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    background-color: rgba(0, 0, 0, 0.4) !important;\\r\\n    width: 100% !important;\\r\\n    bottom: 0px !important;\\r\\n    left:0px !important;\\r\\n    height: 200px;\\r\\n  }\\r\\n  .login-form-5 p {\\r\\n    color: var(--jgt-tpgh-colorTextDescription);\\r\\n    font-weight: 700;\\r\\n    font-size: 16px;\\r\\n  }\\r\\n  .login-form-5 #loginButton {\\r\\n    font-weight: 500;\\r\\n  }\\r\\n  .login-form-5 form {\\r\\n    padding: 3.75rem !important;\\r\\n    width: 100%;\\r\\n    max-width: 500px;\\r\\n    margin: auto;\\r\\n    height: 700px;\\r\\n    text-align: center;\\r\\n  }\\r\\n  .login-form-5 .carousel-indicators{\\r\\n      margin-bottom: 20px;\\r\\n  }\\r\\n  @media (max-width: 767px){\\r\\n    .login-form-5 form {\\r\\n        padding: 3.75rem 0rem !important;\\r\\n    }\\r\\n  }\\r\\n  .login-form-5 input:focus:not([disabled]):not([readonly]),\\r\\n  .login-form-5 input:hover{\\r\\n      border-color: #009265 !important;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-5\\\">\\r\\n      <div class=\\\"login-form-5\\\">\\r\\n        <div class=\\\"row h-100\\\" style=\\\"margin:0\\\">\\r\\n          <div class=\\\"col-4 d-none d-sm-none d-md-block d-lg-block p-0 h-100\\\">\\r\\n            <!-- Carousel -->\\r\\n            <div id=\\\"carousel_{{id||}}\\\" class=\\\"carousel slide car-5\\\" data-ride=\\\"carousel\\\" style=\\\"height:100%\\\">\\r\\n              <div class=\\\"carousel-indicators\\\" data-hide=\\\"{{hideIndicator||false}}\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"carousel-inner\\\" style=\\\"height:100%\\\">\\r\\n              {{repeat||[{\\\"title\\\":\\\"Step Up to Joget DX 8\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control <br> With Enhanced Governance and UX.\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\\\"},{\\\"title\\\":\\\"Future Ready\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\\\"},{\\\"title\\\":\\\"Start Curious, Scale Serious.\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform <br> With No-Code Simplicity\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\\\"}]}}\\r\\n                <div class=\\\"carousel-item carousel-background\\\" style=\\\"background-image:url(\'{{repeat.image}}\');\\\">\\r\\n                  <div class=\\\"carousel-caption d-none d-md-block\\\" style=\\\"bottom:0px;\\\">\\r\\n                    <h4 style=\\\"color:{{repeat.titleColor}};font-weight:700;\\\">{{repeat.title}}<\\/h4>\\r\\n                      <p style=\\\"color:{{repeat.subtitleColor}}\\\">{{repeat.subtitle}}<\\/p>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n                {{repeat}}\\r\\n              <\\/div>\\r\\n            <\\/div>\\r\\n          <\\/div>\\r\\n          <div class=\\\"col-sm-12 col-md-8 p-4 p-lg-5 d-flex align-items-center justify-content-center h-100 flex-column text-center\\\">\\r\\n              <img src=\\\"#request.contextPath#/images/dx9AppCenter/appCenterJogetHorizontalGreen.png\\\" loading=\\\"lazy\\\" alt=\\\"\\\" class=\\\"image\\\" style=\\\"width: 200px;\\\">\\r\\n            <form style=\\\"width:100%;\\\">\\r\\n              <h2 class=\\\"mb-2\\\" style=\\\"{{titleColor||#000000}};\\\">{{title||Sign In to App Center}}<\\/h2>\\r\\n              <p class=\\\"mb-4\\\">Welcome back! Please enter your details.<\\/p>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customUsername||Username}}<\\/label>\\r\\n                <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"Enter your username\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customPassword||Password}}<\\/label>\\r\\n                <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"Enter your password\\\">\\r\\n              <\\/div>\\r\\n              <button type=\\\"button\\\" style=\\\"background-color:{{btnColor||#009265}};\\\" class=\\\"btn btn-primary w-100\\\" id=\\\"loginButton\\\">{{btnText||Sign In}}<\\/button>\\r\\n            <\\/form>\\r\\n          <\\/div>\\r\\n          <script>\\r\\n              $(function(){\\r\\n                  var carousel = $(\\\"#carousel_{{id||}}\\\");\\r\\n                  //create navigation link\\r\\n                  $(carousel).find(\\\".carousel-item\\\").each(function(i){\\r\\n                      $(carousel).find(\'.carousel-indicators\').append(\'<button class=\\\"mx-1\\\" data-target=\\\"#carousel_{{id||}}\\\" data-slide-to=\\\"\'+i+\'\\\"><\\/button>\');\\r\\n                  });\\r\\n                  //active first slide\\r\\n                  $(carousel).find(\\\".carousel-item:first-child, .carousel-indicators button:first-child\\\").addClass(\\\"active\\\");\\r\\n                  //Initialise carousel\\r\\n                  $(carousel).carousel();\\r\\n            });\\r\\n          <\\/script> \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"setting.properties.theme.properties.org.joget.theme.lib.LoginPageComponent.properties.image\",\"isError\":false,\"label\":\"#appResource.appCenterBanner.png#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#appResource.appCenterBanner.png#\"},{\"path\":\"setting.properties.theme.properties.org.joget.theme.lib.LoginPageComponent.properties.repeat\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control <br> With Enhanced Governance and UX.\\\",\\\"title\\\":\\\"Step Up to Joget DX 8\\\"},{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"title\\\":\\\"Future Ready\\\"},{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform <br> With No-Code Simplicity\\\",\\\"title\\\":\\\"Start Curious, Scale Serious.\\\"}]\"},{\"path\":\"setting.properties.theme.properties.org.joget.theme.lib.LoginPageComponent.properties.repeat\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control <br> With Enhanced Governance and UX.\\\",\\\"title\\\":\\\"Step Up to Joget DX 8\\\"},{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"title\\\":\\\"Future Ready\\\"},{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform <br> With No-Code Simplicity\\\",\\\"title\\\":\\\"Start Curious, Scale Serious.\\\"}]\"},{\"path\":\"setting.properties.theme.properties.org.joget.theme.lib.LoginPageComponent.properties.repeat\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control <br> With Enhanced Governance and UX.\\\",\\\"title\\\":\\\"Step Up to Joget DX 8\\\"},{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"title\\\":\\\"Future Ready\\\"},{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform <br> With No-Code Simplicity\\\",\\\"title\\\":\\\"Start Curious, Scale Serious.\\\"}]\"},{\"path\":\"setting.properties.theme.properties.org.joget.theme.lib.LoginPageComponent.properties.repeat[0].image\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\"},{\"path\":\"setting.properties.theme.properties.org.joget.theme.lib.LoginPageComponent.properties.repeat[1].image\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\"},{\"path\":\"setting.properties.theme.properties.org.joget.theme.lib.LoginPageComponent.properties.repeat[2].image\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\"},{\"path\":\"setting.properties.theme.properties.repeat[0].image\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\"},{\"path\":\"setting.properties.theme.properties.repeat[0].image\",\"isError\":false,\"label\":\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\"},{\"path\":\"setting.properties.theme.properties.repeat[1].image\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-matreding-10410088.jpg#\"},{\"path\":\"setting.properties.theme.properties.repeat[1].image\",\"isError\":false,\"label\":\"#appResource.pexels-matreding-10410088.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#appResource.pexels-matreding-10410088.jpg#\"},{\"path\":\"setting.properties.theme.properties.repeat[2].image\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-thisisengineering-3861959.jpg#\"},{\"path\":\"setting.properties.theme.properties.repeat[2].image\",\"isError\":false,\"label\":\"#appResource.pexels-thisisengineering-3861959.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#appResource.pexels-thisisengineering-3861959.jpg#\"}],\"lastModifiedDate\":\"Feb 6, 2025, 1:33:17\\u202fPM\"},\"theme:theme_app_center_theme\":{\"data\":[{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.appCenterBanner.png#\"},{\"path\":\"theme.properties.template\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\"},{\"path\":\"theme.properties.template\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-matreding-10410088.jpg#\"},{\"path\":\"theme.properties.template\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-thisisengineering-3861959.jpg#\"},{\"path\":\"theme.properties.repeat\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\"},{\"path\":\"theme.properties.repeat\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-matreding-10410088.jpg#\"},{\"path\":\"theme.properties.repeat\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-thisisengineering-3861959.jpg#\"},{\"path\":\"theme.properties.css\",\"isError\":false,\"label\":\"#request.baseURL?html#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<\\/style>\\n<link rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"#request.baseURL?html#/css/appCenter9.css?build=#platform.build?html#\\\" />\\n<style>\\n#dataList_applist > form > div > div.cards.row > div > div > h5 > div{\\n    box-shadow: rgba(17, 17, 26, 0.1) 0px 1px 0px;\\n    border-radius: 20%;\\n}\\n#home #dataList_applist .card-icon:hover .card-actions a{\\n    display:block !important;\\n}\"},{\"path\":\"theme.properties.css\",\"isError\":false,\"label\":\"#platform.build?html#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<\\/style>\\n<link rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"#request.baseURL?html#/css/appCenter9.css?build=#platform.build?html#\\\" />\\n<style>\\n#dataList_applist > form > div > div.cards.row > div > div > h5 > div{\\n    box-shadow: rgba(17, 17, 26, 0.1) 0px 1px 0px;\\n    border-radius: 20%;\\n}\\n#home #dataList_applist .card-icon:hover .card-actions a{\\n    display:block !important;\\n}\"},{\"path\":\"theme.properties.logo\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#request.contextPath#/images/dx9AppCenter/appCenterJogetVerticalWhite.png\"},{\"path\":\"theme.properties.template\",\"isError\":false,\"label\":\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'carousel\'}-->\\r\\n<style>\\r\\n  body#login{\\r\\n      background-color: {{bgColor||#F4F6FA}};\\r\\n  }\\r\\n  .login-container-5 {\\r\\n    display: flex !important;\\r\\n    height: 100% !important;\\r\\n    background-size: cover !important;\\r\\n    background-position: center !important;\\r\\n    color: black;\\r\\n    background-color: {{bgColor||#F4F6FA}};\\r\\n  }\\r\\n  .login-form-5 {\\r\\n    border-radius: .8rem;\\r\\n    width: 100% !important;\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    background: {{cardColor||#FFFFFF}} !important;\\r\\n    height: 100% !important;\\r\\n  }\\r\\n  .input-container-5 {\\r\\n    position: relative !important;\\r\\n    margin-bottom: 1rem !important;\\r\\n  }\\r\\n  .login-form-5 input {\\r\\n    height: 45px !important;\\r\\n  }\\r\\n  .login-form-5 input::placeholder {\\r\\n    color: rgba(0, 0, 0, 0.5) !important;\\r\\n  }\\r\\n  .login-form-5 form button {\\r\\n    border-color: {{btnColor||#289FF5}};\\r\\n    background-color: {{btnColor||#289FF5}};\\r\\n    border: none;\\r\\n    height: 48px !important;\\r\\n  }\\r\\n  .login-form-5 label {\\r\\n    font-weight: 600;\\r\\n    margin-bottom: 4px;\\r\\n    text-align: left;\\r\\n    float: left;\\r\\n  }\\r\\n  .car-5 .carousel-inner img {\\r\\n    width: 100%;\\r\\n    height: auto;\\r\\n  }\\r\\n  .car-5 .carousel-control-prev, .carousel .carousel-control-next {\\r\\n    display:none;\\r\\n  }\\r\\n  .car-5 .carousel-indicators button{\\r\\n    background-color: #fff;\\r\\n    border: none;\\r\\n    margin-bottom: 5px;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-background {\\r\\n      background-repeat: no-repeat;\\r\\n  \\t  background-size: cover;\\r\\n  \\t  height: 100%;\\r\\n  } \\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    filter: contrast(85%) !important;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    background-color: rgba(0, 0, 0, 0.4) !important;\\r\\n    width: 100% !important;\\r\\n    bottom: 0px !important;\\r\\n    left:0px !important;\\r\\n    height: 200px;\\r\\n  }\\r\\n  .login-form-5 p {\\r\\n    color: var(--jgt-tpgh-colorTextDescription);\\r\\n    font-weight: 700;\\r\\n    font-size: 16px;\\r\\n  }\\r\\n  .login-form-5 #loginButton {\\r\\n    font-weight: 500;\\r\\n  }\\r\\n  .login-form-5 form {\\r\\n    padding: 3.75rem !important;\\r\\n    width: 100%;\\r\\n    max-width: 500px;\\r\\n    margin: auto;\\r\\n    height: 700px;\\r\\n    text-align: center;\\r\\n  }\\r\\n  .login-form-5 .carousel-indicators{\\r\\n      margin-bottom: 20px;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-5\\\">\\r\\n  <div class=\\\"login-form-5\\\">\\r\\n    <div class=\\\"row h-100\\\" style=\\\"margin:0\\\">\\r\\n      <div class=\\\"col-4 d-none d-sm-none d-md-block d-lg-block p-0 h-100\\\">\\r\\n        <!-- Carousel -->\\r\\n        <div id=\\\"carousel_{{id||}}\\\" class=\\\"carousel slide car-5\\\" data-ride=\\\"carousel\\\" style=\\\"height:100%\\\">\\r\\n          <div class=\\\"carousel-indicators\\\" data-hide=\\\"{{hideIndicator||false}}\\\"><\\/div>\\r\\n          <div class=\\\"carousel-inner\\\" style=\\\"height:100%\\\">\\r\\n            {{repeat||[{\\\"title\\\":\\\"Start Curious, Scale Serious.\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform With No-Code Simplicity\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\\\"},{\\\"title\\\":\\\"Step Up to Joget DX 8\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control With Enhanced Governance and UX.\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-matreding-10410088.jpg#\\\"},{\\\"title\\\":\\\"Future Ready\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-thisisengineering-3861959.jpg#\\\"}]}}\\r\\n            <div class=\\\"carousel-item carousel-background\\\" style=\\\"background-image:url(\'{{repeat.image}}\');\\\">\\r\\n              <div class=\\\"carousel-caption d-none d-md-block\\\" style=\\\"bottom:0px;\\\">\\r\\n                <h4 style=\\\"color:{{repeat.titleColor}};font-weight:700;\\\">{{repeat.title}}<\\/h4>\\r\\n                <p style=\\\"color:{{repeat.subtitleColor}}\\\">{{repeat.subtitle}}<\\/p>\\r\\n              <\\/div>\\r\\n            <\\/div>\\r\\n            {{repeat}}\\r\\n          <\\/div>\\r\\n        <\\/div>\\r\\n      <\\/div>\\r\\n      <div class=\\\"col-sm-12 col-md-8 p-4 p-lg-5 d-flex flex-column h-100\\\" style=\\\"justify-content: center;align-items: center;\\\">\\r\\n        <img src=\\\"/jw/web/app/appcenter/resources/Joget_Horizontal_Green.png\\\" loading=\\\"lazy\\\" alt=\\\"\\\" class=\\\"image\\\" style=\\\"width: 200px;\\\">\\r\\n        <form>\\r\\n          <h3 class=\\\"mb-2\\\" style=\\\"color: #000000;\\\">Sign In to App Center<\\/h3>\\r\\n          <p class=\\\"mb-4\\\">Welcome back! Please enter your details.<\\/p>\\r\\n          <div class=\\\"mb-3 input-container-5\\\">\\r\\n            <label>Username<\\/label>\\r\\n            <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"Enter your username\\\">\\r\\n          <\\/div>\\r\\n          <div class=\\\"mb-3 input-container-5\\\">\\r\\n            <label>Password<\\/label>\\r\\n            <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"Enter your password\\\">\\r\\n          <\\/div>\\r\\n          <button type=\\\"button\\\" class=\\\"btn btn-primary w-100 mt-4\\\" id=\\\"loginButton\\\">Sign In<\\/button>\\r\\n        <\\/form>\\r\\n      <\\/div>\\r\\n        <script>\\r\\n              $(function(){\\r\\n                  var carousel = $(\\\"#carousel_{{id||}}\\\");\\r\\n                  //create navigation link\\r\\n                  $(carousel).find(\\\".carousel-item\\\").each(function(i){\\r\\n                      $(carousel).find(\'.carousel-indicators\').append(\'<button class=\\\"mx-1\\\" data-target=\\\"#carousel_{{id||}}\\\" data-slide-to=\\\"\'+i+\'\\\"><\\/button>\');\\r\\n                  });\\r\\n                  //active first slide\\r\\n                  $(carousel).find(\\\".carousel-item:first-child, .carousel-indicators button:first-child\\\").addClass(\\\"active\\\");\\r\\n                  //Initialise carousel\\r\\n                  $(carousel).carousel();\\r\\n            });\\r\\n        <\\/script>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"theme.properties.template\",\"isError\":false,\"label\":\"#appResource.pexels-matreding-10410088.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'carousel\'}-->\\r\\n<style>\\r\\n  body#login{\\r\\n      background-color: {{bgColor||#F4F6FA}};\\r\\n  }\\r\\n  .login-container-5 {\\r\\n    display: flex !important;\\r\\n    height: 100% !important;\\r\\n    background-size: cover !important;\\r\\n    background-position: center !important;\\r\\n    color: black;\\r\\n    background-color: {{bgColor||#F4F6FA}};\\r\\n  }\\r\\n  .login-form-5 {\\r\\n    border-radius: .8rem;\\r\\n    width: 100% !important;\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    background: {{cardColor||#FFFFFF}} !important;\\r\\n    height: 100% !important;\\r\\n  }\\r\\n  .input-container-5 {\\r\\n    position: relative !important;\\r\\n    margin-bottom: 1rem !important;\\r\\n  }\\r\\n  .login-form-5 input {\\r\\n    height: 45px !important;\\r\\n  }\\r\\n  .login-form-5 input::placeholder {\\r\\n    color: rgba(0, 0, 0, 0.5) !important;\\r\\n  }\\r\\n  .login-form-5 form button {\\r\\n    border-color: {{btnColor||#289FF5}};\\r\\n    background-color: {{btnColor||#289FF5}};\\r\\n    border: none;\\r\\n    height: 48px !important;\\r\\n  }\\r\\n  .login-form-5 label {\\r\\n    font-weight: 600;\\r\\n    margin-bottom: 4px;\\r\\n    text-align: left;\\r\\n    float: left;\\r\\n  }\\r\\n  .car-5 .carousel-inner img {\\r\\n    width: 100%;\\r\\n    height: auto;\\r\\n  }\\r\\n  .car-5 .carousel-control-prev, .carousel .carousel-control-next {\\r\\n    display:none;\\r\\n  }\\r\\n  .car-5 .carousel-indicators button{\\r\\n    background-color: #fff;\\r\\n    border: none;\\r\\n    margin-bottom: 5px;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-background {\\r\\n      background-repeat: no-repeat;\\r\\n  \\t  background-size: cover;\\r\\n  \\t  height: 100%;\\r\\n  } \\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    filter: contrast(85%) !important;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    background-color: rgba(0, 0, 0, 0.4) !important;\\r\\n    width: 100% !important;\\r\\n    bottom: 0px !important;\\r\\n    left:0px !important;\\r\\n    height: 200px;\\r\\n  }\\r\\n  .login-form-5 p {\\r\\n    color: var(--jgt-tpgh-colorTextDescription);\\r\\n    font-weight: 700;\\r\\n    font-size: 16px;\\r\\n  }\\r\\n  .login-form-5 #loginButton {\\r\\n    font-weight: 500;\\r\\n  }\\r\\n  .login-form-5 form {\\r\\n    padding: 3.75rem !important;\\r\\n    width: 100%;\\r\\n    max-width: 500px;\\r\\n    margin: auto;\\r\\n    height: 700px;\\r\\n    text-align: center;\\r\\n  }\\r\\n  .login-form-5 .carousel-indicators{\\r\\n      margin-bottom: 20px;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-5\\\">\\r\\n  <div class=\\\"login-form-5\\\">\\r\\n    <div class=\\\"row h-100\\\" style=\\\"margin:0\\\">\\r\\n      <div class=\\\"col-4 d-none d-sm-none d-md-block d-lg-block p-0 h-100\\\">\\r\\n        <!-- Carousel -->\\r\\n        <div id=\\\"carousel_{{id||}}\\\" class=\\\"carousel slide car-5\\\" data-ride=\\\"carousel\\\" style=\\\"height:100%\\\">\\r\\n          <div class=\\\"carousel-indicators\\\" data-hide=\\\"{{hideIndicator||false}}\\\"><\\/div>\\r\\n          <div class=\\\"carousel-inner\\\" style=\\\"height:100%\\\">\\r\\n            {{repeat||[{\\\"title\\\":\\\"Start Curious, Scale Serious.\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform With No-Code Simplicity\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\\\"},{\\\"title\\\":\\\"Step Up to Joget DX 8\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control With Enhanced Governance and UX.\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-matreding-10410088.jpg#\\\"},{\\\"title\\\":\\\"Future Ready\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-thisisengineering-3861959.jpg#\\\"}]}}\\r\\n            <div class=\\\"carousel-item carousel-background\\\" style=\\\"background-image:url(\'{{repeat.image}}\');\\\">\\r\\n              <div class=\\\"carousel-caption d-none d-md-block\\\" style=\\\"bottom:0px;\\\">\\r\\n                <h4 style=\\\"color:{{repeat.titleColor}};font-weight:700;\\\">{{repeat.title}}<\\/h4>\\r\\n                <p style=\\\"color:{{repeat.subtitleColor}}\\\">{{repeat.subtitle}}<\\/p>\\r\\n              <\\/div>\\r\\n            <\\/div>\\r\\n            {{repeat}}\\r\\n          <\\/div>\\r\\n        <\\/div>\\r\\n      <\\/div>\\r\\n      <div class=\\\"col-sm-12 col-md-8 p-4 p-lg-5 d-flex flex-column h-100\\\" style=\\\"justify-content: center;align-items: center;\\\">\\r\\n        <img src=\\\"/jw/web/app/appcenter/resources/Joget_Horizontal_Green.png\\\" loading=\\\"lazy\\\" alt=\\\"\\\" class=\\\"image\\\" style=\\\"width: 200px;\\\">\\r\\n        <form>\\r\\n          <h3 class=\\\"mb-2\\\" style=\\\"color: #000000;\\\">Sign In to App Center<\\/h3>\\r\\n          <p class=\\\"mb-4\\\">Welcome back! Please enter your details.<\\/p>\\r\\n          <div class=\\\"mb-3 input-container-5\\\">\\r\\n            <label>Username<\\/label>\\r\\n            <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"Enter your username\\\">\\r\\n          <\\/div>\\r\\n          <div class=\\\"mb-3 input-container-5\\\">\\r\\n            <label>Password<\\/label>\\r\\n            <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"Enter your password\\\">\\r\\n          <\\/div>\\r\\n          <button type=\\\"button\\\" class=\\\"btn btn-primary w-100 mt-4\\\" id=\\\"loginButton\\\">Sign In<\\/button>\\r\\n        <\\/form>\\r\\n      <\\/div>\\r\\n        <script>\\r\\n              $(function(){\\r\\n                  var carousel = $(\\\"#carousel_{{id||}}\\\");\\r\\n                  //create navigation link\\r\\n                  $(carousel).find(\\\".carousel-item\\\").each(function(i){\\r\\n                      $(carousel).find(\'.carousel-indicators\').append(\'<button class=\\\"mx-1\\\" data-target=\\\"#carousel_{{id||}}\\\" data-slide-to=\\\"\'+i+\'\\\"><\\/button>\');\\r\\n                  });\\r\\n                  //active first slide\\r\\n                  $(carousel).find(\\\".carousel-item:first-child, .carousel-indicators button:first-child\\\").addClass(\\\"active\\\");\\r\\n                  //Initialise carousel\\r\\n                  $(carousel).carousel();\\r\\n            });\\r\\n        <\\/script>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"theme.properties.template\",\"isError\":false,\"label\":\"#appResource.pexels-thisisengineering-3861959.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'carousel\'}-->\\r\\n<style>\\r\\n  body#login{\\r\\n      background-color: {{bgColor||#F4F6FA}};\\r\\n  }\\r\\n  .login-container-5 {\\r\\n    display: flex !important;\\r\\n    height: 100% !important;\\r\\n    background-size: cover !important;\\r\\n    background-position: center !important;\\r\\n    color: black;\\r\\n    background-color: {{bgColor||#F4F6FA}};\\r\\n  }\\r\\n  .login-form-5 {\\r\\n    border-radius: .8rem;\\r\\n    width: 100% !important;\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    background: {{cardColor||#FFFFFF}} !important;\\r\\n    height: 100% !important;\\r\\n  }\\r\\n  .input-container-5 {\\r\\n    position: relative !important;\\r\\n    margin-bottom: 1rem !important;\\r\\n  }\\r\\n  .login-form-5 input {\\r\\n    height: 45px !important;\\r\\n  }\\r\\n  .login-form-5 input::placeholder {\\r\\n    color: rgba(0, 0, 0, 0.5) !important;\\r\\n  }\\r\\n  .login-form-5 form button {\\r\\n    border-color: {{btnColor||#289FF5}};\\r\\n    background-color: {{btnColor||#289FF5}};\\r\\n    border: none;\\r\\n    height: 48px !important;\\r\\n  }\\r\\n  .login-form-5 label {\\r\\n    font-weight: 600;\\r\\n    margin-bottom: 4px;\\r\\n    text-align: left;\\r\\n    float: left;\\r\\n  }\\r\\n  .car-5 .carousel-inner img {\\r\\n    width: 100%;\\r\\n    height: auto;\\r\\n  }\\r\\n  .car-5 .carousel-control-prev, .carousel .carousel-control-next {\\r\\n    display:none;\\r\\n  }\\r\\n  .car-5 .carousel-indicators button{\\r\\n    background-color: #fff;\\r\\n    border: none;\\r\\n    margin-bottom: 5px;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-background {\\r\\n      background-repeat: no-repeat;\\r\\n  \\t  background-size: cover;\\r\\n  \\t  height: 100%;\\r\\n  } \\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    filter: contrast(85%) !important;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    background-color: rgba(0, 0, 0, 0.4) !important;\\r\\n    width: 100% !important;\\r\\n    bottom: 0px !important;\\r\\n    left:0px !important;\\r\\n    height: 200px;\\r\\n  }\\r\\n  .login-form-5 p {\\r\\n    color: var(--jgt-tpgh-colorTextDescription);\\r\\n    font-weight: 700;\\r\\n    font-size: 16px;\\r\\n  }\\r\\n  .login-form-5 #loginButton {\\r\\n    font-weight: 500;\\r\\n  }\\r\\n  .login-form-5 form {\\r\\n    padding: 3.75rem !important;\\r\\n    width: 100%;\\r\\n    max-width: 500px;\\r\\n    margin: auto;\\r\\n    height: 700px;\\r\\n    text-align: center;\\r\\n  }\\r\\n  .login-form-5 .carousel-indicators{\\r\\n      margin-bottom: 20px;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-5\\\">\\r\\n  <div class=\\\"login-form-5\\\">\\r\\n    <div class=\\\"row h-100\\\" style=\\\"margin:0\\\">\\r\\n      <div class=\\\"col-4 d-none d-sm-none d-md-block d-lg-block p-0 h-100\\\">\\r\\n        <!-- Carousel -->\\r\\n        <div id=\\\"carousel_{{id||}}\\\" class=\\\"carousel slide car-5\\\" data-ride=\\\"carousel\\\" style=\\\"height:100%\\\">\\r\\n          <div class=\\\"carousel-indicators\\\" data-hide=\\\"{{hideIndicator||false}}\\\"><\\/div>\\r\\n          <div class=\\\"carousel-inner\\\" style=\\\"height:100%\\\">\\r\\n            {{repeat||[{\\\"title\\\":\\\"Start Curious, Scale Serious.\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform With No-Code Simplicity\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\\\"},{\\\"title\\\":\\\"Step Up to Joget DX 8\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control With Enhanced Governance and UX.\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-matreding-10410088.jpg#\\\"},{\\\"title\\\":\\\"Future Ready\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-thisisengineering-3861959.jpg#\\\"}]}}\\r\\n            <div class=\\\"carousel-item carousel-background\\\" style=\\\"background-image:url(\'{{repeat.image}}\');\\\">\\r\\n              <div class=\\\"carousel-caption d-none d-md-block\\\" style=\\\"bottom:0px;\\\">\\r\\n                <h4 style=\\\"color:{{repeat.titleColor}};font-weight:700;\\\">{{repeat.title}}<\\/h4>\\r\\n                <p style=\\\"color:{{repeat.subtitleColor}}\\\">{{repeat.subtitle}}<\\/p>\\r\\n              <\\/div>\\r\\n            <\\/div>\\r\\n            {{repeat}}\\r\\n          <\\/div>\\r\\n        <\\/div>\\r\\n      <\\/div>\\r\\n      <div class=\\\"col-sm-12 col-md-8 p-4 p-lg-5 d-flex flex-column h-100\\\" style=\\\"justify-content: center;align-items: center;\\\">\\r\\n        <img src=\\\"/jw/web/app/appcenter/resources/Joget_Horizontal_Green.png\\\" loading=\\\"lazy\\\" alt=\\\"\\\" class=\\\"image\\\" style=\\\"width: 200px;\\\">\\r\\n        <form>\\r\\n          <h3 class=\\\"mb-2\\\" style=\\\"color: #000000;\\\">Sign In to App Center<\\/h3>\\r\\n          <p class=\\\"mb-4\\\">Welcome back! Please enter your details.<\\/p>\\r\\n          <div class=\\\"mb-3 input-container-5\\\">\\r\\n            <label>Username<\\/label>\\r\\n            <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"Enter your username\\\">\\r\\n          <\\/div>\\r\\n          <div class=\\\"mb-3 input-container-5\\\">\\r\\n            <label>Password<\\/label>\\r\\n            <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"Enter your password\\\">\\r\\n          <\\/div>\\r\\n          <button type=\\\"button\\\" class=\\\"btn btn-primary w-100 mt-4\\\" id=\\\"loginButton\\\">Sign In<\\/button>\\r\\n        <\\/form>\\r\\n      <\\/div>\\r\\n        <script>\\r\\n              $(function(){\\r\\n                  var carousel = $(\\\"#carousel_{{id||}}\\\");\\r\\n                  //create navigation link\\r\\n                  $(carousel).find(\\\".carousel-item\\\").each(function(i){\\r\\n                      $(carousel).find(\'.carousel-indicators\').append(\'<button class=\\\"mx-1\\\" data-target=\\\"#carousel_{{id||}}\\\" data-slide-to=\\\"\'+i+\'\\\"><\\/button>\');\\r\\n                  });\\r\\n                  //active first slide\\r\\n                  $(carousel).find(\\\".carousel-item:first-child, .carousel-indicators button:first-child\\\").addClass(\\\"active\\\");\\r\\n                  //Initialise carousel\\r\\n                  $(carousel).carousel();\\r\\n            });\\r\\n        <\\/script>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"theme.properties.js\",\"isError\":false,\"label\":\"#request.baseURL?html#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<\\/script>\\n<script type=\\\"text/javascript\\\" src=\\\"#request.baseURL?html#/js/appCenter9.js?build=#platform.build?html#\\\"><\\/script>\\n<script>\"},{\"path\":\"theme.properties.js\",\"isError\":false,\"label\":\"#platform.build?html#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<\\/script>\\n<script type=\\\"text/javascript\\\" src=\\\"#request.baseURL?html#/js/appCenter9.js?build=#platform.build?html#\\\"><\\/script>\\n<script>\"},{\"path\":\"theme.properties.repeat\",\"isError\":false,\"label\":\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"image\\\":\\\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform With No-Code Simplicity\\\",\\\"title\\\":\\\"Start Curious, Scale Serious.\\\"},{\\\"image\\\":\\\"#appResource.pexels-matreding-10410088.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control With Enhanced Governance and UX.\\\",\\\"title\\\":\\\"Step Up to Joget DX 8\\\"},{\\\"image\\\":\\\"#appResource.pexels-thisisengineering-3861959.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"title\\\":\\\"Future Ready\\\"}]\"},{\"path\":\"theme.properties.repeat\",\"isError\":false,\"label\":\"#appResource.pexels-matreding-10410088.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"image\\\":\\\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform With No-Code Simplicity\\\",\\\"title\\\":\\\"Start Curious, Scale Serious.\\\"},{\\\"image\\\":\\\"#appResource.pexels-matreding-10410088.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control With Enhanced Governance and UX.\\\",\\\"title\\\":\\\"Step Up to Joget DX 8\\\"},{\\\"image\\\":\\\"#appResource.pexels-thisisengineering-3861959.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"title\\\":\\\"Future Ready\\\"}]\"},{\"path\":\"theme.properties.repeat\",\"isError\":false,\"label\":\"#appResource.pexels-thisisengineering-3861959.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"image\\\":\\\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform With No-Code Simplicity\\\",\\\"title\\\":\\\"Start Curious, Scale Serious.\\\"},{\\\"image\\\":\\\"#appResource.pexels-matreding-10410088.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control With Enhanced Governance and UX.\\\",\\\"title\\\":\\\"Step Up to Joget DX 8\\\"},{\\\"image\\\":\\\"#appResource.pexels-thisisengineering-3861959.jpg#\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"title\\\":\\\"Future Ready\\\"}]\"},{\"path\":\"theme\",\"isError\":false,\"label\":\"org.joget.plugin.enterprise.BuilderTheme.theme_app_center_theme (Missing)\",\"tool\":\"org.joget.apps.app.lib.InstalledPluginOverviewTool\",\"content\":\"org.joget.plugin.enterprise.BuilderTheme.theme_app_center_theme\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.image\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.appCenterBanner.png#\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.template\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'carousel\'}-->\\r\\n<style>\\r\\n  #loginButton{\\r\\n      margin-top:15px;\\r\\n  }\\r\\n  body#login{\\r\\n      background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-container-5 {\\r\\n    display: flex !important;\\r\\n    height: 100% !important;\\r\\n    background-size: cover !important;\\r\\n    background-position: center !important;\\r\\n    color: black;\\r\\n    background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-form-5 {\\r\\n    border-radius: .8rem;\\r\\n    width: 100% !important;\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    background: #FFFFFF !important;\\r\\n    height: 100% !important;\\r\\n  }\\r\\n  .input-container-5 {\\r\\n    position: relative !important;\\r\\n    margin-bottom: 1rem !important;\\r\\n  }\\r\\n  .login-form-5 input {\\r\\n    height: 45px !important;\\r\\n  }\\r\\n  .login-form-5 input::placeholder {\\r\\n    color: rgba(0, 0, 0, 0.5) !important;\\r\\n  }\\r\\n  .login-form-5 form button {\\r\\n    border-color: #289FF5;\\r\\n    background-color: #289FF5;\\r\\n    border: none;\\r\\n    height: 48px !important;\\r\\n  }\\r\\n  .login-form-5 label {\\r\\n    font-weight: 600;\\r\\n    margin-bottom: 4px;\\r\\n    text-align: left;\\r\\n    float: left;\\r\\n  }\\r\\n  .car-5 .carousel-inner img {\\r\\n    width: 100%;\\r\\n    height: auto;\\r\\n  }\\r\\n  .car-5 .carousel-control-prev, .carousel .carousel-control-next {\\r\\n    display:none;\\r\\n  }\\r\\n  .car-5 .carousel-indicators button{\\r\\n    background-color: #fff;\\r\\n    border: none;\\r\\n    margin-bottom: 5px;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-background {\\r\\n      background-repeat: no-repeat;\\r\\n  \\t  background-size: cover;\\r\\n  \\t  height: 100%;\\r\\n  } \\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    filter: contrast(85%) !important;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    background-color: rgba(0, 0, 0, 0.4) !important;\\r\\n    width: 100% !important;\\r\\n    bottom: 0px !important;\\r\\n    left:0px !important;\\r\\n    height: 200px;\\r\\n  }\\r\\n  .login-form-5 p {\\r\\n    color: var(--jgt-tpgh-colorTextDescription);\\r\\n    font-weight: 700;\\r\\n    font-size: 16px;\\r\\n  }\\r\\n  .login-form-5 #loginButton {\\r\\n    font-weight: 500;\\r\\n  }\\r\\n  .login-form-5 form {\\r\\n    padding: 3.75rem !important;\\r\\n    width: 100%;\\r\\n    max-width: 500px;\\r\\n    margin: auto;\\r\\n    height: 700px;\\r\\n    text-align: center;\\r\\n  }\\r\\n  .login-form-5 .carousel-indicators{\\r\\n      margin-bottom: 20px;\\r\\n  }\\r\\n  @media (max-width: 767px){\\r\\n    .login-form-5 form {\\r\\n        padding: 3.75rem 0rem !important;\\r\\n    }\\r\\n  }\\r\\n  .login-form-5 input:focus:not([disabled]):not([readonly]),\\r\\n  .login-form-5 input:hover{\\r\\n      border-color: #009265 !important;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-5\\\">\\r\\n      <div class=\\\"login-form-5\\\">\\r\\n        <div class=\\\"row h-100\\\" style=\\\"margin:0\\\">\\r\\n          <div class=\\\"col-4 d-none d-sm-none d-md-block d-lg-block p-0 h-100\\\">\\r\\n            <!-- Carousel -->\\r\\n            <div id=\\\"carousel_{{id||}}\\\" class=\\\"carousel slide car-5\\\" data-ride=\\\"carousel\\\" style=\\\"height:100%\\\">\\r\\n              <div class=\\\"carousel-indicators\\\" data-hide=\\\"{{hideIndicator||false}}\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"carousel-inner\\\" style=\\\"height:100%\\\">\\r\\n              {{repeat||[{\\\"title\\\":\\\"Step Up to Joget DX 8\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control <br> With Enhanced Governance and UX.\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\\\"},{\\\"title\\\":\\\"Future Ready\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\\\"},{\\\"title\\\":\\\"Start Curious, Scale Serious.\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform <br> With No-Code Simplicity\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\\\"}]}}\\r\\n                <div class=\\\"carousel-item carousel-background\\\" style=\\\"background-image:url(\'{{repeat.image}}\');\\\">\\r\\n                  <div class=\\\"carousel-caption d-none d-md-block\\\" style=\\\"bottom:0px;\\\">\\r\\n                    <h4 style=\\\"color:{{repeat.titleColor}};font-weight:700;\\\">{{repeat.title}}<\\/h4>\\r\\n                      <p style=\\\"color:{{repeat.subtitleColor}}\\\">{{repeat.subtitle}}<\\/p>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n                {{repeat}}\\r\\n              <\\/div>\\r\\n            <\\/div>\\r\\n          <\\/div>\\r\\n          <div class=\\\"col-sm-12 col-md-8 p-4 p-lg-5 d-flex align-items-center justify-content-center h-100 flex-column text-center\\\">\\r\\n              <img src=\\\"#request.contextPath#/images/dx9AppCenter/appCenterJogetHorizontalGreen.png\\\" loading=\\\"lazy\\\" alt=\\\"\\\" class=\\\"image\\\" style=\\\"width: 200px;\\\">\\r\\n            <form style=\\\"width:100%;\\\">\\r\\n              <h2 class=\\\"mb-2\\\" style=\\\"{{titleColor||#000000}};\\\">{{title||Sign In to App Center}}<\\/h2>\\r\\n              <p class=\\\"mb-4\\\">Welcome back! Please enter your details.<\\/p>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customUsername||Username}}<\\/label>\\r\\n                <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"Enter your username\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customPassword||Password}}<\\/label>\\r\\n                <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"Enter your password\\\">\\r\\n              <\\/div>\\r\\n              <button type=\\\"button\\\" style=\\\"background-color:{{btnColor||#009265}};\\\" class=\\\"btn btn-primary w-100\\\" id=\\\"loginButton\\\">{{btnText||Sign In}}<\\/button>\\r\\n            <\\/form>\\r\\n          <\\/div>\\r\\n          <script>\\r\\n              $(function(){\\r\\n                  var carousel = $(\\\"#carousel_{{id||}}\\\");\\r\\n                  //create navigation link\\r\\n                  $(carousel).find(\\\".carousel-item\\\").each(function(i){\\r\\n                      $(carousel).find(\'.carousel-indicators\').append(\'<button class=\\\"mx-1\\\" data-target=\\\"#carousel_{{id||}}\\\" data-slide-to=\\\"\'+i+\'\\\"><\\/button>\');\\r\\n                  });\\r\\n                  //active first slide\\r\\n                  $(carousel).find(\\\".carousel-item:first-child, .carousel-indicators button:first-child\\\").addClass(\\\"active\\\");\\r\\n                  //Initialise carousel\\r\\n                  $(carousel).carousel();\\r\\n            });\\r\\n          <\\/script> \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.template\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'carousel\'}-->\\r\\n<style>\\r\\n  #loginButton{\\r\\n      margin-top:15px;\\r\\n  }\\r\\n  body#login{\\r\\n      background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-container-5 {\\r\\n    display: flex !important;\\r\\n    height: 100% !important;\\r\\n    background-size: cover !important;\\r\\n    background-position: center !important;\\r\\n    color: black;\\r\\n    background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-form-5 {\\r\\n    border-radius: .8rem;\\r\\n    width: 100% !important;\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    background: #FFFFFF !important;\\r\\n    height: 100% !important;\\r\\n  }\\r\\n  .input-container-5 {\\r\\n    position: relative !important;\\r\\n    margin-bottom: 1rem !important;\\r\\n  }\\r\\n  .login-form-5 input {\\r\\n    height: 45px !important;\\r\\n  }\\r\\n  .login-form-5 input::placeholder {\\r\\n    color: rgba(0, 0, 0, 0.5) !important;\\r\\n  }\\r\\n  .login-form-5 form button {\\r\\n    border-color: #289FF5;\\r\\n    background-color: #289FF5;\\r\\n    border: none;\\r\\n    height: 48px !important;\\r\\n  }\\r\\n  .login-form-5 label {\\r\\n    font-weight: 600;\\r\\n    margin-bottom: 4px;\\r\\n    text-align: left;\\r\\n    float: left;\\r\\n  }\\r\\n  .car-5 .carousel-inner img {\\r\\n    width: 100%;\\r\\n    height: auto;\\r\\n  }\\r\\n  .car-5 .carousel-control-prev, .carousel .carousel-control-next {\\r\\n    display:none;\\r\\n  }\\r\\n  .car-5 .carousel-indicators button{\\r\\n    background-color: #fff;\\r\\n    border: none;\\r\\n    margin-bottom: 5px;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-background {\\r\\n      background-repeat: no-repeat;\\r\\n  \\t  background-size: cover;\\r\\n  \\t  height: 100%;\\r\\n  } \\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    filter: contrast(85%) !important;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    background-color: rgba(0, 0, 0, 0.4) !important;\\r\\n    width: 100% !important;\\r\\n    bottom: 0px !important;\\r\\n    left:0px !important;\\r\\n    height: 200px;\\r\\n  }\\r\\n  .login-form-5 p {\\r\\n    color: var(--jgt-tpgh-colorTextDescription);\\r\\n    font-weight: 700;\\r\\n    font-size: 16px;\\r\\n  }\\r\\n  .login-form-5 #loginButton {\\r\\n    font-weight: 500;\\r\\n  }\\r\\n  .login-form-5 form {\\r\\n    padding: 3.75rem !important;\\r\\n    width: 100%;\\r\\n    max-width: 500px;\\r\\n    margin: auto;\\r\\n    height: 700px;\\r\\n    text-align: center;\\r\\n  }\\r\\n  .login-form-5 .carousel-indicators{\\r\\n      margin-bottom: 20px;\\r\\n  }\\r\\n  @media (max-width: 767px){\\r\\n    .login-form-5 form {\\r\\n        padding: 3.75rem 0rem !important;\\r\\n    }\\r\\n  }\\r\\n  .login-form-5 input:focus:not([disabled]):not([readonly]),\\r\\n  .login-form-5 input:hover{\\r\\n      border-color: #009265 !important;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-5\\\">\\r\\n      <div class=\\\"login-form-5\\\">\\r\\n        <div class=\\\"row h-100\\\" style=\\\"margin:0\\\">\\r\\n          <div class=\\\"col-4 d-none d-sm-none d-md-block d-lg-block p-0 h-100\\\">\\r\\n            <!-- Carousel -->\\r\\n            <div id=\\\"carousel_{{id||}}\\\" class=\\\"carousel slide car-5\\\" data-ride=\\\"carousel\\\" style=\\\"height:100%\\\">\\r\\n              <div class=\\\"carousel-indicators\\\" data-hide=\\\"{{hideIndicator||false}}\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"carousel-inner\\\" style=\\\"height:100%\\\">\\r\\n              {{repeat||[{\\\"title\\\":\\\"Step Up to Joget DX 8\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control <br> With Enhanced Governance and UX.\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\\\"},{\\\"title\\\":\\\"Future Ready\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\\\"},{\\\"title\\\":\\\"Start Curious, Scale Serious.\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform <br> With No-Code Simplicity\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\\\"}]}}\\r\\n                <div class=\\\"carousel-item carousel-background\\\" style=\\\"background-image:url(\'{{repeat.image}}\');\\\">\\r\\n                  <div class=\\\"carousel-caption d-none d-md-block\\\" style=\\\"bottom:0px;\\\">\\r\\n                    <h4 style=\\\"color:{{repeat.titleColor}};font-weight:700;\\\">{{repeat.title}}<\\/h4>\\r\\n                      <p style=\\\"color:{{repeat.subtitleColor}}\\\">{{repeat.subtitle}}<\\/p>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n                {{repeat}}\\r\\n              <\\/div>\\r\\n            <\\/div>\\r\\n          <\\/div>\\r\\n          <div class=\\\"col-sm-12 col-md-8 p-4 p-lg-5 d-flex align-items-center justify-content-center h-100 flex-column text-center\\\">\\r\\n              <img src=\\\"#request.contextPath#/images/dx9AppCenter/appCenterJogetHorizontalGreen.png\\\" loading=\\\"lazy\\\" alt=\\\"\\\" class=\\\"image\\\" style=\\\"width: 200px;\\\">\\r\\n            <form style=\\\"width:100%;\\\">\\r\\n              <h2 class=\\\"mb-2\\\" style=\\\"{{titleColor||#000000}};\\\">{{title||Sign In to App Center}}<\\/h2>\\r\\n              <p class=\\\"mb-4\\\">Welcome back! Please enter your details.<\\/p>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customUsername||Username}}<\\/label>\\r\\n                <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"Enter your username\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customPassword||Password}}<\\/label>\\r\\n                <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"Enter your password\\\">\\r\\n              <\\/div>\\r\\n              <button type=\\\"button\\\" style=\\\"background-color:{{btnColor||#009265}};\\\" class=\\\"btn btn-primary w-100\\\" id=\\\"loginButton\\\">{{btnText||Sign In}}<\\/button>\\r\\n            <\\/form>\\r\\n          <\\/div>\\r\\n          <script>\\r\\n              $(function(){\\r\\n                  var carousel = $(\\\"#carousel_{{id||}}\\\");\\r\\n                  //create navigation link\\r\\n                  $(carousel).find(\\\".carousel-item\\\").each(function(i){\\r\\n                      $(carousel).find(\'.carousel-indicators\').append(\'<button class=\\\"mx-1\\\" data-target=\\\"#carousel_{{id||}}\\\" data-slide-to=\\\"\'+i+\'\\\"><\\/button>\');\\r\\n                  });\\r\\n                  //active first slide\\r\\n                  $(carousel).find(\\\".carousel-item:first-child, .carousel-indicators button:first-child\\\").addClass(\\\"active\\\");\\r\\n                  //Initialise carousel\\r\\n                  $(carousel).carousel();\\r\\n            });\\r\\n          <\\/script> \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.template\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'carousel\'}-->\\r\\n<style>\\r\\n  #loginButton{\\r\\n      margin-top:15px;\\r\\n  }\\r\\n  body#login{\\r\\n      background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-container-5 {\\r\\n    display: flex !important;\\r\\n    height: 100% !important;\\r\\n    background-size: cover !important;\\r\\n    background-position: center !important;\\r\\n    color: black;\\r\\n    background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-form-5 {\\r\\n    border-radius: .8rem;\\r\\n    width: 100% !important;\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    background: #FFFFFF !important;\\r\\n    height: 100% !important;\\r\\n  }\\r\\n  .input-container-5 {\\r\\n    position: relative !important;\\r\\n    margin-bottom: 1rem !important;\\r\\n  }\\r\\n  .login-form-5 input {\\r\\n    height: 45px !important;\\r\\n  }\\r\\n  .login-form-5 input::placeholder {\\r\\n    color: rgba(0, 0, 0, 0.5) !important;\\r\\n  }\\r\\n  .login-form-5 form button {\\r\\n    border-color: #289FF5;\\r\\n    background-color: #289FF5;\\r\\n    border: none;\\r\\n    height: 48px !important;\\r\\n  }\\r\\n  .login-form-5 label {\\r\\n    font-weight: 600;\\r\\n    margin-bottom: 4px;\\r\\n    text-align: left;\\r\\n    float: left;\\r\\n  }\\r\\n  .car-5 .carousel-inner img {\\r\\n    width: 100%;\\r\\n    height: auto;\\r\\n  }\\r\\n  .car-5 .carousel-control-prev, .carousel .carousel-control-next {\\r\\n    display:none;\\r\\n  }\\r\\n  .car-5 .carousel-indicators button{\\r\\n    background-color: #fff;\\r\\n    border: none;\\r\\n    margin-bottom: 5px;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-background {\\r\\n      background-repeat: no-repeat;\\r\\n  \\t  background-size: cover;\\r\\n  \\t  height: 100%;\\r\\n  } \\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    filter: contrast(85%) !important;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    background-color: rgba(0, 0, 0, 0.4) !important;\\r\\n    width: 100% !important;\\r\\n    bottom: 0px !important;\\r\\n    left:0px !important;\\r\\n    height: 200px;\\r\\n  }\\r\\n  .login-form-5 p {\\r\\n    color: var(--jgt-tpgh-colorTextDescription);\\r\\n    font-weight: 700;\\r\\n    font-size: 16px;\\r\\n  }\\r\\n  .login-form-5 #loginButton {\\r\\n    font-weight: 500;\\r\\n  }\\r\\n  .login-form-5 form {\\r\\n    padding: 3.75rem !important;\\r\\n    width: 100%;\\r\\n    max-width: 500px;\\r\\n    margin: auto;\\r\\n    height: 700px;\\r\\n    text-align: center;\\r\\n  }\\r\\n  .login-form-5 .carousel-indicators{\\r\\n      margin-bottom: 20px;\\r\\n  }\\r\\n  @media (max-width: 767px){\\r\\n    .login-form-5 form {\\r\\n        padding: 3.75rem 0rem !important;\\r\\n    }\\r\\n  }\\r\\n  .login-form-5 input:focus:not([disabled]):not([readonly]),\\r\\n  .login-form-5 input:hover{\\r\\n      border-color: #009265 !important;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-5\\\">\\r\\n      <div class=\\\"login-form-5\\\">\\r\\n        <div class=\\\"row h-100\\\" style=\\\"margin:0\\\">\\r\\n          <div class=\\\"col-4 d-none d-sm-none d-md-block d-lg-block p-0 h-100\\\">\\r\\n            <!-- Carousel -->\\r\\n            <div id=\\\"carousel_{{id||}}\\\" class=\\\"carousel slide car-5\\\" data-ride=\\\"carousel\\\" style=\\\"height:100%\\\">\\r\\n              <div class=\\\"carousel-indicators\\\" data-hide=\\\"{{hideIndicator||false}}\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"carousel-inner\\\" style=\\\"height:100%\\\">\\r\\n              {{repeat||[{\\\"title\\\":\\\"Step Up to Joget DX 8\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control <br> With Enhanced Governance and UX.\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\\\"},{\\\"title\\\":\\\"Future Ready\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\\\"},{\\\"title\\\":\\\"Start Curious, Scale Serious.\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform <br> With No-Code Simplicity\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\\\"}]}}\\r\\n                <div class=\\\"carousel-item carousel-background\\\" style=\\\"background-image:url(\'{{repeat.image}}\');\\\">\\r\\n                  <div class=\\\"carousel-caption d-none d-md-block\\\" style=\\\"bottom:0px;\\\">\\r\\n                    <h4 style=\\\"color:{{repeat.titleColor}};font-weight:700;\\\">{{repeat.title}}<\\/h4>\\r\\n                      <p style=\\\"color:{{repeat.subtitleColor}}\\\">{{repeat.subtitle}}<\\/p>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n                {{repeat}}\\r\\n              <\\/div>\\r\\n            <\\/div>\\r\\n          <\\/div>\\r\\n          <div class=\\\"col-sm-12 col-md-8 p-4 p-lg-5 d-flex align-items-center justify-content-center h-100 flex-column text-center\\\">\\r\\n              <img src=\\\"#request.contextPath#/images/dx9AppCenter/appCenterJogetHorizontalGreen.png\\\" loading=\\\"lazy\\\" alt=\\\"\\\" class=\\\"image\\\" style=\\\"width: 200px;\\\">\\r\\n            <form style=\\\"width:100%;\\\">\\r\\n              <h2 class=\\\"mb-2\\\" style=\\\"{{titleColor||#000000}};\\\">{{title||Sign In to App Center}}<\\/h2>\\r\\n              <p class=\\\"mb-4\\\">Welcome back! Please enter your details.<\\/p>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customUsername||Username}}<\\/label>\\r\\n                <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"Enter your username\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customPassword||Password}}<\\/label>\\r\\n                <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"Enter your password\\\">\\r\\n              <\\/div>\\r\\n              <button type=\\\"button\\\" style=\\\"background-color:{{btnColor||#009265}};\\\" class=\\\"btn btn-primary w-100\\\" id=\\\"loginButton\\\">{{btnText||Sign In}}<\\/button>\\r\\n            <\\/form>\\r\\n          <\\/div>\\r\\n          <script>\\r\\n              $(function(){\\r\\n                  var carousel = $(\\\"#carousel_{{id||}}\\\");\\r\\n                  //create navigation link\\r\\n                  $(carousel).find(\\\".carousel-item\\\").each(function(i){\\r\\n                      $(carousel).find(\'.carousel-indicators\').append(\'<button class=\\\"mx-1\\\" data-target=\\\"#carousel_{{id||}}\\\" data-slide-to=\\\"\'+i+\'\\\"><\\/button>\');\\r\\n                  });\\r\\n                  //active first slide\\r\\n                  $(carousel).find(\\\".carousel-item:first-child, .carousel-indicators button:first-child\\\").addClass(\\\"active\\\");\\r\\n                  //Initialise carousel\\r\\n                  $(carousel).carousel();\\r\\n            });\\r\\n          <\\/script> \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.template\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'carousel\'}-->\\r\\n<style>\\r\\n  #loginButton{\\r\\n      margin-top:15px;\\r\\n  }\\r\\n  body#login{\\r\\n      background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-container-5 {\\r\\n    display: flex !important;\\r\\n    height: 100% !important;\\r\\n    background-size: cover !important;\\r\\n    background-position: center !important;\\r\\n    color: black;\\r\\n    background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-form-5 {\\r\\n    border-radius: .8rem;\\r\\n    width: 100% !important;\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    background: #FFFFFF !important;\\r\\n    height: 100% !important;\\r\\n  }\\r\\n  .input-container-5 {\\r\\n    position: relative !important;\\r\\n    margin-bottom: 1rem !important;\\r\\n  }\\r\\n  .login-form-5 input {\\r\\n    height: 45px !important;\\r\\n  }\\r\\n  .login-form-5 input::placeholder {\\r\\n    color: rgba(0, 0, 0, 0.5) !important;\\r\\n  }\\r\\n  .login-form-5 form button {\\r\\n    border-color: #289FF5;\\r\\n    background-color: #289FF5;\\r\\n    border: none;\\r\\n    height: 48px !important;\\r\\n  }\\r\\n  .login-form-5 label {\\r\\n    font-weight: 600;\\r\\n    margin-bottom: 4px;\\r\\n    text-align: left;\\r\\n    float: left;\\r\\n  }\\r\\n  .car-5 .carousel-inner img {\\r\\n    width: 100%;\\r\\n    height: auto;\\r\\n  }\\r\\n  .car-5 .carousel-control-prev, .carousel .carousel-control-next {\\r\\n    display:none;\\r\\n  }\\r\\n  .car-5 .carousel-indicators button{\\r\\n    background-color: #fff;\\r\\n    border: none;\\r\\n    margin-bottom: 5px;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-background {\\r\\n      background-repeat: no-repeat;\\r\\n  \\t  background-size: cover;\\r\\n  \\t  height: 100%;\\r\\n  } \\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    filter: contrast(85%) !important;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    background-color: rgba(0, 0, 0, 0.4) !important;\\r\\n    width: 100% !important;\\r\\n    bottom: 0px !important;\\r\\n    left:0px !important;\\r\\n    height: 200px;\\r\\n  }\\r\\n  .login-form-5 p {\\r\\n    color: var(--jgt-tpgh-colorTextDescription);\\r\\n    font-weight: 700;\\r\\n    font-size: 16px;\\r\\n  }\\r\\n  .login-form-5 #loginButton {\\r\\n    font-weight: 500;\\r\\n  }\\r\\n  .login-form-5 form {\\r\\n    padding: 3.75rem !important;\\r\\n    width: 100%;\\r\\n    max-width: 500px;\\r\\n    margin: auto;\\r\\n    height: 700px;\\r\\n    text-align: center;\\r\\n  }\\r\\n  .login-form-5 .carousel-indicators{\\r\\n      margin-bottom: 20px;\\r\\n  }\\r\\n  @media (max-width: 767px){\\r\\n    .login-form-5 form {\\r\\n        padding: 3.75rem 0rem !important;\\r\\n    }\\r\\n  }\\r\\n  .login-form-5 input:focus:not([disabled]):not([readonly]),\\r\\n  .login-form-5 input:hover{\\r\\n      border-color: #009265 !important;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-5\\\">\\r\\n      <div class=\\\"login-form-5\\\">\\r\\n        <div class=\\\"row h-100\\\" style=\\\"margin:0\\\">\\r\\n          <div class=\\\"col-4 d-none d-sm-none d-md-block d-lg-block p-0 h-100\\\">\\r\\n            <!-- Carousel -->\\r\\n            <div id=\\\"carousel_{{id||}}\\\" class=\\\"carousel slide car-5\\\" data-ride=\\\"carousel\\\" style=\\\"height:100%\\\">\\r\\n              <div class=\\\"carousel-indicators\\\" data-hide=\\\"{{hideIndicator||false}}\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"carousel-inner\\\" style=\\\"height:100%\\\">\\r\\n              {{repeat||[{\\\"title\\\":\\\"Step Up to Joget DX 8\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control <br> With Enhanced Governance and UX.\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\\\"},{\\\"title\\\":\\\"Future Ready\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\\\"},{\\\"title\\\":\\\"Start Curious, Scale Serious.\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform <br> With No-Code Simplicity\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\\\"}]}}\\r\\n                <div class=\\\"carousel-item carousel-background\\\" style=\\\"background-image:url(\'{{repeat.image}}\');\\\">\\r\\n                  <div class=\\\"carousel-caption d-none d-md-block\\\" style=\\\"bottom:0px;\\\">\\r\\n                    <h4 style=\\\"color:{{repeat.titleColor}};font-weight:700;\\\">{{repeat.title}}<\\/h4>\\r\\n                      <p style=\\\"color:{{repeat.subtitleColor}}\\\">{{repeat.subtitle}}<\\/p>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n                {{repeat}}\\r\\n              <\\/div>\\r\\n            <\\/div>\\r\\n          <\\/div>\\r\\n          <div class=\\\"col-sm-12 col-md-8 p-4 p-lg-5 d-flex align-items-center justify-content-center h-100 flex-column text-center\\\">\\r\\n              <img src=\\\"#request.contextPath#/images/dx9AppCenter/appCenterJogetHorizontalGreen.png\\\" loading=\\\"lazy\\\" alt=\\\"\\\" class=\\\"image\\\" style=\\\"width: 200px;\\\">\\r\\n            <form style=\\\"width:100%;\\\">\\r\\n              <h2 class=\\\"mb-2\\\" style=\\\"{{titleColor||#000000}};\\\">{{title||Sign In to App Center}}<\\/h2>\\r\\n              <p class=\\\"mb-4\\\">Welcome back! Please enter your details.<\\/p>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customUsername||Username}}<\\/label>\\r\\n                <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"Enter your username\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customPassword||Password}}<\\/label>\\r\\n                <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"Enter your password\\\">\\r\\n              <\\/div>\\r\\n              <button type=\\\"button\\\" style=\\\"background-color:{{btnColor||#009265}};\\\" class=\\\"btn btn-primary w-100\\\" id=\\\"loginButton\\\">{{btnText||Sign In}}<\\/button>\\r\\n            <\\/form>\\r\\n          <\\/div>\\r\\n          <script>\\r\\n              $(function(){\\r\\n                  var carousel = $(\\\"#carousel_{{id||}}\\\");\\r\\n                  //create navigation link\\r\\n                  $(carousel).find(\\\".carousel-item\\\").each(function(i){\\r\\n                      $(carousel).find(\'.carousel-indicators\').append(\'<button class=\\\"mx-1\\\" data-target=\\\"#carousel_{{id||}}\\\" data-slide-to=\\\"\'+i+\'\\\"><\\/button>\');\\r\\n                  });\\r\\n                  //active first slide\\r\\n                  $(carousel).find(\\\".carousel-item:first-child, .carousel-indicators button:first-child\\\").addClass(\\\"active\\\");\\r\\n                  //Initialise carousel\\r\\n                  $(carousel).carousel();\\r\\n            });\\r\\n          <\\/script> \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.image\",\"isError\":false,\"label\":\"#appResource.appCenterBanner.png#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#appResource.appCenterBanner.png#\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.repeat\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control <br> With Enhanced Governance and UX.\\\",\\\"title\\\":\\\"Step Up to Joget DX 8\\\"},{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"title\\\":\\\"Future Ready\\\"},{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform <br> With No-Code Simplicity\\\",\\\"title\\\":\\\"Start Curious, Scale Serious.\\\"}]\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.repeat\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control <br> With Enhanced Governance and UX.\\\",\\\"title\\\":\\\"Step Up to Joget DX 8\\\"},{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"title\\\":\\\"Future Ready\\\"},{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform <br> With No-Code Simplicity\\\",\\\"title\\\":\\\"Start Curious, Scale Serious.\\\"}]\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.repeat\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control <br> With Enhanced Governance and UX.\\\",\\\"title\\\":\\\"Step Up to Joget DX 8\\\"},{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"title\\\":\\\"Future Ready\\\"},{\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform <br> With No-Code Simplicity\\\",\\\"title\\\":\\\"Start Curious, Scale Serious.\\\"}]\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.repeat[0].image\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.repeat[1].image\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.repeat[2].image\",\"isError\":false,\"label\":\"#request.contextPath#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\"},{\"path\":\"theme.properties.repeat[0].image\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\"},{\"path\":\"theme.properties.repeat[0].image\",\"isError\":false,\"label\":\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\"},{\"path\":\"theme.properties.repeat[1].image\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-matreding-10410088.jpg#\"},{\"path\":\"theme.properties.repeat[1].image\",\"isError\":false,\"label\":\"#appResource.pexels-matreding-10410088.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#appResource.pexels-matreding-10410088.jpg#\"},{\"path\":\"theme.properties.repeat[2].image\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.pexels-thisisengineering-3861959.jpg#\"},{\"path\":\"theme.properties.repeat[2].image\",\"isError\":false,\"label\":\"#appResource.pexels-thisisengineering-3861959.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#appResource.pexels-thisisengineering-3861959.jpg#\"}],\"lastModifiedDate\":\"Feb 6, 2025, 1:33:17\\u202fPM\"},\"properties\":{\"id\":\"APP_OVERVIEW_DEFINITION\"}}',NULL),
('appcenter',1,'INTERNAL_TAGGING','Tagging','internal','2025-06-05 11:20:18','2025-06-05 11:20:18','{\"datas\":{\"form\":{},\"list\":{},\"userview\":{\"v\":[\"t07\"],\"v3\":[\"t08\"]}},\"properties\":{\"id\":\"INTERNAL_TAGGING\"},\"labels\":{\"t10\":{\"color\":\"black\"},\"t01\":{\"color\":\"red\"},\"t03\":{\"color\":\"orange\"},\"t02\":{\"color\":\"pink\"},\"t05\":{\"color\":\"green\"},\"t04\":{\"color\":\"yellow\"},\"t07\":{\"color\":\"blue\",\"label\":\"Default\"},\"t06\":{\"color\":\"lime\"},\"t09\":{\"color\":\"purple\"},\"t08\":{\"color\":\"sky\",\"label\":\"Glass\"}}}',NULL),
('appcenter',1,'theme_app_center_theme','App Center Theme','theme','2025-06-05 11:20:18','2025-06-05 11:20:18','{\"theme\":{\"className\":\"org.joget.plugin.enterprise.BuilderTheme.theme_app_center_theme\",\"properties\":{\"css\":\"<\\/style>\\n<link rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"#request.baseURL?html#/css/appCenter9.css?build=#platform.build?html#\\\" />\\n<style>\\n#dataList_applist > form > div > div.cards.row > div > div > h5 > div{\\n    box-shadow: rgba(17, 17, 26, 0.1) 0px 1px 0px;\\n    border-radius: 20%;\\n}\\n#home #dataList_applist .card-icon:hover .card-actions a{\\n    display:block !important;\\n}\",\"customLogin\":\"true\",\"hideSidebarUserMenu\":\"\",\"global-itemMarginBlock\":\"4px\",\"primaryColor\":\"#009265\",\"loginBackground\":\"\",\"disablePush\":\"\",\"global-contentPaddingInline\":\"40px\",\"global-controlHeight\":\"40px\",\"dx8borderColor\":\"rgba(5, 5, 5, 0.06)\",\"removeAssignmentTitle\":\"\",\"dx8-dark-sidebar-navBackground\":\"#111217\",\"global-itemMarginInline\":\"15px\",\"org.joget.theme.lib.DropdownComponent\":{\"prefix\":\"jgt-dd-\",\"className\":\"org.joget.theme.lib.DropdownComponent\",\"properties\":{\"controlItemBgHover\":\"rgba(0, 0, 0, 0.04)\",\"paddingBlock\":\"10px\",\"padding\":\"6px\",\"colorText\":\"rgba(0, 0, 0, 0.88)\",\"boxShadowSecondary\":\"0 6px 16px 0 rgba(0, 0, 0, 0.08), 0 3px 6px -4px rgba(0, 0, 0, 0.12), 0 9px 28px 8px rgba(0, 0, 0, 0.05)\",\"borderRadius\":\"8px\",\"controlPaddingHorizontal\":\"12px\",\"fontSize\":\"15px\",\"lineHeight\":\"1.5714285714285714\",\"colorBgElevated\":\"#FFFFFF\"}},\"dx8-dark-sidebar-navActiveLinkColor\":\"#FFFFFF\",\"shortcutLinkLabel\":\"Shortcut\",\"disableHelpGuide\":\"\",\"logo\":\"#request.contextPath#/images/dx9AppCenter/appCenterJogetVerticalWhite.png\",\"enableResponsiveSwitch\":\"true\",\"dx8-dark-sidebar-navLinkIcon\":\"rgba(255, 255, 255, 0.65)\",\"fav_icon\":\"\",\"horizontal_menu\":\"dark-sidebar\",\"global-sidebarWidth\":\"280px\",\"profile\":\"\",\"dx8-dark-sidebar-headerFontColor\":\"#111217\",\"homeAttractBanner\":\"\",\"global-headerPadding\":\"24px 40px\",\"global-padding\":\"16px\",\"formColor\":\"\",\"homeUrl\":\"\",\"dx8footerColor\":\"#252F4A\",\"disablePwa\":\"\",\"subheader\":\"\",\"dx8contentbackground\":\"#FFFFFF\",\"loginPageBottom\":\"\",\"org.joget.theme.lib.LoginPageComponent\":{\"prefix\":\"jgt-login-\",\"className\":\"org.joget.theme.lib.LoginPageComponent\",\"properties\":{\"template\":\"<!--{sampleWidth: \'100%\', tags: \'carousel\'}-->\\r\\n<style>\\r\\n  #loginButton{\\r\\n      margin-top:15px;\\r\\n  }\\r\\n  body#login{\\r\\n      background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-container-5 {\\r\\n    display: flex !important;\\r\\n    height: 100% !important;\\r\\n    background-size: cover !important;\\r\\n    background-position: center !important;\\r\\n    color: black;\\r\\n    background-color: #F4F6FA;\\r\\n  }\\r\\n  .login-form-5 {\\r\\n    border-radius: .8rem;\\r\\n    width: 100% !important;\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    background: #FFFFFF !important;\\r\\n    height: 100% !important;\\r\\n  }\\r\\n  .input-container-5 {\\r\\n    position: relative !important;\\r\\n    margin-bottom: 1rem !important;\\r\\n  }\\r\\n  .login-form-5 input {\\r\\n    height: 45px !important;\\r\\n  }\\r\\n  .login-form-5 input::placeholder {\\r\\n    color: rgba(0, 0, 0, 0.5) !important;\\r\\n  }\\r\\n  .login-form-5 form button {\\r\\n    border-color: #289FF5;\\r\\n    background-color: #289FF5;\\r\\n    border: none;\\r\\n    height: 48px !important;\\r\\n  }\\r\\n  .login-form-5 label {\\r\\n    font-weight: 600;\\r\\n    margin-bottom: 4px;\\r\\n    text-align: left;\\r\\n    float: left;\\r\\n  }\\r\\n  .car-5 .carousel-inner img {\\r\\n    width: 100%;\\r\\n    height: auto;\\r\\n  }\\r\\n  .car-5 .carousel-control-prev, .carousel .carousel-control-next {\\r\\n    display:none;\\r\\n  }\\r\\n  .car-5 .carousel-indicators button{\\r\\n    background-color: #fff;\\r\\n    border: none;\\r\\n    margin-bottom: 5px;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-background {\\r\\n      background-repeat: no-repeat;\\r\\n  \\t  background-size: cover;\\r\\n  \\t  height: 100%;\\r\\n  } \\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    filter: contrast(85%) !important;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    background-color: rgba(0, 0, 0, 0.4) !important;\\r\\n    width: 100% !important;\\r\\n    bottom: 0px !important;\\r\\n    left:0px !important;\\r\\n    height: 200px;\\r\\n  }\\r\\n  .login-form-5 p {\\r\\n    color: var(--jgt-tpgh-colorTextDescription);\\r\\n    font-weight: 700;\\r\\n    font-size: 16px;\\r\\n  }\\r\\n  .login-form-5 #loginButton {\\r\\n    font-weight: 500;\\r\\n  }\\r\\n  .login-form-5 form {\\r\\n    padding: 3.75rem !important;\\r\\n    width: 100%;\\r\\n    max-width: 500px;\\r\\n    margin: auto;\\r\\n    height: 700px;\\r\\n    text-align: center;\\r\\n  }\\r\\n  .login-form-5 .carousel-indicators{\\r\\n      margin-bottom: 20px;\\r\\n  }\\r\\n  @media (max-width: 767px){\\r\\n    .login-form-5 form {\\r\\n        padding: 3.75rem 0rem !important;\\r\\n    }\\r\\n  }\\r\\n  .login-form-5 input:focus:not([disabled]):not([readonly]),\\r\\n  .login-form-5 input:hover{\\r\\n      border-color: #009265 !important;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-5\\\">\\r\\n      <div class=\\\"login-form-5\\\">\\r\\n        <div class=\\\"row h-100\\\" style=\\\"margin:0\\\">\\r\\n          <div class=\\\"col-4 d-none d-sm-none d-md-block d-lg-block p-0 h-100\\\">\\r\\n            <!-- Carousel -->\\r\\n            <div id=\\\"carousel_{{id||}}\\\" class=\\\"carousel slide car-5\\\" data-ride=\\\"carousel\\\" style=\\\"height:100%\\\">\\r\\n              <div class=\\\"carousel-indicators\\\" data-hide=\\\"{{hideIndicator||false}}\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"carousel-inner\\\" style=\\\"height:100%\\\">\\r\\n              {{repeat||[{\\\"title\\\":\\\"Step Up to Joget DX 8\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control <br> With Enhanced Governance and UX.\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\\\"},{\\\"title\\\":\\\"Future Ready\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\\\"},{\\\"title\\\":\\\"Start Curious, Scale Serious.\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform <br> With No-Code Simplicity\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\\\"}]}}\\r\\n                <div class=\\\"carousel-item carousel-background\\\" style=\\\"background-image:url(\'{{repeat.image}}\');\\\">\\r\\n                  <div class=\\\"carousel-caption d-none d-md-block\\\" style=\\\"bottom:0px;\\\">\\r\\n                    <h4 style=\\\"color:{{repeat.titleColor}};font-weight:700;\\\">{{repeat.title}}<\\/h4>\\r\\n                      <p style=\\\"color:{{repeat.subtitleColor}}\\\">{{repeat.subtitle}}<\\/p>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n                {{repeat}}\\r\\n              <\\/div>\\r\\n            <\\/div>\\r\\n          <\\/div>\\r\\n          <div class=\\\"col-sm-12 col-md-8 p-4 p-lg-5 d-flex align-items-center justify-content-center h-100 flex-column text-center\\\">\\r\\n              <img src=\\\"#request.contextPath#/images/dx9AppCenter/appCenterJogetHorizontalGreen.png\\\" loading=\\\"lazy\\\" alt=\\\"\\\" class=\\\"image\\\" style=\\\"width: 200px;\\\">\\r\\n            <form style=\\\"width:100%;\\\">\\r\\n              <h2 class=\\\"mb-2\\\" style=\\\"{{titleColor||#000000}};\\\">{{title||Sign In to App Center}}<\\/h2>\\r\\n              <p class=\\\"mb-4\\\">Welcome back! Please enter your details.<\\/p>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customUsername||Username}}<\\/label>\\r\\n                <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"Enter your username\\\">\\r\\n              <\\/div>\\r\\n              <div class=\\\"mb-3 input-container-5\\\">\\r\\n                <label style=\\\"{{formColor||#000}}\\\">{{customPassword||Password}}<\\/label>\\r\\n                <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"Enter your password\\\">\\r\\n              <\\/div>\\r\\n              <button type=\\\"button\\\" style=\\\"background-color:{{btnColor||#009265}};\\\" class=\\\"btn btn-primary w-100\\\" id=\\\"loginButton\\\">{{btnText||Sign In}}<\\/button>\\r\\n            <\\/form>\\r\\n          <\\/div>\\r\\n          <script>\\r\\n              $(function(){\\r\\n                  var carousel = $(\\\"#carousel_{{id||}}\\\");\\r\\n                  //create navigation link\\r\\n                  $(carousel).find(\\\".carousel-item\\\").each(function(i){\\r\\n                      $(carousel).find(\'.carousel-indicators\').append(\'<button class=\\\"mx-1\\\" data-target=\\\"#carousel_{{id||}}\\\" data-slide-to=\\\"\'+i+\'\\\"><\\/button>\');\\r\\n                  });\\r\\n                  //active first slide\\r\\n                  $(carousel).find(\\\".carousel-item:first-child, .carousel-indicators button:first-child\\\").addClass(\\\"active\\\");\\r\\n                  //Initialise carousel\\r\\n                  $(carousel).carousel();\\r\\n            });\\r\\n          <\\/script> \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n<!---->\",\"image\":\"#appResource.appCenterBanner.png#\",\"btnText\":\"Sign In\",\"btnTextColor\":\"\",\"customLogin\":\"true\",\"cardColor\":\"\",\"title\":\"Sign In to App Center\",\"formColor\":\"\",\"customUsername\":\"Username\",\"subtitleColor\":\"\",\"titleColor\":\"#000000\",\"bgColor\":\"\",\"repeat\":[{\"image\":\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner1.png\",\"subtitleColor\":\"#FFFFFF\",\"titleColor\":\"#FFFFFF\",\"subtitle\":\"Next-Level Speed and Control <br> With Enhanced Governance and UX.\",\"title\":\"Step Up to Joget DX 8\"},{\"image\":\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner2.png\",\"subtitleColor\":\"#FFFFFF\",\"titleColor\":\"#FFFFFF\",\"subtitle\":\"Simple, Secure and Open Innovation Stack\",\"title\":\"Future Ready\"},{\"image\":\"#request.contextPath#/images/dx9AppCenter/appCenterLoginBanner3.png\",\"subtitleColor\":\"#FFFFFF\",\"titleColor\":\"#FFFFFF\",\"subtitle\":\"Enterprise-Grade Low-Code Application Development Platform <br> With No-Code Simplicity\",\"title\":\"Start Curious, Scale Serious.\"}],\"subtitle\":\"\",\"customPassword\":\"Password\",\"btnColor\":\"#009265\"}},\"dx8backgroundImage\":\"\",\"dx8-dark-sidebar-navBadge\":\"#FF4D4F\",\"global-headerHeight\":\"64px\",\"dx8-dark-sidebar-navLinkColor\":\"rgba(255, 255, 255, 0.65)\",\"template\":\"<!--{sampleWidth: \'100%\', tags: \'carousel\'}-->\\r\\n<style>\\r\\n  body#login{\\r\\n      background-color: {{bgColor||#F4F6FA}};\\r\\n  }\\r\\n  .login-container-5 {\\r\\n    display: flex !important;\\r\\n    height: 100% !important;\\r\\n    background-size: cover !important;\\r\\n    background-position: center !important;\\r\\n    color: black;\\r\\n    background-color: {{bgColor||#F4F6FA}};\\r\\n  }\\r\\n  .login-form-5 {\\r\\n    border-radius: .8rem;\\r\\n    width: 100% !important;\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    background: {{cardColor||#FFFFFF}} !important;\\r\\n    height: 100% !important;\\r\\n  }\\r\\n  .input-container-5 {\\r\\n    position: relative !important;\\r\\n    margin-bottom: 1rem !important;\\r\\n  }\\r\\n  .login-form-5 input {\\r\\n    height: 45px !important;\\r\\n  }\\r\\n  .login-form-5 input::placeholder {\\r\\n    color: rgba(0, 0, 0, 0.5) !important;\\r\\n  }\\r\\n  .login-form-5 form button {\\r\\n    border-color: {{btnColor||#289FF5}};\\r\\n    background-color: {{btnColor||#289FF5}};\\r\\n    border: none;\\r\\n    height: 48px !important;\\r\\n  }\\r\\n  .login-form-5 label {\\r\\n    font-weight: 600;\\r\\n    margin-bottom: 4px;\\r\\n    text-align: left;\\r\\n    float: left;\\r\\n  }\\r\\n  .car-5 .carousel-inner img {\\r\\n    width: 100%;\\r\\n    height: auto;\\r\\n  }\\r\\n  .car-5 .carousel-control-prev, .carousel .carousel-control-next {\\r\\n    display:none;\\r\\n  }\\r\\n  .car-5 .carousel-indicators button{\\r\\n    background-color: #fff;\\r\\n    border: none;\\r\\n    margin-bottom: 5px;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-background {\\r\\n      background-repeat: no-repeat;\\r\\n  \\t  background-size: cover;\\r\\n  \\t  height: 100%;\\r\\n  } \\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    filter: contrast(85%) !important;\\r\\n  }\\r\\n  .login-form-5 .carousel .carousel-inner .carousel-caption {\\r\\n    background-color: rgba(0, 0, 0, 0.4) !important;\\r\\n    width: 100% !important;\\r\\n    bottom: 0px !important;\\r\\n    left:0px !important;\\r\\n    height: 200px;\\r\\n  }\\r\\n  .login-form-5 p {\\r\\n    color: var(--jgt-tpgh-colorTextDescription);\\r\\n    font-weight: 700;\\r\\n    font-size: 16px;\\r\\n  }\\r\\n  .login-form-5 #loginButton {\\r\\n    font-weight: 500;\\r\\n  }\\r\\n  .login-form-5 form {\\r\\n    padding: 3.75rem !important;\\r\\n    width: 100%;\\r\\n    max-width: 500px;\\r\\n    margin: auto;\\r\\n    height: 700px;\\r\\n    text-align: center;\\r\\n  }\\r\\n  .login-form-5 .carousel-indicators{\\r\\n      margin-bottom: 20px;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-5\\\">\\r\\n  <div class=\\\"login-form-5\\\">\\r\\n    <div class=\\\"row h-100\\\" style=\\\"margin:0\\\">\\r\\n      <div class=\\\"col-4 d-none d-sm-none d-md-block d-lg-block p-0 h-100\\\">\\r\\n        <!-- Carousel -->\\r\\n        <div id=\\\"carousel_{{id||}}\\\" class=\\\"carousel slide car-5\\\" data-ride=\\\"carousel\\\" style=\\\"height:100%\\\">\\r\\n          <div class=\\\"carousel-indicators\\\" data-hide=\\\"{{hideIndicator||false}}\\\"><\\/div>\\r\\n          <div class=\\\"carousel-inner\\\" style=\\\"height:100%\\\">\\r\\n            {{repeat||[{\\\"title\\\":\\\"Start Curious, Scale Serious.\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Enterprise-Grade Low-Code Application Development Platform With No-Code Simplicity\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\\\"},{\\\"title\\\":\\\"Step Up to Joget DX 8\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Next-Level Speed and Control With Enhanced Governance and UX.\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-matreding-10410088.jpg#\\\"},{\\\"title\\\":\\\"Future Ready\\\",\\\"titleColor\\\":\\\"#FFFFFF\\\",\\\"subtitle\\\":\\\"Simple, Secure and Open Innovation Stack\\\",\\\"subtitleColor\\\":\\\"#FFFFFF\\\",\\\"image\\\":\\\"#appResource.pexels-thisisengineering-3861959.jpg#\\\"}]}}\\r\\n            <div class=\\\"carousel-item carousel-background\\\" style=\\\"background-image:url(\'{{repeat.image}}\');\\\">\\r\\n              <div class=\\\"carousel-caption d-none d-md-block\\\" style=\\\"bottom:0px;\\\">\\r\\n                <h4 style=\\\"color:{{repeat.titleColor}};font-weight:700;\\\">{{repeat.title}}<\\/h4>\\r\\n                <p style=\\\"color:{{repeat.subtitleColor}}\\\">{{repeat.subtitle}}<\\/p>\\r\\n              <\\/div>\\r\\n            <\\/div>\\r\\n            {{repeat}}\\r\\n          <\\/div>\\r\\n        <\\/div>\\r\\n      <\\/div>\\r\\n      <div class=\\\"col-sm-12 col-md-8 p-4 p-lg-5 d-flex flex-column h-100\\\" style=\\\"justify-content: center;align-items: center;\\\">\\r\\n        <img src=\\\"/jw/web/app/appcenter/resources/Joget_Horizontal_Green.png\\\" loading=\\\"lazy\\\" alt=\\\"\\\" class=\\\"image\\\" style=\\\"width: 200px;\\\">\\r\\n        <form>\\r\\n          <h3 class=\\\"mb-2\\\" style=\\\"color: #000000;\\\">Sign In to App Center<\\/h3>\\r\\n          <p class=\\\"mb-4\\\">Welcome back! Please enter your details.<\\/p>\\r\\n          <div class=\\\"mb-3 input-container-5\\\">\\r\\n            <label>Username<\\/label>\\r\\n            <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"Enter your username\\\">\\r\\n          <\\/div>\\r\\n          <div class=\\\"mb-3 input-container-5\\\">\\r\\n            <label>Password<\\/label>\\r\\n            <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"Enter your password\\\">\\r\\n          <\\/div>\\r\\n          <button type=\\\"button\\\" class=\\\"btn btn-primary w-100 mt-4\\\" id=\\\"loginButton\\\">Sign In<\\/button>\\r\\n        <\\/form>\\r\\n      <\\/div>\\r\\n        <script>\\r\\n              $(function(){\\r\\n                  var carousel = $(\\\"#carousel_{{id||}}\\\");\\r\\n                  //create navigation link\\r\\n                  $(carousel).find(\\\".carousel-item\\\").each(function(i){\\r\\n                      $(carousel).find(\'.carousel-indicators\').append(\'<button class=\\\"mx-1\\\" data-target=\\\"#carousel_{{id||}}\\\" data-slide-to=\\\"\'+i+\'\\\"><\\/button>\');\\r\\n                  });\\r\\n                  //active first slide\\r\\n                  $(carousel).find(\\\".carousel-item:first-child, .carousel-indicators button:first-child\\\").addClass(\\\"active\\\");\\r\\n                  //Initialise carousel\\r\\n                  $(carousel).carousel();\\r\\n            });\\r\\n        <\\/script>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n<\\/div>\\r\\n<!---->\",\"dx8background\":\"#F5F8FA\",\"dx8colorScheme\":\"rgb(249, 249, 249);rgb(59, 67, 72);rgb(3, 169, 244);rgb(110, 206, 251);rgb(255, 255, 255);rgb(255, 255, 255)\",\"global-contentWidth\":\"1920px\",\"global-fontSize\":\"15px\",\"js\":\"<\\/script>\\n<script type=\\\"text/javascript\\\" src=\\\"#request.baseURL?html#/js/appCenter9.js?build=#platform.build?html#\\\"><\\/script>\\n<script>\",\"title\":\"Sign In to App Center\",\"userMenu\":[],\"urlsToCache\":\"\",\"loginPageTop\":\"\",\"org.joget.theme.lib.InputComponent\":{\"prefix\":\"jgt-input-\",\"className\":\"org.joget.theme.lib.InputComponent\",\"properties\":{\"activeBg\":\"#FFFFFF\",\"hoverBg\":\"#FFFFFF\",\"colorText\":\"rgba(0, 0, 0, 0.88)\",\"inputFontSize\":\"14px\",\"paddingInline\":\"11px\",\"activeShadow\":\"0 0 0 2px rgba(5, 145, 255, 0.1)\",\"colorBgContainer\":\"#FFFFFF\",\"colorBgContainerDisabled\":\"rgba(0, 0, 0, 0.04)\",\"colorTextDescription\":\"rgba(0, 0, 0, 0.45)\",\"colorBorder\":\"#D9D9D9\",\"lineWidth\":\"1px\",\"colorIconHover\":\"rgba(0, 0, 0, 0.88)\",\"paddingBlock\":\"4px\",\"colorIcon\":\"rgba(0, 0, 0, 0.45)\",\"colorTextDisabled\":\"rgba(0, 0, 0, 0.25)\",\"borderRadius\":\"6px\",\"activeBorderColor\":\"\",\"hoverBorderColor\":\"\",\"lineType\":\"solid\",\"colorTextPlaceholder\":\"rgba(0, 0, 0, 0.25)\",\"fontSizeIcon\":\"12px\",\"lineHeight\":\"1.5714285714285714\",\"controlHeight\":\"32px\"}},\"userImage\":\"\",\"shortcut\":[],\"global-contentPaddingInlineSM\":\"15px\",\"titleColor\":\"#000000\",\"bgColor\":\"#F4F6FA\",\"global-itemHeight\":\"50px\",\"repeat\":[{\"image\":\"#appResource.pexels-anastasia-shuraeva-7279327.jpg#\",\"subtitleColor\":\"#FFFFFF\",\"titleColor\":\"#FFFFFF\",\"subtitle\":\"Enterprise-Grade Low-Code Application Development Platform With No-Code Simplicity\",\"title\":\"Start Curious, Scale Serious.\"},{\"image\":\"#appResource.pexels-matreding-10410088.jpg#\",\"subtitleColor\":\"#FFFFFF\",\"titleColor\":\"#FFFFFF\",\"subtitle\":\"Next-Level Speed and Control With Enhanced Governance and UX.\",\"title\":\"Step Up to Joget DX 8\"},{\"image\":\"#appResource.pexels-thisisengineering-3861959.jpg#\",\"subtitleColor\":\"#FFFFFF\",\"titleColor\":\"#FFFFFF\",\"subtitle\":\"Simple, Secure and Open Innovation Stack\",\"title\":\"Future Ready\"}],\"global-footerheight\":\"54px\",\"customPassword\":\"\",\"fontControl\":\"\",\"global-iconMarginInline\":\"10px\",\"org.joget.theme.lib.ButtonComponent\":{\"prefix\":\"jgt-btn-\",\"className\":\"org.joget.theme.lib.ButtonComponent\",\"properties\":{\"colorLinkHover\":\"\",\"colorPrimaryHover\":\"\",\"primaryColor\":\"#FFFFFF\",\"contentFontSize\":\"14px\",\"colorBgContainerDisabled\":\"rgba(0, 0, 0, 0.04)\",\"colorError\":\"#FF4D4F\",\"paddingBlock\":\"8px\",\"defaultBg\":\"#FFFFFF\",\"primaryShadow\":\"0 2px 0 rgba(5, 145, 255, 0.1)\",\"defaultColor\":\"rgba(0, 0, 0, 0.88)\",\"defaultShadow\":\"0 2px 0 rgba(0, 0, 0, 0.02)\",\"defaultHoverColor\":\"\",\"colorErrorActive\":\"#D9363E\",\"colorTextLightSolid\":\"#FFFFFF\",\"colorErrorBorderHover\":\"#FFA39E\",\"fontWeight\":\"400\",\"colorPrimary\":\"\",\"defaultActiveColor\":\"\",\"textHoverBg\":\"rgba(0, 0, 0, 0.06)\",\"contentLineHeight\":\"1\",\"paddingInline\":\"15px\",\"defaultHoverBorderColor\":\"\",\"defaultActiveBg\":\"#FFFFFF\",\"dangerShadow\":\"0 2px 0 rgba(255, 38, 5, 0.06)\",\"dangerColor\":\"#FFF\",\"colorErrorHover\":\"#FF7875\",\"colorBorder\":\"#D9D9D9\",\"defaultBorderColor\":\"#D9D9D9\",\"colorLink\":\"\",\"defaultHoverBg\":\"#FFFFFF\",\"colorTextDisabled\":\"rgba(0, 0, 0, 0.25)\",\"borderRadius\":\"6px\",\"defaultActiveBorderColor\":\"\",\"colorPrimaryActive\":\"\",\"colorLinkActive\":\"\",\"controlHeight\":\"32px\",\"borderColorDisabled\":\"#D9D9D9\",\"linkHoverBg\":\"#FFFFFF\"}},\"global-iconSize\":\"17px\",\"global-lineHeight\":\"1.5714285714285714\",\"global-borderRadiusLG\":\"8px\",\"dx8-dark-sidebar-navLinkBackground\":\"#111217\",\"btnText\":\"Sign In\",\"dx8-dark-sidebar-navBadgeText\":\"#FFFFFF\",\"cardColor\":\"#FFFFFF\",\"dx8-dark-sidebar-navScrollbarThumb\":\"#4D5F82\",\"global-boxShadowSecondary\":\"0 6px 16px 0 rgba(0, 0, 0, 0.08), 0 3px 6px -4px rgba(0, 0, 0, 0.12), 0 9px 28px 8px rgba(0, 0, 0, 0.05)\",\"org.joget.theme.lib.CardComponent\":{\"prefix\":\"jgt-card-\",\"className\":\"org.joget.theme.lib.CardComponent\",\"properties\":{\"padding\":\"29px\",\"colorText\":\"rgba(0, 0, 0, 0.88)\",\"borderRadiusLG\":\"8px\",\"colorBgContainer\":\"#FFFFFF\",\"fontWeightStrong\":\"500\",\"colorTextDescription\":\"rgba(0, 0, 0, 0.45)\",\"boxShadowCard\":\"\",\"fontSizeLG\":\"14px\",\"lineWidth\":\"1px\",\"headerBg\":\"#FFFFFF\",\"headerFontSize\":\"16px\",\"fontHeight\":\"22\",\"lineType\":\"solid\",\"colorBorderSecondary\":\"#F0F0F0\",\"lineHeight\":\"1.5714285714285714\",\"colorTextHeading\":\"rgba(0, 0, 0, 0.88)\",\"headerHeight\":\"56px\"}},\"subfooter\":\"\",\"customUsername\":\"\",\"dx8footerBackground\":\"#FFFFFF\",\"global-borderRadius\":\"6px\",\"dx8-dark-sidebar-navActiveIconColor\":\"#FFFFFF\",\"btnColor\":\"#289FF5\",\"dx8-dark-sidebar-headerColor\":\"#FFFFFF\",\"dx8-dark-subMenuBgColor\":\"#000C17\",\"dx8-dark-sidebar-navActiveLinkBackground\":\"\",\"inbox\":\"all\",\"global-footerPadding\":\"16px 50px\"}},\"properties\":{\"userviewId\":\"home\",\"name\":\"App Center Theme\",\"description\":\"\",\"id\":\"theme_app_center_theme\"}}',NULL),
('appcenter',1,'up-0497CD0F62BD44DEEAF1294D58166A1A','Design App','INTERNAL_USERVIEW_PAGE','2025-06-05 11:20:18','2025-11-13 12:01:35','{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Design App\",\"id\":\"62D864CCCAD74674CBF82B1887EE9B26\",\"tagName\":\"h3\",\"customId\":\"design_app_header\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Start by creating a plain new app or using an existing template.\\n\",\"id\":\"B69F59B079144EB38CD70DAD453DC970\",\"tagName\":\"h5\",\"customId\":\"design_app_header_subtitle\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-mobile-max-width\":\"100%\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-mobile-flex\":\"0 0 100%\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-text-align\":\"right\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<div class=\\\"design-view-options\\\">\\n  <a id=\\\"per-view\\\">\\n    <i class=\\\"far fa-bookmark\\\"><\\/i>\\n  <\\/a>\\n  <a id=\\\"grid-view\\\">\\n    <i class=\\\"far fa-images\\\"><\\/i>\\n  <\\/a>\\n  <a href=\\\"templates\\\" id=\\\"view-templates\\\" style=\\\"text-decoration: none\\\">\\n  \\t+ View All\\n  <\\/a>\\n<\\/div>\\n\\n<style>\\n  @media (max-width:768px) {\\n   \\t#design_app_heading .row {\\n      width: calc(100% - 10px);\\n    } \\n  }\\n<\\/style>\",\"id\":\"0AAF618F95284278332C89C89EA2460B\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-mobile-max-width\":\"100%\",\"style-text-align\":\"right\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-mobile-flex\":\"0 0 100%\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"5px\",\"columns\":[{\"style-mobile-max-width\":\"100%\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"100%\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"css-mobile-stack-columns\":\"true\",\"col-1-style-text-align\":\"right\",\"id\":\"7E014A6F9B354BADFF8D9521ED52C33C\",\"customId\":\"design_app_heading\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<style>\\n.actions > a > .fas:hover {\\n\\ttransform: scale(1.2);\\n  cursor: pointer;\\n}\\n<\\/style>\\n<div class=\\\"row align-items-center\\\">\\n  <div class=\\\"col-lg-6 col-12\\\">\\n    <img class=\\\"w-100\\\" src=\\\"#request.contextPath?html#/images/dx9AppCenter/jogetAppLab.svg\\\">\\n  <\\/div>\\n  <div class=\\\"col-12 col-lg-6 p-lg-5 p-3 pt-3 col-description\\\">\\n    <span>Create Your Own App<\\/span>\\n\\t<h1>\\n      Create your own enterprise application with Joget.\\n    <\\/h1>\\n\\t<div class=\\\"actions\\\">\\n        <a class=\\\"btn\\\" href=\\\"javascript:appCreate(\'\');\\\">\\n          Create New App\\n        <\\/a>\\n\\t<a><span class=\\\"arrow-message\\\">Next<\\/span><i onclick=\\\"goNext(this); return false;\\\" class=\\\"fas fa-long-arrow-alt-right\\\" title=\\\"Scroll Right\\\"><\\/i><\\/a>\\n\\t\\t<ul><li><\\/li><li><\\/li><li><\\/li><\\/ul>\\n    <\\/div>\\n  <\\/div>\\n<\\/div>\\n<script>\\nlet touchStartX = 0;\\nlet touchEndX = 0;\\n\\nconst swipeThreshold = 30;\\n\\n$(document).on(\\\"touchstart\\\", \\\"body#design_app #perPageView > .row > .col\\\", function (e) {\\n  touchStartX = e.originalEvent.touches[0].clientX;\\n});\\n\\n$(document).on(\\\"touchend\\\", \\\"body#design_app #perPageView > .row > .col\\\", function (e) {\\n  touchEndX = e.originalEvent.changedTouches[0].clientX;\\n  const distance = touchEndX - touchStartX;\\n  const target = e.currentTarget;\\n  if (Math.abs(distance) > swipeThreshold) {\\n    if (distance < 0) {\\n      goNext($(target).find(\\\".actions\\\"));\\n    } else {\\n      goPrev($(target).find(\\\".actions\\\"))\\n    }\\n  }\\n});\\n  \\nfunction goNext(el) { \\n  var $parent = $(el).closest(\\\".HtmlCodeComponent\\\").parent();\\n  \\n  if ($parent.next().length > 0) {\\n    $parent.removeClass(\\\"show\\\");\\n\\t$parent.next().addClass(\\\"show\\\");\\n  }\\n}\\nfunction goPrev(el) { \\n  var $parent = $(el).closest(\\\".HtmlCodeComponent\\\").parent();\\n  \\n  if ($parent.prev().length > 0) {\\n    $parent.removeClass(\\\"show\\\");\\n\\t$parent.prev().addClass(\\\"show\\\");\\n  }\\n}\\n<\\/script>\",\"id\":\"4D16E06E795A458DE28578296744C4D4\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}}}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<style>\\n  .actions > .dropdown {\\n    position:relative;\\n  }\\n  .actions > .dropdown > .dropdown-box {\\n    display: none;\\n\\tposition: absolute;\\n    top: 100%;\\n    z-index: 1000;\\n  }\\n  .actions > .dropdown.show > .dropdown-box {\\n    display: block;\\n  }\\n<\\/style>\\n<div class=\\\"row align-items-center\\\" id=\\\"businessHub\\\">\\n  <div class=\\\"col-lg-6 col-12\\\">\\n    <img class=\\\"w-100\\\" src=\\\"#request.contextPath?html#/images/dx9AppCenter/jogetBusinessHub.svg\\\">\\n  <\\/div>\\n  <div class=\\\"col-12 col-lg-6 p-lg-5 p-3 pt-3 col-description\\\">\\n    <span>Customer, Supplier & Partner<\\/span>\\n\\t<h1>\\n      Enhance business management and relationships among all.\\n    <\\/h1>\\n\\t<div class=\\\"actions\\\">\\n        <div class=\\\"dropdown\\\">\\n          Use Template\\n\\t\\t\\t<div class=\\\"dropdown-box\\\">\\n              <a>Use Template<\\/a>\\n\\t\\t\\t  <a>More Info<\\/a>\\n          <\\/div>\\n      <\\/div>\\n  <a onclick=\\\"goPrev(this); return false;\\\"><i class=\\\"fas fa-long-arrow-alt-left\\\" title=\\\"Scroll Left\\\"><\\/i><\\/a>\\n<span class=\\\"arrow-message\\\">Switch<\\/span>\\n<a onclick=\\\"goNext(this); return false;\\\"><i class=\\\"fas fa-long-arrow-alt-right\\\" title=\\\"Scroll Right\\\"><\\/i><\\/a>\\n    <ul><li><\\/li><li><\\/li><li><\\/li><\\/ul>\\n    <\\/div>\\n  <\\/div>\\n<\\/div>\\n<script>\\n$(\\\".actions > .dropdown\\\").off(\\\"click\\\").on(\\\"click\\\", function(){\\n  $(this).toggleClass(\\\"show\\\");\\n})\\n$(\\\"body\\\").off(\\\"click.dropdown\\\").on(\\\"click.dropdown\\\", function(e){\\n  const target = $(e.target); \\n\\n  if (target.closest(\\\".dropdown\\\").length === 0) {\\n    $(\\\".actions > .dropdown\\\").removeClass(\\\"show\\\");\\n  }\\n})\\n$(document).ready(function(){\\n  var $cardActions = $(\\\"#gridView form[name=\'form_list_newTemplate\'] .cards > :first-child\\\").find(\\\".card-actions\\\");\\n\\n\\t$(\\\"#businessHub\\\").find(\\\".actions > .dropdown > .dropdown-box > a:first-child\\\").attr(\'href\', $cardActions.children().eq(0).attr(\'href\'))\\n\\n$(\\\"#businessHub\\\").find(\\\".actions > .dropdown > .dropdown-box > a:last-child\\\").attr(\'href\', $cardActions.children().eq(1).attr(\'href\'))\\n})\\n<\\/script>\",\"id\":\"57C6AD0D399D42B32D9FA06041016FD6\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}}}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<div class=\\\"row align-items-center\\\" id=\\\"approvalHub\\\">\\n  <div class=\\\"col-lg-6 col-12\\\">\\n    <img class=\\\"w-100\\\" src=\\\"#request.contextPath?html#/images/dx9AppCenter/jogetApprovalHub.svg\\\">\\n  <\\/div>\\n  <div class=\\\"col-12 col-lg-6 p-lg-5 p-3 pt-3 col-description\\\">\\n    <span>Single Level Approval and Clarification<\\/span>\\n\\t<h1>\\n      Provides a quick way to rapidly kickstart app development.\\n    <\\/h1>\\n\\t<div class=\\\"actions\\\">\\n        <div class=\\\"dropdown\\\">\\n          Use Template\\n\\t\\t\\t<div class=\\\"dropdown-box\\\">\\n              <a>Use Template<\\/a>\\n\\t\\t\\t  <a>More Info<\\/a>\\n          <\\/div>\\n      <\\/div>\\n  <a onclick=\\\"goPrev(this); return false;\\\"><i class=\\\"fas fa-long-arrow-alt-left\\\" title=\\\"Scroll Left\\\"><\\/i><\\/a>\\n<span class=\\\"arrow-message\\\">Previous<\\/span>\\n<ul><li><\\/li><li><\\/li><li><\\/li><\\/ul>\\n    <\\/div>\\n<\\/div>\\n<\\/div>\\n<script>\\n$(\\\".actions > .dropdown\\\").off(\\\"click\\\").on(\\\"click\\\", function(){\\n  $(this).toggleClass(\\\"show\\\");\\n})\\n$(document).ready(function(){\\n  var $cardActions2 = $(\\\"#gridView form[name=\'form_list_newTemplate\'] .cards > :last-child\\\").find(\\\".card-actions\\\");\\n\\n\\t$(\\\"#approvalHub\\\").find(\\\".actions > .dropdown > .dropdown-box > a:first-child\\\").attr(\'href\', $cardActions2.children().eq(0).attr(\'href\'))\\n\\n$(\\\"#approvalHub\\\").find(\\\".actions > .dropdown > .dropdown-box > a:last-child\\\").attr(\'href\', $cardActions2.children().eq(1).attr(\'href\'))\\n})\\n<\\/script>\",\"id\":\"055786ED9AA44A7F7306D3855978460A\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}}}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"css-mobile-stack-columns\":\"true\",\"id\":\"3D909CAD478049D694A74BC06EA8408C\",\"customId\":\"perPageView\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<style>\\n    @media only screen and (min-width: 1681px) {\\n      .row_clone {\\n            display: none;\\n        }\\n    }\\n<\\/style>\\n<div class=\\\"card data-row createAppCard\\\">\\n    <div class=\\\"card-body\\\">\\n        <div class=\\\"ph_columns column_5 column_body column_img body_column_5 card-text\\\">\\n            <div style=\\\"background-image:url(\'#request.contextPath#/images/dx9AppCenter/jogetAppLabWithBorder.svg\');height:0;padding-bottom:50%;width:100%;background-size:cover;background-repeat: no-repeat;display:inline-block;border-radius:4px\\\"><\\/div>\\n        <\\/div> \\n        <div style=\\\"\\\" class=\\\"ph_columns column_0 column_body column_name body_column_0 card-text\\\">\\n            Create Your App\\n        <\\/div>     \\n        <div style=\\\"\\\" class=\\\"ph_columns column_6 column_body column_desc body_column_6 card-text\\\">\\n            <p>Create your own enterprise application with Joget.<\\/p>\\n        <\\/div>\\n        <div class=\\\"card-actions\\\">\\n            <a href=\\\"javascript:appCreate(\'\');\\\" target=\\\"_self\\\" class=\\\"ph_rowActions rowAction_0 rowaction_body body_rowAction_0  btn btn-sm btn-primary link_rowAction_0\\\">Create New App<\\/a>\\n        <\\/div>\\n    <\\/div>\\n<\\/div>\\n<style>\\n    @media (max-width: 766px) {\\n        .createAppCard .card-actions > a {\\n            width:100%;\\n        }\\n    }\\n<\\/style>\",\"color\":\"#348fe2\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"id\":\"EC89DBB912E2451322834E357EFEF5F9\",\"title\":\"TOTAL VISITS\",\"customId\":\"\",\"value\":\"3,291,922\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-mobile-max-width\":\"100%\",\"style-mobile-padding-right\":\"0px\",\"style-tablet-flex\":\"0 0 100%\",\"style-mobile-padding-left\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-flex\":\"0 0 33.33%\",\"style-mobile-margin-bottom\":\"0px\",\"style-mobile-flex\":\"0 0 100%\",\"style-tablet-margin-bottom\":\"60px\",\"style-max-width\":\"33.33%\",\"style-tablet-max-width\":\"100%\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.DataListMenu\",\"properties\":{\"cacheAllLinks\":\"\",\"customHeader\":\"\",\"style-border-bottom-width\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"keyName\":\"\",\"customFooter\":\"\",\"enableOffline\":\"\",\"label\":\"List\",\"customId\":\"newTemplate\",\"buttonPosition\":\"bottomLeft\",\"datalistId\":\"list_newTemplate\",\"checkboxPosition\":\"no\",\"selectionType\":\"multiple\",\"userviewCacheDuration\":\"20\",\"cacheListAction\":\"\",\"userviewCacheScope\":\"\",\"style-border-left-width\":\"0px\",\"style-border-right-width\":\"0px\",\"id\":\"85384F9C698948E1CB5A00FB08FE4A3F\",\"rowCount\":\"\",\"style-border-top-width\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-mobile-max-width\":\"100%\",\"style-tablet-flex\":\"0 0 100%\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-mobile-flex\":\"0 0 100%\",\"style-tablet-max-width\":\"100%\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"15px\",\"columns\":[{\"style-mobile-max-width\":\"100%\",\"style-max-width\":\"33.33%\",\"style-tablet-max-width\":\"100%\"},{\"style-mobile-max-width\":\"100%\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"100%\"}],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"css-mobile-stack-columns\":\"true\",\"col-0-style-tablet-margin-bottom\":\"60px\",\"col-0-style-mobile-padding-left\":\"0px\",\"col-0-style-mobile-padding-right\":\"0px\",\"id\":\"B28AB2BFC72B4764DE5EACAF8BFD5C3C\",\"col-0-style-mobile-margin-bottom\":\"0px\",\"customId\":\"gridView\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-padding-right\":\"0px\",\"style-padding-bottom\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"id\":\"894EDF7ED18C446DEF9B2A341D113819\",\"style-padding-top\":\"0px\",\"customId\":\"\",\"style-padding-left\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-tablet-padding-bottom\":\"26px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-padding-top\":\"26px\",\"style-tablet-padding-left\":\"26px\",\"style-tablet-padding-right\":\"26px\",\"id\":\"E28DDE2DA6A24615F1F18665B87591C1\",\"customId\":\"designAppSection\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<ul id=\\\"nav\\\">\\n  <li id=\\\"tutorial-nav\\\" data-target=\\\"tutorial\\\">Tutorial<\\/li>\\n  <li id=\\\"joget-academy-nav\\\" data-target=\\\"joget_academy\\\">Academy<\\/li>\\n  <li id=\\\"community-nav\\\" data-target=\\\"community\\\">Community<\\/li>\\n  <li id=\\\"connect-nav\\\" data-target=\\\"contact\\\">Connect<\\/li>\\n<\\/ul>\",\"id\":\"48A86437061C4B57C688892C799A185D\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}}}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<div class=\\\"design-app-arrows\\\" style=\\\"text-align:right;\\\">\\n  <i class=\\\"fas fa-long-arrow-alt-left\\\" id=\\\"left-arrow\\\" title=\\\"Scroll Left\\\" style=\\\"margin-right: 25px\\\"><\\/i>\\n  <i class=\\\"fas fa-long-arrow-alt-right\\\" id=\\\"right-arrow\\\" title=\\\"Scroll Right\\\"><\\/i>\\n<\\/div>\",\"id\":\"0DFFE3E005374882222C3DC16420D990\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-mobile-display\":\"none\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}}}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"5px\",\"style-margin-top\":\"32px\",\"col-1-style-mobile-display\":\"none\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"css-mobile-stack-columns\":\"true\",\"style-tablet-padding-left\":\"26px\",\"style-tablet-padding-right\":\"26px\",\"id\":\"6B059C148C62444D05EF9B4B2F6FC259\",\"customId\":\"design_nav\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Joget provides an all-encompassing ecosystem that supports community learning and adoption.\",\"id\":\"7FE0F6E946214F0512FAE24EF7850437\",\"tagName\":\"h3\",\"customId\":\"community_title\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<div class=\\\"main-wrapper\\\">\\n\\t<a href=\\\"https://marketplace.joget.org/\\\" title=\\\"Visit Marketplace\\\" target=\\\"_blank\\\"><i class=\\\"material-icons fas fa-cart-arrow-down\\\"><\\/i><\\/a>\\n<\\/div>\\n<style>\\n.main-wrapper {\\n\\t\\tborder-radius: 4px;\\n\\t\\tpadding-bottom: 28px;\\n  \\t\\tpadding-left: 0px;\\n\\t\\tposition: relative;\\n\\t\\ttext-align: left;\\n}\\n\\ni.material-icons {\\n  \\t\\tborder: 2px solid var(--jgt-btn-colorPrimary);\\n\\t\\tfont-size: 2rem;\\n\\t\\tposition: relative;\\n\\t\\tborder-radius: 20%;\\n        padding:0px;\\n        padding-top: 13px;\\n\\t\\twidth: 60px;\\n\\t\\theight: 60px;\\n\\t\\ttext-align:center;\\n        filter: drop-shadow(10px 10px 4px #20C0803D);\\n\\t\\ttransition: color 0.2s ease, background-color 0.2s ease, transform 0.3s ease;\\n  \\t\\tcolor:rgba(255, 255, 255, 1);\\n}\\n\\ni.material-icons:nth-of-type(1) {\\n\\t\\tbackground: linear-gradient(180deg, #67DAB3 0%, #03A46D 100%);\\n;\\n}\\n\\ni.material-icons:nth-of-type(1):hover {\\n  transform: scale(1.2);\\n}\\n\\ni.material-icons:hover {\\n\\t\\tcursor: pointer;\\n      \\tborder: 2px solid var(--jgt-btn-colorPrimary);\\n}\\n\\n\\ti.material-icons:after {\\n\\t\\tborder-width:3px;\\n\\t\\ttop:-3px;\\n\\t\\tleft:-3px;\\n}\\n<\\/style>\",\"id\":\"2ACDC80FA2A44B218C91F8C39E0DF4B8\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-text-align\":\"center\",\"style-color\":\"#092E28\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-font-size\":\"18px\",\"textContent\":\"Marketplace\",\"id\":\"448F700BAF5149815388EB18DA8C7625\",\"tagName\":\"h3\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.ParagraphComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-text-align\":\"center\",\"style-margin-top\":\"5px\",\"style-text-align\":\"left\",\"style-margin-bottom\":\"5px\",\"style-color\":\"#7F7F7F\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<p class=\\\"CDesc\\\" style=\\\"text-align: left;\\\"><span style=\\\"color: rgb(127, 127, 127);\\\">Download ready-made apps, plugins, templates and more from the Joget Marketplace.<\\/span><\\/p>\",\"style-font-size\":\"14px\",\"id\":\"E6B7B892B5B04704553606084A16B7B8\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"id\":\"509C21F0A5BC438EBE516D5D20CBA9FE\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-tablet-flex\":\"0 0 50%\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-max-width\":\"50%\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<div class=\\\"main-wrapper\\\">\\n    <a class=\\\"d-block overlay\\\" title=\\\"Join Q&A\\\" data-fslightbox=\\\"lightbox-hot-sales\\\" href=\\\"https://answers.joget.org/\\\" target=\\\"_blank\\\">\\n    <i class=\\\"material-icons far fa-comment\\\"><\\/i><\\/a><\\/div>\",\"id\":\"916900706C6C4A0ABBF9F35B5E24BE04\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-text-align\":\"center\",\"style-color\":\"#092E28\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-font-size\":\"18px\",\"textContent\":\"Community\",\"id\":\"D5DC6C7719374E74B58440457DC060C1\",\"tagName\":\"h3\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.ParagraphComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"5px\",\"style-text-align\":\"left\",\"style-margin-bottom\":\"5px\",\"style-margin-left\":\"15px\",\"style-margin-right\":\"15px\",\"style-color\":\"#7F7F7F\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<p class=\\\"CDesc\\\" style=\\\"text-align: left;\\\"><span style=\\\"color: rgb(127, 127, 127);\\\">Join the Community Q&amp;A Site to ask questions, get answers, and help others in the Joget Community.<\\/span><\\/p>\",\"style-font-size\":\"14px\",\"id\":\"762736AA96C04E39A72AED0921D31885\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"id\":\"C7B8DDF8E523426A9AB2A48008E7B2AF\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-tablet-flex\":\"0 0 50%\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-max-width\":\"50%\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<div class=\\\"main-wrapper\\\">\\n    <a href=\\\"https://dev.joget.org/community/display/DX9/Knowledge+Base+for+DX+9+Home\\\" title=\\\"Learn More\\\"  target=\\\"_blank\\\">\\n        <i class=\\\"material-icons fas fa-book\\\"><\\/i>\\n    <\\/a>\\n<\\/div>\",\"id\":\"65E59C4D3DEA4A340EE9A191A0AD1309\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-text-align\":\"center\",\"style-color\":\"#092E28\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-font-size\":\"18px\",\"textContent\":\"Knowledge Base\",\"id\":\"32A31AFE93AD4E8972F961DA9413F2CB\",\"tagName\":\"h3\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.ParagraphComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"5px\",\"style-text-align\":\"left\",\"style-margin-bottom\":\"5px\",\"style-margin-left\":\"15px\",\"style-margin-right\":\"15px\",\"style-color\":\"#7F7F7F\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<p class=\\\"CDesc\\\" style=\\\"text-align: left;\\\"><span style=\\\"color: rgb(127, 127, 127);\\\">Access additional tutorials, user and developer references, samples and other documentation.<\\/span><\\/p>\",\"style-font-size\":\"14px\",\"id\":\"87758A93338C4548A0A4D65B8C28277D\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"id\":\"FAD504E59B3D4299629220E87BC9EC67\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-tablet-flex\":\"0 0 50%\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-max-width\":\"50%\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<div class=\\\"main-wrapper\\\">\\n    <a href=\\\"https://github.com/jogetworkflow/jw-community\\\" title=\\\"Contribute\\\" target=\\\"_blank\\\">\\n    <i class=\\\"material-icons fas fa-code-branch\\\"><\\/i><\\/a><\\/div>\",\"id\":\"D2CF91C4D7C5437480CDDA9A3C7B216B\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-color\":\"#092E28\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-font-size\":\"18px\",\"textContent\":\"Open-Source\",\"id\":\"0626BAF45D2C42DC63DA1EDACF526E7A\",\"tagName\":\"h3\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.ParagraphComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"5px\",\"style-margin-bottom\":\"5px\",\"style-margin-left\":\"15px\",\"style-margin-right\":\"15px\",\"style-color\":\"#7F7F7F\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<p class=\\\"CDesc\\\" style=\\\"text-align: left;\\\"><span style=\\\"color: rgb(127, 127, 127);\\\">Join the open-source GitHub project to access and contribute to the source code.<\\/span><\\/p>\",\"style-font-size\":\"14px\",\"id\":\"1B94BC42311F49161181F2592D1DAD64\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"id\":\"59BC95C981F741A9E8540498B9D7FB0C\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-tablet-flex\":\"0 0 50%\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-max-width\":\"50%\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<div class=\\\"main-wrapper\\\">\\n    <a href=\\\"https://translate.joget.org/\\\" title=\\\"Contribute\\\" target=\\\"_blank\\\">\\n\\t<i class=\\\"material-icons zmdi zmdi-translate\\\"><\\/i>\\n\\t<\\/a>\\n<\\/div>\",\"id\":\"0D3738F89B8A47A811C3FEEA2A933E47\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-color\":\"#343A40\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-font-size\":\"17px\",\"textContent\":\"Translations\",\"id\":\"7B7F2B42C4284153A887E1B304787C34\",\"tagName\":\"h3\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.ParagraphComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"5px\",\"style-text-align\":\"left\",\"style-margin-bottom\":\"5px\",\"style-margin-left\":\"15px\",\"style-margin-right\":\"15px\",\"style-color\":\"#99A1B7\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<p class=\\\"CDesc\\\" style=\\\"text-align: left;\\\"><span style=\\\"color: rgb(127, 127, 127);\\\">Get translations for more than 20 languages, and contribute to the translation effort in Joget Translations.<\\/span><\\/p>\",\"id\":\"94E5F7B0EE564961F77C6D1B01EB0E38\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"id\":\"3A991DD795AE4417D39476B575931DF5\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-tablet-flex\":\"0 0 50%\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-max-width\":\"50%\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"5px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"50%\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"50%\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"50%\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"50%\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"50%\"}],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"css-mobile-stack-columns\":\"true\",\"style-mobile-margin-bottom\":\"25px\",\"id\":\"3307DF771D8147B828F22160F3D4C3BB\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-border-bottom-width\":\"1px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-border-color\":\"#F1F1F4\",\"customId\":\"community\",\"style-margin-top\":\"32px\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"style-tablet-padding-left\":\"26px\",\"style-tablet-padding-right\":\"26px\",\"id\":\"D9A0DA38899244D17C759066A21BDE07\",\"style-border-top-width\":\"1px\",\"style-border-radius\":\"0.625em\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.ButtonComponent\",\"properties\":{\"attr-data-events-listening\":[],\"css-display-type\":\"btn btn-light\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Part 1\",\"id\":\"AE79BE87C75B4910A75B7919DB0624B1\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Designing a New App\",\"id\":\"BF306ED470504F0C2868917CD2F4A3A4\",\"tagName\":\"h3\",\"customId\":\"\"}},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<a href=\\\"#request.appCenterVideo1#\\\" target=\\\"_blank\\\"><img src=\\\"#request.contextPath?html#/images/dx9AppCenter/designNewApp.svg\\\"><\\/a>\",\"id\":\"574A193305A648131929F345E8CA4D62\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-tablet-padding-bottom\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-padding-top\":\"0px\",\"style-tablet-padding-left\":\"0px\",\"style-tablet-padding-right\":\"0px\",\"id\":\"A2709E96C76C4AF9E1FF88B78FFB2CB5\",\"style-tablet-margin-bottom\":\"0px\",\"style-tablet-margin-top\":\"0px\",\"customId\":\"\",\"style-tablet-margin-right\":\"0px\",\"style-tablet-margin-left\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-right\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-padding-left\":\"0px\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.ButtonComponent\",\"properties\":{\"attr-data-events-listening\":[],\"css-display-type\":\"btn btn-light\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<p>Part 2<\\/p>\",\"id\":\"FCD5B5CD196A419684218160500E45BD\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Designing a Form\",\"id\":\"4369CC3A09B048425C4B7B9F4F9BCC36\",\"tagName\":\"h3\",\"customId\":\"\"}},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<a href=\\\"#request.appCenterVideo2#\\\" target=\\\"_blank\\\"><img src=\\\"#request.contextPath?html#/images/dx9AppCenter/designNewForm.svg\\\"><\\/a>\\n\",\"id\":\"C405833F3BF24C150C74C1E97CD6DF9C\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-padding-right\":\"0px\",\"style-tablet-padding-bottom\":\"0px\",\"style-mobile-padding-left\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-padding-top\":\"0px\",\"style-tablet-margin-top\":\"0px\",\"customId\":\"\",\"style-tablet-margin-right\":\"0px\",\"style-tablet-padding-left\":\"0px\",\"style-tablet-padding-right\":\"0px\",\"id\":\"F2E0A0C8D1BA471A2DD20DC6C2617859\",\"style-tablet-margin-bottom\":\"0px\",\"style-tablet-margin-left\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-right\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-padding-left\":\"0px\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.ButtonComponent\",\"properties\":{\"attr-data-events-listening\":[],\"css-display-type\":\"btn btn-light\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Part 3\",\"id\":\"1B94BE31FC8F40E825C1750733D02985\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Designing a List\",\"id\":\"E49F885ABF4A4303BBEAF0D22ED3A780\",\"tagName\":\"h3\",\"customId\":\"\"}},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<a href=\\\"#request.appCenterVideo3#\\\" target=\\\"_blank\\\"><img src=\\\"#request.contextPath?html#/images/dx9AppCenter/designNewList.svg\\\"><\\/a>\",\"id\":\"DB10948065604FAF4F44FBD83F56CC06\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-padding-right\":\"0px\",\"style-tablet-padding-bottom\":\"0px\",\"style-mobile-padding-left\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-padding-top\":\"0px\",\"style-tablet-margin-top\":\"0px\",\"customId\":\"\",\"style-tablet-margin-right\":\"0px\",\"style-tablet-padding-left\":\"0px\",\"style-tablet-padding-right\":\"0px\",\"id\":\"CE96F65605F543A0E846788EFDDE3792\",\"style-tablet-margin-bottom\":\"0px\",\"style-tablet-margin-left\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-right\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-padding-left\":\"0px\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.ButtonComponent\",\"properties\":{\"attr-data-events-listening\":[],\"css-display-type\":\"btn btn-light\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Part 4\",\"id\":\"D4F27524582847FB77BCF7B53DF439F6\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Designing a Userview\",\"id\":\"76ED1CAAB79D4374E1CE8302B6229AE4\",\"tagName\":\"h3\",\"customId\":\"\"}},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<a href=\\\"#request.appCenterVideo4#\\\" target=\\\"_blank\\\"><img src=\\\"#request.contextPath?html#/images/dx9AppCenter/designNewUserview.svg\\\"><\\/a>\",\"id\":\"C1390B1B3FC744BB2F9417C7436FF9C2\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-padding-right\":\"0px\",\"style-tablet-padding-bottom\":\"0px\",\"style-mobile-padding-left\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-padding-top\":\"0px\",\"style-tablet-margin-top\":\"0px\",\"customId\":\"\",\"style-tablet-margin-right\":\"0px\",\"style-tablet-padding-left\":\"0px\",\"style-tablet-padding-right\":\"0px\",\"id\":\"EEC838FB7B424A1E966F75E89DD5F427\",\"style-tablet-margin-bottom\":\"0px\",\"style-tablet-margin-left\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-right\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-padding-left\":\"0px\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.ButtonComponent\",\"properties\":{\"attr-data-events-listening\":[],\"css-display-type\":\"btn btn-light\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Part 5\",\"id\":\"54D3EADE1350402FA7DC332AE4CC7543\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Designing a Process\",\"id\":\"55835C1766D04CD3F43A87DB542B8BFB\",\"tagName\":\"h3\",\"customId\":\"\"}},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<a href=\\\"#request.appCenterVideo5#\\\" target=\\\"_blank\\\"><img src=\\\"#request.contextPath?html#/images/dx9AppCenter/designNewProcess.svg\\\" style=\\\"width:100%\\\"><\\/a>\\n\\n\",\"id\":\"CCDB6C8362784811A89331041CBA8BF9\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-padding-right\":\"0px\",\"style-tablet-padding-bottom\":\"0px\",\"style-mobile-padding-left\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-padding-top\":\"0px\",\"style-tablet-margin-top\":\"0px\",\"customId\":\"\",\"style-tablet-margin-right\":\"0px\",\"style-tablet-padding-left\":\"0px\",\"style-tablet-padding-right\":\"0px\",\"id\":\"D7200E151B2842CD0A208F9A3BFD78DC\",\"style-tablet-margin-bottom\":\"0px\",\"style-tablet-margin-left\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-display\":\"block\",\"style-display\":\"none\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.ButtonComponent\",\"properties\":{\"attr-data-events-listening\":[],\"css-display-type\":\"btn btn-light\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Part 6\",\"id\":\"FFE38A5F76534BB77E0011D1D5F41253\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Generative AI\",\"id\":\"DD3AE3E772EA40988F8B69DE3D6BA29F\",\"tagName\":\"h3\",\"customId\":\"\"}},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<a href=\\\"#request.appCenterVideo6#\\\" target=\\\"_blank\\\"><img src=\\\"#request.contextPath?html#/images/dx9AppCenter/designNewAi.svg\\\" style=\\\"width:100%\\\"><\\/a>\",\"id\":\"BFAAFC6E5D4C4908956A61E73D576229\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-padding-right\":\"0px\",\"style-tablet-padding-bottom\":\"0px\",\"style-mobile-padding-left\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-padding-top\":\"0px\",\"style-tablet-margin-top\":\"0px\",\"customId\":\"\",\"style-tablet-margin-right\":\"0px\",\"style-tablet-padding-left\":\"0px\",\"style-tablet-padding-right\":\"0px\",\"id\":\"1AE04EB18E6D4A8133E51CE686EEC945\",\"style-tablet-margin-bottom\":\"0px\",\"style-tablet-margin-left\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-top\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-display\":\"block\",\"style-display\":\"none\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"col-3-style-padding-right\":\"0px\",\"col-5-style-top\":\"0px\",\"col-5-style-display\":\"none\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"col-4-style-display\":\"none\",\"col-0-style-padding-left\":\"0px\",\"customId\":\"\",\"col-3-style-padding-left\":\"0px\",\"col-2-style-padding-left\":\"0px\",\"col-1-style-padding-left\":\"0px\",\"gutter\":\"\",\"col-0-style-padding-right\":\"0px\",\"col-5-style-tablet-display\":\"block\",\"col-4-style-tablet-display\":\"block\",\"id\":\"83522201DFC44F26348696769AD33F40\",\"col-1-style-padding-right\":\"0px\",\"col-2-style-padding-right\":\"0px\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.ButtonComponent\",\"properties\":{\"attr-data-events-listening\":[],\"css-display-type\":\"btn btn-light\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Part 5\",\"id\":\"F64FEF527A0F4C0B05876D2A713BD5A2\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Designing a Process\",\"id\":\"D8BFF51836D0442E2D67E76DE67FB400\",\"tagName\":\"h3\",\"customId\":\"\"}},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<a href=\\\"#request.appCenterVideo5#\\\" target=\\\"_blank\\\"><img src=\\\"#request.contextPath?html#/images/dx9AppCenter/designNewProcess.svg\\\" style=\\\"width:100%\\\"><\\/a>\\n\\n\",\"id\":\"4D76F674E222479D77B4F18502E3FD9E\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-padding-right\":\"0px\",\"style-tablet-padding-bottom\":\"0px\",\"style-mobile-padding-left\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-padding-top\":\"0px\",\"style-tablet-margin-top\":\"0px\",\"customId\":\"\",\"style-tablet-margin-right\":\"0px\",\"style-tablet-padding-left\":\"0px\",\"style-tablet-padding-right\":\"0px\",\"id\":\"C5BC62B06E774384C62F0F06549D251F\",\"style-tablet-margin-bottom\":\"0px\",\"style-tablet-margin-left\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-right\":\"0px\",\"style-mobile-max-width\":\"50%\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-mobile-flex\":\"0 0 50%\",\"style-padding-left\":\"0px\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.ButtonComponent\",\"properties\":{\"attr-data-events-listening\":[],\"css-display-type\":\"btn btn-light\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Part 6\",\"id\":\"F66C0A01393447FC491A9F016F51DFBE\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Generative AI\",\"id\":\"24860DFD4D714AB6F6A1521DE70A60BF\",\"tagName\":\"h3\",\"customId\":\"\"}},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<a href=\\\"#request.appCenterVideo6#\\\" target=\\\"_blank\\\"><img src=\\\"#request.contextPath?html#/images/dx9AppCenter/designNewAi.svg\\\" style=\\\"width:100%\\\"><\\/a>\",\"id\":\"02CB5B7D7098445D7832B913066846C6\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-padding-right\":\"0px\",\"style-tablet-padding-bottom\":\"0px\",\"style-mobile-padding-left\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-padding-top\":\"0px\",\"style-tablet-margin-top\":\"0px\",\"customId\":\"\",\"style-tablet-margin-right\":\"0px\",\"style-tablet-padding-left\":\"0px\",\"style-tablet-padding-right\":\"0px\",\"id\":\"B793C6F0D60B49A5314D5426D0347518\",\"style-tablet-margin-bottom\":\"0px\",\"style-tablet-margin-left\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-right\":\"0px\",\"style-mobile-max-width\":\"50%\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-mobile-flex\":\"0 0 50%\",\"style-padding-left\":\"0px\"}},{\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-right\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-display\":\"none\",\"style-padding-left\":\"0px\"}},{\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-right\":\"0px\",\"style-tablet-flex\":\"0 0 50%\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-tablet-max-width\":\"50%\",\"style-tablet-display\":\"none\",\"style-padding-left\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"col-3-style-tablet-display\":\"none\",\"col-3-style-padding-right\":\"0px\",\"columns\":[{\"style-mobile-max-width\":\"50%\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"50%\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"50%\"}],\"col-2-style-tablet-display\":\"none\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"col-0-style-padding-left\":\"0px\",\"customId\":\"\",\"style-tablet-display\":\"none\",\"col-3-style-padding-left\":\"0px\",\"col-2-style-padding-left\":\"0px\",\"col-1-style-padding-left\":\"0px\",\"gutter\":\"\",\"col-0-style-padding-right\":\"0px\",\"id\":\"30D6E22052974B9C893DAC85B158DF0E\",\"col-1-style-padding-right\":\"0px\",\"col-2-style-padding-right\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-border-bottom-width\":\"1px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-border-color\":\"#F1F1F4\",\"customId\":\"tutorial\",\"style-margin-top\":\"32px\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"style-tablet-padding-left\":\"26px\",\"style-tablet-padding-right\":\"26px\",\"id\":\"B91163A1EE9F45B5F435366986F8EECD\",\"style-border-top-width\":\"1px\",\"style-border-radius\":\"0.625em\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.ButtonComponent\",\"properties\":{\"attr-data-events-listening\":[],\"css-display-type\":\"btn btn-light\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Advanced\",\"id\":\"AD46A51A624C4F5DAA42FABC37AEC5CF\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.ButtonComponent\",\"properties\":{\"attr-data-events-listening\":[],\"css-display-type\":\"btn btn-light\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"DX8\",\"id\":\"B4DE3E0A87BA4FBC760EAA7070A62EEA\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Advanced Course for App Designer\",\"id\":\"09292FC80C314038F797121A87A05DCF\",\"tagName\":\"h3\",\"customId\":\"\"}},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<a href=\\\"https://academy.joget.org/course/jogetdx8advancedcourseforappdesigners\\\" target=\\\"_blank\\\">\\n<img src=\\\"#request.contextPath?html#/images/dx9AppCenter/advancedCourse.svg\\\" style=\\\"width:100%\\\">\\n<\\/a>\",\"id\":\"7412DE1441D9434E24683972028C7BDF\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-right\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-padding-left\":\"0px\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.ButtonComponent\",\"properties\":{\"attr-data-events-listening\":[],\"css-display-type\":\"btn btn-light\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Beginner\",\"id\":\"D8C9F806F28A4406F303547E132BA82E\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.ButtonComponent\",\"properties\":{\"attr-data-events-listening\":[],\"css-display-type\":\"btn btn-light\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"DX8\",\"id\":\"17C839C18AB142CAC9DC36DDB0B5CDF6\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Basic Course for App Designers\",\"id\":\"FC4B017064D4472E81EE2DB0E1926EEA\",\"tagName\":\"h3\",\"customId\":\"\"}},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<a href=\\\"https://academy.joget.org/course/jogetdx8basiccourseforappdesigners\\\" target=\\\"_blank\\\">\\n<img src=\\\"#request.contextPath?html#/images/dx9AppCenter/basicCourse.svg\\\" style=\\\"width:100%\\\">\\n<\\/a>\",\"id\":\"EF15C6C1AA91410D6971328300682B16\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-right\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-padding-left\":\"0px\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.ButtonComponent\",\"properties\":{\"attr-data-events-listening\":[],\"css-display-type\":\"btn btn-light\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Slides\",\"id\":\"BC6689019E894565647C37DB286C1896\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.ButtonComponent\",\"properties\":{\"attr-data-events-listening\":[],\"css-display-type\":\"btn btn-light\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"DX8\",\"id\":\"E7D4255F49B045FB5F339BC662CD3623\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Training Slides\",\"id\":\"F434EF5218D94FFBC9CA605A4A24F876\",\"tagName\":\"h3\",\"customId\":\"\"}},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<a href=\\\"https://academy.joget.org/course/jogetdx8trainingslides\\\" target=\\\"_blank\\\">\\n<img src=\\\"#request.contextPath?html#/images/dx9AppCenter/trainingSlides.svg\\\" style=\\\"width:100%\\\">\\n<\\/a>\",\"id\":\"5DC777CE65AB4AB859DC9970397AEE58\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-right\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-padding-left\":\"0px\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-color\":\"#092E28\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<span class=\\\"vc_icon_element-icon fa fa-graduation-cap\\\"><\\/span> Joget Courses - Learn at your own pace\",\"style-font-size\":\"17px\",\"id\":\"8A922A54C3DF41CE7F6363001D03281E\",\"tagName\":\"h5\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-color\":\"#7F7F7F\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"<p>Discover expertise through our curated video courses<\\/p>\",\"style-font-size\":\"14px\",\"id\":\"736F7561DAAB493150506974ADA69E79\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.Link\",\"properties\":{\"style-hover-color\":\"#009265\",\"style-color\":\"#009265\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-font-size\":\"15px\",\"label\":\"Start Now\",\"type\":\"pagecomponent\",\"style-display\":\"block\",\"url\":\"https://academy.joget.org/lms/courses\",\"target\":\"blank\",\"style-font-weight\":\"500\",\"userviewCacheDuration\":\"20\",\"style-width\":\"auto\",\"userviewCacheScope\":\"\",\"id\":\"2590C287EFD04E6E5903FAE804441959\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-right\":\"0px\",\"style-margin-top\":\"auto\",\"style-margin-bottom\":\"auto\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-padding-left\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"col-5-style-margin-top\":\"auto\",\"col-3-style-padding-right\":\"0px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"col-4-style-display\":\"block\",\"col-3-style-margin-top\":\"auto\",\"col-5-style-margin-bottom\":\"auto\",\"col-0-style-padding-left\":\"0px\",\"customId\":\"\",\"col-3-style-padding-left\":\"0px\",\"col-2-style-padding-left\":\"0px\",\"col-1-style-padding-left\":\"0px\",\"gutter\":\"\",\"col-0-style-padding-right\":\"0px\",\"col-5-style-tablet-display\":\"block\",\"col-3-style-margin-bottom\":\"auto\",\"col-4-style-tablet-display\":\"block\",\"id\":\"6E693AA289474BB19C20552BDDDD2721\",\"col-1-style-padding-right\":\"0px\",\"col-2-style-padding-right\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-border-bottom-width\":\"1px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-border-color\":\"#F1F1F4\",\"customId\":\"joget_academy\",\"style-margin-top\":\"32px\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"style-tablet-padding-left\":\"26px\",\"style-tablet-padding-right\":\"26px\",\"id\":\"3C7E3CAD11A641480A3A7EEA6548F707\",\"style-border-top-width\":\"1px\",\"style-border-radius\":\"0.625em\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"Stay updated with the latest information by joining us on our social media channels! <br> Follow us to get real-time updates, news, and more.\",\"id\":\"5A1270BFE1004055C736519A41E2E0B5\",\"tagName\":\"h3\",\"customId\":\"contact_header\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"textContent\":\"\\n<div class=\\\"social-btns row\\\">\\n  <div class=\\\"d-inline-flex flex-column col\\\">\\n  <a class=\\\"btn facebook\\\" target=\\\"_blank\\\" href=\\\"https://www.facebook.com/jogetworkflow\\\"><i class=\\\"fab fa-facebook-f\\\"><\\/i><\\/a>\\n<span style=\\\"font-size:18px;color:#092E28\\\">Facebook<\\/span>\\n  <\\/div>\\n<div class=\\\"d-inline-flex flex-column align-items-center align-items-md-start col\\\">\\n  <a class=\\\"btn twitter p-0\\\" target=\\\"_blank\\\" href=\\\"https://x.com/jogetworkflow\\\"><i class=\\\"fab fa-x-twitter\\\"><\\/i><\\/a>\\n<span style=\\\"font-size:18px;color:#092E28\\\">X.com<\\/span>\\n  <\\/div>\\n<div class=\\\"d-inline-flex flex-column col align-items-center align-items-md-start\\\">\\n  <a class=\\\"btn linkin p-0\\\" target=\\\"_blank\\\" href=\\\"https://www.linkedin.com/company/joget/\\\"><i class=\\\"fab fa-linkedin-in\\\"><\\/i><\\/a>\\n<span style=\\\"font-size:18px;color:#092E28\\\">LinkedIn<\\/span>\\n  <\\/div>\\n  <div class=\\\"d-inline-flex flex-column col align-items-center align-items-md-start\\\">\\n  <a class=\\\"btn youtube p-0\\\" target=\\\"_blank\\\" href=\\\"https://www.youtube.com/user/jogetworkflow\\\"><i class=\\\"fab fa-youtube\\\"><\\/i><\\/a>\\n<span style=\\\"font-size:18px;color:#092E28\\\">YouTube<\\/span>\\n  <\\/div>\\n<\\/div>\\n\\n<style>\\n.social-btns .btn.facebook:before {\\n  background: linear-gradient(180deg, #1877F2 0%, #5195EE 100%);\\n}\\n.social-btns .btn.facebook .fab,\\n.social-btns .btn.facebook:hover .fab,\\n.social-btns .btn.facebook:focus .fab {\\n  color: #FFF;\\n  transform: translateY(5px) scale(0.8);\\n}\\n.social-btns .btn.twitter .fab {\\n  color: #000000;\\n}\\n.social-btns .btn.linkin .fab {\\n  color: #FFF;\\n  transform: scale(0.8)\\n}\\n.social-btns .btn.linkin,\\n.social-btns .btn.linkin:hover {\\n\\tbackground-color: #0A66C2 !important;\\n    width: 60px;\\n    height: 60px;\\n    padding: 0px;\\n}\\n.social-btns .btn.youtube .fab {\\n  color: #ff0f00;\\n}\\n.social-btns .btn:focus,\\n.social-btns .btn:hover,\\n.social-btns .btn.facebook:hover,\\n.social-btns .btn.facebook:focus {\\n  transform: scale(1.2);\\n  background-color: transparent;\\n  box-shadow: none;\\n  animation: none;\\n}\\n.social-btns {\\n  margin: auto;\\n  font-size: 0;\\n  top: 0;\\n  bottom: 0;\\n  left: 0;\\n  right: 0;\\n}\\n.social-btns .btn.facebook {\\n\\tbackground: linear-gradient(180deg, #1877F2 0%, #5195EE 100%) !important;\\n  line-height: initial;\\n  border-radius: 50%;\\n  padding-bottom: 0px;\\n  padding-top: 0px;\\n}\\n  .social-btns .btn.facebook:hover {\\n\\tbackground: linear-gradient(180deg, #1877F2 0%, #5195EE 100%);\\n}\\n.social-btns .btn {\\n  display: inline-block;\\n  background-color: transparent !important;\\n  width: fit-content;\\n  height: fit-content;\\n  line-height: initial;\\n  margin: 0 0px;\\n  text-align: center;\\n  position: relative;\\n  overflow: hidden;\\n  border-radius: 28%;\\n  box-shadow: none !important;\\n  opacity: 0.99;\\n  border-color: transparent !important;\\n  animation: none !important;\\n}\\n.social-btns .btn .fab {\\n  font-size: 60px;\\n}\\n@media (max-width: 766px) {\\n  .social-btns > div:first-of-type {\\n    align-items: center;\\n  }\\n  \\n  .social-btns {\\n    row-gap: 16px;\\n  }\\n}\\n<\\/style>\",\"id\":\"95C01D26AA3B449BBFCACCFC6E9C3F1E\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"id\":\"B0EBC00177C841D4CAE97381B5B6AF45\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}}}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"5px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"css-mobile-stack-columns\":\"true\",\"style-mobile-margin-bottom\":\"25px\",\"id\":\"C2F5E35B8643460B1BA3ED5D9F7A47EF\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-border-bottom-width\":\"1px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-border-color\":\"#F1F1F4\",\"customId\":\"contact\",\"style-margin-top\":\"32px\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"style-tablet-padding-left\":\"26px\",\"style-tablet-padding-right\":\"26px\",\"id\":\"D71C7F0EA650463FA74FE4109A126B5D\",\"style-border-top-width\":\"1px\",\"style-border-radius\":\"0.625em\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-padding-right\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-padding-top\":\"0px\",\"customId\":\"\",\"style-tablet-margin-right\":\"0%\",\"style-mobile-margin-right\":\"0%\",\"style-padding-left\":\"0px\",\"style-padding-bottom\":\"0px\",\"style-mobile-margin-left\":\"0%\",\"id\":\"CF9BE1662CEA47717282164F140A8E5A\",\"style-tablet-margin-left\":\"0%\",\"style-border-radius\":\"10px\"}},{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-0497CD0F62BD44DEEAF1294D58166A1A\"}}',NULL),
('appcenter',1,'up-4E2A517C3275429806518BAA8D29AB1F','Admin','INTERNAL_USERVIEW_PAGE','2025-06-05 11:20:18','2025-11-13 12:01:35','{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"Admin\",\"id\":\"40D56FA324124C7DD68DBBB8E270E79A\",\"tagName\":\"h3\",\"customId\":\"admin_header\"}},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-bottom\":\"28px\",\"textContent\":\"<ul id=\\\"admin-nav\\\">\\n  <li data-target=\\\"monitor_section\\\">Monitor<\\/li>\\n  <li data-target=\\\"apps_section\\\">Apps<\\/li>\\n  <li data-target=\\\"users_section\\\">Users<\\/li>\\n<\\/ul>\",\"id\":\"E3FE9686FF5E421778BBB5C835FC3933\",\"customId\":\"\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"template\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag complex\'}-->\\r\\n<div class=\\\"card\\\" style=\\\"padding:16px 28px;\\\">\\r\\n    <div class=\\\"card-body d-flex flex-wrap p-0\\\" id=\\\"monitor-summary\\\" style=\\\"align-items: center;gap: 40px;\\\">\\r\\n            <div class=\\\"stats-info first d-flex align-items-center position-relative\\\">\\r\\n                <div class=\\\"header-title\\\" style=\\\"color:#09583D;font-size:14px;padding-right:16px;border-right: 1px solid #DAE6E2;margin-right: 16px;\\\">\\r\\n                    All Processes\\r\\n                <\\/div>\\r\\n                <p class=\\\"value-number\\\" style=\\\"font-size: 18px;\\r\\n                color: rgba(0,0,0,.8); display:inline;\\r\\n                          margin-bottom: 0; color: #009265;\\\">\\r\\n                    #stats.runningProcess#\\r\\n                <\\/p>\\r\\n                <p style=\\\"display:inline;font-size:14px;;color:#09583D;margin-bottom: 0;margin-left:12px\\\">\\r\\n                    Running\\r\\n                <\\/p>\\r\\n              \\r\\n                <p class=\\\"value-number\\\" style=\\\"font-size: 18px;\\r\\n                  color: rgba(0,0,0,.8); display:inline;\\r\\n                            margin-bottom: 0; color: #009265;\\r\\n                          \\t\\tmargin-left: 32px;\\\">\\r\\n                     #stats.completedProcess#\\r\\n                  <\\/p>\\r\\n                  <p style=\\\"display:inline;font-size:14px;;color:#09583D;margin-bottom: 0;margin-left:12px;padding-right: 40px;border-right:1px solid #09583D\\\">\\r\\n                      Completed\\r\\n                  <\\/p>\\r\\n\\t\\t\\t<a href=\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/running\');\\\" class=\\\"stretched-link\\\"><\\/a>\\r\\n            <\\/div>\\r\\n            \\r\\n            <div class=\\\"separator\\\" style=\\\"display: none\\\"><\\/div>\\r\\n      \\r\\n      \\t\\t<div class=\\\"stats-info d-flex align-items-center second\\\">\\r\\n                <div class=\\\"header-title\\\" style=\\\"color:#09583D;font-size:14px;padding-right:16px;border-right: 1px solid #DAE6E2;margin-right: 16px;\\\">\\r\\n                    System Log\\r\\n                <\\/div>\\r\\n              \\t<a class=\\\"btn\\\" href=\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/slogs\');\\\" style=\\\"margin-left: 16px;border-radius:16px;background-color:#DAE6E2;color:#092E28;height:32px;padding:3px 16px;\\\">\\r\\n              \\t\\tView\\r\\n              \\t<\\/a>\\r\\n            <\\/div>\\r\\n            \\r\\n            <div class=\\\"separator\\\" style=\\\"display: none\\\"><\\/div>\\r\\n      \\t\\r\\n      \\t\\t<div class=\\\"stats-info third d-flex align-items-center position-relative\\\">\\r\\n                <div class=\\\"header-title\\\" style=\\\"color:#09583D;font-size:14px;padding-right:16px;border-right: 1px solid #DAE6E2;margin-right: 16px;padding-left: 40px;border-left:1px solid #09583D\\\">\\r\\n                    Performance\\r\\n                <\\/div>\\r\\n              \\t<p class=\\\"value-number\\\" style=\\\"font-size: 18px;\\r\\n                color: rgba(0,0,0,.8); display:inline;\\r\\n                          margin-bottom: 0; color: #009265;\\\">\\r\\n                    #stats.nodeCount#\\r\\n                <\\/p>\\r\\n                <p style=\\\"display:inline;font-size:14px;;color:#09583D;margin-bottom: 0;margin-left:12px;\\\">\\r\\n                    Cluster Nodes\\r\\n                <\\/p>\\r\\n\\t\\t\\t\\t<a href=\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\" class=\\\"stretched-link\\\"><\\/a>\\r\\n            <\\/div>\\r\\n        {{reload}}\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n<style>\\r\\n    #monitor-summary {\\r\\n        row-gap: 20px !important;\\r\\n    }\\r\\n    @media (max-width: 1020px) {\\r\\n        #monitor-summary {\\r\\n            row-gap: 20px !important;\\r\\n        }\\r\\n        \\r\\n        #monitor-summary > .stats-info.first,\\r\\n        #monitor-summary > .stats-info.second {\\r\\n            flex: 1 1 50%;\\r\\n            max-width: fit-content;\\r\\n        }\\r\\n        \\r\\n        #monitor-summary > .stats-info.third {\\r\\n            flex: 1 1 100%;\\r\\n        }\\r\\n        \\r\\n        #monitor-summary > .stats-info.third .header-title {\\r\\n            border-left: none !important;\\r\\n            padding-left: 0 !important;\\r\\n        }\\r\\n    }\\r\\n    @media (max-width: 640px) {\\r\\n        #monitor-summary > .stats-info.first {\\r\\n            flex: 1 1 100%;\\r\\n            max-width: 100%;\\r\\n            justify-content: center;\\r\\n        }\\r\\n        #monitor-summary > .stats-info.second,\\r\\n        #monitor-summary > .stats-info.third {\\r\\n            flex: 0 1 50%;\\r\\n            max-width: fit-content;\\r\\n        }\\r\\n        \\r\\n        #monitor-summary {\\r\\n            row-gap: 10px !important;\\r\\n            justify-content: center;\\r\\n        }\\r\\n        \\r\\n        #monitor-summary > .stats-info.first > p:last-of-type {\\r\\n            border-right: none !important;\\r\\n            padding-right: 0 !important;\\r\\n        }\\r\\n        \\r\\n        #monitor-summary > .stats-info.second,\\r\\n        #monitor-summary > .stats-info.third {\\r\\n            padding-top: 10px !important;\\r\\n        }\\r\\n        \\r\\n        #monitor-summary > .stats-info.third {\\r\\n            max-width: fit-content;\\r\\n        }\\r\\n        \\r\\n        #monitor-summary > .stats-info.third .header-title {\\r\\n            border-left: none !important;\\r\\n        }\\r\\n    }\\r\\n    @media (max-width: 510px) {\\r\\n        #monitor-summary {\\r\\n            flex-direction: column;\\r\\n        }\\r\\n        \\r\\n        #monitor-summary > .stats-info {\\r\\n            flex: 1 1 100% !important;\\r\\n            max-width: 100% !important;\\r\\n            justify-content: center;\\r\\n            flex-direction: column;\\r\\n        }\\r\\n        \\r\\n        #monitor-summary > .stats-info.second,\\r\\n        #monitor-summary > .stats-info.third {\\r\\n            padding-top: 0px !important;\\r\\n        }\\r\\n        \\r\\n        #monitor-summary > .stats-info > * {\\r\\n            margin: 0px !important;\\r\\n        }\\r\\n        \\r\\n        #monitor-summary > .stats-info > .header-title {\\r\\n            margin-right: 0px !important;\\r\\n            border-right: none !important;\\r\\n            padding-right: 0 !important;\\r\\n        }\\r\\n        \\r\\n        #monitor-summary > .separator {\\r\\n            border-bottom: 1px solid #DAE6E2;\\r\\n            display: block !important;\\r\\n            height: 1px;\\r\\n            width: 50%;\\r\\n        }\\r\\n    }\\r\\n<\\/style>\\r\\n<!---->\",\"attr-data-events-listening\":[],\"reload\":\"true\",\"color\":\"#348fe2\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"id\":\"00496722EBD846917D9FBE4E592BE7D3\",\"title\":\"TOTAL VISITS\",\"value\":\"3,291,922\",\"customId\":\"\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"template\":\"<!--{sampleWidth: \'100%\', tags: \'light-bg grid\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"color:#009265;\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row mx-0\\\">\\n            <div class=\\\"header-title col-8 p-0 value-number\\\">\\n                {{header||STATUS}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right p-0\\\">\\n                <span class=\\\"badge desktop\\\">\\n                    Last 4 Hours\\n                <\\/span>\\n                <span class=\\\"badge mobile\\\">\\n                    4H\\n                <\\/span>\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div>\\n    <div class=\\\"card-body row d-flex flex-wrap pb-0 mx-0\\\">\\n        <div>\\n            <span style=\\\"font-size:64px;display:block;font-weigth:400;\\\">#stats.transactionCount#<\\/span>\\n            <span>Total Transactions<\\/span>\\n        <\\/div>\\n        #stats.listOfTransactionApps#\\n        <a href=\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\" class=\\\"btn\\\">View Full Data<\\/a>\\n    <\\/div>\\n    {{reload}}\\n<\\/div>\\n<style>\\n    #performance_column .header-tag > .badge.mobile {\\n        display: none;\\n    }\\n    @media (min-width: 577px) and (max-width: 1200px) {\\n        #performance_column .header-tag > .badge.desktop {\\n            display: none;\\n        }\\n        #performance_column .header-tag > .badge.mobile {\\n            display: block;\\n        }\\n    }\\n    #performance_column > .row > .col > * {\\n        padding: 28px 28px;\\n    }\\n    #performance_column .card-header {\\n        border-bottom: 0px;\\n    }\\n    #performance_column .card-body > div:first-child > span {\\n        line-height: 1;\\n    }\\n    #performance_column > .row > .col > * > * {\\n        padding: 0px;\\n    }\\n    #performance_column .card-header {\\n        margin-bottom: 16px;\\n    }\\n    #performance_column .card-body > div:first-child {\\n        margin-bottom: 32px;\\n    }\\n    #performance_column .card-body > div:last-of-type {\\n        margin-bottom: 24px;\\n    }\\n    #performance_column .card-body > div:last-of-type > .group-container:not(:first-of-type) {\\n        padding-top: 16px;\\n        border-top: 1px  solid #DAE6E2;\\n    }\\n    #performance_column .card-body > div:last-of-type > .group-container:first-of-type {\\n        padding-bottom: 16px;\\n    }\\n    @media (min-width: 801px) {\\n        #performance_column > .row > .col {\\n            padding-left: 0px;\\n            padding-right: 0px;\\n          \\tflex: 1;\\n        }\\n      \\n      #performance_column > .row {\\n        \\tcolumn-gap: 21px;\\n      }\\n    }\\n    @media (max-width: 400px) {\\n        #performance_column > .row > .col > .card .header-tag > .badge.desktop {\\n            display: none;\\n        }\\n        #performance_column > .row > .col > .card .header-tag > .badge.mobile {\\n            display: block;\\n        }\\n    }\\n    @media (max-width: 800px) {\\n        #performance_column > .row > .col {\\n            padding-left: 0px;\\n            padding-right: 0px;\\n            flex: 1;\\n        }\\n      \\n        #performance_column > .row {\\n         \\t column-gap: 7px;\\n        }\\n    }\\n    @media (max-width: 576px) {\\n        #performance_column > .row > .col {\\n            max-width: 100% !important;\\n            flex: 1 1 100% !important;\\n        }\\n    }\\n<\\/style>\\n<!---->\",\"attr-data-events-listening\":[],\"color\":\"#348fe2\",\"headerTag\":\"Last 4 Hours\",\"tagColor\":\"\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"bgImg\":\"\",\"title\":\"TOTAL VISITS\",\"customId\":\"\",\"reload\":\"true\",\"bgColor\":\"\",\"repeat\":[],\"header\":\"Performance Data\",\"id\":\"1948BE9953C146513F252DAEB7C2845A\",\"value\":\"3,291,922\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-bottom\":\"0px\",\"style-padding-top\":\"0px\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"template\":\"<!--{sampleWidth: \'100%\', tags: \'light-bg grid\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"color:#009265;\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row mx-0\\\">\\n            <div class=\\\"header-title col-8 p-0 value-number\\\">\\n                {{header||STATUS}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right p-0\\\">\\n                <span class=\\\"badge desktop\\\">\\n                    Last 4 Hours\\n                <\\/span>\\n                <span class=\\\"badge mobile\\\">\\n                    4H\\n                <\\/span>\\n            <\\/div>\\n        <\\/div>  \\n    <\\/div>\\n    <div class=\\\"card-body row d-flex flex-wrap pb-0 mx-0\\\">\\n        <div>\\n            <span style=\\\"font-size:64px;display:block;font-weigth:400;\\\">#stats.slowTrace#<\\/span>\\n            <span>Total Slow Traces<\\/span>\\n        <\\/div>\\n        #stats.listOfSlowTraceApps#\\n        <a href=\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\" class=\\\"btn\\\">View Full Data<\\/a>\\n    <\\/div>\\n    {{reload}}\\n<\\/div>\\n<!---->\",\"attr-data-events-listening\":[],\"color\":\"#348fe2\",\"headerTag\":\"Last 4 Hours\",\"tagColor\":\"\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"title\":\"TOTAL VISITS\",\"customId\":\"\",\"reload\":\"true\",\"header\":\"Performance Data\",\"id\":\"9B3B57746862458F0098CF14F2B5B1E4\",\"value\":\"3,291,922\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-bottom\":\"0px\",\"style-padding-top\":\"0px\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"template\":\"<!--{sampleWidth: \'100%\', tags: \'light-bg grid\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"color:#009265;\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row mx-0\\\">\\n            <div class=\\\"header-title col-8 p-0 value-number\\\">\\n                {{header||STATUS}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right p-0\\\">\\n                <span class=\\\"badge desktop\\\">\\n                    Last 4 Hours\\n                <\\/span>\\n                <span class=\\\"badge mobile\\\">\\n                    4H\\n                <\\/span>\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div>\\n    <div class=\\\"card-body row d-flex flex-wrap pb-0 mx-0\\\">\\n        <div>\\n            <span style=\\\"font-size:64px;display:block;font-weigth:400;\\\">#stats.errorCount#<\\/span>\\n            <span>Total Error Count<\\/span>\\n        <\\/div>\\n        #stats.listOfErrorApps#\\n        <a href=\\\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\\\" class=\\\"btn\\\">View Full Data<\\/a>\\n    <\\/div>\\n    {{reload}}\\n<\\/div>\\n<!---->\",\"attr-data-events-listening\":[],\"color\":\"#348fe2\",\"headerTag\":\"Last 4 Hours\",\"tagColor\":\"\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"title\":\"TOTAL VISITS\",\"customId\":\"\",\"reload\":\"true\",\"header\":\"Performance Data\",\"id\":\"A83AB09FE1CD4AE73040B3483E782457\",\"value\":\"3,291,922\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-bottom\":\"0px\",\"style-padding-top\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"\",\"col-1-style-padding-top\":\"0px\",\"col-2-style-padding-top\":\"0px\",\"col-2-style-padding-bottom\":\"0px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"col-1-style-padding-bottom\":\"0px\",\"col-0-style-padding-bottom\":\"0px\",\"id\":\"A2365447C5D34DA59E62479D245A2C0A\",\"customId\":\"performance_column\",\"col-0-style-padding-top\":\"0px\"}},{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag progress\'}-->\\n<div class=\\\"card GHC position-relative\\\" \\n     style=\\\"height:{{height||}};\\n            background-color:{{bgColor||}}; \\n            background-image:url(\'{{bgImg||}}\');\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;padding:0px;padding-bottom: 16px;\\\">\\n        <div class=\\\"row align-items-center\\\">\\n            <div class=\\\"header-title col-10\\\" style=\\\"color:#03543D;height: auto;overflow: hidden;white-space: nowrap;text-overflow: ellipsis;font-size:16px;\\\">\\n                {{header||Governance Health Check (%)}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-2 text-right pl-0\\\">\\n                <span class=\\\"badge\\\">\\n                    {{headerTag||Latest}}\\n                <\\/span>\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div> \\n    <div class=\\\"pt-3 pb-2 GHCInfo\\\" style=\\\"column-gap: 48px; row-gap: 28px; display: grid;\\\">\\n        {{repeat||[{\\\"title\\\":\\\"Performance\\\",\\\"value\\\":\\\"#stats.performance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.performance#\\\"},{\\\"title\\\":\\\"Security\\\",\\\"value\\\":\\\"#stats.security#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.security#\\\"},{\\\"title\\\":\\\"Quality Assurance\\\",\\\"value\\\":\\\"#stats.qualityAssurance#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.qualityAssurance#\\\"},{\\\"title\\\":\\\"DB Connections Check\\\",\\\"value\\\":\\\"#stats.DbConnectionsCheck#  %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.DbConnectionsCheck#\\\"},{\\\"title\\\":\\\"Memory Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#A9A9A9\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"},{\\\"title\\\":\\\"CPU Usage Check\\\",\\\"value\\\":\\\"#stats.MemoryUsageCheck# %\\\",\\\"color\\\":\\\"#348FE2\\\",\\\"progressbar-value\\\":\\\"#stats.MemoryUsageCheck#\\\"}]}}\\n            <div>\\n                <div class=\\\"mb-1\\\" style=\\\"display:flex;flex-direction:row;font-size:14px;\\\">\\n                    <span style=\\\"color: #09583D;\\n                                white-space: normal;\\n                                flex: 1 1 80%;\\n                                min-width: 0;\\\">\\n                        {{repeat.title}}\\n                    <\\/span>\\n                    <small class=\\\"float-right\\\" style=\\\"color:#98B3A9;\\n                                                        flex: 1 1 20%;\\n                                                        text-align: right; font-size: 14px\\\">\\n                        {{repeat.value}}\\n                    <\\/small>\\n                <\\/div>\\n                <div class=\\\"progress progress-small\\\" style=\\\"height: 6px;\\\">\\n                    <div class=\\\"progress-bar\\\" \\n                         style=\\\"width: {{repeat.progressbar-value}}%; \\n                                transition: width .6s ease; \\n                                background-color:{{repeat.color}};\\\">\\n                    <\\/div>\\n                <\\/div>\\n            <\\/div>\\n        {{repeat}}\\n    <\\/div>\\n    {{reload}}\\n<\\/div>\\n<script>\\n    $(document).ready(function(){\\n        function checkThreshold(){\\n            $(\\\".progress-bar\\\").each(function(){\\n                if( ($(this).css(\'width\').includes(\'%\') && parseFloat($(this).css(\'width\')) <= 50) || (!$(this).css(\'width\').includes(\'%\') && (parseFloat($(this).css(\'width\'))/$(this).parent().outerWidth()) < 0.5)) {\\n                    $(this).addClass(\\\"below-threshold\\\");\\n                }\\n            })   \\n        }\\n        \\n        checkThreshold();\\n    })\\n<\\/script>\\n<style>\\n    .progress-bar.below-threshold {\\n        background-color: #092E28 !important;\\n    }\\n    @media (min-width: 991px) {\\n        .GHCInfo {\\n            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));\\n        }\\n    }\\n    @media (max-width: 991px) {\\n        .GHCInfo {\\n            grid-template-columns: 1fr 1fr 1fr;\\n        }\\n    }\\n    @media (max-width: 767px) {\\n        .GHCInfo {\\n            grid-template-columns: 1fr 1fr;\\n        }\\n    }\\n    @media (max-width: 575px) {\\n        .GHCInfo {\\n            grid-template-columns: 1fr;\\n        }\\n        \\n        .GHCInfo .header-tag {\\n            display: none;\\n        }\\n    }\\n<\\/style>\\n<!---->\",\"style-padding-right\":\"40px\",\"color\":\"#348fe2\",\"headerTag\":\"Latest\",\"tagColor\":\"#0BAB73\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/governance\');\",\"bgImg\":\"\",\"title\":\"TOTAL VISITS\",\"style-padding-top\":\"16px\",\"customId\":\"\",\"style-padding-left\":\"40px\",\"style-padding-bottom\":\"24px\",\"reload\":\"true\",\"bgColor\":\"\",\"repeat\":[{\"color\":\"#009265\",\"progressbar-value\":\"#stats.performance#\",\"title\":\"Performance\",\"value\":\"#stats.performance#  %\"},{\"color\":\"#009265\",\"progressbar-value\":\"#stats.security#\",\"title\":\"Security\",\"value\":\"#stats.security#  %\"},{\"color\":\"#009265\",\"progressbar-value\":\"#stats.qualityAssurance#\",\"title\":\"Quality Assurance\",\"value\":\"#stats.qualityAssurance#  %\"},{\"color\":\"#009265\",\"progressbar-value\":\"#stats.DbConnectionsCheck#\",\"title\":\"DB Connections Check\",\"value\":\"#stats.DbConnectionsCheck#  %\"},{\"color\":\"#009265\",\"progressbar-value\":\"#stats.MemoryUsageCheck#\",\"title\":\"Memory Usage Check\",\"value\":\"#stats.MemoryUsageCheck# %\"}],\"header\":\"Governance Health Check (%)\",\"id\":\"FF13DE7F3F4249C90D7FDA32EAE9A358\",\"value\":\"3,291,922\",\"height\":\"\"}},{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"template\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag complex\'}-->\\r\\n<div class=\\\"card system-info position-relative\\\" \\r\\n     style=\\\"height:{{height}};\\r\\n            background-color:{{bgColor}}; \\r\\n            background-image:url(\'{{bgImg}}\');\\\">\\r\\n    <div class=\\\"card-body row ms-0 me-0\\\">\\r\\n        <div class=\\\"col-md-8 col-12\\\">\\r\\n            <span style=\\\"font-size: 14px;color:#03543D;\\\">\\r\\n                @@enterprise.console.footer.message@@ @@console.footer.label.revision@@\\r\\n            <\\/span>\\r\\n        <\\/div>\\r\\n        <div class=\\\"stats-info col-md-4 col-12\\\" style=\\\"display:flex;gap:16px;justify-content:flex-end\\\">\\r\\n        {{repeat||[{value: \\\"406,42\\\", subvalue: \\\"33% <i class=\\\\\\\"fa fa-level-up\\\\\\\"><\\/i>\\\", subtitle: \\\"Rapid pace\\\", color: \\\"#1ab394\\\"},{value: \\\"206,12\\\", subvalue: \\\"10% <i class=\\\\\\\"fa fa-level-up\\\\\\\"><\\/i>\\\", subtitle: \\\"Slow pace\\\", color: \\\"#8753de\\\"}]}}\\r\\n                <a href=\\\"{{repeat.link}}\\\" style=\\\"font-size:14px;color:#008C60;\\\">\\r\\n                    {{repeat.value}}\\r\\n                <\\/a>\\r\\n        {{repeat}}\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n    {{reload}}\\r\\n<\\/div>\\r\\n<style>\\r\\n    .system-info a {\\r\\n        text-decoration: none !important;\\r\\n    }\\r\\n    .system-info a:hover {\\r\\n        text-decoration: underline !important;\\r\\n    }\\r\\n    @media (max-width:767px) {\\r\\n        .system-info .stats-info {\\r\\n            justify-content: flex-start !important;\\r\\n        }\\r\\n    }\\r\\n<\\/style>\\r\\n<!---->\",\"attr-data-events-listening\":[],\"color\":\"#348fe2\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"bgImg\":\"\",\"title\":\"TOTAL VISITS\",\"customId\":\"\",\"reload\":\"true\",\"bgColor\":\"\",\"repeat\":[{\"link\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/setting/general\');\",\"value\":\"Settings\"},{\"link\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/setting/sysinfo\');\",\"value\":\"System Information\"}],\"id\":\"8B9FE1037DD446531A973091E350585D\",\"value\":\"3,291,922\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-padding-right\":\"0px\",\"style-margin-top\":\"0px\",\"id\":\"506197F8A8D048825CBA8E5EA6CE99A1\",\"customId\":\"monitor_section\",\"style-padding-left\":\"0px\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"template\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag complex\'}-->\\r\\n<div class=\\\"card\\\" style=\\\"padding:16px 28px;\\\">\\r\\n    <div class=\\\"card-body d-flex flex-wrap row app-summary p-0 mx-0\\\" style=\\\"align-items: center;\\\">\\r\\n            <div class=\\\"col-6 stats-info first d-flex align-items-center px-0 position-relative\\\">\\r\\n                <div class=\\\"header-title\\\" style=\\\"color:#09583D;font-size:14px;padding-right:16px;border-right: 1px solid #DAE6E2;margin-right: 16px;\\\">\\r\\n                    Apps\\r\\n                <\\/div>\\r\\n                <p id=\\\"publishedAppCountVal\\\" class=\\\"value-number\\\" style=\\\"font-size: 18px;\\r\\n                color: rgba(0,0,0,.8); display:inline;\\r\\n                          margin-bottom: 0; color: #009265;\\\">\\r\\n                    #stats.publishedAppCount#\\r\\n                <\\/p>\\r\\n                <p style=\\\"display:inline;font-size:14px;;color:#09583D;margin-bottom: 0;margin-left:12px\\\">\\r\\n                    Published\\r\\n                <\\/p>\\r\\n                <i class=\\\"fas fa-cloud-arrow-up\\\"><\\/i>\\r\\n                <p id=\\\"unpublishedAppCountVal\\\" class=\\\"value-number\\\" style=\\\"font-size: 18px;\\r\\n                  color: rgba(0,0,0,.8); display:inline;\\r\\n                            margin-bottom: 0; color: #009265;\\r\\n                          \\t\\tmargin-left: 32px;\\\">\\r\\n                     #stats.unPublishedAppCount#\\r\\n                  <\\/p>\\r\\n                  <p style=\\\"display:inline;font-size:14px;;color:#09583D;margin-bottom: 0;margin-left:12px;\\\">\\r\\n                      Unpublished\\r\\n                  <\\/p>\\r\\n                  <i class=\\\"fas fa-cloud-arrow-down\\\"><\\/i>\\r\\n            <\\/div>\\r\\n      \\t\\t<div id=\\\"search-bar-container\\\" class=\\\"col-6 px-0 stats-info d-flex align-items-center justify-content-end second\\\">\\r\\n                <div class=\\\"search-bar position-relative\\\" style=\\\"color:#09583D;font-size:14px;\\\">\\r\\n                    <input>\\r\\n                    <i class=\\\"fas fa-magnifying-glass\\\"><\\/i>\\r\\n                <\\/div>\\r\\n              \\t<a class=\\\"btn\\\"  id=\\\"import-btn\\\" onclick=\\\"appImport(); document.getElementById(\'dialog\').close(); return false;\\\" style=\\\"margin-left: 16px;border-radius:16px;background-color:#DAE6E2;color:#092E28;height:32px;padding:3px 16px;\\\">\\r\\n              \\t\\t<span>Import<\\/span>\\r\\n              \\t\\t<i class=\\\"fas fa-upload\\\"><\\/i>\\r\\n              \\t<\\/a>\\r\\n              \\t<a class=\\\"btn\\\"  id=\\\"create-btn\\\" href=\\\"javascript:appCreate(\'\');\\\" style=\\\"margin-left: 16px;border-radius:16px;background-color:#DAE6E2;color:#092E28;height:32px;padding:3px 16px;\\\">\\r\\n              \\t\\t<span>Create<\\/span>\\r\\n              \\t\\t<i class=\\\"fas fa-plus\\\"><\\/i>\\r\\n              \\t<\\/a>\\r\\n            <\\/div>\\r\\n        {{reload}}\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n<style>\\r\\n    .app-summary .fas.fa-cloud-arrow-down,\\r\\n    .app-summary .fas.fa-cloud-arrow-up {\\r\\n        display: none;\\r\\n    }\\r\\n    #search-bar-container > a.btn > i {\\r\\n        display: none;\\r\\n    }\\r\\n    @media (max-width: 400px) {\\r\\n        .app-summary .fas.fa-cloud-arrow-up,\\r\\n        .app-summary .fas.fa-cloud-arrow-down {\\r\\n            display: block;\\r\\n            color: #009265;\\r\\n            margin-left: 5px;\\r\\n        }\\r\\n        \\r\\n        .app-summary #publishedAppCountVal + p,\\r\\n        .app-summary #unpublishedAppCountVal + p\\r\\n        {\\r\\n            display: none !important;\\r\\n        }\\r\\n        \\r\\n        .app-summary .fas.fa-cloud-arrow-down {\\r\\n            opacity: 0.5;\\r\\n        }\\r\\n        \\r\\n        #search-bar-container > a.btn {\\r\\n            padding: 6px 16px !important;\\r\\n        }\\r\\n        \\r\\n        #search-bar-container > a.btn > span {\\r\\n            display: none;\\r\\n        }\\r\\n        \\r\\n        #search-bar-container > a.btn > i {\\r\\n            display: block;\\r\\n        }\\r\\n    }\\r\\n    .app-summary .search-bar >  input {\\r\\n        padding-left: 45px;\\r\\n        min-width: 60px;\\r\\n        width: 100%;\\r\\n        max-width: 250px;\\r\\n        border-radius: 16px;\\r\\n        height: 40px;\\r\\n        border: 1px solid #98B3A9;\\r\\n        min-height: 40px;\\r\\n    }\\r\\n    .app-summary .search-bar >  input:focus,\\r\\n    body#admin #users_section .filters .filter-cell:not(:last-of-type) input:focus {\\r\\n        border: 1px solid #009265 !important;\\r\\n        outline-color: #009265 !important;\\r\\n    }\\r\\n    .app-summary .search-bar > .fas {\\r\\n        position: absolute;\\r\\n        left: 18px;\\r\\n        top: 50%;\\r\\n        transform: translateY(-50%);\\r\\n    }\\r\\n    @media (max-width: 650px) {\\r\\n        .app-summary .search-bar > .fas {\\r\\n            left: 5px;\\r\\n        }\\r\\n        .app-summary .search-bar >  input {\\r\\n            padding-left: 25px;\\r\\n        }\\r\\n    }\\r\\n    @media (min-width: 510px) {\\r\\n        .app-summary > div.separator {\\r\\n            display: none;\\r\\n        }\\r\\n    }\\r\\n    @media (max-width: 510px) {\\r\\n        .app-summary > .stats-info:last-of-type {\\r\\n            row-gap: 8px;\\r\\n        }\\r\\n        .app-summary > div.separator {\\r\\n            display: block;\\r\\n            border-bottom: 1px solid #DAE6E2;\\r\\n            height: 1px;\\r\\n            width: 50%;\\r\\n        }\\r\\n    }\\r\\n<\\/style>\\r\\n<script>\\r\\n    // Minus one because of App Center\\r\\n    $(\\\".app-summary\\\").find(\\\"#publishedAppCountVal\\\").text(parseInt(#stats.publishedAppCount#) - 1);\\r\\n\\r\\n    $(\\\".app-summary .search-bar > input\\\").off(\\\"input\\\").on(\\\"input\\\", function(){\\r\\n        const val = $(this).val().toLowerCase();\\r\\n        \\r\\n        if (val === \\\"\\\") {\\r\\n            $(\\\"body#admin #publishedUnpublishedAppSection .datalist-body-content .cards.row > *.hide\\\").removeClass(\\\"hide\\\");\\r\\n        } else {\\r\\n            $(\\\"#publishedAppViewList\\\").find(\\\"form > .table-wrapper .cards.row .column_apps_name\\\").each(function(){\\r\\n                $(this).text().trim().toLowerCase().includes(val) ? $(this).closest(\\\".card\\\").parent().removeClass(\\\"hide\\\") : $(this).closest(\\\".card\\\").parent().addClass(\\\"hide\\\");\\r\\n            });\\r\\n            \\r\\n            $(\\\"#unpublishedAppViewList\\\").find(\\\"form > .table-wrapper .cards.row .column_apps_name\\\").each(function(){\\r\\n                $(this).text().trim().toLowerCase().includes(val) ? $(this).closest(\\\".card\\\").parent().removeClass(\\\"hide\\\") : $(this).closest(\\\".card\\\").parent().addClass(\\\"hide\\\");\\r\\n            });\\r\\n        }\\r\\n    })\\r\\n<\\/script>\\r\\n<!---->\",\"attr-data-events-listening\":[],\"reload\":\"\",\"color\":\"#348fe2\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"id\":\"AC8CFDA829CA49B91B36FA17C09027B9\",\"title\":\"TOTAL VISITS\",\"value\":\"3,291,922\",\"customId\":\"\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<ul class=\\\"published-unpublished-apps\\\" style=\\\"margin-bottom:0;list-style-type:none;color:#03543D;height: auto;overflow: hidden;white-space: nowrap;text-overflow: ellipsis;font-size:16px;display:flex;flex-direction:column;gap:20px;padding-left:0px;\\\">\\n    <li data-container=\\\"publishedSection\\\" class=\\\"active\\\">Published<\\/li>\\n    <li data-container=\\\"unpublishedSection\\\">Unpublished<\\/li>\\n<\\/ul>\\n<style>\\n    @media (max-width: 576px) {\\n      ul.published-unpublished-apps {\\n        flex-direction: row !important;\\n        margin-bottom: 20px !important;\\n      }\\n      #publishedUnpublishedAppSection:has(li[data-container=\\\"publishedSection\\\"].active) #publishedAppViewList, #publishedUnpublishedAppSection:has(li[data-container=\\\"unpublishedSection\\\"].active) #unpublishedAppViewList {\\n        padding-left: 0px !important;\\n      }\\n    }\\t\\n    ul.published-unpublished-apps > li {\\n        padding-bottom: 4px;\\n        cursor: pointer;\\n        width: fit-content;\\n    }\\n    ul.published-unpublished-apps > li.active {\\n        border-bottom: 1px solid #003A70;\\n    }\\n    #publishedUnpublishedAppSection #publishedAppViewList,\\n  \\t#publishedUnpublishedAppSection #unpublishedAppViewList  {\\n        display: none;\\n    }\\n    #publishedUnpublishedAppSection:has(li[data-container=\\\"publishedSection\\\"].active) \\t#publishedAppViewList,\\n    #publishedUnpublishedAppSection:has(li[data-container=\\\"unpublishedSection\\\"].active) #unpublishedAppViewList {\\n        display: grid;\\n      \\tpadding: 0px;\\n        padding-left: 40px;\\n      \\tmargin: 0px;\\n    }\\n<\\/style>\",\"id\":\"BAC2D6A63F9D40D212DF9CB706AE1423\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-flex\":\"0 0 fit-content\",\"style-max-width\":\"fit-content\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.DataListMenu\",\"properties\":{\"cacheAllLinks\":\"\",\"customHeader\":\"\",\"keyName\":\"\",\"customFooter\":\"\",\"label\":\"List\",\"enableOffline\":\"\",\"customId\":\"publishedAppViewList\",\"buttonPosition\":\"bothLeft\",\"datalistId\":\"appPublishedViewList\",\"checkboxPosition\":\"left\",\"selectionType\":\"multiple\",\"userviewCacheDuration\":\"20\",\"cacheListAction\":\"\",\"userviewCacheScope\":\"\",\"rowCount\":\"\",\"id\":\"EF66085B918A458A4E5C657B6694CB50\"}},{\"className\":\"org.joget.apps.userview.lib.DataListMenu\",\"properties\":{\"cacheAllLinks\":\"\",\"customHeader\":\"\",\"keyName\":\"\",\"customFooter\":\"\",\"label\":\"List\",\"enableOffline\":\"\",\"customId\":\"unpublishedAppViewList\",\"buttonPosition\":\"bothLeft\",\"datalistId\":\"appUnpublishedViewList\",\"checkboxPosition\":\"left\",\"selectionType\":\"multiple\",\"userviewCacheDuration\":\"20\",\"cacheListAction\":\"\",\"userviewCacheScope\":\"\",\"rowCount\":\"\",\"id\":\"B577DC10058A4F4D6A5C10C5BA45C675\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-flex\":\"0 0 max-width\",\"style-max-width\":\"max-width\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-padding-right\":\"40px\",\"gutter\":\"5px\",\"style-padding-bottom\":\"40px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"fit-content\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"max-width\",\"style-tablet-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"F8A8D7F511874525D5E7CD90765979B7\",\"style-padding-top\":\"36px\",\"customId\":\"publishedUnpublishedAppSection\",\"style-padding-left\":\"40px\"}},{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"template\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag progress\'}-->\\n<div class=\\\"card apps-data\\\" \\n     style=\\\"padding: 20.5px 40px 24px 40px;\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;padding:0px;\\\">\\n        <div class=\\\"row\\\">\\n            <ul class=\\\"header-title col\\\" style=\\\"margin-bottom:0;list-style-type:none;color:#03543D;height: auto;overflow: hidden;white-space: nowrap;text-overflow: ellipsis;font-size:16px;display:flex;flex-direction:row;gap:32px;\\\">\\n                <li data-container=\\\"formSection\\\" class=\\\"active\\\">Form<\\/li>\\n                <li data-container=\\\"listSection\\\">Lists<\\/li>\\n                <li data-container=\\\"uiSection\\\">UIs<\\/li>\\n            <\\/ul>\\n        <\\/div>    \\n    <\\/div> \\n    <div class=\\\"pt-3 pb-2\\\" style=\\\"column-gap: 48px; row-gap: 28px; display: grid;\\\">\\n        <div class=\\\"row\\\">\\n            <div class=\\\"col-6 col-sm-8 col-md-10 apps-data-content\\\">\\n                <div id=\\\"formSection\\\">\\n                <\\/div>\\n                <div id=\\\"listSection\\\">\\n                <\\/div>\\n                <div id=\\\"uiSection\\\">\\n                <\\/div>\\n            <\\/div>\\n            <div class=\\\"col-6 col-sm-4 col-md-2 total-section\\\">\\n                <div>\\n                    <span>#stats.form.total#<\\/span>\\n                    <span>Total Form<\\/span>\\n                <\\/div>\\n                <div>\\n                    <span>#stats.list.total#<\\/span>\\n                    <span>Total List<\\/span>\\n                <\\/div>\\n                <div>\\n                    <span>#stats.UI.total#<\\/span>\\n                    <span>Total UI<\\/span>\\n                <\\/div>\\n            <\\/div>\\n        <\\/div>\\n    <\\/div>\\n<\\/div>\\n<script>\\n    $(document).ready(function(){\\n        function checkThreshold(){\\n            $(\\\".progress-bar\\\").each(function(){\\n                if( ($(this).css(\'width\').includes(\'%\') && parseFloat($(this).css(\'width\')) <= 50) || (!$(this).css(\'width\').includes(\'%\') && (parseFloat($(this).css(\'width\'))/$(this).parent().outerWidth()) < 0.5)) {\\n                    $(this).addClass(\\\"below-threshold\\\");\\n                }\\n            })   \\n        }\\n        \\n        checkThreshold();\\n        \\n        $(\\\".apps-data ul.header-title > li, ul.published-unpublished-apps > li\\\").off(\\\"click\\\").on(\\\"click\\\", function(){\\n            $(this).parent().find(\\\"li.active\\\").removeClass(\\\"active\\\");\\n            \\n            $(this).addClass(\\\"active\\\");\\n        })\\n        \\n        const lists = {\\n            app: \'#stats.appList#\'.split(\', \'),\\n            formSection: \'#stats.form.countPerApp#\'.split(\', \'),\\n            listSection: \'#stats.list.countPerApp#\'.split(\', \'),\\n            uiSection: \'#stats.UI.countPerApp#\'.split(\', \')\\n        };\\n        \\n        const total = {\\n            formSection: \'#stats.form.total#\',\\n            listSection: \'#stats.list.total#\',\\n            uiSection: \'#stats.UI.total#\'\\n        }\\n        \\n        $(\\\".apps-data-content > div\\\").each(function(){\\n            const $container = $(this);\\n            const name = $(this).attr(\'id\');\\n            const list = lists[name];\\n            lists[\\\"app\\\"].forEach((app, index) => {\\n                const percentage = (parseInt(list[index]) / parseInt(total[name])) * 100;\\n                const insertedHtml = `<div>\\n                <div style=\\\"margin-bottom:4px;height:calc(100% - 6px - 4px);display:flex;flex-direction:row;font-size: 14px;\\\">\\n                    <span style=\\\"color: #09583D;\\n                                white-space: normal;\\n                                flex: 1 1 80%;\\n                                min-width: 0;\\\">` +\\n                        app +\\n                    `<\\/span>\\n                    <small class=\\\"float-right\\\" style=\\\"color:#98B3A9;\\n                                                        flex: 1 1 20%;\\n                                                        text-align: right; font-size:14px\\\">` + \\n                                                        \\n                        list[index] +\\n                    `<\\/small>\\n                <\\/div>\\n                <div class=\\\"progress progress-small\\\" style=\\\"height: 6px;\\\">\\n                    <div class=\\\"progress-bar\\\" \\n                         style=\\\"width: ` + percentage + `%; \\n                                transition: width .6s ease; \\n                                background-color:#009265;\\\">\\n                    <\\/div>\\n                <\\/div>\\n            <\\/div>`;\\n                \\n                $container.append(insertedHtml);\\n            })\\n        })\\n    })\\n<\\/script>\\n<style>\\n    .apps-data ul.header-title {\\n        padding-bottom:0px;\\n    }\\n    .apps-data ul.header-title > li {\\n        cursor: pointer;\\n        padding-bottom:16px;\\n    }\\n    .apps-data ul.header-title > li.active {\\n        border-bottom: 2px solid #003A70;\\n    }\\n    .apps-data .apps-data-content > div {\\n        display: none;\\n    }\\n    .apps-data .total-section > div {\\n        display: none;\\n        text-align: right;\\n        color: #09583D;\\n        font-size: 14px;\\n    }\\n    .apps-data .total-section > div > span:first-child {\\n        display:block;\\n        font-size: 40px;\\n        color: #009265;\\n    }\\n    .apps-data:has(li[data-container=\\\"formSection\\\"].active) #formSection,\\n    .apps-data:has(li[data-container=\\\"listSection\\\"].active) #listSection,\\n    .apps-data:has(li[data-container=\\\"uiSection\\\"].active) #uiSection {\\n        display: grid;\\n        column-gap: 48px;\\n        row-gap: 16px;\\n    }\\n    .apps-data:has(li[data-container=\\\"formSection\\\"].active) .total-section > :nth-child(1),\\n    .apps-data:has(li[data-container=\\\"listSection\\\"].active) .total-section > :nth-child(2),\\n    .apps-data:has(li[data-container=\\\"uiSection\\\"].active) .total-section > :nth-child(3) {\\n        display: block;\\n    }\\n    .progress-bar.below-threshold {\\n        background-color: #092E28 !important;\\n    }\\n    @media (min-width: 992px) {\\n        .apps-data #formSection,\\n        .apps-data #listSection,\\n        .apps-data #uiSection {\\n            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));\\n        }\\n    }\\n    @media (max-width: 991px) {\\n        .apps-data-content #formSection,\\n        .apps-data-content #listSection,\\n        .apps-data-content #uiSection {\\n            grid-template-columns: 1fr 1fr 1fr;\\n        }\\n    }\\n    @media (max-width: 767px) {\\n        .apps-data-content #formSection,\\n        .apps-data-content #listSection,\\n        .apps-data-content #uiSection {\\n            grid-template-columns: 1fr 1fr;\\n        }\\n    }\\n    @media (max-width: 575px) {\\n        .apps-data-content #formSection,\\n        .apps-data-content #listSection,\\n        .apps-data-content #uiSection {\\n            grid-template-columns: 1fr;\\n        }\\n        \\n        .GHC .header-tag {\\n            display: none;\\n        }\\n    }\\n<\\/style>\\n<!---->\",\"attr-data-events-listening\":[],\"color\":\"#348fe2\",\"headerTag\":\"\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"bgImg\":\"\",\"title\":\"TOTAL VISITS\",\"customId\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"repeat\":[],\"id\":\"50D397659E7E4792CBFC51D1E48218A9\",\"value\":\"3,291,922\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-padding-right\":\"0px\",\"style-margin-top\":\"0px\",\"id\":\"38A41F7D03C745BD9D41510E1DEFBBAD\",\"customId\":\"apps_section\",\"style-padding-left\":\"0px\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"template\":\"<!--{sampleWidth: \'250px\'}-->\\n<div class=\\\"card user-heading\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;padding:0px; border-bottom: 0px;\\\">\\n        <div class=\\\"row\\\">\\n            <ul id=\\\"user-tab-nav\\\" class=\\\"header-title col-6\\\" style=\\\"margin-bottom:0;list-style-type:none;color:#03543D;height: auto;overflow: hidden;white-space: nowrap;text-overflow: ellipsis;font-size:16px;display:flex;flex-direction:row;gap:32px;\\\">\\n                <li style=\\\"padding-bottom: 18px;\\\" id=\\\"users-tab\\\">\\n                    Users\\n                <\\/li>\\n                <li style=\\\"padding-bottom: 18px;\\\" id=\\\"groups-tab\\\">\\n                    Groups\\n                <\\/li>\\n                <li id=\\\"organization-tab\\\">\\n                    Organization\\n                <\\/li>\\n            <\\/ul>\\n            <div class=\\\"header-tag col-6 text-right pl-0\\\">\\n                  <span class=\\\"value total-users value-number\\\">#stats.user.total#<span class=\\\"description\\\">Users<\\/span><\\/span>\\n                  <span class=\\\"value total-groups value-number\\\">#stats.group.total#<span class=\\\"description\\\">Groups<\\/span><\\/span>          \\n                  <span class=\\\"value total-organization value-number\\\"><span class=\\\"description\\\">Organizations<\\/span><\\/span>          \\n            <\\/div>\\n        <\\/div>    \\n    <\\/div> \\n<\\/div>\\n<style>\\n    .user-heading ul#user-tab-nav > li {\\n        cursor: pointer;\\n    }\\n    .user-heading ul#user-tab-nav > li.active {\\n        border-bottom: 2px solid #092E28;\\n    }\\n    .user-heading .header-tag > span {\\n        display: none;\\n    }\\n    #users_section #userDatalist,\\n    #users_section #groupDatalist,\\n    #users_section #organizationDatalist {\\n        display: none;\\n    } \\n    #users_section:has(.user-heading li:nth-child(1).active) span.total-users,\\n    #users_section:has(.user-heading li:nth-child(2).active) span.total-groups,\\n    #users_section:has(.user-heading li:nth-child(3).active) span.total-organization,\\n    #users_section:has(.user-heading li:nth-child(1).active) #userDatalist,\\n    #users_section:has(.user-heading li:nth-child(2).active) #groupDatalist,\\n    #users_section:has(.user-heading li:nth-child(3).active) #organizationDatalist {\\n        display: block;\\n        -webkit-animation: fadeIn 1s;\\n        animation: fadeIn 1s;\\n    } \\n    #users_section span.value {\\n        font-size: 18px;\\n        color: #009265;\\n    }\\n    #users_section span.value > span {\\n        font-size: 14px;\\n        margin-left: 12px;\\n        color: #09583D;\\n    }\\n<\\/style>\\n<script>\\n    $(document).ready(function(){\\n        var textVal = $(\\\"#organizationDatalist\\\").find(\\\"tbody .column_total\\\").eq(0).text();\\n        $(\\\"span.total-organization\\\").prepend(textVal === \\\"\\\" ? \\\"0\\\" : textVal)    \\n        \\n        $(\\\"#organizationDatalist .filters\\\").append(`\\n            <a class=\'btn\' onclick=\\\"AdminBar.showQuickOverlay(\'/jw/web/console/directory/orgs\'); setTimeout(function(){ $(\'#quickOverlayFrame\').contents().find(\'#main-action-buttons button\').click(); }, 500);\\\">Create Organization<\\/a>\\n        `);\\n        \\n        $(\\\"#userDatalist .filters\\\").append(`\\n            <a class=\'btn\' onclick=\\\"AdminBar.showQuickOverlay(\'/jw/web/console/directory/users\'); setTimeout(function(){ $(\'#quickOverlayFrame\').contents().find(\'#main-action-buttons button\').click(); }, 500);\\\">Create User<\\/a>\\n        `);\\n        \\n        $(\\\"#groupDatalist .filters\\\").append(`\\n            <a class=\'btn\' onclick=\\\"AdminBar.showQuickOverlay(\'/jw/web/console/directory/groups\'); setTimeout(function(){ $(\'#quickOverlayFrame\').contents().find(\'#main-action-buttons button\').click(); }, 500);\\\">Create Group<\\/a>\\n        `);\\n    })\\n<\\/script>\",\"attr-data-events-listening\":[],\"style-padding-right\":\"19px\",\"color\":\"#348FE2\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"bgImg\":\"\",\"title\":\"TOTAL VISITS\",\"style-padding-top\":\"14px\",\"customId\":\"\",\"style-padding-left\":\"19px\",\"bgColor\":\"\",\"id\":\"94C3FCACD8F147DDE84EA9AAEE12885F\",\"value\":\"3,291,922\",\"height\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.DataListMenu\",\"properties\":{\"cacheAllLinks\":\"\",\"customHeader\":\"\",\"keyName\":\"\",\"customFooter\":\"\",\"label\":\"List\",\"enableOffline\":\"\",\"customId\":\"userDatalist\",\"buttonPosition\":\"bothLeft\",\"datalistId\":\"userList\",\"checkboxPosition\":\"left\",\"selectionType\":\"multiple\",\"userviewCacheDuration\":\"20\",\"cacheListAction\":\"\",\"userviewCacheScope\":\"\",\"rowCount\":\"\",\"id\":\"B7F640D85D324DCA467E70626F18967D\"}},{\"className\":\"org.joget.apps.userview.lib.DataListMenu\",\"properties\":{\"cacheAllLinks\":\"\",\"customHeader\":\"\",\"keyName\":\"\",\"customFooter\":\"\",\"label\":\"List\",\"enableOffline\":\"\",\"customId\":\"groupDatalist\",\"buttonPosition\":\"bothLeft\",\"datalistId\":\"groupList\",\"checkboxPosition\":\"left\",\"selectionType\":\"multiple\",\"userviewCacheDuration\":\"20\",\"cacheListAction\":\"\",\"userviewCacheScope\":\"\",\"rowCount\":\"\",\"id\":\"8181D20FEBF24B67BE877ED15885AA8F\"}},{\"className\":\"org.joget.apps.userview.lib.DataListMenu\",\"properties\":{\"cacheAllLinks\":\"\",\"customHeader\":\"\",\"keyName\":\"\",\"customFooter\":\"\",\"label\":\"List\",\"enableOffline\":\"\",\"customId\":\"organizationDatalist\",\"buttonPosition\":\"bothLeft\",\"datalistId\":\"organizationList\",\"checkboxPosition\":\"left\",\"selectionType\":\"multiple\",\"userviewCacheDuration\":\"20\",\"cacheListAction\":\"\",\"userviewCacheScope\":\"\",\"rowCount\":\"\",\"id\":\"FF1A406BD3D34F8521E70C5B248AFA69\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-padding-right\":\"0px\",\"style-margin-top\":\"0px\",\"id\":\"43A998BB317B4BC8173CD4FEC13BDDB0\",\"customId\":\"users_section\",\"style-padding-left\":\"0px\"}},{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-4E2A517C3275429806518BAA8D29AB1F\"}}',NULL),
('appcenter',1,'up-8C70B71371B942B6D48A7E9B4C1DB8D1','Home','INTERNAL_USERVIEW_PAGE','2025-06-05 11:20:18','2025-11-13 12:01:34','{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"textContent\":\"<div class=\\\"container desktop\\\" id=\\\"homePageBanner\\\">\\n<div id=\\\"homePageBannerCarouselDesktop\\\" class=\\\"carousel slide show-neighbors\\\" data-bs-ride=\\\"carousel\\\"> \\n  <div class=\\\"carousel-inner\\\">\\n    <div class=\\\"carousel-item active\\\" data-bs-interval=\\\"3000\\\">\\n      <div class=\\\"item__third\\\">\\n        <a href=\\\"#request.appCenterBanner1#\\\" target=\\\"_blank\\\">\\n        <img src=\\\"#request.contextPath#/images/dx9AppCenter/desktopAppCenterBanner1.png\\\" class=\\\"d-block w-100\\\" alt=\\\"\\\">\\n        <\\/a>\\n      <\\/div>\\n    <\\/div>\\n    <div class=\\\"carousel-item\\\" data-bs-interval=\\\"3000\\\">\\n      <div class=\\\"item__third\\\">\\n        <a href=\\\"#request.appCenterBanner2#\\\" target=\\\"_blank\\\">\\n        <img src=\\\"#request.contextPath#/images/dx9AppCenter/desktopAppCenterBanner2.png\\\" class=\\\"d-block w-100\\\" alt=\\\"\\\">\\n        <\\/a>\\n      <\\/div>\\n    <\\/div>\\n    <div class=\\\"carousel-item\\\" data-bs-interval=\\\"3000\\\">\\n      <div class=\\\"item__third\\\">\\n        <a href=\\\"#request.appCenterBanner3#\\\" target=\\\"_blank\\\">\\n        <img src=\\\"#request.contextPath#/images/dx9AppCenter/desktopAppCenterBanner3.png\\\" class=\\\"d-block w-100\\\" alt=\\\"\\\">\\n        <\\/a>\\n      <\\/div>\\n    <\\/div>\\n    <div class=\\\"carousel-item\\\" data-bs-interval=\\\"3000\\\">\\n      <div class=\\\"item__third\\\">\\n<a href=\\\"#request.appCenterBanner4#\\\" target=\\\"_blank\\\">\\n        <img src=\\\"#request.contextPath#/images/dx9AppCenter/desktopAppCenterBanner4.png\\\" class=\\\"d-block w-100\\\" alt=\\\"\\\">\\n        <\\/a>\\n      <\\/div>\\n    <\\/div>\\n  <\\/div>\\n<\\/div>\\n  <button class=\\\"carousel-control-prev\\\" type=\\\"button\\\" data-bs-target=\\\"#homePageBannerCarouselDesktop\\\" data-bs-slide=\\\"prev\\\">\\n    <i class=\\\"fas fa-arrow-left\\\" id=\\\"image-left-arrow\\\"><\\/i>\\n  <\\/button>\\n  <button class=\\\"carousel-control-next\\\" type=\\\"button\\\" data-bs-target=\\\"#homePageBannerCarouselDesktop\\\" data-bs-slide=\\\"next\\\">\\n    <i class=\\\"fas fa-arrow-right\\\" id=\\\"image-right-arrow\\\"><\\/i>\\n  <\\/button>\\n<\\/div>\\n\\n<div class=\\\"container tablet\\\" id=\\\"homePageBanner\\\">\\n<div id=\\\"homePageBannerCarouselTablet\\\" class=\\\"carousel slide show-neighbors\\\" data-bs-ride=\\\"carousel\\\"> \\n  <div class=\\\"carousel-inner\\\">\\n    <div class=\\\"carousel-item active\\\" data-bs-interval=\\\"3000\\\">\\n      <div class=\\\"item__third\\\">\\n        <a href=\\\"#request.appCenterBanner1#\\\" target=\\\"_blank\\\">\\n        <img src=\\\"#request.contextPath#/images/dx9AppCenter/tabletAppCenterBanner1.png\\\" class=\\\"d-block w-100\\\" alt=\\\"\\\">\\n        <\\/a>\\n      <\\/div>\\n    <\\/div>\\n    <div class=\\\"carousel-item\\\" data-bs-interval=\\\"3000\\\">\\n      <div class=\\\"item__third\\\">\\n<a href=\\\"#request.appCenterBanner2#\\\" target=\\\"_blank\\\">\\n        <img src=\\\"#request.contextPath#/images/dx9AppCenter/tabletAppCenterBanner2.png\\\" class=\\\"d-block w-100\\\" alt=\\\"\\\">\\n        <\\/a>\\n      <\\/div>\\n    <\\/div>\\n    <div class=\\\"carousel-item\\\" data-bs-interval=\\\"3000\\\">\\n      <div class=\\\"item__third\\\">\\n <a href=\\\"#request.appCenterBanner3#\\\" target=\\\"_blank\\\">\\n        <img src=\\\"#request.contextPath#/images/dx9AppCenter/tabletAppCenterBanner3.png\\\" class=\\\"d-block w-100\\\" alt=\\\"\\\">\\n        <\\/a>\\n      <\\/div>\\n    <\\/div>\\n    <div class=\\\"carousel-item\\\" data-bs-interval=\\\"3000\\\">\\n      <div class=\\\"item__third\\\">\\n        <a href=\\\"#request.appCenterBanner4#\\\" target=\\\"_blank\\\">\\n        <img src=\\\"#request.contextPath#/images/dx9AppCenter/tabletAppCenterBanner4.png\\\" class=\\\"d-block w-100\\\" alt=\\\"\\\">\\n        <\\/a>\\n      <\\/div>\\n    <\\/div>\\n  <\\/div>\\n<\\/div>\\n  <button class=\\\"carousel-control-prev\\\" type=\\\"button\\\" data-bs-target=\\\"#homePageBannerCarouselTablet\\\" data-bs-slide=\\\"prev\\\">\\n    <i class=\\\"fas fa-arrow-left\\\" id=\\\"image-left-arrow\\\"><\\/i>\\n  <\\/button>\\n  <button class=\\\"carousel-control-next\\\" type=\\\"button\\\" data-bs-target=\\\"#homePageBannerCarouselTablet\\\" data-bs-slide=\\\"next\\\">\\n    <i class=\\\"fas fa-arrow-right\\\" id=\\\"image-right-arrow\\\"><\\/i>\\n  <\\/button>\\n<\\/div>\\n\\n<div class=\\\"container mobile\\\" id=\\\"homePageBanner\\\">\\n<div id=\\\"homePageBannerCarouselMobile\\\" class=\\\"carousel slide show-neighbors\\\" data-bs-ride=\\\"carousel\\\"> \\n  <div class=\\\"carousel-inner\\\">\\n    <div class=\\\"carousel-item active\\\" data-bs-interval=\\\"3000\\\">\\n      <div class=\\\"item__third\\\">\\n<a href=\\\"#request.appCenterBanner1#\\\" target=\\\"_blank\\\">\\n        <img src=\\\"#request.contextPath#/images/dx9AppCenter/mobileAppCenterBanner1.png\\\" class=\\\"d-block w-100\\\" alt=\\\"\\\">\\n        <\\/a>\\n      <\\/div>\\n    <\\/div>\\n    <div class=\\\"carousel-item\\\" data-bs-interval=\\\"3000\\\">\\n      <div class=\\\"item__third\\\">\\n<a href=\\\"#request.appCenterBanner2#\\\" target=\\\"_blank\\\">\\n        <img src=\\\"#request.contextPath#/images/dx9AppCenter/mobileAppCenterBanner2.png\\\" class=\\\"d-block w-100\\\" alt=\\\"\\\">\\n        <\\/a>\\n      <\\/div>\\n    <\\/div>\\n    <div class=\\\"carousel-item\\\" data-bs-interval=\\\"3000\\\">\\n      <div class=\\\"item__third\\\">\\n <a href=\\\"#request.appCenterBanner3#\\\" target=\\\"_blank\\\">\\n        <img src=\\\"#request.contextPath#/images/dx9AppCenter/mobileAppCenterBanner3.png\\\" class=\\\"d-block w-100\\\" alt=\\\"\\\">\\n        <\\/a>\\n      <\\/div>\\n    <\\/div>\\n    <div class=\\\"carousel-item\\\" data-bs-interval=\\\"3000\\\">\\n      <div class=\\\"item__third\\\">\\n<a href=\\\"#request.appCenterBanner4#\\\" target=\\\"_blank\\\">\\n        <img src=\\\"#request.contextPath#/images/dx9AppCenter/mobileAppCenterBanner4.png\\\" class=\\\"d-block w-100\\\" alt=\\\"\\\">\\n        <\\/a>\\n      <\\/div>\\n    <\\/div>\\n  <\\/div>\\n<\\/div>\\n  <button class=\\\"carousel-control-prev\\\" type=\\\"button\\\" data-bs-target=\\\"#homePageBannerCarouselMobile\\\" data-bs-slide=\\\"prev\\\">\\n     <i class=\\\"fas fa-arrow-left\\\" id=\\\"image-left-arrow\\\"><\\/i>\\n  <\\/button>\\n  <button class=\\\"carousel-control-next\\\" type=\\\"button\\\" data-bs-target=\\\"#homePageBannerCarouselMobile\\\" data-bs-slide=\\\"next\\\">\\n    <i class=\\\"fas fa-arrow-right\\\" id=\\\"image-right-arrow\\\"><\\/i>\\n  <\\/button>\\n<\\/div>\",\"id\":\"CAD108B62AF94E477880B911137C8ABB\",\"customId\":\"bannerSlideshow\"}},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"textContent\":\"<ul id=\\\"mobileTab\\\">\\n  <li id=\\\"taskTab\\\"><span>Tasks & Search<\\/span><\\/li>\\n  <li id=\\\"miniBannerTab\\\"><span>Low-Code Solutions<\\/span><\\/li>\\n<\\/ul>\",\"id\":\"7018FFF5880D429631B93BBB2F0B1044\",\"customId\":\"mobileTabContainer\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"textContent\":\"<div id=\\\"taskCounter\\\">\\n \\n<\\/div>\\n\\n<script>\\n$(document).ready(function () {\\n    setTimeout(function() {\\n        var $targetElement = $(\'#page > header > div > div > div.nav-no-collapse.header-nav > ul > li.inbox-notification.dropdown > a > span\');\\n        \\n        if ($targetElement.length) {\\n            var taskCount = $targetElement[0].innerText;\\n            var taskReminder;\\n\\t\\t\\tif($(\'.taskReminder\').length){\\n              $(\'.taskReminder\').remove();\\n            }\\n            if(taskCount > 0){\\n                taskReminder = `<a class=\\\"taskReminder badge badge-light\\\" href=\\\"/jw/web/userview/appcenter/home/_/_ja_inbox\\\">${taskCount} Task(s)<span class=\\\"badge red\\\"><\\/span><\\/a>`;\\n            } else {\\n                taskReminder = `<a class=\\\"taskReminder badge badge-light\\\" href=\\\"/jw/web/userview/appcenter/home/_/_ja_inbox\\\">${taskCount} Task(s)<\\/a>`;\\n            }\\n            \\n            $(\\\"#taskCounter\\\").append(taskReminder);\\n          \\n          var $notifications = $(\\\"#page > header > div > div > div.nav-no-collapse.header-nav > ul > li.inbox-notification.dropdown > ul.notifications\\\");\\n\\n          if ($notifications.find(\\\"li.task\\\").length > 0) {\\n            $(\\\"#taskCounter\\\").append(\\\"<div id=\'tasksMessage\'> \\\" + $notifications.find(\\\"li.task\\\").eq(0).html() + \\\"<\\/div>\\\");\\n          } else {\\n            $(\\\"#taskCounter\\\").append(\\\"<span id=\'tasksMessage\'>No tasks found<\\/span>\\\");\\n          }\\n\\n          if ($notifications.find(\\\"li > .dropdown-menu-sub-footer\\\").length) {\\n            var link = $(\\\"#page > header > div > div > div.nav-no-collapse.header-nav > ul > li.inbox-notification.dropdown > ul.notifications\\\").find(\\\"li > a.dropdown-menu-sub-footer\\\").attr(\\\"href\\\");\\n            $(\\\"#taskCounter\\\").append(\\\"<a id=\'viewTasks\' href=\'\\\" + link + \\\"\'><span>View all <\\/span><i class=\'zmdi zmdi-arrow-right-top\'><\\/i><\\/a>\\\");\\n          }\\n        }\\n    }, 1000); // Delay execution by 1000 milliseconds (1 second)\\n});\\n<\\/script>\",\"id\":\"900FFE725843468A8B35C0A61C773C56\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}}}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"textContent\":\"<div id=\\\"customSearchSection\\\" style=\\\"display: flex; justify-content: center;\\\">\\n  <i class=\\\"fas fa-search\\\" id=\\\"search-icon\\\"><\\/i>\\n  <input id=\\\"customSearchInput\\\" type=\\\"text\\\" placeholder=\\\"Search Apps\\\"/>\\n<\\/div>\\n\\n<script>\\n$(document).ready(function () {\\n    $(\'main #home.main-body-content #filters_applist\').hide();\\n    $(\\\"#customSearchInput\\\").off(\\\"input\\\").on(\\\"input\\\", function () {\\n        const input = this.value.trim().toLowerCase();\\n        const apps = $(\\\"#dataList_applist .table-wrapper .cards.row\\\").children();\\n        if (input === \\\"\\\") {\\n            apps.show();\\n            return;\\n        }\\n        apps.each(function () {\\n            const $this = $(this);\\n            const name = $this.find(\\\".card-title\\\").text().trim().toLowerCase();\\n            const toggleCondition = name.includes(input) || name.replace(/[^\\\\p{L}\\\\p{N}]/gu, \'\').includes(input);\\n            $this.toggle(toggleCondition);\\n        });\\n    });\\n});\\n<\\/script>\",\"id\":\"58619904738C42160909013B6EFF01B3\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}}}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#EDF0EF\",\"gutter\":\"10px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"css-mobile-stack-columns\":\"true\",\"id\":\"0014C07233314430CC4EC12554DED8D9\",\"customId\":\"searchColumn\",\"style-border-radius\":\"24px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-mobile-max-width\":\"100%\",\"style-tablet-flex\":\"0 0 60%\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-flex\":\"0 0 74%\",\"style-mobile-flex\":\"0 0 100%\",\"style-max-width\":\"74%\",\"style-tablet-max-width\":\"60%\"}},{\"elements\":[],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-mobile-max-width\":\"0%\",\"style-tablet-flex\":\"0 0 2%\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-flex\":\"0 0 1%\",\"style-mobile-flex\":\"0 0 0%\",\"style-max-width\":\"1%\",\"style-tablet-max-width\":\"2%\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"textContent\":\"<a href=\\\"https://joget.com/\\\" target=\\\"_blank\\\">\\n<img id=\\\"lowCodeBannerDesktop\\\" src=\\\"#request.contextPath#/images/dx9AppCenter/Low-CodeSolutionsDesktop.svg\\\" class=\\\"d-block w-100\\\" alt=\\\"\\\">\\n<img id=\\\"lowCodeBannerTablet\\\" src=\\\"#request.contextPath#/images/dx9AppCenter/Low-CodeSolutionsTablet.svg\\\" class=\\\"d-block w-100\\\" alt=\\\"\\\">\\n<img id=\\\"lowCodeBannerMobile\\\" src=\\\"#request.contextPath#/images/dx9AppCenter/Low-CodeSolutionsMobile.svg\\\" class=\\\"d-block w-100\\\" alt=\\\"\\\">\\n<\\/a>\",\"id\":\"B38F9954585042D40062812111DDCD25\",\"customId\":\"miniBannerContainer\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-mobile-max-width\":\"100%\",\"style-tablet-flex\":\"0 0 38%\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-flex\":\"0 0 25%\",\"style-mobile-flex\":\"0 0 100%\",\"style-max-width\":\"25%\",\"style-tablet-max-width\":\"38%\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"\",\"columns\":[{\"style-mobile-max-width\":\"100%\",\"style-max-width\":\"74%\",\"style-tablet-max-width\":\"60%\"},{\"style-mobile-max-width\":\"0%\",\"style-max-width\":\"1%\",\"style-tablet-max-width\":\"2%\"},{\"style-mobile-max-width\":\"100%\",\"style-max-width\":\"25%\",\"style-tablet-max-width\":\"38%\"}],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"css-mobile-stack-columns\":\"true\",\"id\":\"89AACE6022BB4560031C78DBA57ACAB1\",\"customId\":\"searchColumnContainer\",\"style-border-radius\":\"24px\"}},{\"elements\":[{\"elements\":[],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-padding-right\":\"0px\",\"style-padding-bottom\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{},\"F6E97C06864E4F62843B259A8C9AB1AD\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"attr-data-events-triggering\":[],\"id\":\"970F3C4619204E5D5F9253C3A2B9D8A3\",\"style-padding-top\":\"0px\",\"customId\":\"inbox_container\",\"style-padding-left\":\"0px\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-color\":\"#FFFFFF\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"textContent\":\"<h3 class=\\\"appCenterLabel\\\">\\n All Apps\\n<\\/h3>\\n<style>\\n  /*General Styles*/\\n  button.primary {\\n    display: inline-block;\\n    font-size: 0.8rem;\\n    color: #fff !important;\\n    background: rgb(var(--vs-primary)/100%);\\n    padding: 13px 25px;\\n    border-radius: 17px;\\n    transition: background-color 0.1s ease;\\n    box-sizing: border-box;\\n    transition: all 0.25s ease;\\n    border: 0;\\n    cursor: pointer;\\n    box-shadow: 0 10px 20px -10px rgb(var(--vs-primary)/50%);\\n  }\\n\\n  button.primary:hover {\\n    box-shadow: 0 20px 20px -10px rgb(var(--vs-primary)/50%);\\n    transform: translateY(-5px);\\n  }\\n<\\/style>\",\"style-font-size\":\"26px\",\"id\":\"DCFF483F2BDC48A2FC36722C7B98D5E3\",\"customId\":\"bannerLabel\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-bottom\":\"0px\",\"style-mobile-max-width\":\"100%\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-mobile-margin-bottom\":\"16px\",\"style-mobile-flex\":\"0 0 100%\",\"style-padding-top\":\"0px\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"textContent\":\"<div class=\\\"appListNav\\\">\\n  <i class=\\\"fas fa-long-arrow-alt-left\\\" id=\\\"left-arrow\\\" title=\\\"Scroll Left\\\"><\\/i>\\n  <i class=\\\"fas fa-long-arrow-alt-right\\\" id=\\\"right-arrow\\\" title=\\\"Scroll Right\\\"><\\/i>\\n<\\/div>\",\"id\":\"8AFD5FD29A11401010A81846427B770A\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-mobile-padding-bottom\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-mobile-padding-top\":\"0px\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"hidden\":\"true\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{\"hidden\":\"true\"},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"textContent\":\"<div class=\\\"addNew dropdown dataList\\\">\\n <button class=\\\"btn btn-primary dropdown-toggle more-action\\\" type=\\\"button\\\" id=\\\"dropdownMenuButton\\\" data-toggle=\\\"dropdown\\\" aria-haspopup=\\\"true\\\" aria-expanded=\\\"false\\\">\\nAdd New\\n<\\/button>\\n  <div class=\\\"dropdown-menu dropdown-menu-right\\\" aria-labelledby=\\\"dropdownMenuButton\\\">\\n    <a data-pc-id=\\\"8EFC9D21190A4BFBE31A945826FF6B34\\\" href=\\\"design_app\\\" id=\\\"pc-8EFC9D21190A4BFBE31A945826FF6B34\\\" class=\\\"dropdown-item\\\"><i class=\\\"fas fa-pencil-ruler\\\"><\\/i>Design App<\\/a>\\n    <a class=\\\"dropdown-item\\\" onclick=\\\"appImport(); return false;\\\" data-pc-id=\\\"10862931081E4DF47D44CCDFC696CAD6\\\" href=\\\"#\\\"><i class=\\\"zmdi zmdi-square-down\\\"><\\/i>Import App<\\/a>\\n    <a class=\\\"dropdown-item\\\" onclick=\\\"AdminBar.showQuickOverlay(\'/jw/web/desktop/marketplace/app?url=\' + encodeURIComponent(\'https://marketplace.joget.org\')); return false;\\\" href=\\\"#\\\"><i class=\\\"fas fa-file-download\\\"><\\/i>Download From Marketplace<\\/a>\\n  <\\/div>\\n<\\/div>\",\"id\":\"A81395644C124B33E6D78C40A235029F\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}}}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"css-mobile-stack-columns\":\"true\",\"id\":\"03EC104731C441FFD58113F297AE3319\",\"col-0-style-mobile-padding-bottom\":\"0px\",\"customId\":\"addContainer\",\"col-0-style-mobile-padding-top\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-bottom\":\"0px\",\"style-mobile-max-width\":\"100%\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{}},\"style-mobile-flex\":\"0 0 100%\",\"style-padding-top\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"col-1-style-padding-top\":\"0px\",\"columns\":[{\"style-mobile-max-width\":\"100%\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"100%\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"col-1-style-padding-bottom\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"css-mobile-stack-columns\":\"true\",\"col-0-style-padding-bottom\":\"0px\",\"customId\":\"appHeader\",\"style-mobile-padding-top\":\"0px\",\"gutter\":\"0px\",\"style-mobile-padding-bottom\":\"0px\",\"style-mobile-margin-bottom\":\"15px\",\"id\":\"A3A0BF9DC54F47DCFC32029D56DA4D5E\",\"col-0-style-mobile-margin-bottom\":\"16px\",\"col-0-style-padding-top\":\"0px\"}},{\"elements\":[{\"elements\":[{\"elements\":[],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-padding-right\":\"0px\",\"style-padding-bottom\":\"0px\",\"style-text-align\":\"center\",\"hidden\":\"true\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{},\"F6E97C06864E4F62843B259A8C9AB1AD\":{\"hidden\":\"true\"},\"58F9FBEA76264BE037991759BC1645A2\":{\"hidden\":\"\"}},\"attr-data-events-triggering\":[],\"id\":\"96141190357145C9478235142772AEC5\",\"style-padding-top\":\"0px\",\"customId\":\"\",\"style-padding-left\":\"0px\"}},{\"permission_rules\":{\"F6E97C06864E4F62843B259A8C9AB1AD\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-padding-right\":\"0px\",\"style-padding-bottom\":\"0px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"style-flex\":\"0 0 100%\",\"style-padding-top\":\"0px\",\"style-max-width\":\"100%\",\"style-padding-left\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-padding-right\":\"0px\",\"col-1-style-padding-top\":\"0px\",\"col-1-style-tablet-custom\":\"padding:80px 40px 40px 20px;\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"100%\",\"style-tablet-max-width\":\"\"}],\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{},\"F6E97C06864E4F62843B259A8C9AB1AD\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"col-1-style-padding-bottom\":\"0px\",\"css-mobile-stack-columns\":\"true\",\"col-1-style-custom\":\"height: 100vh !important;\",\"col-0-style-padding-bottom\":\"0px\",\"attr-data-events-triggering\":[],\"style-padding-top\":\"0px\",\"col-0-style-padding-left\":\"0px\",\"customId\":\"home_column\",\"style-padding-left\":\"0px\",\"gutter\":\"\",\"style-padding-bottom\":\"0px\",\"col-0-style-padding-right\":\"0px\",\"id\":\"74DC9C5E101D4BB4D955B3B9C5FE48D3\",\"col-1-style-mobile-custom\":\"padding: 0px 20px 20px;\",\"col-0-style-padding-top\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-padding-right\":\"10px\",\"style-mobile-padding-left\":\"10px\",\"permission_rules\":{\"94913ebc-eaf3-eb26-9d8e-4b18fb8ffc81\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"style-tablet-padding-left\":\"40px\",\"style-tablet-padding-right\":\"40px\",\"id\":\"4DCA577808B846C1A790C74379A81D58\",\"customId\":\"homeContent\",\"style-mobile-padding-top\":\"40px\"}}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-8C70B71371B942B6D48A7E9B4C1DB8D1\"}}',NULL),
('appcenter',1,'up-95447DD6260B48B2E00C1354A179CD44','Templates','INTERNAL_USERVIEW_PAGE','2025-06-05 11:20:18','2025-11-13 12:01:35','{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"Templates\",\"id\":\"05C7846C333D49C67A72D578A4D3F8D1\",\"tagName\":\"h3\",\"customId\":\"template_header\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"Joget app templates are pre-built applications that help speed up the development process on the Joget platform. <br> These templates include essential components like forms, lists, user interfaces, and workflows, making it easy to <br> customize and deploy apps for specific business needs.\",\"id\":\"C7461F08EB4043C424097945DDD991A2\",\"tagName\":\"h5\",\"customId\":\"template_header_subtitle\"}},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<script>\\n$(document).ready(function(){\\n  $(\\\"select\\\").chosen({disable_search: true});\\n})\\n<\\/script>\",\"id\":\"F06D68B139EC435096192F3536E133C6\",\"customId\":\"\"}},{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-95447DD6260B48B2E00C1354A179CD44\"}}',NULL),
('competitor_research',1,'APP_OVERVIEW_DEFINITION','-1702905276','APP_OVERVIEW_DEFINITION','2025-06-06 10:21:47','2025-09-24 17:28:24','{\"userview:v\":{\"data\":[{\"path\":\"properties.welcomeMessage\",\"isError\":false,\"label\":\"#date.EEE, d MMM yyyy#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#date.EEE, d MMM yyyy#\"},{\"path\":\"categories[0].menus[0].properties.content\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.crWelcomePage.jpg#\"},{\"path\":\"categories[0].menus[0].properties.content\",\"isError\":false,\"label\":\"#appResource.crWelcomePage.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<h1><\\/h1>\\n<table width=\\\"90%\\\" border=\\\"0\\\" collapse=\\\"\\\" align=\\\"center\\\">\\n<tbody>\\n<tr>\\n<td>\\n<h3><span style=\\\"font-size: 24pt; color: rgb(51, 51, 51);\\\">Welcome to the Competitor Research App<\\/span><\\/h3>\\n<p><span style=\\\"font-size: 14pt; color: #000000;\\\">&nbsp;Track, Review and Research Competitors<\\/span><\\/p>\\n<\\/td>\\n<\\/tr>\\n<tr>\\n<td><img width=\\\"25%\\\" src=\\\"#appResource.crWelcomePage.jpg#\\\"><\\/td>\\n<\\/tr>\\n<tr>\\n<td><br>\\n<p><span style=\\\"color: #333333;\\\"><strong>Competitor Research app<\\/strong> <span>helps you to monitor and analyze your market competitors to gain strategic insights<\\/span>:<\\/span><\\/p>\\n<ul>\\n<li class=\\\"li1\\\">\\n<div class=\\\"de1\\\">The main view displays competitors in an organized card layout for easy comparison<\\/div>\\n<\\/li>\\n<li class=\\\"li1\\\">\\n<div class=\\\"de1\\\">Add competitors with their company details, revenue figures, and capabilities<\\/div>\\n<\\/li>\\n<li class=\\\"li1\\\">\\n<div class=\\\"de1\\\">Categorize competitors by sectors and differentiators for quick filtering<\\/div>\\n<\\/li>\\n<li class=\\\"li1\\\">\\n<div class=\\\"de1\\\">Track deals with competitors and monitor their status<\\/div>\\n<\\/li>\\n<\\/ul>\\n<ul><\\/ul>\\n<\\/td>\\n<\\/tr>\\n<\\/tbody>\\n<\\/table>\"},{\"path\":\"categories[0].menus[0].properties.content\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<h1><\\/h1>\\n<table width=\\\"90%\\\" border=\\\"0\\\" collapse=\\\"\\\" align=\\\"center\\\">\\n<tbody>\\n<tr>\\n<td>\\n<h3><span style=\\\"font-size: 24pt; color: rgb(51, 51, 51);\\\">Welcome to the Competitor Research App<\\/span><\\/h3>\\n<p><span style=\\\"font-size: 14pt; color: #000000;\\\">&nbsp;Track, Review and Research Competitors<\\/span><\\/p>\\n<\\/td>\\n<\\/tr>\\n<tr>\\n<td><img width=\\\"25%\\\" src=\\\"#appResource.crWelcomePage.jpg#\\\"><\\/td>\\n<\\/tr>\\n<tr>\\n<td><br>\\n<p><span style=\\\"color: #333333;\\\"><strong>Competitor Research app<\\/strong> <span>helps you to monitor and analyze your market competitors to gain strategic insights<\\/span>:<\\/span><\\/p>\\n<ul>\\n<li class=\\\"li1\\\">\\n<div class=\\\"de1\\\">The main view displays competitors in an organized card layout for easy comparison<\\/div>\\n<\\/li>\\n<li class=\\\"li1\\\">\\n<div class=\\\"de1\\\">Add competitors with their company details, revenue figures, and capabilities<\\/div>\\n<\\/li>\\n<li class=\\\"li1\\\">\\n<div class=\\\"de1\\\">Categorize competitors by sectors and differentiators for quick filtering<\\/div>\\n<\\/li>\\n<li class=\\\"li1\\\">\\n<div class=\\\"de1\\\">Track deals with competitors and monitor their status<\\/div>\\n<\\/li>\\n<\\/ul>\\n<ul><\\/ul>\\n<\\/td>\\n<\\/tr>\\n<\\/tbody>\\n<\\/table>\"},{\"path\":\"categories[1].menus[0].properties.list-customHeader\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<style>\\n#dataList_list_competitor .card-actions > a.ph_rowActions.rowaction_body.body_.link_{\\n  \\tcolor: #2563EB !important;\\n  \\tfont-weight: 500;\\n  \\tline-height: 40px;\\n  }\\n<\\/style>\"},{\"path\":\"categories[1].menus[0].referencePage.elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<script>\\n  $(document).ready(function() {\\n        $(\\\".filters\\\").hide();\\n        $(\'.actions\').append(\\\"<button id=\'anchorSearchFilter\' href=\'javascript:void(0)\' class=\'btn btn-secondary\'  title=\'Filter\'><i class=\'fas fa-filter\'><\\/i> Filter<\\/button>\\\");\\n          $(\\\"#anchorSearchFilter\\\").click(function(e) {\\n            e.preventDefault();\\n            $(\\\".filters\\\").toggle(600);\\n          });\\n\\n          function toggleButtonVisibility() {\\n            if ($(window).width() > 767) { // Adjust the breakpoint according to your design\\n              $(\'#anchorSearchFilter\').show(); // Show button on mobile view\\n            } else {\\n              $(\'#anchorSerchFilter\').hide(); // Hide button on desktop view\\n              $(\\\".filters\\\").show();\\n            }\\n          }\\n          // Initial check on page load\\n          toggleButtonVisibility();\\n          // Check on window resize\\n          $(window).resize(function() {\\n            toggleButtonVisibility();\\n          }); $(\'#list_interview_Assessment_1 tbody tr\').each(function() {\\n            $(this).find(\'td:last\').hide();\\n          });\\n        });\\n<\\/script>\"},{\"path\":\"categories[1].menus[1].referencePage.elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<script>\\n  $(document).ready(function() {\\n        $(\\\".filters\\\").hide();\\n        $(\'.actions\').append(\\\"<button id=\'anchorSearchFilter\' href=\'javascript:void(0)\' class=\'btn btn-secondary\'  title=\'Filter\'><i class=\'fas fa-filter\'><\\/i> Filter<\\/button>\\\");\\n          $(\\\"#anchorSearchFilter\\\").click(function(e) {\\n            e.preventDefault();\\n            $(\\\".filters\\\").toggle(600);\\n          });\\n\\n          function toggleButtonVisibility() {\\n            if ($(window).width() > 767) { // Adjust the breakpoint according to your design\\n              $(\'#anchorSearchFilter\').show(); // Show button on mobile view\\n            } else {\\n              $(\'#anchorSerchFilter\').hide(); // Hide button on desktop view\\n              $(\\\".filters\\\").show();\\n            }\\n          }\\n          // Initial check on page load\\n          toggleButtonVisibility();\\n          // Check on window resize\\n          $(window).resize(function() {\\n            toggleButtonVisibility();\\n          }); $(\'#list_interview_Assessment_1 tbody tr\').each(function() {\\n            $(this).find(\'td:last\').hide();\\n          });\\n        });\\n<\\/script>\"},{\"path\":\"categories[2].menus[0].referencePage.elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<script>\\n  $(document).ready(function() {\\n        $(\\\".filters\\\").hide();\\n        $(\'.actions\').append(\\\"<button id=\'anchorSearchFilter\' href=\'javascript:void(0)\' class=\'btn btn-secondary\'  title=\'Filter\'><i class=\'fas fa-filter\'><\\/i> Filter<\\/button>\\\");\\n          $(\\\"#anchorSearchFilter\\\").click(function(e) {\\n            e.preventDefault();\\n            $(\\\".filters\\\").toggle(600);\\n          });\\n\\n          function toggleButtonVisibility() {\\n            if ($(window).width() > 767) { // Adjust the breakpoint according to your design\\n              $(\'#anchorSearchFilter\').show(); // Show button on mobile view\\n            } else {\\n              $(\'#anchorSerchFilter\').hide(); // Hide button on desktop view\\n              $(\\\".filters\\\").show();\\n            }\\n          }\\n          // Initial check on page load\\n          toggleButtonVisibility();\\n          // Check on window resize\\n          $(window).resize(function() {\\n            toggleButtonVisibility();\\n          }); $(\'#list_interview_Assessment_1 tbody tr\').each(function() {\\n            $(this).find(\'td:last\').hide();\\n          });\\n        });\\n<\\/script>\"},{\"path\":\"categories[3].menus[0].referencePage.elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<script>\\n  $(document).ready(function() {\\n        $(\\\".filters\\\").hide();\\n        $(\'.actions\').append(\\\"<button id=\'anchorSearchFilter\' href=\'javascript:void(0)\' class=\'btn btn-secondary\'  title=\'Filter\'><i class=\'fas fa-filter\'><\\/i> Filter<\\/button>\\\");\\n          $(\\\"#anchorSearchFilter\\\").click(function(e) {\\n            e.preventDefault();\\n            $(\\\".filters\\\").toggle(600);\\n          });\\n\\n          function toggleButtonVisibility() {\\n            if ($(window).width() > 767) { // Adjust the breakpoint according to your design\\n              $(\'#anchorSearchFilter\').show(); // Show button on mobile view\\n            } else {\\n              $(\'#anchorSerchFilter\').hide(); // Hide button on desktop view\\n              $(\\\".filters\\\").show();\\n            }\\n          }\\n          // Initial check on page load\\n          toggleButtonVisibility();\\n          // Check on window resize\\n          $(window).resize(function() {\\n            toggleButtonVisibility();\\n          }); $(\'#list_interview_Assessment_1 tbody tr\').each(function() {\\n            $(this).find(\'td:last\').hide();\\n          });\\n        });\\n<\\/script>\"},{\"path\":\"categories[4].menus[0].referencePage.elements[1].properties.textContent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<script>\\n  $(document).ready(function() {\\n        $(\\\".filters\\\").hide();\\n        $(\'.actions\').append(\\\"<button id=\'anchorSearchFilter\' href=\'javascript:void(0)\' class=\'btn btn-secondary\'  title=\'Filter\'><i class=\'fas fa-filter\'><\\/i> Filter<\\/button>\\\");\\n          $(\\\"#anchorSearchFilter\\\").click(function(e) {\\n            e.preventDefault();\\n            $(\\\".filters\\\").toggle(600);\\n          });\\n\\n          function toggleButtonVisibility() {\\n            if ($(window).width() > 767) { // Adjust the breakpoint according to your design\\n              $(\'#anchorSearchFilter\').show(); // Show button on mobile view\\n            } else {\\n              $(\'#anchorSerchFilter\').hide(); // Hide button on desktop view\\n              $(\\\".filters\\\").show();\\n            }\\n          }\\n          // Initial check on page load\\n          toggleButtonVisibility();\\n          // Check on window resize\\n          $(window).resize(function() {\\n            toggleButtonVisibility();\\n          }); $(\'#list_interview_Assessment_1 tbody tr\').each(function() {\\n            $(this).find(\'td:last\').hide();\\n          });\\n        });\\n<\\/script>\"},{\"path\":\"categories[5].menus[0].properties.content\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<p><strong><span style=\\\"font-size: 18pt;\\\">Competitor Research App<\\/span><\\/strong><br>This application helps you monitor and analyze your market competitors to gain strategic insights.<br><br><strong>Workflow Overview:&nbsp;<\\/strong><\\/p>\\n<ul>\\n<li>The main view displays competitors in an organized card layout for easy comparison<\\/li>\\n<li>Add competitors with their company details, revenue figures, and capabilities<\\/li>\\n<li>Categorize competitors by sectors and differentiators for quick filtering<\\/li>\\n<li>Track deals with competitors and monitor their status<\\/li>\\n<\\/ul>\\n<p>&nbsp;<br><strong>Using the app<\\/strong>:<\\/p>\\n<ul>\\n<li>&nbsp;Navigate the Menu: Use the sidebar to access Competitors, Sectors, Differentiators, and Deals sections.<\\/li>\\n<li>Add Competitors: Click \\\"Add Competitor\\\" button to create new competitor profiles with company information, product capabilities, and revenue data.<\\/li>\\n<li>View Competitor Details: Click on any competitor card to see their complete profile, including capabilities and market position.<\\/li>\\n<li>Track Deals: Record and monitor deal statuses with competitors through the deals listing page.<\\/li>\\n<\\/ul>\"},{\"path\":\"categories[5].menus[1].properties.content\",\"isError\":false,\"label\":\"#i18n.Joget Home#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<ul>\\n<li><a href=\\\"https://www.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Home#<\\/a><\\/li>\\n<li><a href=\\\"https://www.joget.org/download/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Downloads#<\\/a><\\/li>\\n<li><a href=\\\"http://www.jogetcloud.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Cloud#<\\/a><\\/li>\\n<li><a href=\\\"https://academy.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Academy#<\\/a><\\/li>\\n<li><a href=\\\"https://www.youtube.com/user/jogetworkflow\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Videos#<\\/a><\\/li>\\n<li><a href=\\\"https://marketplace.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Marketplace#<\\/a><\\/li>\\n<li><a href=\\\"https://community.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Knowledge Base#<\\/a><\\/li>\\n<li><a href=\\\"http://answer.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Answers#<\\/a><\\/li>\\n<li><a href=\\\"http://blog.joget.org/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Blog#<\\/a><\\/li>\\n<li><a href=\\\"https://play.google.com/store/apps/details?id=org.joget.mobile&amp;hl=en\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile Android App#<\\/a><\\/li>\\n<li><a href=\\\"https://itunes.apple.com/us/app/joget-workflow-mobile/id1084995640?mt=8\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile iOS App#<\\/a><\\/li>\\n<li><a href=\\\"https://github.com/jogetworkflow/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Open Source Repository#<\\/a><\\/li>\\n<li><a href=\\\"https://translate.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Translations#<\\/a><\\/li>\\n<li><a href=\\\"http://joget.org/buy-enterprise-edition-license/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Purchase Joget License#<\\/a><\\/li>\\n<\\/ul>\"},{\"path\":\"categories[5].menus[1].properties.content\",\"isError\":false,\"label\":\"#i18n.Joget Downloads#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<ul>\\n<li><a href=\\\"https://www.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Home#<\\/a><\\/li>\\n<li><a href=\\\"https://www.joget.org/download/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Downloads#<\\/a><\\/li>\\n<li><a href=\\\"http://www.jogetcloud.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Cloud#<\\/a><\\/li>\\n<li><a href=\\\"https://academy.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Academy#<\\/a><\\/li>\\n<li><a href=\\\"https://www.youtube.com/user/jogetworkflow\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Videos#<\\/a><\\/li>\\n<li><a href=\\\"https://marketplace.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Marketplace#<\\/a><\\/li>\\n<li><a href=\\\"https://community.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Knowledge Base#<\\/a><\\/li>\\n<li><a href=\\\"http://answer.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Answers#<\\/a><\\/li>\\n<li><a href=\\\"http://blog.joget.org/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Blog#<\\/a><\\/li>\\n<li><a href=\\\"https://play.google.com/store/apps/details?id=org.joget.mobile&amp;hl=en\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile Android App#<\\/a><\\/li>\\n<li><a href=\\\"https://itunes.apple.com/us/app/joget-workflow-mobile/id1084995640?mt=8\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile iOS App#<\\/a><\\/li>\\n<li><a href=\\\"https://github.com/jogetworkflow/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Open Source Repository#<\\/a><\\/li>\\n<li><a href=\\\"https://translate.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Translations#<\\/a><\\/li>\\n<li><a href=\\\"http://joget.org/buy-enterprise-edition-license/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Purchase Joget License#<\\/a><\\/li>\\n<\\/ul>\"},{\"path\":\"categories[5].menus[1].properties.content\",\"isError\":false,\"label\":\"#i18n.Joget Cloud#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<ul>\\n<li><a href=\\\"https://www.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Home#<\\/a><\\/li>\\n<li><a href=\\\"https://www.joget.org/download/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Downloads#<\\/a><\\/li>\\n<li><a href=\\\"http://www.jogetcloud.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Cloud#<\\/a><\\/li>\\n<li><a href=\\\"https://academy.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Academy#<\\/a><\\/li>\\n<li><a href=\\\"https://www.youtube.com/user/jogetworkflow\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Videos#<\\/a><\\/li>\\n<li><a href=\\\"https://marketplace.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Marketplace#<\\/a><\\/li>\\n<li><a href=\\\"https://community.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Knowledge Base#<\\/a><\\/li>\\n<li><a href=\\\"http://answer.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Answers#<\\/a><\\/li>\\n<li><a href=\\\"http://blog.joget.org/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Blog#<\\/a><\\/li>\\n<li><a href=\\\"https://play.google.com/store/apps/details?id=org.joget.mobile&amp;hl=en\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile Android App#<\\/a><\\/li>\\n<li><a href=\\\"https://itunes.apple.com/us/app/joget-workflow-mobile/id1084995640?mt=8\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile iOS App#<\\/a><\\/li>\\n<li><a href=\\\"https://github.com/jogetworkflow/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Open Source Repository#<\\/a><\\/li>\\n<li><a href=\\\"https://translate.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Translations#<\\/a><\\/li>\\n<li><a href=\\\"http://joget.org/buy-enterprise-edition-license/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Purchase Joget License#<\\/a><\\/li>\\n<\\/ul>\"},{\"path\":\"categories[5].menus[1].properties.content\",\"isError\":false,\"label\":\"#i18n.Joget Academy#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<ul>\\n<li><a href=\\\"https://www.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Home#<\\/a><\\/li>\\n<li><a href=\\\"https://www.joget.org/download/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Downloads#<\\/a><\\/li>\\n<li><a href=\\\"http://www.jogetcloud.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Cloud#<\\/a><\\/li>\\n<li><a href=\\\"https://academy.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Academy#<\\/a><\\/li>\\n<li><a href=\\\"https://www.youtube.com/user/jogetworkflow\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Videos#<\\/a><\\/li>\\n<li><a href=\\\"https://marketplace.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Marketplace#<\\/a><\\/li>\\n<li><a href=\\\"https://community.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Knowledge Base#<\\/a><\\/li>\\n<li><a href=\\\"http://answer.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Answers#<\\/a><\\/li>\\n<li><a href=\\\"http://blog.joget.org/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Blog#<\\/a><\\/li>\\n<li><a href=\\\"https://play.google.com/store/apps/details?id=org.joget.mobile&amp;hl=en\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile Android App#<\\/a><\\/li>\\n<li><a href=\\\"https://itunes.apple.com/us/app/joget-workflow-mobile/id1084995640?mt=8\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile iOS App#<\\/a><\\/li>\\n<li><a href=\\\"https://github.com/jogetworkflow/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Open Source Repository#<\\/a><\\/li>\\n<li><a href=\\\"https://translate.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Translations#<\\/a><\\/li>\\n<li><a href=\\\"http://joget.org/buy-enterprise-edition-license/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Purchase Joget License#<\\/a><\\/li>\\n<\\/ul>\"},{\"path\":\"categories[5].menus[1].properties.content\",\"isError\":false,\"label\":\"#i18n.Joget Videos#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<ul>\\n<li><a href=\\\"https://www.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Home#<\\/a><\\/li>\\n<li><a href=\\\"https://www.joget.org/download/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Downloads#<\\/a><\\/li>\\n<li><a href=\\\"http://www.jogetcloud.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Cloud#<\\/a><\\/li>\\n<li><a href=\\\"https://academy.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Academy#<\\/a><\\/li>\\n<li><a href=\\\"https://www.youtube.com/user/jogetworkflow\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Videos#<\\/a><\\/li>\\n<li><a href=\\\"https://marketplace.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Marketplace#<\\/a><\\/li>\\n<li><a href=\\\"https://community.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Knowledge Base#<\\/a><\\/li>\\n<li><a href=\\\"http://answer.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Answers#<\\/a><\\/li>\\n<li><a href=\\\"http://blog.joget.org/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Blog#<\\/a><\\/li>\\n<li><a href=\\\"https://play.google.com/store/apps/details?id=org.joget.mobile&amp;hl=en\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile Android App#<\\/a><\\/li>\\n<li><a href=\\\"https://itunes.apple.com/us/app/joget-workflow-mobile/id1084995640?mt=8\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile iOS App#<\\/a><\\/li>\\n<li><a href=\\\"https://github.com/jogetworkflow/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Open Source Repository#<\\/a><\\/li>\\n<li><a href=\\\"https://translate.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Translations#<\\/a><\\/li>\\n<li><a href=\\\"http://joget.org/buy-enterprise-edition-license/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Purchase Joget License#<\\/a><\\/li>\\n<\\/ul>\"},{\"path\":\"categories[5].menus[1].properties.content\",\"isError\":false,\"label\":\"#i18n.Joget Marketplace#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<ul>\\n<li><a href=\\\"https://www.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Home#<\\/a><\\/li>\\n<li><a href=\\\"https://www.joget.org/download/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Downloads#<\\/a><\\/li>\\n<li><a href=\\\"http://www.jogetcloud.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Cloud#<\\/a><\\/li>\\n<li><a href=\\\"https://academy.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Academy#<\\/a><\\/li>\\n<li><a href=\\\"https://www.youtube.com/user/jogetworkflow\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Videos#<\\/a><\\/li>\\n<li><a href=\\\"https://marketplace.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Marketplace#<\\/a><\\/li>\\n<li><a href=\\\"https://community.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Knowledge Base#<\\/a><\\/li>\\n<li><a href=\\\"http://answer.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Answers#<\\/a><\\/li>\\n<li><a href=\\\"http://blog.joget.org/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Blog#<\\/a><\\/li>\\n<li><a href=\\\"https://play.google.com/store/apps/details?id=org.joget.mobile&amp;hl=en\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile Android App#<\\/a><\\/li>\\n<li><a href=\\\"https://itunes.apple.com/us/app/joget-workflow-mobile/id1084995640?mt=8\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile iOS App#<\\/a><\\/li>\\n<li><a href=\\\"https://github.com/jogetworkflow/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Open Source Repository#<\\/a><\\/li>\\n<li><a href=\\\"https://translate.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Translations#<\\/a><\\/li>\\n<li><a href=\\\"http://joget.org/buy-enterprise-edition-license/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Purchase Joget License#<\\/a><\\/li>\\n<\\/ul>\"},{\"path\":\"categories[5].menus[1].properties.content\",\"isError\":false,\"label\":\"#i18n.Joget Knowledge Base#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<ul>\\n<li><a href=\\\"https://www.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Home#<\\/a><\\/li>\\n<li><a href=\\\"https://www.joget.org/download/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Downloads#<\\/a><\\/li>\\n<li><a href=\\\"http://www.jogetcloud.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Cloud#<\\/a><\\/li>\\n<li><a href=\\\"https://academy.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Academy#<\\/a><\\/li>\\n<li><a href=\\\"https://www.youtube.com/user/jogetworkflow\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Videos#<\\/a><\\/li>\\n<li><a href=\\\"https://marketplace.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Marketplace#<\\/a><\\/li>\\n<li><a href=\\\"https://community.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Knowledge Base#<\\/a><\\/li>\\n<li><a href=\\\"http://answer.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Answers#<\\/a><\\/li>\\n<li><a href=\\\"http://blog.joget.org/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Blog#<\\/a><\\/li>\\n<li><a href=\\\"https://play.google.com/store/apps/details?id=org.joget.mobile&amp;hl=en\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile Android App#<\\/a><\\/li>\\n<li><a href=\\\"https://itunes.apple.com/us/app/joget-workflow-mobile/id1084995640?mt=8\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile iOS App#<\\/a><\\/li>\\n<li><a href=\\\"https://github.com/jogetworkflow/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Open Source Repository#<\\/a><\\/li>\\n<li><a href=\\\"https://translate.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Translations#<\\/a><\\/li>\\n<li><a href=\\\"http://joget.org/buy-enterprise-edition-license/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Purchase Joget License#<\\/a><\\/li>\\n<\\/ul>\"},{\"path\":\"categories[5].menus[1].properties.content\",\"isError\":false,\"label\":\"#i18n.Joget Answers#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<ul>\\n<li><a href=\\\"https://www.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Home#<\\/a><\\/li>\\n<li><a href=\\\"https://www.joget.org/download/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Downloads#<\\/a><\\/li>\\n<li><a href=\\\"http://www.jogetcloud.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Cloud#<\\/a><\\/li>\\n<li><a href=\\\"https://academy.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Academy#<\\/a><\\/li>\\n<li><a href=\\\"https://www.youtube.com/user/jogetworkflow\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Videos#<\\/a><\\/li>\\n<li><a href=\\\"https://marketplace.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Marketplace#<\\/a><\\/li>\\n<li><a href=\\\"https://community.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Knowledge Base#<\\/a><\\/li>\\n<li><a href=\\\"http://answer.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Answers#<\\/a><\\/li>\\n<li><a href=\\\"http://blog.joget.org/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Blog#<\\/a><\\/li>\\n<li><a href=\\\"https://play.google.com/store/apps/details?id=org.joget.mobile&amp;hl=en\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile Android App#<\\/a><\\/li>\\n<li><a href=\\\"https://itunes.apple.com/us/app/joget-workflow-mobile/id1084995640?mt=8\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile iOS App#<\\/a><\\/li>\\n<li><a href=\\\"https://github.com/jogetworkflow/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Open Source Repository#<\\/a><\\/li>\\n<li><a href=\\\"https://translate.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Translations#<\\/a><\\/li>\\n<li><a href=\\\"http://joget.org/buy-enterprise-edition-license/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Purchase Joget License#<\\/a><\\/li>\\n<\\/ul>\"},{\"path\":\"categories[5].menus[1].properties.content\",\"isError\":false,\"label\":\"#i18n.Joget Blog#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<ul>\\n<li><a href=\\\"https://www.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Home#<\\/a><\\/li>\\n<li><a href=\\\"https://www.joget.org/download/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Downloads#<\\/a><\\/li>\\n<li><a href=\\\"http://www.jogetcloud.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Cloud#<\\/a><\\/li>\\n<li><a href=\\\"https://academy.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Academy#<\\/a><\\/li>\\n<li><a href=\\\"https://www.youtube.com/user/jogetworkflow\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Videos#<\\/a><\\/li>\\n<li><a href=\\\"https://marketplace.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Marketplace#<\\/a><\\/li>\\n<li><a href=\\\"https://community.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Knowledge Base#<\\/a><\\/li>\\n<li><a href=\\\"http://answer.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Answers#<\\/a><\\/li>\\n<li><a href=\\\"http://blog.joget.org/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Blog#<\\/a><\\/li>\\n<li><a href=\\\"https://play.google.com/store/apps/details?id=org.joget.mobile&amp;hl=en\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile Android App#<\\/a><\\/li>\\n<li><a href=\\\"https://itunes.apple.com/us/app/joget-workflow-mobile/id1084995640?mt=8\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile iOS App#<\\/a><\\/li>\\n<li><a href=\\\"https://github.com/jogetworkflow/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Open Source Repository#<\\/a><\\/li>\\n<li><a href=\\\"https://translate.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Translations#<\\/a><\\/li>\\n<li><a href=\\\"http://joget.org/buy-enterprise-edition-license/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Purchase Joget License#<\\/a><\\/li>\\n<\\/ul>\"},{\"path\":\"categories[5].menus[1].properties.content\",\"isError\":false,\"label\":\"#i18n.Joget Mobile Android App#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<ul>\\n<li><a href=\\\"https://www.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Home#<\\/a><\\/li>\\n<li><a href=\\\"https://www.joget.org/download/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Downloads#<\\/a><\\/li>\\n<li><a href=\\\"http://www.jogetcloud.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Cloud#<\\/a><\\/li>\\n<li><a href=\\\"https://academy.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Academy#<\\/a><\\/li>\\n<li><a href=\\\"https://www.youtube.com/user/jogetworkflow\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Videos#<\\/a><\\/li>\\n<li><a href=\\\"https://marketplace.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Marketplace#<\\/a><\\/li>\\n<li><a href=\\\"https://community.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Knowledge Base#<\\/a><\\/li>\\n<li><a href=\\\"http://answer.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Answers#<\\/a><\\/li>\\n<li><a href=\\\"http://blog.joget.org/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Blog#<\\/a><\\/li>\\n<li><a href=\\\"https://play.google.com/store/apps/details?id=org.joget.mobile&amp;hl=en\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile Android App#<\\/a><\\/li>\\n<li><a href=\\\"https://itunes.apple.com/us/app/joget-workflow-mobile/id1084995640?mt=8\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile iOS App#<\\/a><\\/li>\\n<li><a href=\\\"https://github.com/jogetworkflow/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Open Source Repository#<\\/a><\\/li>\\n<li><a href=\\\"https://translate.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Translations#<\\/a><\\/li>\\n<li><a href=\\\"http://joget.org/buy-enterprise-edition-license/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Purchase Joget License#<\\/a><\\/li>\\n<\\/ul>\"},{\"path\":\"categories[5].menus[1].properties.content\",\"isError\":false,\"label\":\"#i18n.Joget Mobile iOS App#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<ul>\\n<li><a href=\\\"https://www.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Home#<\\/a><\\/li>\\n<li><a href=\\\"https://www.joget.org/download/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Downloads#<\\/a><\\/li>\\n<li><a href=\\\"http://www.jogetcloud.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Cloud#<\\/a><\\/li>\\n<li><a href=\\\"https://academy.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Academy#<\\/a><\\/li>\\n<li><a href=\\\"https://www.youtube.com/user/jogetworkflow\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Videos#<\\/a><\\/li>\\n<li><a href=\\\"https://marketplace.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Marketplace#<\\/a><\\/li>\\n<li><a href=\\\"https://community.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Knowledge Base#<\\/a><\\/li>\\n<li><a href=\\\"http://answer.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Answers#<\\/a><\\/li>\\n<li><a href=\\\"http://blog.joget.org/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Blog#<\\/a><\\/li>\\n<li><a href=\\\"https://play.google.com/store/apps/details?id=org.joget.mobile&amp;hl=en\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile Android App#<\\/a><\\/li>\\n<li><a href=\\\"https://itunes.apple.com/us/app/joget-workflow-mobile/id1084995640?mt=8\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile iOS App#<\\/a><\\/li>\\n<li><a href=\\\"https://github.com/jogetworkflow/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Open Source Repository#<\\/a><\\/li>\\n<li><a href=\\\"https://translate.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Translations#<\\/a><\\/li>\\n<li><a href=\\\"http://joget.org/buy-enterprise-edition-license/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Purchase Joget License#<\\/a><\\/li>\\n<\\/ul>\"},{\"path\":\"categories[5].menus[1].properties.content\",\"isError\":false,\"label\":\"#i18n.Joget Open Source Repository#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<ul>\\n<li><a href=\\\"https://www.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Home#<\\/a><\\/li>\\n<li><a href=\\\"https://www.joget.org/download/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Downloads#<\\/a><\\/li>\\n<li><a href=\\\"http://www.jogetcloud.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Cloud#<\\/a><\\/li>\\n<li><a href=\\\"https://academy.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Academy#<\\/a><\\/li>\\n<li><a href=\\\"https://www.youtube.com/user/jogetworkflow\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Videos#<\\/a><\\/li>\\n<li><a href=\\\"https://marketplace.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Marketplace#<\\/a><\\/li>\\n<li><a href=\\\"https://community.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Knowledge Base#<\\/a><\\/li>\\n<li><a href=\\\"http://answer.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Answers#<\\/a><\\/li>\\n<li><a href=\\\"http://blog.joget.org/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Blog#<\\/a><\\/li>\\n<li><a href=\\\"https://play.google.com/store/apps/details?id=org.joget.mobile&amp;hl=en\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile Android App#<\\/a><\\/li>\\n<li><a href=\\\"https://itunes.apple.com/us/app/joget-workflow-mobile/id1084995640?mt=8\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile iOS App#<\\/a><\\/li>\\n<li><a href=\\\"https://github.com/jogetworkflow/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Open Source Repository#<\\/a><\\/li>\\n<li><a href=\\\"https://translate.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Translations#<\\/a><\\/li>\\n<li><a href=\\\"http://joget.org/buy-enterprise-edition-license/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Purchase Joget License#<\\/a><\\/li>\\n<\\/ul>\"},{\"path\":\"categories[5].menus[1].properties.content\",\"isError\":false,\"label\":\"#i18n.Joget Translations#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<ul>\\n<li><a href=\\\"https://www.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Home#<\\/a><\\/li>\\n<li><a href=\\\"https://www.joget.org/download/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Downloads#<\\/a><\\/li>\\n<li><a href=\\\"http://www.jogetcloud.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Cloud#<\\/a><\\/li>\\n<li><a href=\\\"https://academy.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Academy#<\\/a><\\/li>\\n<li><a href=\\\"https://www.youtube.com/user/jogetworkflow\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Videos#<\\/a><\\/li>\\n<li><a href=\\\"https://marketplace.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Marketplace#<\\/a><\\/li>\\n<li><a href=\\\"https://community.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Knowledge Base#<\\/a><\\/li>\\n<li><a href=\\\"http://answer.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Answers#<\\/a><\\/li>\\n<li><a href=\\\"http://blog.joget.org/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Blog#<\\/a><\\/li>\\n<li><a href=\\\"https://play.google.com/store/apps/details?id=org.joget.mobile&amp;hl=en\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile Android App#<\\/a><\\/li>\\n<li><a href=\\\"https://itunes.apple.com/us/app/joget-workflow-mobile/id1084995640?mt=8\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile iOS App#<\\/a><\\/li>\\n<li><a href=\\\"https://github.com/jogetworkflow/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Open Source Repository#<\\/a><\\/li>\\n<li><a href=\\\"https://translate.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Translations#<\\/a><\\/li>\\n<li><a href=\\\"http://joget.org/buy-enterprise-edition-license/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Purchase Joget License#<\\/a><\\/li>\\n<\\/ul>\"},{\"path\":\"categories[5].menus[1].properties.content\",\"isError\":false,\"label\":\"#i18n.Purchase Joget License#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<ul>\\n<li><a href=\\\"https://www.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Home#<\\/a><\\/li>\\n<li><a href=\\\"https://www.joget.org/download/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Downloads#<\\/a><\\/li>\\n<li><a href=\\\"http://www.jogetcloud.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Cloud#<\\/a><\\/li>\\n<li><a href=\\\"https://academy.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Academy#<\\/a><\\/li>\\n<li><a href=\\\"https://www.youtube.com/user/jogetworkflow\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Videos#<\\/a><\\/li>\\n<li><a href=\\\"https://marketplace.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Marketplace#<\\/a><\\/li>\\n<li><a href=\\\"https://community.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Knowledge Base#<\\/a><\\/li>\\n<li><a href=\\\"http://answer.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Answers#<\\/a><\\/li>\\n<li><a href=\\\"http://blog.joget.org/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Blog#<\\/a><\\/li>\\n<li><a href=\\\"https://play.google.com/store/apps/details?id=org.joget.mobile&amp;hl=en\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile Android App#<\\/a><\\/li>\\n<li><a href=\\\"https://itunes.apple.com/us/app/joget-workflow-mobile/id1084995640?mt=8\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile iOS App#<\\/a><\\/li>\\n<li><a href=\\\"https://github.com/jogetworkflow/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Open Source Repository#<\\/a><\\/li>\\n<li><a href=\\\"https://translate.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Translations#<\\/a><\\/li>\\n<li><a href=\\\"http://joget.org/buy-enterprise-edition-license/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Purchase Joget License#<\\/a><\\/li>\\n<\\/ul>\"},{\"path\":\"categories[5].menus[1].properties.content\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<ul>\\n<li><a href=\\\"https://www.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Home#<\\/a><\\/li>\\n<li><a href=\\\"https://www.joget.org/download/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Downloads#<\\/a><\\/li>\\n<li><a href=\\\"http://www.jogetcloud.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Cloud#<\\/a><\\/li>\\n<li><a href=\\\"https://academy.joget.com/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Academy#<\\/a><\\/li>\\n<li><a href=\\\"https://www.youtube.com/user/jogetworkflow\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Videos#<\\/a><\\/li>\\n<li><a href=\\\"https://marketplace.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Marketplace#<\\/a><\\/li>\\n<li><a href=\\\"https://community.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Knowledge Base#<\\/a><\\/li>\\n<li><a href=\\\"http://answer.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Answers#<\\/a><\\/li>\\n<li><a href=\\\"http://blog.joget.org/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Blog#<\\/a><\\/li>\\n<li><a href=\\\"https://play.google.com/store/apps/details?id=org.joget.mobile&amp;hl=en\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile Android App#<\\/a><\\/li>\\n<li><a href=\\\"https://itunes.apple.com/us/app/joget-workflow-mobile/id1084995640?mt=8\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Mobile iOS App#<\\/a><\\/li>\\n<li><a href=\\\"https://github.com/jogetworkflow/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Open Source Repository#<\\/a><\\/li>\\n<li><a href=\\\"https://translate.joget.org\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Joget Translations#<\\/a><\\/li>\\n<li><a href=\\\"http://joget.org/buy-enterprise-edition-license/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">#i18n.Purchase Joget License#<\\/a><\\/li>\\n<\\/ul>\"},{\"path\":\"properties.welcomeMessage\",\"isError\":false,\"label\":\"#date.EEE, d MMM yyyy#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#date.EEE, d MMM yyyy#\"},{\"path\":\"setting.properties.theme.properties.logo\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.competitorResearch_Logo.png#\"},{\"path\":\"setting.properties.theme.properties.fav_icon\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.ChatGPT_Image_Jul_17__2025__12_36_21_PM.png#\"},{\"path\":\"setting.properties.theme.properties.logo\",\"isError\":false,\"label\":\"#appResource.competitorResearch_Logo.png#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#appResource.competitorResearch_Logo.png#\"},{\"path\":\"setting.properties.theme.properties.fav_icon\",\"isError\":false,\"label\":\"#appResource.ChatGPT_Image_Jul_17__2025__12_36_21_PM.png#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#appResource.ChatGPT_Image_Jul_17__2025__12_36_21_PM.png#\"},{\"path\":\"setting.properties.theme\",\"isError\":false,\"label\":\"org.joget.plugin.enterprise.BuilderTheme.theme_competitor_research_theme (Missing)\",\"tool\":\"org.joget.apps.app.lib.InstalledPluginOverviewTool\",\"content\":\"org.joget.plugin.enterprise.BuilderTheme.theme_competitor_research_theme\"},{\"path\":\"setting.properties.userview_thumbnail\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.competitorResearch_appIcon.png#\"},{\"path\":\"setting.properties.userview_thumbnail\",\"isError\":false,\"label\":\"#appResource.competitorResearch_appIcon.png#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#appResource.competitorResearch_appIcon.png#\"}],\"lastModifiedDate\":\"Jul 17, 2025, 5:09:24\\u202fPM\"},\"datalist:list_deal\":{\"data\":[],\"lastModifiedDate\":\"Jul 15, 2025, 10:43:33\\u202fAM\"},\"datalist:list_differentiators\":{\"data\":[],\"lastModifiedDate\":\"Jul 15, 2025, 10:43:33\\u202fAM\"},\"datalist:list_sectors\":{\"data\":[],\"lastModifiedDate\":\"Jul 15, 2025, 10:43:34\\u202fAM\"},\"datalist:list_view_competitor\":{\"data\":[],\"lastModifiedDate\":\"Jul 15, 2025, 10:43:34\\u202fAM\"},\"form:sectors\":{\"data\":[],\"lastModifiedDate\":\"Jul 15, 2025, 10:43:33\\u202fAM\"},\"form:competitor\":{\"data\":[],\"lastModifiedDate\":\"Jul 15, 2025, 12:00:47\\u202fPM\"},\"theme:theme_competitor_research_theme\":{\"data\":[{\"path\":\"theme.properties.logo\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.competitorResearch_Logo.png#\"},{\"path\":\"theme.properties.fav_icon\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.competitorResearch_AppIcon.png#\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.competitorResearch_appIcon.png#\"},{\"path\":\"theme.properties.logo\",\"isError\":false,\"label\":\"#appResource.competitorResearch_Logo.png#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#appResource.competitorResearch_Logo.png#\"},{\"path\":\"theme.properties.fav_icon\",\"isError\":false,\"label\":\"#appResource.competitorResearch_AppIcon.png#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#appResource.competitorResearch_AppIcon.png#\"},{\"path\":\"theme\",\"isError\":false,\"label\":\"org.joget.plugin.enterprise.BuilderTheme.theme_competitor_research_theme (Missing)\",\"tool\":\"org.joget.apps.app.lib.InstalledPluginOverviewTool\",\"content\":\"org.joget.plugin.enterprise.BuilderTheme.theme_competitor_research_theme\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.template\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.competitorResearch_appIcon.png#\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.template\",\"isError\":false,\"label\":\"#appResource.competitorResearch_appIcon.png#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'transparent\'}-->\\r\\n<style>\\r\\n  .login-container-2 {\\r\\n      display: flex;\\r\\n      height: 100%;\\r\\n      position: relative;\\r\\n      background-size: cover;\\r\\n      background-position: center;\\r\\n      overflow: hidden; \\r\\n    }\\r\\n  .login-container-2::before {\\r\\n      content: \'\';\\r\\n      position: absolute;\\r\\n      top: 0;\\r\\n      left: 0;\\r\\n      width: 100%;\\r\\n      height: 100%;\\r\\n      background: radial-gradient(55.87% 55.87% at 35.49% -18.37%, #dd77fa 0%, rgba(255, 255, 255, 0) 100%), radial-gradient(70.81% 48.44% at -24.53% -16.02%, #0d6efd 0%, rgba(255, 255, 255, 0) 100%), radial-gradient(91.61% 92.58% at 104.86% -43.36%, #dc3545 0%, rgba(255, 255, 255, 0) 100%), radial-gradient(50.59% 55.55% at -2.99% -8.69%, #0d6efd 9.06%, rgba(255, 255, 255, 0) 100%), #f7fafc;\\r\\n      pointer-events: none; \\r\\n    }\\r\\n  .login-form-2 {\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    width: 100% !important;\\r\\n    max-width: 400px !important;\\r\\n    background-color: transparent !important;\\r\\n    border:none;\\r\\n  }\\r\\n  .login-form-2 button {\\r\\n    background-color: {{btnColor||#000000}} !important;\\r\\n    border:none !important;\\r\\n    height:50px !important;\\r\\n    border-radius: 25px !important;\\r\\n    font-weight: 700 !important;\\r\\n    color: {{btnTextColor||#FFFFFF}} !important;\\r\\n  }\\r\\n  .login-card-2 {\\r\\n    padding: 20px;\\r\\n  }\\r\\n  .input-container-2 {\\r\\n    position: relative !important;\\r\\n  }\\r\\n  .icon-2 {\\r\\n    position: absolute !important;\\r\\n    left: 30px !important;\\r\\n    top: 50% !important;\\r\\n    transform: translateY(-50%) !important;\\r\\n    color: #404040 !important;\\r\\n    font-size:15px!important;\\r\\n  }\\r\\n  .login-card-2 form input{\\r\\n    padding-left: 50px !important;\\r\\n    height: 50px !important;\\r\\n    border-radius:5px !important;\\r\\n    font-size:15px!important;\\r\\n    float: unset !important;\\r\\n    text-align:left !important;\\r\\n    background-color: #edf2f7 !important;\\r\\n    border: none !important;\\r\\n  }\\r\\n  .login-card-2 form input::placeholder{\\r\\n    color: #333 !important;\\r\\n  }\\r\\n  .login-card-2 .input-container-2 input:focus + .icon-2{\\r\\n    left: 25px !important;\\r\\n    color: #1677FF !important;\\r\\n    transition-duration: 1s;\\r\\n  }\\r\\n  .login-card-2 input#customUsername, .login-card-2 input#customUsername::placeholder{\\r\\n    color: {{usernameFieldColor||#404040}} !important;\\r\\n  }\\r\\n  .login-card-2 input#customPassword, .login-card-2 input#customPassword::placeholder{\\r\\n    color: {{passwordFieldColor||#404040}} !important;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-2\\\">\\r\\n  <div class=\\\"card login-form-2 login-card-2\\\">\\r\\n    <form>\\r\\n      <div class=\\\"text-center\\\">\\r\\n        <img class=\\\"mb-3\\\" src=\\\"#appResource.competitorResearch_appIcon.png#\\\" style=\\\"width:75px;height:75px;border-radius:8px;\\\">\\r\\n      <\\/div>\\r\\n      <h2 class=\\\"mb-4 text-center\\\" style=\\\"color:{{titleColor||#000000}};font-weight: 400;font-size: 24px;\\\">{{title||Welcome back! <br> Please enter your details.}}<\\/h2>\\r\\n      <div class=\\\"mb-3 input-container-2\\\">\\r\\n        <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"{{customUsername||Username}}\\\">\\r\\n        <i class=\\\"fa fa-user icon-2\\\"><\\/i>\\r\\n      <\\/div>\\r\\n      <div class=\\\"mb-5 input-container-2\\\">\\r\\n        <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"{{customPassword||Password}}\\\">\\r\\n        <i class=\\\"fas fa-lock icon-2\\\"><\\/i>\\r\\n      <\\/div>\\r\\n      <button type=\\\"button\\\" class=\\\"btn btn-primary w-100\\\" id=\\\"loginButton\\\">{{btnText||Log In}}<\\/button>\\r\\n    <\\/form>\\r\\n  <\\/div>\\r\\n<\\/div>\\r\\n<!---->\"}],\"lastModifiedDate\":\"Jul 17, 2025, 8:40:42\\u202fPM\"},\"datalist:list_competitor\":{\"data\":[{\"path\":\"columns[1].format.properties.script\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.BeanShellOverviewTool\",\"content\":\"return \\\"<div class=\\\\\\\"badge rounded-pill text-secondary-emphasis bg-secondary-subtle border-secondary-subtle\\\\\\\" style=\\\\\\\"    font-size: 11px;\\\\\\\">\\\" + value+ \\\"<\\/div>\\\"\"},{\"path\":\"columns[2].format.properties.script\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.BeanShellOverviewTool\",\"content\":\"String[] items = value.split(\\\";\\\");\\nString newValue = \\\"\\\";\\n\\nfor (String item : items) {\\n\\tnewValue += \\\"<div style=\\\\\\\"font-size: 13px\\\\\\\" class=\\\\\\\"mb-1 badge rounded-pill fw-normal text-secondary-emphasis bg-secondary-subtle border-secondary-subtle\\\\\\\">\\\" + item + \\\"<\\/div> \\\";\\n    System.out.println(item.trim());\\n}\\n\\nreturn newValue;\"}],\"lastModifiedDate\":\"Jul 21, 2025, 5:25:21\\u202fPM\"},\"properties\":{\"id\":\"APP_OVERVIEW_DEFINITION\"},\"form:deal\":{\"data\":[{\"path\":\"properties.postProcessor.properties.fields\",\"isError\":false,\"label\":\"#form.deal.name#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"field\\\":\\\"deal_id\\\",\\\"value\\\":\\\"#form.deal.name# - #form.deal.deal_date#\\\"}]\"},{\"path\":\"properties.postProcessor.properties.fields\",\"isError\":false,\"label\":\"#form.deal.deal_date#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"[{\\\"field\\\":\\\"deal_id\\\",\\\"value\\\":\\\"#form.deal.name# - #form.deal.deal_date#\\\"}]\"},{\"path\":\"properties.postProcessor.properties.fields[0].value\",\"isError\":false,\"label\":\"#form.deal.name#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#form.deal.name# - #form.deal.deal_date#\"},{\"path\":\"properties.postProcessor.properties.fields[0].value\",\"isError\":false,\"label\":\"#form.deal.deal_date#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#form.deal.name# - #form.deal.deal_date#\"}],\"lastModifiedDate\":\"Jul 15, 2025, 10:43:33\\u202fAM\"},\"form:differentiators\":{\"data\":[],\"lastModifiedDate\":\"Jul 15, 2025, 10:43:33\\u202fAM\"}}',NULL),
('competitor_research',1,'theme_competitor_research_theme','Competitor Research Theme','theme','2025-06-06 10:21:47','2025-09-24 17:28:25','{\"theme\":{\"className\":\"org.joget.plugin.enterprise.BuilderTheme.theme_competitor_research_theme\",\"properties\":{\"css\":\".dynamicselect_addbutton button{\\n    border-radius: 6px !important;\\n    margin-left: 10px;\\n}\\n.header-nav a.btn .badge {\\n    right: 4px;\\n    top: 10px;\\n}\\n#header-name .logo {\\n  border-radius: 50%;\\n  height: 60px;\\n  margin-right: 0;\\n}\\n#header-link {\\n    line-height: 60px;\\n}\\nbody.rtl .badge > i{\\n\\tmargin-left: 6px;\\n\\tmargin-right: 0 !important;\\n}\\n@media(max-width:767px) {\\n\\t#welcomePageImage{\\n  \\t\\twidth: 100%;\\n\\t}\\n}\",\"dx8-light-sidebar-navActiveIconColor\":\"\",\"global-itemPaddingBlock\":\"5px\",\"global-contentPaddingInline\":\"40px\",\"global-controlHeight\":\"40px\",\"dx8borderColor\":\"rgba(5, 5, 5, 0.06)\",\"dx8-dark-header-headerFontColor\":\"\",\"dx8-dark-header-navActiveLinkColor\":\"\",\"global-itemMarginInline\":\"8px\",\"dx8-light-sidebar-navActiveLinkColor\":\"\",\"dx8-light-header-navActiveLinkBackground\":\"\",\"disableHelpGuide\":\"\",\"dx8-dark-sidebar-navLinkIcon\":\"#333333\",\"dx8-dark-header-navBadge\":\"#52C41A\",\"horizontal_menu\":\"light-header\",\"global-sidebarWidth\":\"280px\",\"profile\":\"\",\"dx8-dark-sidebar-headerFontColor\":\"#001529\",\"homeAttractBanner\":\"\",\"global-headerPadding\":\"20px\",\"dx8-dark-header-navActiveLinkBackground\":\"\",\"homeUrl\":\"\",\"dx8footerColor\":\"#252F4A\",\"subheader\":\"\",\"dx8contentbackground\":\"#FFFFFF\",\"dx8-dark-sidebar-navBadge\":\"#EDEDED\",\"dx8-dark-header-navActiveIconColor\":\"\",\"dx8background\":\"#E9E9EE\",\"dx8-light-sidebar-navBadge\":\"#52C41A\",\"dx8-dark-header-navBackground\":\"\",\"js\":\"\",\"dx8-light-header-navActiveIconColor\":\"#252F4A\",\"global-itemPaddingInline\":\"50px\",\"urlsToCache\":\"\",\"userImage\":\"\",\"dx8-dark-header-navLinkBackground\":\"\",\"fontControl\":\"\",\"global-iconSize\":\"14px\",\"global-lineHeight\":\"1.5714285714285714\",\"dx8-light-sidebar-headerColor\":\"\",\"global-boxShadowSecondary\":\"0 6px 16px 0 rgba(0, 0, 0, 0.08), 0 3px 6px -4px rgba(0, 0, 0, 0.12), 0 9px 28px 8px rgba(0, 0, 0, 0.05)\",\"dx8-light-header-headerColor\":\"#000000\",\"dx8footerBackground\":\"#F7F7F7\",\"global-borderRadius\":\"6px\",\"dx8-light-header-headerFontColor\":\"#FFFFFF\",\"dx8-dark-sidebar-navActiveIconColor\":\"#EE1D52\",\"dx8-dark-sidebar-headerColor\":\"#333333\",\"dx8-light-sidebar-navBackground\":\"\",\"dx8-light-header-navActiveLinkColor\":\"#252F4A\",\"dx8-dark-header-navScrollbarThumb\":\"\",\"inbox\":\"current\",\"global-footerPadding\":\"16px 50px\",\"dx8-light-sidebar-navScrollbarThumb\":\"\",\"hideSidebarUserMenu\":\"true\",\"primaryColor\":\"#000000\",\"global-itemMarginBlock\":\"4px\",\"disablePush\":\"\",\"removeAssignmentTitle\":\"\",\"dx8-dark-sidebar-navBackground\":\"#F7F7F7\",\"dx8-light-sidebar-navLinkBackground\":\"\",\"global-footerHeight\":\"50px\",\"dx8-dark-sidebar-navActiveLinkColor\":\"#EE1D52\",\"shortcutLinkLabel\":\"Shortcut\",\"logo\":\"#appResource.competitorResearch_Logo.png#\",\"enableResponsiveSwitch\":\"true\",\"fav_icon\":\"#appResource.competitorResearch_AppIcon.png#\",\"global-padding\":\"10px\",\"disablePwa\":\"\",\"dx8-light-subMenuColor\":\"\",\"org.joget.theme.lib.LoginPageComponent\":{\"prefix\":\"jgt-login-\",\"className\":\"org.joget.theme.lib.LoginPageComponent\",\"properties\":{\"template\":\"<!--{sampleWidth: \'100%\', tags: \'transparent\'}-->\\r\\n<style>\\r\\n  .login-container-2 {\\r\\n      display: flex;\\r\\n      height: 100%;\\r\\n      position: relative;\\r\\n      background-size: cover;\\r\\n      background-position: center;\\r\\n      overflow: hidden; \\r\\n    }\\r\\n  .login-container-2::before {\\r\\n      content: \'\';\\r\\n      position: absolute;\\r\\n      top: 0;\\r\\n      left: 0;\\r\\n      width: 100%;\\r\\n      height: 100%;\\r\\n      background: radial-gradient(55.87% 55.87% at 35.49% -18.37%, #dd77fa 0%, rgba(255, 255, 255, 0) 100%), radial-gradient(70.81% 48.44% at -24.53% -16.02%, #0d6efd 0%, rgba(255, 255, 255, 0) 100%), radial-gradient(91.61% 92.58% at 104.86% -43.36%, #dc3545 0%, rgba(255, 255, 255, 0) 100%), radial-gradient(50.59% 55.55% at -2.99% -8.69%, #0d6efd 9.06%, rgba(255, 255, 255, 0) 100%), #f7fafc;\\r\\n      pointer-events: none; \\r\\n    }\\r\\n  .login-form-2 {\\r\\n    position: absolute !important;\\r\\n    top: 50% !important;\\r\\n    left: 50% !important;\\r\\n    transform: translate(-50%, -50%) !important;\\r\\n    width: 100% !important;\\r\\n    max-width: 400px !important;\\r\\n    background-color: transparent !important;\\r\\n    border:none;\\r\\n  }\\r\\n  .login-form-2 button {\\r\\n    background-color: {{btnColor||#000000}} !important;\\r\\n    border:none !important;\\r\\n    height:50px !important;\\r\\n    border-radius: 25px !important;\\r\\n    font-weight: 700 !important;\\r\\n    color: {{btnTextColor||#FFFFFF}} !important;\\r\\n  }\\r\\n  .login-card-2 {\\r\\n    padding: 20px;\\r\\n  }\\r\\n  .input-container-2 {\\r\\n    position: relative !important;\\r\\n  }\\r\\n  .icon-2 {\\r\\n    position: absolute !important;\\r\\n    left: 30px !important;\\r\\n    top: 50% !important;\\r\\n    transform: translateY(-50%) !important;\\r\\n    color: #404040 !important;\\r\\n    font-size:15px!important;\\r\\n  }\\r\\n  .login-card-2 form input{\\r\\n    padding-left: 50px !important;\\r\\n    height: 50px !important;\\r\\n    border-radius:5px !important;\\r\\n    font-size:15px!important;\\r\\n    float: unset !important;\\r\\n    text-align:left !important;\\r\\n    background-color: #edf2f7 !important;\\r\\n    border: none !important;\\r\\n  }\\r\\n  .login-card-2 form input::placeholder{\\r\\n    color: #333 !important;\\r\\n  }\\r\\n  .login-card-2 .input-container-2 input:focus + .icon-2{\\r\\n    left: 25px !important;\\r\\n    color: #1677FF !important;\\r\\n    transition-duration: 1s;\\r\\n  }\\r\\n  .login-card-2 input#customUsername, .login-card-2 input#customUsername::placeholder{\\r\\n    color: {{usernameFieldColor||#404040}} !important;\\r\\n  }\\r\\n  .login-card-2 input#customPassword, .login-card-2 input#customPassword::placeholder{\\r\\n    color: {{passwordFieldColor||#404040}} !important;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-2\\\">\\r\\n  <div class=\\\"card login-form-2 login-card-2\\\">\\r\\n    <form>\\r\\n      <div class=\\\"text-center\\\">\\r\\n        <img class=\\\"mb-3\\\" src=\\\"#appResource.competitorResearch_appIcon.png#\\\" style=\\\"width:75px;height:75px;border-radius:8px;\\\">\\r\\n      <\\/div>\\r\\n      <h2 class=\\\"mb-4 text-center\\\" style=\\\"color:{{titleColor||#000000}};font-weight: 400;font-size: 24px;\\\">{{title||Welcome back! <br> Please enter your details.}}<\\/h2>\\r\\n      <div class=\\\"mb-3 input-container-2\\\">\\r\\n        <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"{{customUsername||Username}}\\\">\\r\\n        <i class=\\\"fa fa-user icon-2\\\"><\\/i>\\r\\n      <\\/div>\\r\\n      <div class=\\\"mb-5 input-container-2\\\">\\r\\n        <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"{{customPassword||Password}}\\\">\\r\\n        <i class=\\\"fas fa-lock icon-2\\\"><\\/i>\\r\\n      <\\/div>\\r\\n      <button type=\\\"button\\\" class=\\\"btn btn-primary w-100\\\" id=\\\"loginButton\\\">{{btnText||Log In}}<\\/button>\\r\\n    <\\/form>\\r\\n  <\\/div>\\r\\n<\\/div>\\r\\n<!---->\",\"customUsername\":\"\",\"btnText\":\"Log In\",\"titleColor\":\"#000000\",\"btnTextColor\":\"#FFFFFF\",\"customLogin\":\"true\",\"customPassword\":\"\",\"btnColor\":\"#000000\",\"title\":\"Welcome back! <br> Please enter your details.\",\"usernameFieldColor\":\"#404040\",\"passwordFieldColor\":\"#404040\"}},\"dx8backgroundImage\":\"\",\"dx8-dark-header-navLinkIcon\":\"\",\"dx8-light-sidebar-navActiveLinkBackground\":\"\",\"global-headerHeight\":\"74px\",\"dx8-dark-sidebar-navLinkColor\":\"#333333\",\"global-contentWidth\":\"1560px\",\"global-fontSize\":\"14px\",\"dx8-light-header-navLinkBackground\":\"\",\"dx8-light-sidebar-navBadgeText\":\"\",\"dx8-dark-header-navBadgeText\":\"#FFFFFF\",\"dx8-light-header-navScrollbarThumb\":\"\",\"userMenu\":[],\"dx8-light-header-navLinkIcon\":\"\",\"dx8-light-sidebar-headerFontColor\":\"\",\"dx8-light-header-navLinkColor\":\"\",\"org.joget.theme.lib.TypographyComponent\":{\"prefix\":\"jgt-tpgh-\",\"className\":\"org.joget.theme.lib.TypographyComponent\",\"properties\":{\"colorLinkHover\":\"#69B1FF\",\"colorText\":\"rgba(0, 0, 0, 0.88)\",\"googleFontAPIKey\":\"\",\"lineHeightHeading2\":\"1.2666666666666666\",\"fontWeightStrong\":\"600\",\"lineHeightHeading1\":\"1.2105263157894737\",\"colorTextDescription\":\"rgba(0, 0, 0, 0.45)\",\"fontSizeHeading1\":\"38px\",\"lineHeightHeading5\":\"1.5\",\"lineHeightHeading4\":\"1.4\",\"lineHeightHeading3\":\"1.3333333333333333\",\"googleFont\":\"\",\"titleMarginTop\":\"0px\",\"colorLink\":\"#1677FF\",\"colorTextDisabled\":\"rgba(0, 0, 0, 0.25)\",\"fontSizeHeading3\":\"24px\",\"fontSizeHeading2\":\"30px\",\"fontSizeHeading5\":\"16px\",\"fontSizeHeading4\":\"20px\",\"fontSize\":\"14px\",\"lineHeight\":\"1.5714285714285714\",\"colorLinkActive\":\"#0958D9\",\"colorTextHeading\":\"rgba(0, 0, 0, 0.88)\",\"titleMarginBottom\":\"0.5em\"}},\"shortcut\":[],\"global-contentPaddingInlineSM\":\"20px\",\"global-itemHeight\":\"40px\",\"global-footerheight\":\"54px\",\"global-iconMarginInline\":\"5px\",\"dx8-dark-header-headerColor\":\"\",\"org.joget.theme.lib.FormComponent\":{\"prefix\":\"jgt-form-\",\"className\":\"org.joget.theme.lib.FormComponent\",\"properties\":{\"fieldWidth\":\"70%\",\"labelFloat\":\"left\",\"borderRadiusLG\":\"8px\",\"colorTextDescription\":\"rgba(0, 0, 0, 0.45)\",\"labelWidth\":\"30%\",\"lineWidth\":\"1px\",\"headerFontWeight\":\"600\",\"labelRequiredMarkColor\":\"#FF4D4F\",\"headerFontSize\":\"16px\",\"controlOutline\":\"rgba(5, 145, 255, 0.1)\",\"lineType\":\"solid\",\"controlOutlineWidth\":\"2px\",\"fontWeight\":\"400\",\"colorText\":\"rgba(0, 0, 0, 0.88)\",\"labelMarginInlineEnd\":\"15px\",\"labelFontSize\":\"14px\",\"colorBgContainer\":\"#FFFFFF\",\"headerFontHeight\":\"22\",\"colorBorder\":\"#F0F0F0\",\"labelHeight\":\"auto\",\"headerBg\":\"#FFFFFF\",\"itemMarginBottom\":\"24px\",\"labelAlign\":\"end\",\"sectionPaddingBottom\":\"20px\",\"marginBottom\":\"10px\",\"lineHeight\":\"1.5714285714285714\",\"colorTextHeading\":\"rgba(0, 0, 0, 0.88)\",\"headerHeight\":\"56px\",\"headerPaddingInline\":\"24px\",\"fieldFloat\":\"left\"}},\"global-borderRadiusLG\":\"8px\",\"dx8-light-subMenuBgColor\":\"\",\"dx8-dark-sidebar-navLinkBackground\":\"#F7F7F7\",\"dx8-dark-sidebar-navBadgeText\":\"#333333\",\"dx8-dark-sidebar-navScrollbarThumb\":\"#4D5F82\",\"dx8-dark-header-navLinkColor\":\"\",\"dx8-light-sidebar-navLinkIcon\":\"\",\"dx8-light-header-navBadgeText\":\"#000000\",\"subfooter\":\"\",\"dx8-light-header-navBackground\":\"\",\"dx8-light-header-navBadge\":\"#F1F1F2\",\"dx8-dark-subMenuBgColor\":\"#001529\",\"dx8-dark-sidebar-navActiveLinkBackground\":\"#EE1D52\",\"dx8-light-sidebar-navLinkColor\":\"\"}},\"properties\":{\"userviewId\":\"v\",\"name\":\"Competitor Research Theme\",\"description\":\"\",\"id\":\"theme_competitor_research_theme\"}}',NULL),
('competitor_research',1,'up-28e16adb-85d9-4f52-8bec-dfc4a4553606','Sectors','INTERNAL_USERVIEW_PAGE','2025-06-06 10:21:47','2025-10-12 19:21:53','{\"elements\":[{\"className\":\"menu-component\"},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<script>\\n  $(document).ready(function() {\\n        $(\\\".filters\\\").hide();\\n        $(\'.actions\').append(\\\"<button id=\'anchorSearchFilter\' href=\'javascript:void(0)\' class=\'btn btn-secondary\'  title=\'Filter\'><i class=\'fas fa-filter\'><\\/i> Filter<\\/button>\\\");\\n          $(\\\"#anchorSearchFilter\\\").click(function(e) {\\n            e.preventDefault();\\n            $(\\\".filters\\\").toggle(600);\\n          });\\n\\n          function toggleButtonVisibility() {\\n            if ($(window).width() > 767) { // Adjust the breakpoint according to your design\\n              $(\'#anchorSearchFilter\').show(); // Show button on mobile view\\n            } else {\\n              $(\'#anchorSearchFilter\').hide(); // Hide button on desktop view\\n              $(\\\".filters\\\").show();\\n            }\\n          }\\n          // Initial check on page load\\n          toggleButtonVisibility();\\n          // Check on window resize\\n          $(window).resize(function() {\\n            toggleButtonVisibility();\\n          }); $(\'#list_interview_Assessment_1 tbody tr\').each(function() {\\n            $(this).find(\'td:last\').hide();\\n          });\\n        });\\n<\\/script>\",\"id\":\"7C1E95847E9E476826E47A3423CC0B4B\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-28e16adb-85d9-4f52-8bec-dfc4a4553606\"}}','v'),
('competitor_research',1,'up-3F54853397894A5F16AD07E2863F2D7B','Welcome','INTERNAL_USERVIEW_PAGE','2025-06-06 10:21:47','2025-10-12 19:21:53','{\"elements\":[{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-3F54853397894A5F16AD07E2863F2D7B\"}}','v'),
('competitor_research',1,'up-40da1cea-eb6c-4939-8ad3-cf7c7e171ff2','Competitors','INTERNAL_USERVIEW_PAGE','2025-06-06 10:21:48','2025-10-12 19:21:53','{\"elements\":[{\"className\":\"menu-component\"},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<script>\\n  $(document).ready(function() {\\n        $(\\\".filters\\\").hide();\\n        $(\'.actions\').append(\\\"<button id=\'anchorSearchFilter\' href=\'javascript:void(0)\' class=\'btn btn-secondary\'  title=\'Filter\'><i class=\'fas fa-filter\'><\\/i> Filter<\\/button>\\\");\\n          $(\\\"#anchorSearchFilter\\\").click(function(e) {\\n            e.preventDefault();\\n            $(\\\".filters\\\").toggle(600);\\n          });\\n\\n          function toggleButtonVisibility() {\\n            console.log($(window).width());\\nif ($(window).width() > 767) { // Adjust the breakpoint according to your design\\n              $(\'#anchorSearchFilter\').show(); // Show button on mobile view\\n            } else {\\n              $(\'#anchorSearchFilter\').hide(); // Hide button on desktop view\\n              $(\\\".filters\\\").show();\\n            }\\n          }\\n          // Initial check on page load\\n          toggleButtonVisibility();\\n          // Check on window resize\\n          $(window).resize(function() {\\n            toggleButtonVisibility();\\n          }); $(\'#list_interview_Assessment_1 tbody tr\').each(function() {\\n            $(this).find(\'td:last\').hide();\\n          });\\n        });\\n<\\/script>\",\"id\":\"2600B1E723AA4729DF421C96C1DDD1C6\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-40da1cea-eb6c-4939-8ad3-cf7c7e171ff2\"}}','v'),
('competitor_research',1,'up-5B0F615BAAF141E88EFCFF7B37AF8C2E','Manage Competitor','INTERNAL_USERVIEW_PAGE','2025-06-06 10:21:48','2025-10-12 19:21:53','{\"elements\":[{\"className\":\"menu-component\"},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<script>\\n  $(document).ready(function() {\\n        $(\\\".filters\\\").hide();\\n        $(\'.actions\').append(\\\"<button id=\'anchorSearchFilter\' href=\'javascript:void(0)\' class=\'btn btn-secondary\'  title=\'Filter\'><i class=\'fas fa-filter\'><\\/i> Filter<\\/button>\\\");\\n          $(\\\"#anchorSearchFilter\\\").click(function(e) {\\n            e.preventDefault();\\n            $(\\\".filters\\\").toggle(600);\\n          });\\n\\n          function toggleButtonVisibility() {\\n            if ($(window).width() > 767) { // Adjust the breakpoint according to your design\\n              $(\'#anchorSearchFilter\').show(); // Show button on mobile view\\n            } else {\\n              $(\'#anchorSearchFilter\').hide(); // Hide button on desktop view\\n              $(\\\".filters\\\").show();\\n            }\\n          }\\n          // Initial check on page load\\n          toggleButtonVisibility();\\n          // Check on window resize\\n          $(window).resize(function() {\\n            toggleButtonVisibility();\\n          }); $(\'#list_interview_Assessment_1 tbody tr\').each(function() {\\n            $(this).find(\'td:last\').hide();\\n          });\\n        });\\n<\\/script>\",\"id\":\"2600B1E723AA4729DF421C96C1DDD1C6\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-5B0F615BAAF141E88EFCFF7B37AF8C2E\"}}','v'),
('competitor_research',1,'up-818AE1814E134BBCCF865D83829FE91B','Deals','INTERNAL_USERVIEW_PAGE','2025-08-14 18:36:46','2025-10-12 19:21:53','{\"elements\":[{\"className\":\"menu-component\"},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<script>\\n  $(document).ready(function() {\\n        $(\\\".filters\\\").hide();\\n        $(\'.actions\').append(\\\"<button id=\'anchorSearchFilter\' href=\'javascript:void(0)\' class=\'btn btn-secondary\'  title=\'Filter\'><i class=\'fas fa-filter\'><\\/i> Filter<\\/button>\\\");\\n          $(\\\"#anchorSearchFilter\\\").click(function(e) {\\n            e.preventDefault();\\n            $(\\\".filters\\\").toggle(600);\\n          });\\n\\n          function toggleButtonVisibility() {\\n            if ($(window).width() > 767) { // Adjust the breakpoint according to your design\\n              $(\'#anchorSearchFilter\').show(); // Show button on mobile view\\n            } else {\\n              $(\'#anchorSearchFilter\').hide(); // Hide button on desktop view\\n              $(\\\".filters\\\").show();\\n            }\\n          }\\n          // Initial check on page load\\n          toggleButtonVisibility();\\n          // Check on window resize\\n          $(window).resize(function() {\\n            toggleButtonVisibility();\\n          }); $(\'#list_interview_Assessment_1 tbody tr\').each(function() {\\n            $(this).find(\'td:last\').hide();\\n          });\\n        });\\n<\\/script>\",\"id\":\"1CDA7D89F03F4BDF3962626A6B7622D2\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-818AE1814E134BBCCF865D83829FE91B\"}}','v'),
('competitor_research',1,'up-C88A292002D94785EA63191A39004464','About','INTERNAL_USERVIEW_PAGE','2025-06-06 10:21:48','2025-10-12 19:21:53','{\"elements\":[{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-C88A292002D94785EA63191A39004464\"}}','v'),
('competitor_research',1,'up-d3044044-48d4-43ef-8db0-45c13723543f','Differentiators','INTERNAL_USERVIEW_PAGE','2025-06-06 10:21:48','2025-10-12 19:21:53','{\"elements\":[{\"className\":\"menu-component\"},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<script>\\n  $(document).ready(function() {\\n        $(\\\".filters\\\").hide();\\n        $(\'.actions\').append(\\\"<button id=\'anchorSearchFilter\' href=\'javascript:void(0)\' class=\'btn btn-secondary\'  title=\'Filter\'><i class=\'fas fa-filter\'><\\/i> Filter<\\/button>\\\");\\n          $(\\\"#anchorSearchFilter\\\").click(function(e) {\\n            e.preventDefault();\\n            $(\\\".filters\\\").toggle(600);\\n          });\\n\\n          function toggleButtonVisibility() {\\n            if ($(window).width() > 767) { // Adjust the breakpoint according to your design\\n              $(\'#anchorSearchFilter\').show(); // Show button on mobile view\\n            } else {\\n              $(\'#anchorSearchFilter\').hide(); // Hide button on desktop view\\n              $(\\\".filters\\\").show();\\n            }\\n          }\\n          // Initial check on page load\\n          toggleButtonVisibility();\\n          // Check on window resize\\n          $(window).resize(function() {\\n            toggleButtonVisibility();\\n          }); $(\'#list_interview_Assessment_1 tbody tr\').each(function() {\\n            $(this).find(\'td:last\').hide();\\n          });\\n        });\\n<\\/script>\",\"id\":\"FBB11A3E0FBA41C11F5C95ED27386CC1\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-d3044044-48d4-43ef-8db0-45c13723543f\"}}','v'),
('competitor_research',1,'up-e01a256a-e698-4ce8-8140-23f7685043f9','Deals','INTERNAL_USERVIEW_PAGE','2025-06-06 10:21:48','2025-10-12 19:21:53','{\"elements\":[{\"className\":\"menu-component\"},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<script>\\n  $(document).ready(function() {\\n        $(\\\".filters\\\").hide();\\n        $(\'.actions\').append(\\\"<button id=\'anchorSearchFilter\' href=\'javascript:void(0)\' class=\'btn btn-secondary\'  title=\'Filter\'><i class=\'fas fa-filter\'><\\/i> Filter<\\/button>\\\");\\n          $(\\\"#anchorSearchFilter\\\").click(function(e) {\\n            e.preventDefault();\\n            $(\\\".filters\\\").toggle(600);\\n          });\\n\\n          function toggleButtonVisibility() {\\n            if ($(window).width() > 767) { // Adjust the breakpoint according to your design\\n              $(\'#anchorSearchFilter\').show(); // Show button on mobile view\\n            } else {\\n              $(\'#anchorSearchFilter\').hide(); // Hide button on desktop view\\n              $(\\\".filters\\\").show();\\n            }\\n          }\\n          // Initial check on page load\\n          toggleButtonVisibility();\\n          // Check on window resize\\n          $(window).resize(function() {\\n            toggleButtonVisibility();\\n          }); $(\'#list_interview_Assessment_1 tbody tr\').each(function() {\\n            $(this).find(\'td:last\').hide();\\n          });\\n        });\\n<\\/script>\",\"id\":\"1CDA7D89F03F4BDF3962626A6B7622D2\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-e01a256a-e698-4ce8-8140-23f7685043f9\"}}','v'),
('crm',1,'APP_OVERVIEW_DEFINITION','-1702905276','APP_OVERVIEW_DEFINITION','2025-05-21 14:50:31','2025-09-24 17:28:30','{\"form:crm_proposal_sending_form\":{\"data\":[],\"lastModifiedDate\":\"Apr 28, 2025, 12:09:06\\u202fPM\"},\"datalist:ContactDashboard\":{\"data\":[{\"path\":\"columns[1].format.properties.script\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.BeanShellOverviewTool\",\"content\":\"//import the necessary classes\\nimport org.joget.apps.datalist.service.DataListService;\\nimport org.joget.apps.app.service.AppUtil;\\n  \\nDataListService dataListService = (DataListService) AppUtil.getApplicationContext().getBean(\\\"dataListService\\\");\\n   \\n//since this entire bean shell applies to every row, \\\"row\\\" is automatically iterated here.\\n//\\\"name\\\" is the column id\\nreturn dataListService.evaluateColumnValueFromRow(row, \\\"firstName\\\") +  \\\" \\\" + dataListService.evaluateColumnValueFromRow(row, \\\"lastName\\\")\"}],\"lastModifiedDate\":\"May 10, 2025, 1:11:46\\u202fPM\"},\"process:process1\":{\"data\":[{\"path\":\"activityPlugins.process1::tool4.properties.tools[0].properties.subject\",\"isError\":false,\"label\":\"#form.j_crm_proposal.title#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"Your proposal titled \\\"#form.j_crm_proposal.title#\\\" needs to be resubmitted\"},{\"path\":\"activityPlugins.process1::tool4.properties.tools[0].properties.message\",\"isError\":false,\"label\":\"#form.j_crm_proposal.title#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"Dear Proposer\\n\\nYour proposal titled \\\"#form.j_crm_proposal.title#\\\" needs to be resubmitted as requested by #form.j_crm_proposal.approver#.\\n\\n\\nEmail notification generated by Joget Workflow.\"},{\"path\":\"activityPlugins.process1::tool4.properties.tools[0].properties.message\",\"isError\":false,\"label\":\"#form.j_crm_proposal.approver#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"Dear Proposer\\n\\nYour proposal titled \\\"#form.j_crm_proposal.title#\\\" needs to be resubmitted as requested by #form.j_crm_proposal.approver#.\\n\\n\\nEmail notification generated by Joget Workflow.\"},{\"path\":\"activityPlugins.process1::tool2.properties.tools[0].properties.subject\",\"isError\":false,\"label\":\"#form.j_crm_proposal.title#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"Your proposal titled \\\"#form.j_crm_proposal.title#\\\" has been rejected by #form.j_crm_proposal.approver#\"},{\"path\":\"activityPlugins.process1::tool2.properties.tools[0].properties.subject\",\"isError\":false,\"label\":\"#form.j_crm_proposal.approver#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"Your proposal titled \\\"#form.j_crm_proposal.title#\\\" has been rejected by #form.j_crm_proposal.approver#\"},{\"path\":\"activityPlugins.process1::tool2.properties.tools[0].properties.message\",\"isError\":false,\"label\":\"#form.j_crm_proposal.title#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"Dear Proposer\\n\\nYour proposal titled \\\"#form.j_crm_proposal.title#\\\" has been rejected by #form.j_crm_proposal.approver#.\\n\\n\\nEmail notification generated by Joget Workflow.\"},{\"path\":\"activityPlugins.process1::tool2.properties.tools[0].properties.message\",\"isError\":false,\"label\":\"#form.j_crm_proposal.approver#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"Dear Proposer\\n\\nYour proposal titled \\\"#form.j_crm_proposal.title#\\\" has been rejected by #form.j_crm_proposal.approver#.\\n\\n\\nEmail notification generated by Joget Workflow.\"},{\"path\":\"activityPlugins.process1::tool3.properties.tools[0].properties.subject\",\"isError\":false,\"label\":\"#form.j_crm_proposal.title#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"The  proposal titled \\\"#form.j_crm_proposal.title#\\\" is pending your approval\"},{\"path\":\"activityPlugins.process1::tool3.properties.tools[0].properties.message\",\"isError\":false,\"label\":\"#form.j_crm_proposal.approver#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"Dear #form.j_crm_proposal.approver#\\n\\nThe proposal titled \\\"#form.j_crm_proposal.title#\\\" is pending your approval.\\n\\nEmail notification generated by Joget Workflow.\"},{\"path\":\"activityPlugins.process1::tool3.properties.tools[0].properties.message\",\"isError\":false,\"label\":\"#form.j_crm_proposal.title#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"Dear #form.j_crm_proposal.approver#\\n\\nThe proposal titled \\\"#form.j_crm_proposal.title#\\\" is pending your approval.\\n\\nEmail notification generated by Joget Workflow.\"},{\"path\":\"activityPlugins.process1::tool1.properties.tools[0].properties.subject\",\"isError\":false,\"label\":\"#form.j_crm_proposal.title#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"Your proposal titled \\\"#form.j_crm_proposal.title#\\\" has been approved by #form.j_crm_proposal.approver#\"},{\"path\":\"activityPlugins.process1::tool1.properties.tools[0].properties.subject\",\"isError\":false,\"label\":\"#form.j_crm_proposal.approver#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"Your proposal titled \\\"#form.j_crm_proposal.title#\\\" has been approved by #form.j_crm_proposal.approver#\"},{\"path\":\"activityPlugins.process1::tool1.properties.tools[0].properties.message\",\"isError\":false,\"label\":\"#form.j_crm_proposal.title#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"Dear Proposer\\n\\nYour proposal titled \\\"#form.j_crm_proposal.title#\\\" has been approved by #form.j_crm_proposal.approver#.\\n\\n\\nEmail notification generated by Joget Workflow.\"},{\"path\":\"activityPlugins.process1::tool1.properties.tools[0].properties.message\",\"isError\":false,\"label\":\"#form.j_crm_proposal.approver#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"Dear Proposer\\n\\nYour proposal titled \\\"#form.j_crm_proposal.title#\\\" has been approved by #form.j_crm_proposal.approver#.\\n\\n\\nEmail notification generated by Joget Workflow.\"}],\"lastModifiedDate\":\"Feb 17, 2025, 7:32:52\\u202fPM\"},\"datalist:ProposalsDashboard\":{\"data\":[],\"lastModifiedDate\":\"May 7, 2025, 9:15:37\\u202fPM\"},\"datalist:AccountsDashboard\":{\"data\":[],\"lastModifiedDate\":\"Apr 28, 2025, 12:09:07\\u202fPM\"},\"datalist:UsersDashboard\":{\"data\":[],\"lastModifiedDate\":\"Apr 28, 2025, 12:09:08\\u202fPM\"},\"form:crm_contact\":{\"data\":[{\"path\":\"elements[0].elements[0].elements[0].properties.optionsBinder.properties.emptyLabel\",\"isError\":false,\"label\":\"#i18n.Select#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#i18n.Select#\"}],\"lastModifiedDate\":\"Apr 28, 2025, 12:09:03\\u202fPM\"},\"form:AccountContactSub\":{\"data\":[],\"lastModifiedDate\":\"Apr 28, 2025, 12:09:02\\u202fPM\"},\"datalist:Users\":{\"data\":[],\"lastModifiedDate\":\"Apr 28, 2025, 12:09:08\\u202fPM\"},\"datalist:crm_contact_list\":{\"data\":[{\"path\":\"columns[1].format.properties.script\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.BeanShellOverviewTool\",\"content\":\"//import the necessary classes\\nimport org.joget.apps.datalist.service.DataListService;\\nimport org.joget.apps.app.service.AppUtil;\\n  \\nDataListService dataListService = (DataListService) AppUtil.getApplicationContext().getBean(\\\"dataListService\\\");\\n   \\n//since this entire bean shell applies to every row, \\\"row\\\" is automatically iterated here.\\n//\\\"name\\\" is the column id\\nreturn dataListService.evaluateColumnValueFromRow(row, \\\"firstName\\\") +  \\\" \\\" +dataListService.evaluateColumnValueFromRow(row, \\\"lastName\\\")\"}],\"lastModifiedDate\":\"May 10, 2025, 1:35:34\\u202fPM\"},\"datalist:OpportunityDashboard\":{\"data\":[{\"path\":\"columns[2].format.properties.script\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.BeanShellOverviewTool\",\"content\":\"//import the necessary classes\\nimport org.joget.apps.datalist.service.DataListService;\\nimport org.joget.apps.app.service.AppUtil;\\nimport java.text.NumberFormat;\\nimport java.util.Locale;\\n  \\nDataListService dataListService = (DataListService) AppUtil.getApplicationContext().getBean(\\\"dataListService\\\");\\n   \\nObject amountObj = dataListService.evaluateColumnValueFromRow(row, \\\"amount\\\");\\ndouble amount = 0.0;\\n\\nif (amountObj != null) {\\n    try {\\n        amount = Double.parseDouble(amountObj.toString());\\n    } catch (NumberFormatException e) {\\n        // Handle invalid number format\\n    }\\n}\\n\\nNumberFormat currencyFormatter = NumberFormat.getCurrencyInstance(Locale.US);\\nreturn currencyFormatter.format(amount);\"}],\"lastModifiedDate\":\"May 10, 2025, 1:07:00\\u202fPM\"},\"form:crm_proposal_approval_form\":{\"data\":[{\"path\":\"elements[1].elements[0].elements[2].properties.value\",\"isError\":false,\"label\":\"#currentUser.firstName#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#currentUser.firstName# #currentUser.lastName#\"},{\"path\":\"elements[1].elements[0].elements[2].properties.value\",\"isError\":false,\"label\":\"#currentUser.lastName#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#currentUser.firstName# #currentUser.lastName#\"},{\"path\":\"elements[1].elements[0].elements[3].properties.value\",\"isError\":false,\"label\":\"#date.yyyy-MM-dd#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#date.yyyy-MM-dd#\"}],\"lastModifiedDate\":\"Apr 28, 2025, 12:09:04\\u202fPM\"},\"form:Users\":{\"data\":[{\"path\":\"elements[0].elements[0].elements[9].properties.optionsBinder.properties.emptyLabel\",\"isError\":false,\"label\":\"#i18n.Select#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#i18n.Select#\"},{\"path\":\"elements[0].elements[0].elements[12].properties.optionsBinder.properties.emptyLabel\",\"isError\":false,\"label\":\"#i18n.Select#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#i18n.Select#\"},{\"path\":\"elements[0].elements[0].elements[13].properties.optionsBinder.properties.emptyLabel\",\"isError\":false,\"label\":\"#i18n.Select#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#i18n.Select#\"},{\"path\":\"elements[0].elements[0].elements[15].properties.optionsBinder.properties.emptyLabel\",\"isError\":false,\"label\":\"#i18n.Select#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#i18n.Select#\"},{\"path\":\"elements[0].elements[0].elements[18].properties.optionsBinder.properties.emptyLabel\",\"isError\":false,\"label\":\"#i18n.Select#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#i18n.Select#\"},{\"path\":\"elements[0].elements[0].elements[19].properties.value\",\"isError\":false,\"label\":\"#requestParam.id#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!---\\r\\n\\r\\n<script>\\r\\n    if (\'#requestParam.id#\' === \'admin\' || \'requestParam.id\' === \'Admin\') {\\r\\n        document.location.href = \'/jw/web/userview/v6_um/v6_um/_/suser\';\\r\\n    }\\r\\n<\\/script>\\r\\n\\r\\n--->\"},{\"path\":\"elements[0].elements[0].elements[19].properties.value\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<!---\\r\\n\\r\\n<script>\\r\\n    if (\'#requestParam.id#\' === \'admin\' || \'requestParam.id\' === \'Admin\') {\\r\\n        document.location.href = \'/jw/web/userview/v6_um/v6_um/_/suser\';\\r\\n    }\\r\\n<\\/script>\\r\\n\\r\\n--->\"}],\"lastModifiedDate\":\"Apr 28, 2025, 12:09:06\\u202fPM\"},\"form:crm_account\":{\"data\":[],\"lastModifiedDate\":\"Apr 28, 2025, 12:09:03\\u202fPM\"},\"datalist:Proposal\":{\"data\":[],\"lastModifiedDate\":\"Apr 28, 2025, 2:32:08\\u202fPM\"},\"form:crm_proposal_resubmit_form\":{\"data\":[],\"lastModifiedDate\":\"Apr 28, 2025, 12:09:05\\u202fPM\"},\"theme:theme_crm\":{\"data\":[{\"path\":\"theme.properties.template\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.building-4884852_1280.jpg#\"},{\"path\":\"theme.properties.template\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.crm.png#\"},{\"path\":\"theme.properties.logo\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.crm.png#\"},{\"path\":\"theme.properties.fav_icon\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.crm.png#\"},{\"path\":\"theme.properties.image\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.building-4884852_1280.jpg#\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.ChatGPT_Image_May_11__2025__12_58_34_PM.png#\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.crm.png#\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.ChatGPT_Image_May_11__2025__12_58_34_PM.png#\"},{\"path\":\"theme.properties.template\",\"isError\":false,\"label\":\"#appResource.building-4884852_1280.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'basic\'}-->\\r\\n<style>\\r\\n  .login-container-1 {\\r\\n    display: flex;\\r\\n    height: 100%;\\r\\n    background-color: {{bgColor||#FFF}} !important;\\r\\n    padding: 0px;\\r\\n  }\\r\\n  .login-form-1 {\\r\\n    flex: 1;\\r\\n    display: flex;\\r\\n    align-items: center;\\r\\n    justify-content: center;\\r\\n    padding-right: 25px;\\r\\n    padding-left: 25px;\\r\\n  }\\r\\n  .login-form-1 form {\\r\\n    width: 100%;\\r\\n    max-width: 400px;\\r\\n    float: unset !important;\\r\\n    text-align:left !important;\\r\\n  }\\r\\n  .login-image-1 {\\r\\n    flex: 1;\\r\\n    background-image: url(\'{{image||#appResource.building-4884852_1280.jpg#}}\');\\r\\n    background-size: 100% 100%;\\r\\n    background-repeat: no-repeat;\\r\\n    background-position: right top;\\r\\n  }\\r\\n  .login-form-1 .form-group {\\r\\n    border: 1px solid #efefef !important;\\r\\n    padding: 15px 15px !important;\\r\\n  }\\r\\n  .login-form-1 .form-group .form-label{\\r\\n    font-size: 12px !important;\\r\\n  }\\r\\n  .login-form-1 .form-group input{\\r\\n    border: none !important;\\r\\n    font-size:20px !important;\\r\\n    background-color:transparent !important;\\r\\n    padding: 0px 10px !important;\\r\\n    float: unset !important;\\r\\n    text-align:left !important;\\r\\n  }\\r\\n  .login-form-1 input#customUsername, .login-form-1 input#customUsername::placeholder{\\r\\n    color: {{usernameFieldColor||#000}} !important;\\r\\n  }\\r\\n  .login-form-1 input#customPassword, .login-form-1 input#customPassword::placeholder{\\r\\n    color: {{passwordFieldColor||#000}} !important;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-1\\\">\\r\\n<div class=\\\"login-form-1\\\">\\r\\n  <form>\\r\\n    <img class=\\\"mb-3\\\" src=\\\"#appResource.crm.png#\\\" style=\\\"width: 75px;height: 75px;\\\">\\r\\n    <h2 class=\\\"mb-3\\\" style=\\\"color:{{titleColor||#141414}}\\\">{{title||Sign In to CRM App}}<\\/h2>\\r\\n    <p class=\\\"mb-4\\\" style=\\\"color:{{subtitleColor||#b3b3b3}}\\\">{{subtitle||Please enter your details}}<\\/p>\\r\\n    <div class=\\\"form-group my-0\\\">\\r\\n      <label for=\\\"username\\\" class=\\\"form-label\\\" style=\\\"color:{{customUsernameColor||black}};\\\">{{customUsername||a}}<\\/label>\\r\\n      <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"{{usernamePlaceholder||Username}}\\\">\\r\\n    <\\/div>\\r\\n    <div class=\\\"form-group mb-5\\\">\\r\\n      <label for=\\\"password\\\" class=\\\"form-label\\\" style=\\\"color:{{customPasswordColor||black}};\\\">{{customPassword||Password}}<\\/label>\\r\\n      <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"{{passwordPlaceholder||Password}}\\\">\\r\\n    <\\/div>\\r\\n    <button type=\\\"button\\\" class=\\\"btn btn-primary w-100\\\" id=\\\"loginButton\\\" style=\\\"height:54px;background-color:{{btnColor||#0133C4}};border:none;color:{{btnTextColor||#fff}}\\\">{{btnText||Sign In}}<\\/button>\\r\\n  <\\/form>\\r\\n<\\/div>\\r\\n<div class=\\\"login-image-1 d-none d-md-block\\\"><\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"theme.properties.template\",\"isError\":false,\"label\":\"#appResource.crm.png#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'basic\'}-->\\r\\n<style>\\r\\n  .login-container-1 {\\r\\n    display: flex;\\r\\n    height: 100%;\\r\\n    background-color: {{bgColor||#FFF}} !important;\\r\\n    padding: 0px;\\r\\n  }\\r\\n  .login-form-1 {\\r\\n    flex: 1;\\r\\n    display: flex;\\r\\n    align-items: center;\\r\\n    justify-content: center;\\r\\n    padding-right: 25px;\\r\\n    padding-left: 25px;\\r\\n  }\\r\\n  .login-form-1 form {\\r\\n    width: 100%;\\r\\n    max-width: 400px;\\r\\n    float: unset !important;\\r\\n    text-align:left !important;\\r\\n  }\\r\\n  .login-image-1 {\\r\\n    flex: 1;\\r\\n    background-image: url(\'{{image||#appResource.building-4884852_1280.jpg#}}\');\\r\\n    background-size: 100% 100%;\\r\\n    background-repeat: no-repeat;\\r\\n    background-position: right top;\\r\\n  }\\r\\n  .login-form-1 .form-group {\\r\\n    border: 1px solid #efefef !important;\\r\\n    padding: 15px 15px !important;\\r\\n  }\\r\\n  .login-form-1 .form-group .form-label{\\r\\n    font-size: 12px !important;\\r\\n  }\\r\\n  .login-form-1 .form-group input{\\r\\n    border: none !important;\\r\\n    font-size:20px !important;\\r\\n    background-color:transparent !important;\\r\\n    padding: 0px 10px !important;\\r\\n    float: unset !important;\\r\\n    text-align:left !important;\\r\\n  }\\r\\n  .login-form-1 input#customUsername, .login-form-1 input#customUsername::placeholder{\\r\\n    color: {{usernameFieldColor||#000}} !important;\\r\\n  }\\r\\n  .login-form-1 input#customPassword, .login-form-1 input#customPassword::placeholder{\\r\\n    color: {{passwordFieldColor||#000}} !important;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-1\\\">\\r\\n<div class=\\\"login-form-1\\\">\\r\\n  <form>\\r\\n    <img class=\\\"mb-3\\\" src=\\\"#appResource.crm.png#\\\" style=\\\"width: 75px;height: 75px;\\\">\\r\\n    <h2 class=\\\"mb-3\\\" style=\\\"color:{{titleColor||#141414}}\\\">{{title||Sign In to CRM App}}<\\/h2>\\r\\n    <p class=\\\"mb-4\\\" style=\\\"color:{{subtitleColor||#b3b3b3}}\\\">{{subtitle||Please enter your details}}<\\/p>\\r\\n    <div class=\\\"form-group my-0\\\">\\r\\n      <label for=\\\"username\\\" class=\\\"form-label\\\" style=\\\"color:{{customUsernameColor||black}};\\\">{{customUsername||a}}<\\/label>\\r\\n      <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"{{usernamePlaceholder||Username}}\\\">\\r\\n    <\\/div>\\r\\n    <div class=\\\"form-group mb-5\\\">\\r\\n      <label for=\\\"password\\\" class=\\\"form-label\\\" style=\\\"color:{{customPasswordColor||black}};\\\">{{customPassword||Password}}<\\/label>\\r\\n      <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"{{passwordPlaceholder||Password}}\\\">\\r\\n    <\\/div>\\r\\n    <button type=\\\"button\\\" class=\\\"btn btn-primary w-100\\\" id=\\\"loginButton\\\" style=\\\"height:54px;background-color:{{btnColor||#0133C4}};border:none;color:{{btnTextColor||#fff}}\\\">{{btnText||Sign In}}<\\/button>\\r\\n  <\\/form>\\r\\n<\\/div>\\r\\n<div class=\\\"login-image-1 d-none d-md-block\\\"><\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"theme.properties.logo\",\"isError\":false,\"label\":\"#appResource.crm.png#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#appResource.crm.png#\"},{\"path\":\"theme.properties.fav_icon\",\"isError\":false,\"label\":\"#appResource.crm.png#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#appResource.crm.png#\"},{\"path\":\"theme.properties.image\",\"isError\":false,\"label\":\"#appResource.building-4884852_1280.jpg#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#appResource.building-4884852_1280.jpg#\"},{\"path\":\"theme\",\"isError\":false,\"label\":\"org.joget.plugin.enterprise.BuilderTheme.theme_crm (Missing)\",\"tool\":\"org.joget.apps.app.lib.InstalledPluginOverviewTool\",\"content\":\"org.joget.plugin.enterprise.BuilderTheme.theme_crm\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.template\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.ChatGPT_Image_May_11__2025__12_58_34_PM.png#\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.template\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.crm.png#\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.image\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.ChatGPT_Image_May_11__2025__12_58_34_PM.png#\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.template\",\"isError\":false,\"label\":\"#appResource.ChatGPT_Image_May_11__2025__12_58_34_PM.png#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'basic\'}-->\\r\\n<style>\\r\\n  .login-container-1 {\\r\\n    display: flex;\\r\\n    height: 100%;\\r\\n    background-color: {{bgColor||#FFF}} !important;\\r\\n    padding: 0px;\\r\\n  }\\r\\n  .login-form-1 {\\r\\n    flex: 2;\\r\\n    display: flex;\\r\\n    align-items: center;\\r\\n    justify-content: center;\\r\\n    padding-right: 25px;\\r\\n    padding-left: 25px;\\r\\n  }\\r\\n  .login-form-1 form {\\r\\n    width: 100%;\\r\\n    max-width: 400px;\\r\\n    float: unset !important;\\r\\n    text-align:left !important;\\r\\n  }\\r\\n  .login-image-1 {\\r\\n    flex: 1;\\r\\n    background-image: url(\'{{image||#appResource.ChatGPT_Image_May_11__2025__12_58_34_PM.png#}}\');\\r\\n    background-size: 100% 100%;\\r\\n    background-repeat: no-repeat;\\r\\n    background-position: right top;\\r\\n  }\\r\\n  .login-form-1 .form-group {\\r\\n    border: 1px solid #efefef !important;\\r\\n    padding: 15px 15px !important;\\r\\n  }\\r\\n  .login-form-1 .form-group .form-label{\\r\\n    font-size: 12px !important;\\r\\n  }\\r\\n  .login-form-1 .form-group input{\\r\\n    border: none !important;\\r\\n    font-size:20px !important;\\r\\n    background-color:transparent !important;\\r\\n    padding: 0px 10px !important;\\r\\n    float: unset !important;\\r\\n    text-align:left !important;\\r\\n  }\\r\\n  .login-form-1 input#customUsername, .login-form-1 input#customUsername::placeholder{\\r\\n    color: {{usernameFieldColor||#000}} !important;\\r\\n  }\\r\\n  .login-form-1 input#customPassword, .login-form-1 input#customPassword::placeholder{\\r\\n    color: {{passwordFieldColor||#000}} !important;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-1\\\">\\r\\n<div class=\\\"login-image-1 d-none d-md-block\\\"><\\/div>\\r\\n<div class=\\\"login-form-1\\\">\\r\\n  <form>\\r\\n    <img class=\\\"mb-3\\\" src=\\\"#appResource.crm.png#\\\" style=\\\"width:75px;height:75px\\\">\\r\\n    <h2 class=\\\"mb-2\\\" style=\\\"color:{{titleColor||#141414}}\\\">{{title||Sign In to CRM App}}<\\/h2>\\r\\n    <p class=\\\"mb-4\\\" style=\\\"color:{{subtitleColor||#b3b3b3}}\\\">{{subtitle||Please enter your details}}<\\/p>\\r\\n    <div class=\\\"form-group my-0\\\">\\r\\n      <label for=\\\"username\\\" class=\\\"form-label\\\" style=\\\"color:{{customUsernameColor||black}};\\\">{{customUsername||a}}<\\/label>\\r\\n      <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"{{usernamePlaceholder||Username}}\\\">\\r\\n    <\\/div>\\r\\n    <div class=\\\"form-group mb-5\\\">\\r\\n      <label for=\\\"password\\\" class=\\\"form-label\\\" style=\\\"color:{{customPasswordColor||black}};\\\">{{customPassword||Password}}<\\/label>\\r\\n      <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"{{passwordPlaceholder||Password}}\\\">\\r\\n    <\\/div>\\r\\n    <button type=\\\"button\\\" class=\\\"btn btn-primary w-100\\\" id=\\\"loginButton\\\" style=\\\"height:54px;background-color:{{btnColor||#0133C4}};border:none;color:{{btnTextColor||#fff}}\\\">{{btnText||Sign In}}<\\/button>\\r\\n  <\\/form>\\r\\n<\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.template\",\"isError\":false,\"label\":\"#appResource.crm.png#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<!--{sampleWidth: \'100%\', tags: \'basic\'}-->\\r\\n<style>\\r\\n  .login-container-1 {\\r\\n    display: flex;\\r\\n    height: 100%;\\r\\n    background-color: {{bgColor||#FFF}} !important;\\r\\n    padding: 0px;\\r\\n  }\\r\\n  .login-form-1 {\\r\\n    flex: 2;\\r\\n    display: flex;\\r\\n    align-items: center;\\r\\n    justify-content: center;\\r\\n    padding-right: 25px;\\r\\n    padding-left: 25px;\\r\\n  }\\r\\n  .login-form-1 form {\\r\\n    width: 100%;\\r\\n    max-width: 400px;\\r\\n    float: unset !important;\\r\\n    text-align:left !important;\\r\\n  }\\r\\n  .login-image-1 {\\r\\n    flex: 1;\\r\\n    background-image: url(\'{{image||#appResource.ChatGPT_Image_May_11__2025__12_58_34_PM.png#}}\');\\r\\n    background-size: 100% 100%;\\r\\n    background-repeat: no-repeat;\\r\\n    background-position: right top;\\r\\n  }\\r\\n  .login-form-1 .form-group {\\r\\n    border: 1px solid #efefef !important;\\r\\n    padding: 15px 15px !important;\\r\\n  }\\r\\n  .login-form-1 .form-group .form-label{\\r\\n    font-size: 12px !important;\\r\\n  }\\r\\n  .login-form-1 .form-group input{\\r\\n    border: none !important;\\r\\n    font-size:20px !important;\\r\\n    background-color:transparent !important;\\r\\n    padding: 0px 10px !important;\\r\\n    float: unset !important;\\r\\n    text-align:left !important;\\r\\n  }\\r\\n  .login-form-1 input#customUsername, .login-form-1 input#customUsername::placeholder{\\r\\n    color: {{usernameFieldColor||#000}} !important;\\r\\n  }\\r\\n  .login-form-1 input#customPassword, .login-form-1 input#customPassword::placeholder{\\r\\n    color: {{passwordFieldColor||#000}} !important;\\r\\n  }\\r\\n<\\/style>\\r\\n<div class=\\\"container-fluid login-container-1\\\">\\r\\n<div class=\\\"login-image-1 d-none d-md-block\\\"><\\/div>\\r\\n<div class=\\\"login-form-1\\\">\\r\\n  <form>\\r\\n    <img class=\\\"mb-3\\\" src=\\\"#appResource.crm.png#\\\" style=\\\"width:75px;height:75px\\\">\\r\\n    <h2 class=\\\"mb-2\\\" style=\\\"color:{{titleColor||#141414}}\\\">{{title||Sign In to CRM App}}<\\/h2>\\r\\n    <p class=\\\"mb-4\\\" style=\\\"color:{{subtitleColor||#b3b3b3}}\\\">{{subtitle||Please enter your details}}<\\/p>\\r\\n    <div class=\\\"form-group my-0\\\">\\r\\n      <label for=\\\"username\\\" class=\\\"form-label\\\" style=\\\"color:{{customUsernameColor||black}};\\\">{{customUsername||a}}<\\/label>\\r\\n      <input type=\\\"text\\\" class=\\\"form-control w-100\\\" id=\\\"customUsername\\\" placeholder=\\\"{{usernamePlaceholder||Username}}\\\">\\r\\n    <\\/div>\\r\\n    <div class=\\\"form-group mb-5\\\">\\r\\n      <label for=\\\"password\\\" class=\\\"form-label\\\" style=\\\"color:{{customPasswordColor||black}};\\\">{{customPassword||Password}}<\\/label>\\r\\n      <input type=\\\"password\\\" class=\\\"form-control w-100\\\" id=\\\"customPassword\\\" placeholder=\\\"{{passwordPlaceholder||Password}}\\\">\\r\\n    <\\/div>\\r\\n    <button type=\\\"button\\\" class=\\\"btn btn-primary w-100\\\" id=\\\"loginButton\\\" style=\\\"height:54px;background-color:{{btnColor||#0133C4}};border:none;color:{{btnTextColor||#fff}}\\\">{{btnText||Sign In}}<\\/button>\\r\\n  <\\/form>\\r\\n<\\/div>\\r\\n<\\/div>\\r\\n<!---->\"},{\"path\":\"theme.properties.org.joget.theme.lib.LoginPageComponent.properties.image\",\"isError\":false,\"label\":\"#appResource.ChatGPT_Image_May_11__2025__12_58_34_PM.png#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#appResource.ChatGPT_Image_May_11__2025__12_58_34_PM.png#\"}],\"lastModifiedDate\":\"May 11, 2025, 12:59:08\\u202fPM\"},\"datalist:ProposalDashboardInbox\":{\"data\":[],\"lastModifiedDate\":\"May 7, 2025, 9:16:00\\u202fPM\"},\"form:AccountContacts\":{\"data\":[],\"lastModifiedDate\":\"Apr 28, 2025, 12:09:01\\u202fPM\"},\"form:AccountsMain\":{\"data\":[{\"path\":\"elements[0].elements[0].elements[0].properties.numberOfPage.properties.page2_label\",\"isError\":false,\"label\":\"#i18n.Contacts#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#i18n.Contacts#\"},{\"path\":\"elements[0].elements[0].elements[0].properties.numberOfPage.properties.page1_label\",\"isError\":false,\"label\":\"#i18n.Account Details#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#i18n.Account Details#\"}],\"lastModifiedDate\":\"Apr 28, 2025, 12:09:02\\u202fPM\"},\"datalist:crm_account_list\":{\"data\":[],\"lastModifiedDate\":\"May 10, 2025, 1:23:44\\u202fPM\"},\"datalist:crm_opportunity_list\":{\"data\":[{\"path\":\"columns[3].format.properties.script\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.BeanShellOverviewTool\",\"content\":\"//import the necessary classes\\nimport org.joget.apps.datalist.service.DataListService;\\nimport org.joget.apps.app.service.AppUtil;\\nimport java.text.NumberFormat;\\nimport java.util.Locale;\\n  \\nDataListService dataListService = (DataListService) AppUtil.getApplicationContext().getBean(\\\"dataListService\\\");\\n   \\nObject amountObj = dataListService.evaluateColumnValueFromRow(row, \\\"amount\\\");\\ndouble amount = 0.0;\\n\\nif (amountObj != null) {\\n    try {\\n        amount = Double.parseDouble(amountObj.toString());\\n    } catch (NumberFormatException e) {\\n        // Handle invalid number format\\n    }\\n}\\n\\nNumberFormat currencyFormatter = NumberFormat.getCurrencyInstance(Locale.US);\\nreturn currencyFormatter.format(amount);\"}],\"lastModifiedDate\":\"May 11, 2025, 1:29:56\\u202fPM\"},\"datalist:oppportunity_Chart\":{\"data\":[],\"lastModifiedDate\":\"May 4, 2025, 4:13:40\\u202fPM\"},\"form:crm_opportunity\":{\"data\":[{\"path\":\"elements[1].elements[0].elements[1].properties.value\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.WebCodingOverviewTool\",\"content\":\"<script>\\n    $(function(){\\n        FormUtil.getField(\\\"newAccount\\\").filter(\'[value=No]\').prop(\'checked\', true).trigger(\\\"change\\\");\\n    });\\n<\\/script>\"}],\"lastModifiedDate\":\"Apr 28, 2025, 12:09:03\\u202fPM\"},\"userview:crm_userview_sales\":{\"data\":[{\"path\":\"properties.welcomeMessage\",\"isError\":false,\"label\":\"#date.EEE, d MMM yyyy#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#date.EEE, d MMM yyyy#\"},{\"path\":\"properties.name\",\"isError\":false,\"label\":\"#i18n.applicationName#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"#i18n.applicationName#\"},{\"path\":\"categories[0].menus[0].properties.content\",\"isError\":false,\"label\":\"\",\"tool\":\"org.joget.apps.app.lib.AppResourcesOverviewTool\",\"content\":\"#appResource.crmWelcomePage.png#\"},{\"path\":\"categories[0].menus[0].properties.content\",\"isError\":false,\"label\":\"#appResource.crmWelcomePage.png#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<h1><\\/h1>\\n<table width=\\\"90%\\\" border=\\\"0\\\" collapse=\\\"\\\" align=\\\"center\\\">\\n<tbody>\\n<tr>\\n<td>\\n<h1><span style=\\\"font-size: 24pt; color: rgb(51, 51, 51);\\\">Welcome to the CRM App<\\/span><\\/h1>\\n<p><span style=\\\"font-size: 14pt; color: #000000;\\\"> Track and Manage Your Customers and Business Opportunities<\\/span><\\/p>\\n<\\/td>\\n<\\/tr>\\n<tr>\\n<td>\\n<p><img width=\\\"50%\\\" src=\\\"#appResource.crmWelcomePage.png#\\\"><a href=\\\"http://www.freepik.com/\\\"><\\/a><\\/p>\\n<\\/td>\\n<\\/tr>\\n<tr>\\n<td><br>\\n<p><span style=\\\"color: #333333;\\\">Use the free CRM app in your business to:<\\/span><\\/p>\\n<ul>\\n<li><span style=\\\"color: #333333;\\\">Track your prospects and customers,<\\/span><\\/li>\\n<li><span style=\\\"color: #333333;\\\">Track sales opportunities, and<\\/span><\\/li>\\n<li><span style=\\\"color: #333333;\\\">Submit sales proposals for approval.<\\/span><\\/li>\\n<\\/ul>\\n<p><span style=\\\"color: #333333;\\\">This CRM app has been built to make use of the new features and capababilities of Joget DX Enterprise or Professional Edition.<\\/span><\\/p>\\n<p><span style=\\\"color: #333333;\\\">Tips to Joget administrator:<\\/span><span style=\\\"color: #333333;\\\"><\\/span><\\/p>\\n<ul>\\n<li><span style=\\\"color: #333333;\\\">Input your Joget SMTP server configurations in <a href=\\\"#request.contextPath?html#/web/console/setting/general\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\" style=\\\"color: #333333;\\\">Web Console &gt; General Settings <\\/a> to send email messages.<\\/span><\\/li>\\n<li><span style=\\\"color: #333333;\\\">Input an email address for admin &amp; other users in <a href=\\\"#request.contextPath?html#/web/console/directory/users\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\" style=\\\"color: #333333;\\\">Web Console &gt; Setup Users <\\/a> for email notification to work.<\\/span><\\/li>\\n<\\/ul>\\n<\\/td>\\n<\\/tr>\\n<\\/tbody>\\n<\\/table>\"},{\"path\":\"categories[0].menus[0].properties.content\",\"isError\":false,\"label\":\"#request.contextPath?html#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<h1><\\/h1>\\n<table width=\\\"90%\\\" border=\\\"0\\\" collapse=\\\"\\\" align=\\\"center\\\">\\n<tbody>\\n<tr>\\n<td>\\n<h1><span style=\\\"font-size: 24pt; color: rgb(51, 51, 51);\\\">Welcome to the CRM App<\\/span><\\/h1>\\n<p><span style=\\\"font-size: 14pt; color: #000000;\\\"> Track and Manage Your Customers and Business Opportunities<\\/span><\\/p>\\n<\\/td>\\n<\\/tr>\\n<tr>\\n<td>\\n<p><img width=\\\"50%\\\" src=\\\"#appResource.crmWelcomePage.png#\\\"><a href=\\\"http://www.freepik.com/\\\"><\\/a><\\/p>\\n<\\/td>\\n<\\/tr>\\n<tr>\\n<td><br>\\n<p><span style=\\\"color: #333333;\\\">Use the free CRM app in your business to:<\\/span><\\/p>\\n<ul>\\n<li><span style=\\\"color: #333333;\\\">Track your prospects and customers,<\\/span><\\/li>\\n<li><span style=\\\"color: #333333;\\\">Track sales opportunities, and<\\/span><\\/li>\\n<li><span style=\\\"color: #333333;\\\">Submit sales proposals for approval.<\\/span><\\/li>\\n<\\/ul>\\n<p><span style=\\\"color: #333333;\\\">This CRM app has been built to make use of the new features and capababilities of Joget DX Enterprise or Professional Edition.<\\/span><\\/p>\\n<p><span style=\\\"color: #333333;\\\">Tips to Joget administrator:<\\/span><span style=\\\"color: #333333;\\\"><\\/span><\\/p>\\n<ul>\\n<li><span style=\\\"color: #333333;\\\">Input your Joget SMTP server configurations in <a href=\\\"#request.contextPath?html#/web/console/setting/general\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\" style=\\\"color: #333333;\\\">Web Console &gt; General Settings <\\/a> to send email messages.<\\/span><\\/li>\\n<li><span style=\\\"color: #333333;\\\">Input an email address for admin &amp; other users in <a href=\\\"#request.contextPath?html#/web/console/directory/users\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\" style=\\\"color: #333333;\\\">Web Console &gt; Setup Users <\\/a> for email notification to work.<\\/span><\\/li>\\n<\\/ul>\\n<\\/td>\\n<\\/tr>\\n<\\/tbody>\\n<\\/table>\"},{\"path\":\"categories[0].menus[0].properties.content\",\"isError\":false,\"label\":\"#request.contextPath?html#\",\"tool\":\"org.joget.apps.app.lib.HashVariableOverviewTool\",\"content\":\"<h1><\\/h1>\\n<tab